/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import bass.eftpos.TransactionMode;
import bass.eftpos.posnet.PosNetEftpos;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.pay.PaymentTM;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchToggleButton;

public class TenderEFTValsDlg
extends PayDialog {
    private JPanel panel1 = new JPanel();
    private LabelSubHeading lAmt = new LabelSubHeading();
    private DecimalField dfAmount;
    private LabelSubHeading lCashout;
    private DecimalField dfCashout;
    private ButtonGroup group;
    private TouchToggleButton bMoto;
    private TouchToggleButton bCard;
    private TouchToggleButton bWallet;
    private TouchToggleButton bQrpay;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayout1;
    private RetTranP retTranP;
    private PayType payType;
    private PaymentTM paymentTM;
    private boolean cashoutEnabled;
    private boolean motoEnabled;
    private boolean cardEnabled;
    private boolean walletEnabled;
    private boolean qrpayEnabled;

    public TenderEFTValsDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfAmount = new DecimalField(SP.sParams.storeCurrency);
        this.lCashout = new LabelSubHeading();
        this.dfCashout = new DecimalField(SP.sParams.storeCurrency);
        this.group = new ButtonGroup();
        this.bMoto = new TouchToggleButton();
        this.bCard = new TouchToggleButton();
        this.bWallet = new TouchToggleButton();
        this.bQrpay = new TouchToggleButton();
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.gridBagLayout1 = new GridBagLayout();
        this.motoEnabled = false;
        this.cardEnabled = false;
        this.walletEnabled = false;
        this.qrpayEnabled = false;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.lAmt.setText(SP.getRS("enter_eftpos_amount_to_pay"));
        this.lCashout.setText(SP.getRS("enter_cash_out_amount"));
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.dfAmount.setText("0.00");
        this.dfCashout.setText("0.00");
        this.bMoto.setText(SP.getRS(TransactionMode.MOTO.getName()));
        this.bCard.setText(SP.getRS(TransactionMode.STANDARD.getName()));
        this.bQrpay.setText(SP.getRS(TransactionMode.QRPAY.getName()));
        this.bWallet.setText(SP.getRS(TransactionMode.WALLET.getName()));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.lAmt, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.dfAmount, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.lCashout, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.dfCashout, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.bCard, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.bMoto, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.bQrpay, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.bWallet, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
        this.panel1.add((Component)this.bOk, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 20, 10), 0, 0));
        this.panel1.add((Component)this.bCancel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfAmount);
        v.add(this.dfCashout);
        v.add(this.bCard);
        v.add(this.bMoto);
        v.add(this.bQrpay);
        v.add(this.bWallet);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setPaymentTM(PaymentTM pPaymentTM) {
        this.paymentTM = pPaymentTM;
    }

    public void setRetTranP(RetTranP pRetTranP) {
        this.retTranP = pRetTranP;
        this.payType = pRetTranP.getPayType();
        this.cashoutEnabled = this.payType.maxCashout.isNotNull() && this.payType.maxCashout.doubleValue() != 0.0;
        List supportedTypes = this.frSales.sParams.eftpos.getSupportedTypes();
        for (TransactionMode mode : supportedTypes) {
            if (this.frSales != null && mode == TransactionMode.MOTO) {
                this.motoEnabled = true;
                continue;
            }
            if (this.frSales != null && mode == TransactionMode.WALLET) {
                this.walletEnabled = true;
                continue;
            }
            if (this.frSales == null || mode != TransactionMode.QRPAY) continue;
            this.qrpayEnabled = true;
        }
        boolean bl = this.cardEnabled = supportedTypes.size() > 1;
        if (this.cardEnabled) {
            this.group.add(this.bCard);
            this.group.add(this.bMoto);
            this.group.add(this.bQrpay);
            this.group.add(this.bWallet);
        }
    }

    @Override
    public boolean initDialog() {
        this.group.clearSelection();
        this.dfAmount.setText(this.retTranP.getAmount());
        this.dfCashout.setText(this.retTranP.getCashout());
        this.lCashout.setVisible(this.cashoutEnabled);
        this.dfCashout.setVisible(this.cashoutEnabled);
        this.bMoto.setVisible(this.motoEnabled);
        this.bMoto.setSelected(this.motoEnabled && this.retTranP.getEftMode() == TransactionMode.MOTO);
        this.bCard.setVisible(this.cardEnabled);
        this.bCard.setSelected(this.cardEnabled && this.frSales.sParams.eftpos instanceof PosNetEftpos);
        this.bWallet.setVisible(this.walletEnabled);
        this.bQrpay.setVisible(this.qrpayEnabled);
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        double amountRnd = this.retTranP.getPayType().roundAmt(this.dfAmount.getDouble());
        double cashoutRnd = PayTypes.cashPayType.roundAmt(this.dfCashout.getDouble());
        if (amountRnd != this.dfAmount.getDouble() || cashoutRnd != this.dfCashout.getDouble()) {
            this.dfAmount.setText(amountRnd);
            this.dfCashout.setText(cashoutRnd);
            return;
        }
        if (amountRnd < 0.0) {
            return;
        }
        if (cashoutRnd < 0.0) {
            return;
        }
        if (this.dfAmount.getDouble() == 0.0) {
            return;
        }
        if (this.payType.maxOverridePayment.isNotNull() && PayType.roundDec(amountRnd + this.paymentTM.getTotalNoChange(this.payType)) > this.payType.maxOverridePayment.doubleValue() && !this.frSales.hasSecurity(11127L, 0)) {
            Object[] objs = new Object[]{SP.sParams.storeCurrency.formatDetailNoScale(this.payType.maxOverridePayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("max_payment_noman"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (this.payType.maxPayment.isNotNull() && PayType.roundDec(amountRnd + this.paymentTM.getTotalNoChange(this.payType)) > this.payType.maxPayment.doubleValue()) {
            Object[] objs = new Object[]{SP.sParams.storeCurrency.formatDetailNoScale(this.payType.maxPayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("max_payment_man"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (this.payType.minPayment.isNotNull() && amountRnd < this.payType.minPayment.doubleValue()) {
            Object[] objs = new Object[]{SP.sParams.storeCurrency.formatDetailNoScale(this.payType.minPayment.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("min_payment"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (this.payType.maxCashout.isNotNull() && cashoutRnd > this.payType.maxCashout.doubleValue()) {
            Object[] objs = new Object[]{SP.sParams.storeCurrency.formatDetailNoScale(this.payType.maxCashout.doubleValue()), this.retTranP.getPayType().code};
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("max_cashout"), objs), SP.getRS("Stop"), 0);
            return;
        }
        if (cashoutRnd > 0.0 && this.bMoto.isSelected()) {
            DlgMessage.showMessage(this, SP.getRS("MOTO_no_cashout"), SP.getRS("Stop"), 0);
            return;
        }
        this.retTranP.setAmount(amountRnd + cashoutRnd);
        this.retTranP.setCashout(cashoutRnd);
        TransactionMode mode = TransactionMode.STANDARD;
        if (this.bMoto.isSelected()) {
            mode = TransactionMode.MOTO;
        } else if (this.bWallet.isSelected()) {
            mode = TransactionMode.WALLET;
        } else if (this.bQrpay.isSelected()) {
            mode = TransactionMode.QRPAY;
        }
        this.retTranP.setEftMode(mode);
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }
}

