/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.RetTranP;
import jpos.pay.VoucherPinDlg;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.voucher.DlgVoucherAmount;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.GatewayVoucherTran;
import jpos.voucher.VoucherRedeemAdapter;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class VoucherNumDlg
extends PayDialog {
    private LabelSubHeading lVoucherNum = new LabelSubHeading();
    private TouchTextField tfVoucherNum = new TouchTextField();
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Vector<RetTranP> vRetTranPs;
    private RetTranP retTranP;
    private VoucherPinDlg dVoucherPinDlg;

    public VoucherNumDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lVoucherNum.setText("");
        this.tfVoucherNum.setText("");
        this.tfVoucherNum.setFieldWidth(100);
        this.tfVoucherNum.setHorizontalAlignment(4);
        this.tfVoucherNum.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '?' && VoucherNumDlg.this.tfVoucherNum.getText().length() > 1 && (VoucherNumDlg.this.tfVoucherNum.getText().substring(0, 1).equals(";") || VoucherNumDlg.this.tfVoucherNum.getText().substring(0, 1).equals("%"))) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VoucherNumDlg.this.okDialog();
                        }
                    });
                }
            }
        });
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lVoucherNum, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelAll.add((Component)this.tfVoucherNum, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 100, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfVoucherNum);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public void setRetTranPs(Vector<RetTranP> pVRetTranPs, RetTranP pRetTranP) {
        this.vRetTranPs = pVRetTranPs;
        this.retTranP = pRetTranP;
    }

    public RetTranP getRetTranP() {
        return this.retTranP;
    }

    @Override
    public boolean initDialog() {
        this.tfVoucherNum.setText(this.retTranP.getPaymentNum());
        this.lVoucherNum.setText(SP.getRS("scan_voucher_2"));
        this.setTitle(SP.getRS("validate_voucher"));
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        if (this.validateVoucherNum()) {
            super.okDialog();
        }
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    private boolean validateVoucherNum() {
        boolean bOk = false;
        this.tfVoucherNum.setText(VoucherUtils.cleanVoucherNumber(this.tfVoucherNum.getText()));
        String voucherNumber = this.tfVoucherNum.getText();
        if (voucherNumber.length() > 0 && voucherNumber.toUpperCase().startsWith("CN")) {
            voucherNumber = voucherNumber.substring(2);
        }
        if (this.retTranP.getVoucherAdapter() == null) {
            this.retTranP.setVoucherAdapter(new VoucherRedeemAdapter(this.frSales, this.vRetTranPs));
        }
        if (this.retTranP.getVoucherAdapter().processNumber(voucherNumber)) {
            GatewayVoucher gatewayVoucher;
            if (this.retTranP.getVoucherAdapter().getVoucher() != null) {
                boolean pinValid = true;
                if (this.retTranP.getVoucherAdapter() instanceof VoucherRedeemAdapter && ((VoucherRedeemAdapter)this.retTranP.getVoucherAdapter()).promptForPin()) {
                    this.dVoucherPinDlg = new VoucherPinDlg((Frame)this.frSales, SP.getRS("enter_pin"), this.retTranP.getVoucherAdapter().getVoucher());
                    this.dVoucherPinDlg.setVisible(true);
                    if (!this.dVoucherPinDlg.getResult()) {
                        pinValid = false;
                    }
                }
                if (pinValid) {
                    VoucherType.BalanceRules balanceRules = this.retTranP.getVoucherAdapter().getVoucher().getVoucherType().getBalanceRules();
                    if (balanceRules == VoucherType.BalanceRules.GIVE_CHANGE) {
                        this.retTranP.setAmount(this.retTranP.getVoucherAdapter().getVoucher().getAvailableAmount());
                        bOk = true;
                    } else if (balanceRules == VoucherType.BalanceRules.RETAIN_VALUE) {
                        Object[] objs = new Object[]{this.retTranP.getVoucherAdapter().getVoucher().getVoucherType().getName()};
                        DlgVoucherAmount dlgVoucherAmount = new DlgVoucherAmount((PosFrame)this.frSales, MessageFormat.format(SP.getRS("Voucher_Value"), objs), this.retTranP);
                        dlgVoucherAmount.setVisible(true);
                        if (dlgVoucherAmount.isAmountSet()) {
                            bOk = true;
                        }
                        dlgVoucherAmount.dispose();
                    } else if (balanceRules == VoucherType.BalanceRules.WRITE_OFF) {
                        if (this.retTranP.getPayType().roundAmt(this.retTranP.getVoucherAdapter().getVoucher().getAvailableAmount()) > this.retTranP.getAmount()) {
                            this.retTranP.setAmount(this.retTranP.getAmount());
                        } else {
                            this.retTranP.setAmount(this.retTranP.getVoucherAdapter().getVoucher().getAvailableAmount());
                        }
                        bOk = true;
                    }
                }
            }
            if ((gatewayVoucher = this.retTranP.getVoucherAdapter().getGatewayVoucher()) != null) {
                try {
                    this.retTranP.setEFTTran(new GatewayVoucherTran(gatewayVoucher.getNumber(), gatewayVoucher.getPin(), this.retTranP.getAmount()));
                    DlgVoucherAmount dlgVoucherAmount = new DlgVoucherAmount((PosFrame)this.frSales, SP.getRS("voucher_redemption"), this.retTranP);
                    dlgVoucherAmount.setVisible(true);
                    if (dlgVoucherAmount.isAmountSet()) {
                        this.retTranP.getETran().setAmount(this.retTranP.getAmount());
                        this.retTranP.setEFTStatus(1);
                        bOk = true;
                    }
                    dlgVoucherAmount.dispose();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    return false;
                }
            }
        }
        if (bOk) {
            this.retTranP.setPaymentNum(this.retTranP.getVoucherAdapter().getBaseVoucher().getNumber());
        } else {
            this.retTranP.setEFTTran(null);
            this.tfVoucherNum.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VoucherNumDlg.this.tfVoucherNum.selectAll();
                }
            });
        }
        return bOk;
    }
}

