/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.zip;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.zip.ZipPayTran;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class DlgShopInStore
extends PayDialog {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private LabelSubHeading lShopInStoreCode = new LabelSubHeading();
    private TouchTextField tfShopInStoreCode = new TouchTextField();
    private DialogButton bOk = new DialogButton("", this);
    private DialogButton bCancel = new DialogButton("", this);
    private ZipPayTran zipTran;

    public DlgShopInStore(Frame parentFrame, String title, ZipPayTran zipTran) {
        super(parentFrame, title);
        this.zipTran = zipTran;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lShopInStoreCode.setText("");
        this.tfShopInStoreCode.setText("");
        this.tfShopInStoreCode.setFieldWidth(10);
        this.tfShopInStoreCode.setHorizontalAlignment(4);
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lShopInStoreCode, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.panelAll.add((Component)this.tfShopInStoreCode, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.bOk, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.bCancel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 20, 10, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfShopInStoreCode);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public boolean initDialog() {
        this.lShopInStoreCode.setText(SP.getRS("zippay_shop_in_store_code"));
        this.setTitle(SP.getRS("zippay_dlg"));
        this.pack();
        return super.initDialog();
    }

    @Override
    public void okDialog() {
        if (this.validateCode()) {
            super.okDialog();
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    private boolean validateCode() {
        String sShopInStoreCode = this.tfShopInStoreCode.getText();
        if (sShopInStoreCode == null || sShopInStoreCode.trim().length() < 1) {
            DlgMessage.showMessage(this, SP.getRS("zippay_shop_in_store_code_check"));
            return false;
        }
        try {
            this.zipTran.setShopInStoreCode(sShopInStoreCode);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

