/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpos.DlgMessage;
import jpos.LinkStyle;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.XMLUtils;
import jpos.crypt.PersonCrypt;
import jpos.person.Person;
import jpos.ui.DialogButton;
import jpos.ui.FormButton;
import jpos.ui.LabelHeading;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class DlgPersonSearchResult
extends PosDialog {
    private static final int PERIDX = 6;
    private static final int FIRST_NAME = 0;
    private static final int SURNAME = 1;
    private static final int PHONE = 2;
    private static final int EMAIL = 3;
    private static final int POSTCODE = 4;
    private static final int REWARDS_LOYALTY = 5;
    private static final int COLUMN_COUNT = 6;
    private static final String HDR_FIRST_NAME = SP.getRS("First_Name");
    private static final String HDR_LAST_NAME = SP.getRS("Surname");
    private static final String HDR_PHONE = SP.getRS("Contact_hash");
    private static final String HDR_EMAIL = SP.getRS("Email");
    private static final String HDR_POSTCODE = SP.getRS("Post_Code");
    private static final String HDR_REWARDS_LOYALTY = SP.getRS("Rewards_Loyalty");
    private static final int MIN_COLUMN_WIDTH = 50;
    private static final int POSTCODE_COLUMN_WIDTH = 100;
    private static final int MIN_DLG_WIDTH = 800;
    private static final int MAX_PERSON_RECORDS = 10000;
    private boolean online;
    private Result result;
    private JPanel resultsInfoPanel = new JPanel();
    private LabelNormal lpersonLoadError = new LabelNormal();
    private LabelNormal lloadAllPersons = new LabelNormal();
    private PersonTableModel personTableModel;
    private PosTable personTable;
    private JPanel searchPanel = new JPanel();
    private GridBagLayout gridBagLayoutSearch = new GridBagLayout();
    private LabelSubHeading searchTitle = new LabelSubHeading();
    private LabelNormal lSurname = new LabelNormal();
    private LabelNormal lFirstName = new LabelNormal();
    private LabelNormal lContact = new LabelNormal();
    private LabelNormal lPostCode = new LabelNormal();
    private TouchTextField searchFirstName = new TouchTextField();
    private TouchTextField searchSurname = new TouchTextField();
    private TouchTextField searchContact = new TouchTextField();
    private TouchTextField searchPostCode = new TouchTextField();
    private DialogButton bSearch = new DialogButton("");
    private DialogButton bReset = new DialogButton("");
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private GridBagLayout gridBagLayoutButtons = new GridBagLayout();
    private JPanel panel = new JPanel();
    private JPanel panelButtons = new JPanel();
    private LabelHeading lSearch = new LabelHeading();
    private PosScrollPane scrollPane = null;
    private FormButton bOk = new FormButton("");
    private FormButton bCancel = new FormButton("");
    private FormButton bNew = new FormButton("");
    private List<Person> searchData;
    private String custidx;
    private int maxRows;

    public Result getResult() {
        return this.result;
    }

    private DlgPersonSearchResult(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean online, String custidx, String firstName, String surname, String phone, String email, String postcode, List<String> peridxs) {
        super(frame, dlgParent, title, modal, false);
        this.setAcceptOnEnter(false);
        if (online) {
            this.setTitle(title);
        } else {
            this.setTitle(title + " - OFFLINE");
        }
        this.online = online && DlgPersonSearchResult.allowedToSearchOnline();
        this.maxRows = DlgPersonSearchResult.getMaxRows();
        this.searchData = new ArrayList<Person>();
        this.custidx = custidx;
        this.result = new Result();
        this.dlgInit();
        this.resizeDialog(dlgParent, 0.98f, 0.75f);
        this.setLocationRelativeTo(this.getParent());
        this.searchFirstName.setText(firstName);
        this.searchSurname.setText(surname);
        if (online) {
            this.searchContact.setText(phone.isEmpty() ? email : phone);
        } else {
            this.searchContact.setText("");
        }
        this.searchPostCode.setText(postcode);
        this.setFocus();
        if (peridxs.size() > 0) {
            this.loadFromPeridxs(peridxs);
        } else if (!(StringUtils.isNullOrEmpty(firstName) && StringUtils.isNullOrEmpty(surname) && StringUtils.isNullOrEmpty(phone) && StringUtils.isNullOrEmpty(email))) {
            this.bSearch.doClick();
        }
    }

    private void setFocus() {
        this.searchFirstName.requestFocusInWindow();
    }

    public static Result showDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean online, String custidx) {
        return DlgPersonSearchResult.showDialog(frame, dlgParent, title, modal, online, custidx, "", "", "", "", "", new ArrayList<String>());
    }

    public static Result showDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean online, String custidx, List<String> peridxs) {
        return DlgPersonSearchResult.showDialog(frame, dlgParent, title, modal, online, custidx, "", "", "", "", "", peridxs);
    }

    public static Result showDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean online, String custidx, String firstName, String surname, String phone, String email, String postcode) {
        return DlgPersonSearchResult.showDialog(frame, dlgParent, title, modal, online, custidx, firstName, surname, phone, email, postcode, new ArrayList<String>());
    }

    public static Result showDialog(PosFrame frame, JDialog dlgParent, String title, boolean modal, boolean online, String custidx, String firstName, String surname, String phone, String email, String postcode, List<String> persons) {
        PersonCrypt.getInstance().acquireKey(frame, dlgParent);
        DlgPersonSearchResult dlgPersonSearch = new DlgPersonSearchResult(frame, dlgParent, title, modal, online, custidx, firstName, surname, phone, email, postcode, persons);
        dlgPersonSearch.setVisible(true);
        return dlgPersonSearch.getResult();
    }

    public static boolean allowedToSearchOnline() {
        Boolean propAllowed = Settings.isPersonSearchOnline();
        if (propAllowed != null) {
            return propAllowed;
        }
        String[] param = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.PERSON_SEARCH).split("@");
        boolean paramAllowed = !param[0].equals("0");
        return paramAllowed;
    }

    public static int getMaxRows() {
        int propMaxRows = Settings.getPersonSearchMaxRows();
        if (propMaxRows > 0) {
            return propMaxRows;
        }
        int paramMaxRows = (int)SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.PERSON_SEARCH);
        if (paramMaxRows > 0) {
            return paramMaxRows;
        }
        return 50;
    }

    public void populateResultSearchFields() {
        this.result.firstName = this.searchFirstName.getText().trim();
        this.result.surname = this.searchSurname.getText().trim();
        this.result.postCode = this.searchPostCode.getText().trim();
        String text = this.searchContact.getText().trim();
        if (!text.isEmpty()) {
            if (text.contains("@")) {
                this.result.email = this.searchContact.getText();
            } else {
                this.result.phone = this.searchContact.getText();
            }
        }
    }

    private void dlgInit() {
        this.personTableModel = new PersonTableModel();
        this.personTable = new PosTable(this, this.personTableModel);
        this.personTable.setAutoCreateRowSorter(true);
        this.personTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DlgPersonSearchResult.this.bOk.doClick();
                }
            }
        });
        this.personTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!DlgPersonSearchResult.this.personTable.getSelectionModel().isSelectionEmpty()) {
                    DlgPersonSearchResult.this.bOk.setEnabled(true);
                } else {
                    DlgPersonSearchResult.this.bOk.setEnabled(false);
                }
            }
        });
        this.personTableModel.resetPeopleArrays();
        this.scrollPane = new PosScrollPane(this.personTable);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.resultsInfoPanel.setLayout(new GridBagLayout());
        final String loadAll = SP.getRS("Search_Person_Load_All");
        this.lloadAllPersons.setText(LinkStyle.UNVISITED.format(loadAll));
        this.lloadAllPersons.setVisible(false);
        this.lloadAllPersons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DlgPersonSearchResult.this.lloadAllPersons.getParent().setCursor(new Cursor(3));
                DlgPersonSearchResult.this.doSearch(true);
                DlgPersonSearchResult.this.lloadAllPersons.getParent().setCursor(new Cursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DlgPersonSearchResult.this.lloadAllPersons.getParent().setCursor(new Cursor(12));
                DlgPersonSearchResult.this.lloadAllPersons.setText(LinkStyle.ACTIVE.format(loadAll));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DlgPersonSearchResult.this.lloadAllPersons.getParent().setCursor(new Cursor(0));
                DlgPersonSearchResult.this.lloadAllPersons.setText(LinkStyle.UNVISITED.format(loadAll));
            }
        });
        this.lpersonLoadError.setVisible(false);
        this.lloadAllPersons.setVisible(false);
        Insets infoPanelInset = new Insets(10, 0, 10, 0);
        this.resultsInfoPanel.add((Component)this.lpersonLoadError, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, infoPanelInset, 0, 0));
        this.resultsInfoPanel.add((Component)this.lloadAllPersons, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, infoPanelInset, 0, 0));
        this.resultsInfoPanel.setBorder(this.scrollPane.getBorder());
        this.resultsInfoPanel.setVisible(false);
        this.panel.setLayout(this.gridBagLayout);
        this.panelButtons.setLayout(this.gridBagLayoutButtons);
        this.initSearchPanel();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: 
                    case 40: {
                        DlgPersonSearchResult.this.navigatePersonTable(e);
                        break;
                    }
                    case 123: {
                        DlgPersonSearchResult.this.doSearch();
                        break;
                    }
                    case 78: {
                        if (!e.isAltDown()) break;
                        DlgPersonSearchResult.this.bNew.doClick();
                        break;
                    }
                    case 114: {
                        DlgPersonSearchResult.this.resetDialog(true);
                        break;
                    }
                }
            }
        });
        this.bOk.setText(SP.getRS("OK"));
        this.bOk.setEnabled(false);
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPersonSearchResult.this.populateResultSearchFields();
                DlgPersonSearchResult.this.result.perIdx = PosUtils.longVal(DlgPersonSearchResult.this.personTable.getModel().getValueAt(DlgPersonSearchResult.this.personTable.convertRowIndexToModel(DlgPersonSearchResult.this.personTable.getSelectedRow()), 6));
                DlgPersonSearchResult.this.result.buttonPressed = Button.OK;
                DlgPersonSearchResult.this.dispose();
            }
        });
        this.bCancel.setText(SP.getRS("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPersonSearchResult.this.populateResultSearchFields();
                DlgPersonSearchResult.this.result.buttonPressed = Button.CANCEL;
                DlgPersonSearchResult.this.dispose();
            }
        });
        this.bNew.setText(SP.getRS("Alt+N_New_Person"));
        this.bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgPersonSearchResult.this.frParent.hasSecurity(11160L, 1)) {
                    DlgMessage.showMessage(DlgPersonSearchResult.this, StoreParams.res.getString("No_Add_Person_Security"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
                DlgPersonSearchResult.this.populateResultSearchFields();
                DlgPersonSearchResult.this.result.buttonPressed = Button.NEW;
                DlgPersonSearchResult.this.dispose();
            }
        });
        this.personTable.setSelectionMode(0);
        Insets panelInset = new Insets(10, 10, 0, 10);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, panelInset, 0, 0));
        this.panel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, panelInset, 0, 0));
        this.panel.add((Component)this.resultsInfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, panelInset, 0, 0));
        this.panel.add((Component)this.panelButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelButtons.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panelButtons.add((Component)this.bNew, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane.getViewport().add(this.personTable);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.searchFirstName);
        v.add(this.searchSurname);
        v.add(this.searchContact);
        v.add(this.searchPostCode);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        this.setColumnWidth();
        this.setMinimumSize(new Dimension(Math.max(800, this.getOwner().getWidth()), (int)((double)this.getOwner().getHeight() * 0.75)));
    }

    private void initSearchPanel() {
        this.searchPanel.setLayout(this.gridBagLayoutSearch);
        this.searchTitle.setText(SP.getRS("Person_Search"));
        this.lFirstName.setText(SP.getRS("First_Name"));
        this.lSurname.setText(SP.getRS("Surname"));
        this.lContact.setText(SP.getRS("Phone_Email"));
        this.lPostCode.setText(SP.getRS("Post_Code"));
        this.lSearch.setText(SP.getRS("Person_Search"));
        this.addSearchFieldListeners(this.searchFirstName, this.searchSurname, this.searchContact, this.searchPostCode);
        this.searchFirstName.setFieldWidth(100);
        this.searchSurname.setFieldWidth(100);
        this.searchContact.setFieldWidth(100);
        this.searchPostCode.setFieldWidth(100);
        this.searchContact.setEnabled(PersonCrypt.getInstance().keyExists() || this.online);
        if (!this.searchContact.isEnabled()) {
            this.searchContact.setHint(SP.getRS("Password_req"));
        } else {
            this.searchContact.setHint(SP.getRS("Phone_Email"));
        }
        this.searchFirstName.setHint(SP.getRS("First_Name"));
        this.searchSurname.setHint(SP.getRS("Surname"));
        this.searchPostCode.setHint(SP.getRS("Post_Code"));
        this.bSearch.setText(SP.getRS("Search_F12"));
        this.bSearch.setIcon(new ImageIcon(SP.sParams.imagepath + "search.png"));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPersonSearchResult.this.doSearch();
            }
        });
        this.bReset.setText(SP.getRS("F3_Reset"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPersonSearchResult.this.resetDialog(true);
            }
        });
        Insets searchInsets = new Insets(5, 10, 5, 10);
        Insets col1LabelInsets = new Insets(5, 10, 5, 10);
        Insets col2LabelInsets = new Insets(5, 10, 5, 10);
        this.searchPanel.add((Component)this.lSearch, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.searchPanel.add((Component)this.lFirstName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, col1LabelInsets, 0, 0));
        this.searchPanel.add((Component)this.searchFirstName, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 17, 2, searchInsets, 0, 0));
        this.searchPanel.add((Component)this.lSurname, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, col2LabelInsets, 0, 0));
        this.searchPanel.add((Component)this.searchSurname, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 17, 2, searchInsets, 0, 0));
        this.searchPanel.add((Component)this.bReset, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.searchPanel.add((Component)this.lContact, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, col1LabelInsets, 0, 0));
        this.searchPanel.add((Component)this.searchContact, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 17, 2, searchInsets, 0, 0));
        this.searchPanel.add((Component)this.lPostCode, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, col2LabelInsets, 0, 0));
        this.searchPanel.add((Component)this.searchPostCode, new GridBagConstraints(3, 2, 1, 1, 0.5, 0.0, 17, 2, searchInsets, 0, 0));
        this.searchPanel.add((Component)this.bSearch, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
    }

    private void addSearchFieldListeners(TouchTextField ... fields) {
        for (TouchTextField field : fields) {
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DlgPersonSearchResult.this.personTable.clearSelection();
                    DlgPersonSearchResult.this.resetDialog(false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DlgPersonSearchResult.this.personTable.clearSelection();
                    DlgPersonSearchResult.this.resetDialog(false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DlgPersonSearchResult.this.personTable.clearSelection();
                    DlgPersonSearchResult.this.resetDialog(false);
                }
            });
        }
    }

    private void setColumnWidth() {
        Enumeration<TableColumn> cols = this.personTable.getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            TableColumn curr = cols.nextElement();
            if (curr.getHeaderValue().toString() == HDR_POSTCODE) {
                curr.setMinWidth(100);
                curr.setMaxWidth(100);
                continue;
            }
            if (curr.getHeaderValue().toString() == HDR_PHONE) {
                curr.setMinWidth(50);
                curr.setPreferredWidth(curr.getPreferredWidth() * 80 / 100);
                continue;
            }
            curr.setMinWidth(50);
        }
    }

    private void doSearch() {
        this.doSearch(false);
    }

    private void doSearch(boolean loadAllOffline) {
        boolean error;
        ArrayList<Person> returnPeople = new ArrayList<Person>();
        boolean tooManyResults = false;
        if (this.online && !loadAllOffline) {
            String filters = this.getOnlineSearchString();
            Element perReturn = this.sParams.OnlineQueryProvider.getOnlineQuery("person_search", filters, false).getXML();
            if (perReturn != null) {
                if (XMLUtils.getValue(perReturn, "too_many_results").equals("1")) {
                    tooManyResults = true;
                } else {
                    for (Object person : perReturn.getChildren()) {
                        try {
                            XMLOutputter outp = new XMLOutputter();
                            String temp = outp.outputString((Element)person);
                            returnPeople.add(Person.getPersonFromXml(temp));
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                    }
                }
            }
        } else {
            String limit = String.valueOf((loadAllOffline ? 10000 : this.maxRows) + 1);
            String whereClause = this.getSqlSearchString();
            if (!whereClause.isEmpty()) {
                try (SqlQuery sql = new SqlQuery(SP.sParams.conn, " SELECT FIRST " + limit + " P.PERIDX, P.FIRSTNAME, P.SURNAME, P.PHONE, P.EMAIL, P.POSTCODE, PO.MAIN_PHONE AS OFFLINE_PHONE, PO.EMAIL AS OFFLINE_EMAIL, (SELECT REWARDS_LOYALTY FROM GetRewardsLoyaltyDesc(P.PERIDX)) AS REWARDS_LOYALTY  FROM PERSON P  LEFT JOIN PERSON_OFFLINE PO ON PO.PERIDX = P.PERIDX   WHERE P.ACTIVE = 1 " + this.sParams.sWhseRefSecWherePERSON + whereClause);){
                    while (sql.next()) {
                        String emailOffline;
                        String email;
                        String phoneOffline;
                        String phone = this.decrypt(sql.getBytes("PHONE"));
                        if (phone.isEmpty() && (phoneOffline = sql.getString("OFFLINE_PHONE")) != null && phoneOffline.length() > 0) {
                            phone = phoneOffline;
                        }
                        if ((email = this.decrypt(sql.getBytes("EMAIL"))).isEmpty() && (emailOffline = sql.getString("OFFLINE_EMAIL")) != null && emailOffline.length() > 0) {
                            email = emailOffline;
                        }
                        returnPeople.add(new Person(sql.getLong("PERIDX"), sql.getString("FIRSTNAME"), sql.getString("SURNAME"), phone, email, sql.getString("POSTCODE"), sql.getString("REWARDS_LOYALTY")));
                        if (returnPeople.size() < 10000) continue;
                    }
                }
                catch (SQLException e) {
                    PosUtils.logError(e);
                }
            }
        }
        boolean bl = error = tooManyResults || returnPeople.size() >= 10000 || returnPeople.size() > this.maxRows && !loadAllOffline || returnPeople.size() == 0;
        if (error) {
            this.lpersonLoadError.setVisible(true);
            if (returnPeople.size() >= 10000) {
                this.lpersonLoadError.setText(SP.getRS("Search_Person_Cant_Display_Results"));
                this.lloadAllPersons.setVisible(false);
            } else if (returnPeople.size() > this.maxRows || tooManyResults) {
                this.lpersonLoadError.setText(SP.getRS("Search_Person_Too_Many_Results"));
                this.lloadAllPersons.setVisible(true);
            } else {
                this.lpersonLoadError.setText(SP.getRS("Search_Person_No_Results"));
                this.lloadAllPersons.setVisible(false);
            }
            returnPeople.clear();
        }
        this.resultsInfoPanel.setVisible(error);
        this.personTable.setEnabled(!error);
        this.scrollPane.setVisible(!error);
        returnPeople.sort(null);
        this.searchData = returnPeople;
        this.personTableModel.resetPeopleArrays();
        this.personTable.selectFirstRow();
    }

    private String decrypt(byte[] encrypted) {
        if (encrypted != null && encrypted.length > 0) {
            if (PersonCrypt.getInstance().keyExists()) {
                try {
                    return new String(PersonCrypt.getInstance().decryptValue(encrypted));
                }
                catch (GeneralSecurityException e) {
                    return SP.getRS("Decryption_Error");
                }
            }
            return SP.getRS("Encrypted");
        }
        return "";
    }

    private String getOnlineSearchString() {
        String email = "";
        String phone = "";
        String text = this.searchContact.getText().trim();
        if (!text.isEmpty()) {
            if (text.contains("@")) {
                email = this.searchContact.getText();
            } else {
                phone = this.searchContact.getText();
            }
        }
        return this.sParams.getStore().getWidx() + "," + this.searchFirstName.getText().trim() + "," + this.searchSurname.getText().trim() + "," + email + "," + phone + "," + this.searchPostCode.getText() + "," + String.valueOf(this.maxRows) + "," + StringUtils.nullToEmpty(this.custidx);
    }

    private String getSqlSearchString() {
        String text;
        StringBuilder sqlWhere = new StringBuilder();
        if (!this.searchFirstName.getText().equals("")) {
            sqlWhere.append(" AND UPPER(P.FIRSTNAME) LIKE " + PosUtils.StringToSqlString(this.searchFirstName.getText().trim().toUpperCase() + "%"));
        }
        if (!this.searchSurname.getText().equals("")) {
            sqlWhere.append(" AND UPPER(P.SURNAME) LIKE " + PosUtils.StringToSqlString(this.searchSurname.getText().trim().toUpperCase() + "%"));
        }
        if (!this.searchPostCode.getText().equals("")) {
            sqlWhere.append(" AND P.POSTCODE = " + PosUtils.StringToSqlString(this.searchPostCode.getText().trim().toUpperCase()));
        }
        if (!StringUtils.isNullOrEmpty(this.custidx)) {
            sqlWhere.append(" AND P.CUSTIDX = " + PosUtils.StringToSqlString(this.custidx));
        }
        if (PersonCrypt.getInstance().keyExists() && !(text = this.searchContact.getText().trim()).isEmpty()) {
            sqlWhere.append(PersonCrypt.getInstance().getContactWhere("P", text, SP.sParams.conn));
        }
        return sqlWhere.toString();
    }

    private void loadFromPeridxs(List<String> peridxs) {
        ArrayList<Person> people = new ArrayList<Person>();
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, " SELECT P.PERIDX, P.FIRSTNAME, P.SURNAME, P.PHONE, P.EMAIL, P.POSTCODE, PO.MAIN_PHONE AS OFFLINE_PHONE, PO.EMAIL AS OFFLINE_EMAIL, (SELECT REWARDS_LOYALTY FROM GetRewardsLoyaltyDesc(P.PERIDX)) AS REWARDS_LOYALTY  FROM PERSON P  LEFT JOIN PERSON_OFFLINE PO ON PO.PERIDX = P.PERIDX  WHERE P.PERIDX IN ( " + String.join((CharSequence)",", peridxs) + " )");){
            while (sql.next()) {
                String email;
                String phone = this.decrypt(sql.getBytes("PHONE"));
                if (phone.isEmpty() && sql.getString("OFFLINE_PHONE") != null) {
                    phone = sql.getString("OFFLINE_PHONE");
                }
                if ((email = this.decrypt(sql.getBytes("EMAIL"))).isEmpty() && sql.getString("OFFLINE_EMAIL") != null) {
                    email = sql.getString("OFFLINE_EMAIL");
                }
                people.add(new Person(sql.getLong("PERIDX"), sql.getString("FIRSTNAME"), sql.getString("SURNAME"), phone, email, sql.getString("POSTCODE"), sql.getString("REWARDS_LOYALTY")));
            }
            people.sort(null);
            this.searchData = people;
            this.personTableModel.resetPeopleArrays();
            this.personTable.selectFirstRow();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.bSearch.isEnabled() && this.personTable.getSelectedRow() == -1) {
                this.bSearch.doClick();
            } else {
                this.okDialog();
            }
            return true;
        }
        return false;
    }

    private boolean navigatePersonTable(KeyEvent key) {
        Component focusComp = this.getFocusOwner();
        if (focusComp == null || focusComp != this.personTable && focusComp.getParent() != this.personTable) {
            if (key.getKeyCode() == 38) {
                if (this.personTable.getSelectedRow() > 0) {
                    this.personTable.changeSelection(this.personTable.getSelectedRow() - 1, this.personTable.getSelectedColumn(), false, false);
                }
                return true;
            }
            if (key.getKeyCode() == 40) {
                if (this.personTable.getSelectedRow() < this.personTable.getRowCount() - 1) {
                    this.personTable.changeSelection(this.personTable.getSelectedRow() + 1, this.personTable.getSelectedColumn(), false, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void okDialog() {
        if (this.bOk.isEnabled()) {
            this.bOk.doClick();
        }
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = Math.max((int)((float)parentRect.width * scaleWidth), 800);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = (int)((float)parentRect.x + (float)parentRect.width / 2.0f - (float)width / 2.0f);
        int y = (int)((float)parentRect.y + (float)parentRect.height / 2.0f - (float)height / 2.0f);
        this.setBounds(x, y, width, height);
    }

    private void resetDialog(boolean clearText) {
        if (this.resultsInfoPanel.isVisible() || clearText) {
            this.personTableModel.clearPeopleArray();
        }
        this.resultsInfoPanel.setVisible(false);
        this.scrollPane.setVisible(true);
        if (clearText) {
            this.searchFirstName.setText("");
            this.searchSurname.setText("");
            this.searchContact.setText("");
            this.searchPostCode.setText("");
            this.setFocus();
        }
    }

    public class Result {
        private String firstName = "";
        private String surname = "";
        private String phone = "";
        private String email = "";
        private String postCode = "";
        private long perIdx = 0L;
        private String rewardsLoyalty = "";
        private Button buttonPressed;

        public String getFirstName() {
            return this.firstName;
        }

        public String getSurname() {
            return this.surname;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public long getPerIdx() {
            return this.perIdx;
        }

        public String getRewardsLoyalty() {
            return this.rewardsLoyalty;
        }

        public Button getButtonPressed() {
            return this.buttonPressed;
        }
    }

    public static enum Button {
        CANCEL,
        OK,
        NEW;

    }

    private class PersonTableModel
    extends AbstractTableModel {
        ArrayList<Person> people = new ArrayList();

        private PersonTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.people.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.people.isEmpty()) {
                return Object.class;
            }
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.people.size()) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getFirstName());
                }
                case 1: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getLastName());
                }
                case 2: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getPhone());
                }
                case 3: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getEmail());
                }
                case 4: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getPostcode());
                }
                case 6: {
                    return this.people.get(rowIndex).getPeridx();
                }
                case 5: {
                    return StringUtils.nullToEmpty(this.people.get(rowIndex).getRewardsLoyalty());
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return HDR_FIRST_NAME;
                }
                case 1: {
                    return HDR_LAST_NAME;
                }
                case 2: {
                    return HDR_PHONE;
                }
                case 3: {
                    return HDR_EMAIL;
                }
                case 4: {
                    return HDR_POSTCODE;
                }
                case 5: {
                    return HDR_REWARDS_LOYALTY;
                }
            }
            return "";
        }

        public void clearPeopleArray() {
            this.people.clear();
            this.fireTableDataChanged();
        }

        public void resetPeopleArrays() {
            this.people.clear();
            for (int i = 0; i < DlgPersonSearchResult.this.searchData.size(); ++i) {
                this.people.add((Person)DlgPersonSearchResult.this.searchData.get(i));
            }
            this.fireTableDataChanged();
        }
    }
}

