/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SkuReservation;
import jpos.SpecialOrderReceiptProcessor;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.basscom.utils.Utils;
import jpos.quickreceipts.Carton;
import jpos.quickreceipts.CartonContent;
import jpos.quickreceipts.PaQuickReceipts;
import jpos.quickreceipts.PaQuickReceiptsFoot;
import jpos.quickreceipts.QuickReceiptsLine;
import org.jdom.Element;

public class FrQuickReceipts
extends PosFrame {
    private boolean completing = false;
    protected Element transRoot = null;
    private Vector<String> transactionsCreated = new Vector();

    public FrQuickReceipts(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 13, 11161L, psParams, StoreParams.res.getString("Quick_Receipts"));
        this.paBody = new PaQuickReceipts(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaQuickReceiptsFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaQuickReceipts)this.paBody).tfBarcode.requestFocus();
            this.setButtons();
        }
    }

    @Override
    protected void setTransType() {
        this.setTransType(251);
    }

    @Override
    public void setTransType(int ptype) {
        this.transType = ptype;
        if (this.paBody != null) {
            this.setButtons();
            ((PaQuickReceipts)this.paBody).tfBarcode.requestFocus();
            ((PaQuickReceipts)this.paBody).tfBarcode.setText("");
        }
    }

    @Override
    public boolean validateTrans() {
        PaQuickReceipts body = (PaQuickReceipts)this.paBody;
        if (body.tblCartons.isEditing()) {
            body.tblCartons.getCellEditor().stopCellEditing();
        }
        if (!((PaQuickReceiptsFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (body.tblCartons.getRowCount() == 0 || body.tblCartons.getTotalQty() <= 0.0) {
            return false;
        }
        String msg = null;
        msg = body.tblCartons.getRowCount() > 1 && body.tblCartons.getTotalQty() > 1.0 ? "barcodes_scanned_total_units" : (body.tblCartons.getTotalQty() > 1.0 ? "barcode_scanned_total_units" : "barcode_scanned_total_unit");
        return DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString(msg), body.tfTotalCartons.getText(), body.tfTotalUnits.getText()), StoreParams.res.getString("Confirm_rec"), 2, 3) == 0;
    }

    @Override
    public boolean completeTrans() {
        if (this.completing) {
            return false;
        }
        this.completing = true;
        try {
            boolean bl = super.completeTrans();
            return bl;
        }
        finally {
            this.completing = false;
        }
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        boolean bl;
        PaQuickReceipts body = (PaQuickReceipts)this.paBody;
        Vector<QuickReceiptsLine> lines = body.tblCartons.getModel().getData();
        Vector<Vector<Carton>> cartonGroups = new Vector<Vector<Carton>>();
        for (QuickReceiptsLine quickReceiptsLine : lines) {
            boolean bFound = false;
            if (!SP.sParams.bReceiptPerCarton) {
                for (Vector vector : cartonGroups) {
                    if (!((Carton)vector.elementAt(0)).getTransDescription().equals(quickReceiptsLine.getCarton().getTransDescription()) || !((Carton)vector.elementAt(0)).getDeliveryNumber().equals(quickReceiptsLine.getCarton().getDeliveryNumber())) continue;
                    vector.add(quickReceiptsLine.getCarton());
                    bFound = true;
                    break;
                }
            }
            if (bFound) continue;
            Iterator<QuickReceiptsLine> v = new Vector<Carton>();
            ((Vector)((Object)v)).add((QuickReceiptsLine)((Object)quickReceiptsLine.getCarton()));
            cartonGroups.add((Vector<Carton>)((Object)v));
        }
        Vector<StyleLine> styleLines = new Vector<StyleLine>();
        for (QuickReceiptsLine line : lines) {
            for (CartonContent cartonContent : line.getCarton().getContents()) {
                styleLines.add(cartonContent.getStyleLine());
            }
        }
        Vector<SkuReservation> vector = SkuReservation.allocateTransfersToReservations(styleLines);
        if (vector.size() > 0) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("stk_reserved"), "\n"), StoreParams.res.getString("Reserved_Stock"), 1);
        }
        Vector<String> pordidxs = new Vector<String>();
        for (QuickReceiptsLine quickReceiptsLine : lines) {
            if (!quickReceiptsLine.getCarton().getTransType().equals("PO") || pordidxs.contains(quickReceiptsLine.getCarton().getTransIdx())) continue;
            pordidxs.add(quickReceiptsLine.getCarton().getTransIdx());
        }
        Vector<Element> specialOrders = new Vector<Element>();
        for (String pordidx : pordidxs) {
            Element element = SpecialOrderReceiptProcessor.loadSpecialOrderFromPurchaseOrder(PosUtils.longVal(pordidx));
            if (element == null) continue;
            specialOrders.add(element);
        }
        if (specialOrders.size() > 0) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("SpecialOrder_stk"), "\n"), StoreParams.res.getString("Reserved_Stock"), 1);
        }
        if (bl = this.writeTransactions(cartonGroups)) {
            try {
                Vector<SkuReservation> reservationsToPrint = new Vector<SkuReservation>();
                for (SkuReservation reservation : vector) {
                    reservation.updateAvailQty();
                    boolean markedToPrint = false;
                    for (SkuReservation reservationToPrint : reservationsToPrint) {
                        if (reservationToPrint.getVhidx() != reservation.getVhidx()) continue;
                        markedToPrint = true;
                        break;
                    }
                    if (markedToPrint) continue;
                    reservationsToPrint.add(reservation);
                }
                for (SkuReservation reservationToPrint : reservationsToPrint) {
                    reservationToPrint.printStoreDocket(this, true);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            for (Element element : specialOrders) {
                SpecialOrderReceiptProcessor.printSpecialOrder(this, element);
            }
        }
        return bl;
    }

    private boolean writeTransactions(Vector<Vector<Carton>> cartonGroup) {
        this.transactionsCreated.clear();
        try {
            PosUtils.startTrans(this.sParams.conn);
            try (PreparedStatement stmtHeader = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE, TILL_NUMBER, FROM_WIDX, TO_WIDX, SUPPLIERIDX, CARRIERIDX, PORDIDX, SALE_DATE, SSCC) VALUES(?, ?, 1, ?, ?, CURRENT_TIMESTAMP, ?, ?, ?, ?, ?, 0, ?, ?, ?, ?, ?, ?, TRUNC_DATE(CURRENT_TIMESTAMP), ?)");
                 PreparedStatement stmtCartonsReceived = this.sParams.conn.prepareStatement("INSERT INTO CARTONS_RECEIVED(CARTON, RECEIVE_DATE) SELECT ?, CURRENT_TIMESTAMP FROM DUAL WHERE NOT EXISTS (SELECT 1 FROM CARTONS_RECEIVED WHERE CARTON = ?)");){
                for (int i = 0; i < cartonGroup.size(); ++i) {
                    Carton firstCarton = cartonGroup.elementAt(i).elementAt(0);
                    long vhidx = this.sParams.nextVal("XRET_TRANH");
                    stmtHeader.setLong(1, vhidx);
                    stmtHeader.setInt(2, firstCarton.getTransType().equals("PO") ? 251 : 250);
                    stmtHeader.setLong(3, this.sParams.getStoreIdx());
                    stmtHeader.setString(4, firstCarton.getDeliveryNumber());
                    stmtHeader.setLong(5, this.getUser().getPeridx());
                    stmtHeader.setLong(6, this.getUser().getMemidx());
                    stmtHeader.setLong(7, this.getUser().getPeridx());
                    stmtHeader.setLong(8, this.getUser().getMemidx());
                    stmtHeader.setNull(9, 12);
                    stmtHeader.setString(10, this.sParams.tillnum);
                    if (firstCarton.getTransType().equals("PO")) {
                        stmtHeader.setNull(11, 4);
                        stmtHeader.setNull(12, 4);
                        stmtHeader.setLong(13, PosUtils.longVal(firstCarton.getSupplierIdx()));
                        stmtHeader.setNull(14, 4);
                        stmtHeader.setLong(15, PosUtils.longVal(firstCarton.getTransIdx()));
                    } else {
                        stmtHeader.setString(11, firstCarton.getFromWarehouseIdx());
                        stmtHeader.setString(12, firstCarton.getFromWarehouseIdx());
                        stmtHeader.setNull(13, 4);
                        if (firstCarton.getCarrierIdx() != null && !firstCarton.getCarrierIdx().isEmpty()) {
                            stmtHeader.setLong(14, PosUtils.longVal(firstCarton.getCarrierIdx()));
                        } else {
                            stmtHeader.setNull(14, 4);
                        }
                        stmtHeader.setNull(15, 4);
                    }
                    if (SP.sParams.bReceiptPerCarton && cartonGroup.elementAt(i).size() > 0) {
                        stmtHeader.setString(16, cartonGroup.elementAt(i).elementAt(0).getHiddenBarcode());
                    } else {
                        stmtHeader.setNull(16, 12);
                    }
                    stmtHeader.executeUpdate();
                    Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", vhidx);
                    for (int j = 0; j < cartonGroup.elementAt(i).size(); ++j) {
                        Carton carton = cartonGroup.elementAt(i).elementAt(j);
                        stmtCartonsReceived.setString(1, carton.getHiddenBarcode());
                        stmtCartonsReceived.setString(2, carton.getHiddenBarcode());
                        stmtCartonsReceived.executeUpdate();
                        for (int k = 0; k < carton.getContents().size(); ++k) {
                            CartonContent content = carton.getContents().elementAt(k);
                            content.getStyleLine().db_insertline();
                        }
                    }
                    this.transactionsCreated.add(String.valueOf(vhidx));
                }
            }
            PosUtils.endTrans(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
        return this.assignDocketNumbersAndSentToHO();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean assignDocketNumbersAndSentToHO() {
        try (PreparedStatement stmtComplete = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET DOCKET_NUMBER = ?, COMPLETE = 1 WHERE VHIDX = ?");){
            for (int i = 0; i < this.transactionsCreated.size(); ++i) {
                String idx = this.transactionsCreated.elementAt(i);
                this.setDocketnum();
                stmtComplete.setString(1, this.docknum);
                stmtComplete.setString(2, idx);
                stmtComplete.executeUpdate();
                this.sParams.yTabInsert("RET_TRANH", "VHIDX", String.valueOf(idx));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    protected void setButtons() {
        if (((PaQuickReceipts)this.paBody).tblCartons.getRowCount() > 0) {
            ((PaQuickReceiptsFoot)this.paFoot).bDelete.setEnabled(true);
        } else {
            ((PaQuickReceiptsFoot)this.paFoot).bDelete.setEnabled(false);
        }
        if (((PaQuickReceipts)this.paBody).tblCartons.getTotalQty() > 0.0) {
            ((PaQuickReceiptsFoot)this.paFoot).bComplete.setEnabled(true);
        } else {
            ((PaQuickReceiptsFoot)this.paFoot).bComplete.setEnabled(false);
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            super.voidTrans(logout);
            this.transRoot = null;
            ((PaQuickReceipts)this.paBody).tblCartons.clear();
            ((PaQuickReceipts)this.paBody).tfBarcode.setText("");
            ((PaQuickReceipts)this.paBody).barcodeClear();
            this.transactionsCreated.clear();
            this.setButtons();
        }
    }

    @Override
    public void delLines() {
        if (((PaQuickReceiptsFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaQuickReceipts)this.paBody).delLines();
            this.setFocus();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaQuickReceiptsFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaQuickReceiptsFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaQuickReceiptsFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaQuickReceipts)this.paBody).tblCartons.getRowCount() == 0;
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaQuickReceiptsFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaQuickReceiptsFoot)this.paFoot).bDelete.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
        for (int i = 0; i < this.transactionsCreated.size(); ++i) {
            Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Transfer"), false, this.sParams.getDocketConnection(), PosUtils.longVal(this.transactionsCreated.elementAt(i)), reprint);
            if (r1.isValidReceipt()) {
                r1.PrintTransferIn();
            } else {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
            }
            r1.close();
        }
        this.transactionsCreated.clear();
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    protected void setTransnum() {
    }

    @Override
    public void notesSet() {
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaQuickReceipts)this.paBody).tblCartons.getModel().getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
    }

    @Override
    public void processLogin() {
    }
}

