/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.SP;
import jpos.quickreceipts.Carton;
import jpos.quickreceipts.QuickReceiptsLine;

public class QuickReceiptsTableModel
extends AbstractTableModel {
    String[] columnNames;
    private Vector<QuickReceiptsLine> data = new Vector();
    public static final int BARCODE_COLUMN = 0;
    public static final int TRANSACTION_COLUMN = 1;
    public static final int DELIVERY_NUMBER_COLUMN = 2;
    public static final int SUPPLIER_COLUMN = 3;
    public static final int QTY_COLUMN = 4;
    public static final int CARTON_NUMBER_COLUMN = 5;

    public QuickReceiptsTableModel() {
        this.columnNames = new String[]{SP.getRS("QR_Barcode"), SP.getRS("QR_Transaction"), SP.getRS("QR_Delivery_Number"), SP.getRS("QR_Supplier"), SP.getRS("QR_Units"), SP.getRS("QR_Carton_Number")};
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= 0 && row < this.data.size()) {
            return this.data.elementAt(row).getVal(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    protected void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    protected int addLine(QuickReceiptsLine row) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.data.get(i).getCarton().getHiddenBarcode().equals(row.getCarton().getHiddenBarcode())) continue;
            row.getCarton().setBarcode("");
            break;
        }
        this.data.add(row);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        this.assignCartonNumbers(row.getCarton());
        return this.getRowCount() - 1;
    }

    protected QuickReceiptsLine getCarton(String barcode) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.data.elementAt(i).getCarton().getHiddenBarcode().equals(barcode)) continue;
            return this.data.elementAt(i);
        }
        return null;
    }

    protected void deleteLine(int row) {
        if (row >= 0 && row < this.data.size()) {
            Carton carton = this.data.elementAt(row).getCarton();
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
            this.assignCartonNumbers(carton);
        }
    }

    protected Vector<QuickReceiptsLine> getData() {
        return this.data;
    }

    protected double getQty(int row) {
        if (row >= 0 && row < this.data.size()) {
            return this.data.elementAt(row).getCarton().getTotalQty();
        }
        return 0.0;
    }

    protected String getBarcode(int row) {
        if (row >= 0 && row < this.data.size()) {
            return this.data.elementAt(row).getCarton().getHiddenBarcode();
        }
        return "";
    }

    private void assignCartonNumbers(Carton carton) {
        int cartonNumber = 1;
        for (int i = 0; i < this.data.size(); ++i) {
            Carton otherCarton = this.data.elementAt(i).getCarton();
            if (!otherCarton.getTransDescription().equals(carton.getTransDescription()) || !otherCarton.getDeliveryNumber().equals(carton.getDeliveryNumber())) continue;
            if (otherCarton.getCartonNumber() != cartonNumber) {
                otherCarton.setCartonNumber(cartonNumber);
                this.fireTableCellUpdated(i, 4);
            }
            ++cartonNumber;
        }
    }
}

