/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StyleLine;
import jpos.rewards.Gift;

public class RetailRewardsDataTransaction {
    private static int MAX_REVERSAL_ATTEMPTS = 14;
    private long transactionId = 0L;
    private long peridx;
    private String requestId;
    private double amount;
    private StyleLine giftLine;
    private long overrideSkuIdx;
    private Gift overrideGift;

    protected RetailRewardsDataTransaction() {
        this(0L);
    }

    private RetailRewardsDataTransaction(long transactionId) {
        this.transactionId = transactionId;
        if (this.transactionId > 0L) {
            this.loadFromDatabase();
        }
    }

    private void loadFromDatabase() {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT PERIDX, AMOUNT, GIFT_IDX, GIFT_SKUIDX, REQUEST_ID FROM REWARDS_REDEMPTION_REQUEST WHERE TRANSIDX = " + this.transactionId);){
            if (query.next()) {
                this.peridx = query.getLong("PERIDX");
                this.amount = query.getDouble("AMOUNT");
                this.requestId = query.getString("REQUEST_ID");
                long giftIdx = query.getLong("GIFT_IDX");
                if (giftIdx > 0L) {
                    this.overrideGift = new Gift();
                    this.overrideGift.setGiftId(giftIdx);
                    this.overrideSkuIdx = query.getLong("GIFT_SKUIDX");
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected boolean saveRedemption(String requestId, long memidx) {
        Timestamp requestDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO REWARDS_REDEMPTION_REQUEST (TRANSIDX, PERIDX, AMOUNT, TILL_NAME, MEMIDX, REQUEST_DATE, REQUEST_ID, GIFT_IDX, GIFT_SKUIDX) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            this.transactionId = SP.sParams.nextVal("XREWARDS_REDEMPTION_REQUEST");
            stmt.setLong(1, this.transactionId);
            stmt.setLong(2, this.peridx);
            stmt.setDouble(3, this.amount);
            stmt.setString(4, SP.sParams.tillnum);
            stmt.setDouble(5, memidx);
            stmt.setTimestamp(6, requestDate);
            stmt.setString(7, requestId);
            if (this.getGift() != null) {
                stmt.setLong(8, this.getGift().getGiftId());
                stmt.setLong(9, this.getGiftSkuIdx());
            } else {
                stmt.setNull(8, 4);
                stmt.setNull(9, 4);
            }
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        this.requestId = requestId;
        return true;
    }

    protected boolean finishRedemption(long vhidx) {
        block47: {
            Throwable throwable;
            PreparedStatement stmt;
            if (this.transactionId == 0L) {
                return false;
            }
            Timestamp committedDate = new Timestamp(new Date().getTime());
            try {
                stmt = SP.sParams.conn.prepareStatement("UPDATE REWARDS_REDEMPTION_REQUEST SET VHIDX = ?, COMMITTED_DATE = ? WHERE TRANSIDX = ?");
                throwable = null;
                try {
                    stmt.setLong(1, vhidx);
                    stmt.setTimestamp(2, committedDate);
                    stmt.setLong(3, this.transactionId);
                    stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return false;
            }
            if (this.getGift() != null) {
                try {
                    stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRAND SET GIFT_REQUEST_ID = ? WHERE VHIDX = ? AND VSHIDX = ?");
                    throwable = null;
                    try {
                        stmt.setString(1, this.requestId);
                        stmt.setLong(2, vhidx);
                        if (this.giftLine != null) {
                            stmt.setLong(3, this.giftLine.getVshidx());
                        } else {
                            stmt.setNull(3, 4);
                        }
                        stmt.executeUpdate();
                        break block47;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    return false;
                }
            }
            try {
                stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET REWARDS_REQUEST_ID = ?, REWARDS_REDEMPTION_VALUE = ? WHERE VHIDX = ?");
                throwable = null;
                try {
                    stmt.setString(1, this.requestId);
                    stmt.setDouble(2, this.amount);
                    stmt.setLong(3, vhidx);
                    stmt.executeUpdate();
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return false;
            }
        }
        return true;
    }

    protected boolean reverseRedemption() {
        if (this.transactionId == 0L) {
            return false;
        }
        Timestamp reversalDate = new Timestamp(new Date().getTime());
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE REWARDS_REDEMPTION_REQUEST SET REVERSAL_DATE = ?, REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setTimestamp(1, reversalDate);
            stmt.setLong(2, this.transactionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return false;
    }

    protected boolean logFailedReversal() {
        if (this.transactionId == 0L) {
            return false;
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE REWARDS_REDEMPTION_REQUEST SET REVERSAL_ATTEMPT_COUNT = COALESCE(REVERSAL_ATTEMPT_COUNT,0) + 1 WHERE TRANSIDX = ?");){
            stmt.setLong(1, this.transactionId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return false;
    }

    protected static ArrayList<RetailRewardsDataTransaction> getAllTransactionsToReverse() {
        ArrayList<RetailRewardsDataTransaction> list = new ArrayList<RetailRewardsDataTransaction>();
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT TRANSIDX, REQUEST_DATE, REVERSAL_ATTEMPT_COUNT FROM REWARDS_REDEMPTION_REQUEST WHERE VHIDX IS NULL AND REVERSAL_DATE IS NULL  AND COALESCE(REVERSAL_ATTEMPT_COUNT,0) <= " + MAX_REVERSAL_ATTEMPTS + " AND TILL_NAME = " + PosUtils.StringToSqlString(SP.sParams.tillnum));){
            while (query.next()) {
                int retryCount;
                Timestamp requestDate = query.getTimestamp("REQUEST_DATE");
                if (!RetailRewardsDataTransaction.canRetryReversal(requestDate, retryCount = query.getInt("REVERSAL_ATTEMPT_COUNT"))) continue;
                list.add(new RetailRewardsDataTransaction(query.getLong("TRANSIDX")));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return list;
    }

    protected void setPeridx(long peridx) {
        this.peridx = peridx;
    }

    protected long getPeridx() {
        return this.peridx;
    }

    protected String getRequestId() {
        return this.requestId;
    }

    protected double getAmount() {
        return this.amount;
    }

    protected void setAmount(double amount) {
        this.amount = amount;
    }

    protected long getGiftSkuIdx() {
        return this.giftLine != null ? this.giftLine.getSkuidx() : this.overrideSkuIdx;
    }

    protected Gift getGift() {
        return this.giftLine != null ? this.giftLine.getGift() : this.overrideGift;
    }

    protected void setGiftLine(StyleLine giftLine) {
        this.giftLine = giftLine;
    }

    protected static boolean canRetryReversal(Timestamp requestTime, int retryCount) {
        long retryMiliSeconds = RetailRewardsDataTransaction.calculateRetryMiliSeconds(retryCount);
        Date now = new Date();
        return requestTime.getTime() + retryMiliSeconds < now.getTime();
    }

    protected static long calculateRetryMiliSeconds(int retryCount) {
        if (retryCount == 0) {
            return 0L;
        }
        return (long)Math.pow(2.0, (double)retryCount * 0.74) * 60L * 1000L;
    }
}

