/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;

public class TaxExemptReason {
    private long exemptIdx;
    private String description;

    public TaxExemptReason(long exemptIdx, String description) {
        this.exemptIdx = exemptIdx;
        this.description = description;
    }

    public long getExemptIdx() {
        return this.exemptIdx;
    }

    public void setExemptIdx(long exemptIdx) {
        this.exemptIdx = exemptIdx;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public static Vector<TaxExemptReason> getAllReasons() {
        Vector<TaxExemptReason> reasons = new Vector<TaxExemptReason>();
        reasons.addElement(new TaxExemptReason(0L, ""));
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT EXEMPTIDX, DESCRIPT FROM TAX_EXEMPT_REASONS ORDER BY DESCRIPT");){
            while (sql.next()) {
                TaxExemptReason reason = new TaxExemptReason(sql.getLong(1), sql.getString(2));
                reasons.addElement(reason);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return reasons;
    }

    public static int findReasonIndex(Vector<TaxExemptReason> reasons, long reasonIdx) {
        for (int i = 0; i < reasons.size(); ++i) {
            if (reasons.elementAt(i).getExemptIdx() != reasonIdx) continue;
            return i;
        }
        return 0;
    }
}

