/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import jpos.StringUtils;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DespatchInfo;
import jpos.person.Country;

public class TaxLookupDeliveryInfo {
    private String addressLine1 = "";
    private String addressLine2 = "";
    private String city = "";
    private String state = "";
    private String postcode = "";
    private Country country = new Country();
    private boolean deliveryAddressLoaded = false;

    public TaxLookupDeliveryInfo(DeliveryInfo deliveryInfo, DespatchInfo despatchInfo) {
        if (deliveryInfo != null && deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY) {
            this.addressLine1 = deliveryInfo.getAddressLine1();
            this.addressLine2 = deliveryInfo.getAddressLine2();
            this.city = deliveryInfo.getCity();
            this.state = deliveryInfo.getState();
            this.postcode = deliveryInfo.getPostcode();
            this.country = deliveryInfo.getCountry();
            this.deliveryAddressLoaded = true;
        } else if (despatchInfo != null && despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH) {
            this.addressLine1 = despatchInfo.getAddressLine1();
            this.addressLine2 = despatchInfo.getAddressLine2();
            this.city = despatchInfo.getCity();
            this.state = despatchInfo.getState();
            this.postcode = despatchInfo.getPostcode();
            this.country = despatchInfo.getCountry();
            this.deliveryAddressLoaded = true;
        }
    }

    public String getAddressLine1() {
        return StringUtils.nullToEmpty(this.addressLine1);
    }

    public String getAddressLine2() {
        return StringUtils.nullToEmpty(this.addressLine2);
    }

    public String getCity() {
        return StringUtils.nullToEmpty(this.city);
    }

    public String getState() {
        return StringUtils.nullToEmpty(this.state);
    }

    public String getPostcode() {
        return StringUtils.nullToEmpty(this.postcode);
    }

    public Country getCountry() {
        return this.country;
    }

    public boolean isDeliveryAddressLoaded() {
        return this.deliveryAddressLoaded;
    }

    public boolean isDeliveryAddressComplete() {
        return !this.addressLine1.isEmpty() && !this.city.isEmpty() && !this.state.isEmpty() && !this.postcode.isEmpty() && !this.country.getName().isEmpty();
    }
}

