/*
 * Decompiled with CFR 0.152.
 */
package jpos.transreq;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.basscom.utils.Utils;
import jpos.transreq.PaTransferRequest;
import jpos.transreq.PaTransferRequestFoot;
import org.jdom.Element;

public class FrTransferRequest
extends PosFrame {
    private boolean completing = false;
    protected Element transRoot = null;

    public FrTransferRequest(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 9, 11153L, psParams, StoreParams.res.getString("Transfer_Requests"));
        this.paBody = new PaTransferRequest(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaTransferRequestFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaTransferRequest)this.paBody).tfBarcode.requestFocus();
            this.setButtons();
        }
    }

    @Override
    protected void setTransType() {
        this.setTransType(691);
    }

    @Override
    public void setTransType(int ptype) {
        this.transType = ptype;
        if (this.paBody != null) {
            this.setButtons();
            ((PaTransferRequest)this.paBody).tfBarcode.requestFocus();
            ((PaTransferRequest)this.paBody).tfBarcode.setText("");
        }
    }

    @Override
    public boolean validateTrans() {
        PaTransferRequest body = (PaTransferRequest)this.paBody;
        if (body.tblStyles.isEditing()) {
            body.tblStyles.getCellEditor().stopCellEditing();
        }
        if (!((PaTransferRequestFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (body.tblStyles.getQty() <= 0.0) {
            return false;
        }
        if (body.tfWhse.getText().length() == 0 || body.tfWhse.getidx() <= 0L) {
            DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a8"));
            body.tfWhse.requestFocus();
            return false;
        }
        Object[] objs = new Object[]{PosDouble.valueOf(body.tblStyles.getQty(), 4), body.tfWhse.getDesc()};
        return DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Request_units_from"), objs), StoreParams.res.getString("Confirm_Request"), 2, 3) == 0;
    }

    @Override
    public boolean completeTrans() {
        if (this.completing) {
            return false;
        }
        this.completing = true;
        try {
            boolean bl = super.completeTrans();
            return bl;
        }
        finally {
            this.completing = false;
        }
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            String transNunber = this.sParams.getStore().getStoreNo() + "-" + this.vhidx;
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, COMPLETE, TILL_NUMBER, TO_WIDX, SALE_DATE) VALUES(?, ?, 1, ?, ?, current_timestamp, ?, ?, ?, ?, 0, ?, ?, TRUNC_DATE(current_timestamp))");){
                prepStmt.setLong(1, this.vhidx);
                prepStmt.setInt(2, this.transType);
                prepStmt.setLong(3, ((PaTransferRequest)this.paBody).tfWhse.getidx());
                prepStmt.setString(4, transNunber);
                prepStmt.setLong(5, this.getUser().getPeridx());
                prepStmt.setLong(6, this.getUser().getMemidx());
                prepStmt.setLong(7, this.getUser().getPeridx());
                prepStmt.setLong(8, this.getUser().getMemidx());
                prepStmt.setString(9, this.sParams.tillnum);
                prepStmt.setLong(10, this.sParams.getStoreIdx());
                prepStmt.executeUpdate();
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            ((PaTransferRequest)this.paBody).tblStyles.db_insertLines(this.transType);
            prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = ?");
            var4_5 = null;
            try {
                prepStmt.setLong(1, this.sParams.currVal("XRET_TRANH"));
                prepStmt.executeUpdate();
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (prepStmt != null) {
                    if (var4_5 != null) {
                        try {
                            prepStmt.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        prepStmt.close();
                    }
                }
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
            PosUtils.endTrans(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Request_sent"), ((PaTransferRequest)this.paBody).tfWhse.getDesc()), StoreParams.res.getString("Request_complete"), 1);
        return true;
    }

    protected void setButtons() {
        if (this.docknum == null) {
            if (((PaTransferRequest)this.paBody).tblStyles.getRowCount() > 0) {
                ((PaTransferRequestFoot)this.paFoot).bDelete.setEnabled(true);
            } else {
                ((PaTransferRequestFoot)this.paFoot).bDelete.setEnabled(false);
            }
            if (((PaTransferRequest)this.paBody).tblStyles.getQty() > 0.0) {
                ((PaTransferRequestFoot)this.paFoot).bComplete.setEnabled(true);
            } else {
                ((PaTransferRequestFoot)this.paFoot).bComplete.setEnabled(false);
            }
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            super.voidTrans(logout);
            this.transRoot = null;
            ((PaTransferRequest)this.paBody).tblStyles.clear();
            ((PaTransferRequest)this.paBody).tfWhse.clear();
            ((PaTransferRequest)this.paBody).tfBarcode.setText("");
            ((PaTransferRequest)this.paBody).lFeedBack2.setText("");
            ((PaTransferRequest)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            this.setButtons();
        }
    }

    @Override
    public void delLines() {
        if (((PaTransferRequestFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaTransferRequest)this.paBody).delLines();
            this.setFocus();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaTransferRequestFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaTransferRequestFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaTransferRequestFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaTransferRequest)this.paBody).tblStyles.getRowCount() == 0 && ((PaTransferRequest)this.paBody).tfWhse.getidx() <= 0L;
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaTransferRequest)this.paBody).tblStyles.setEditable(this.editable);
        ((PaTransferRequest)this.paBody).tfWhse.setEnabled(this.editable);
        ((PaTransferRequestFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaTransferRequestFoot)this.paFoot).bDelete.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    protected void setTransnum() {
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaTransferRequest)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaTransferRequest)this.paBody).tblStyles.model.getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaTransferRequest)this.paBody).tblStyles.RefreshImage();
    }

    @Override
    public void processLogin() {
    }

    @Override
    protected void setDocketnum() {
    }
}

