/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.ui.Colours;

public class StatusButton
extends JButton {
    String message;
    Object parent;
    Color cOrigForegroundClr;

    public StatusButton(String msg) {
        this.message = msg;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public StatusButton(String msg, Object pparent) {
        this.message = msg;
        this.parent = pparent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    private void jbInit() throws Exception {
        if (UIManager.getBorder("Button.border").toString().indexOf("XP") > 0) {
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                StatusButton.this.this_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                StatusButton.this.this_focusLost(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusButton.this.this_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusButton.this.this_mouseExited(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && StatusButton.this.isEnabled() && StatusButton.this.isVisible()) {
                    e.setKeyCode(32);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && StatusButton.this.isEnabled() && StatusButton.this.isVisible()) {
                    e.setKeyCode(32);
                }
            }
        });
        this.cOrigForegroundClr = this.getForeground();
    }

    public Object getParentForm() {
        if (this.parent == null) {
            this.parent = this.getTopLevelAncestor();
        }
        return this.parent;
    }

    void this_mouseEntered(MouseEvent e) {
        if (this.getParentForm() instanceof PosFrame) {
            ((PosFrame)this.getParentForm()).setStatusText(this.message);
        }
    }

    void this_mouseExited(MouseEvent e) {
        if (this.getParentForm() instanceof PosFrame) {
            ((PosFrame)this.getParentForm()).resetStatus();
        }
    }

    void this_focusGained(FocusEvent e) {
        this.setForeground(Colours.BLUE);
        if (this.getParentForm() instanceof PosFrame) {
            ((PosFrame)this.getParentForm()).setStatusMsg(this.message);
        }
    }

    void this_focusLost(FocusEvent e) {
        this.setForeground(this.cOrigForegroundClr);
        if (this.getParentForm() instanceof PosFrame) {
            ((PosFrame)this.getParentForm()).setStatusMsg("");
        }
    }
}

