/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JRadioButton;
import jpos.ui.Fonts;
import jpos.ui.UIConstants;

public class TouchRadioButton
extends JRadioButton {
    private static final int MIN_WIDTH = 120;
    private static final int HORIZONTAL_MARGIN = 5;

    public TouchRadioButton(String text) {
        super(text);
        this.init();
    }

    public TouchRadioButton(String msg, boolean selected) {
        super(msg, selected);
        this.init();
    }

    private void init() {
        this.setFont(Fonts.PlainText);
        this.setMargin(new Insets(0, 5, 0, 5));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Math.max(120, d.width);
        d.height = Math.max(UIConstants.BUTTON_HEIGHT, d.height);
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        d.width = Math.max(120, d.width);
        d.height = Math.max(UIConstants.BUTTON_HEIGHT, d.height);
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.width = Math.max(120, d.width);
        d.height = Math.max(UIConstants.BUTTON_HEIGHT, d.height);
        return d;
    }
}

