/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import jpos.ui.Colours;
import jpos.ui.DragScrollListener;
import jpos.ui.Fonts;
import jpos.ui.UIConstants;

public class TouchTable
extends JTable {
    public TouchTable() {
        this.init();
    }

    public TouchTable(TableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        this.addDragScrollListener();
        this.setRowHeight(UIConstants.TABLE_ROW_HEIGHT);
        this.setShowGrid(true);
        this.setGridColor(Colours.GRID_LINES);
        this.setFont(Fonts.PlainText);
        this.setSelectionForeground(Colours.BLACK);
        this.setSelectionBackground(Colours.SELECTED_ROW);
        this.setTableHeader(new JTableHeader(this.getColumnModel()){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = UIConstants.TABLE_HEADER_HEIGHT;
                return d;
            }
        });
        this.getTableHeader().setFont(Fonts.BoldText);
    }

    private void addDragScrollListener() {
        DragScrollListener l = new DragScrollListener(this);
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
    }

    public void updateRowHeightsToFitText() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            int rowHeight = this.getRowHeight();
            for (int column = 0; column < this.getColumnCount(); ++column) {
                Component comp = this.prepareRenderer(this.getCellRenderer(row, column), row, column);
                rowHeight = Math.max(rowHeight, Math.max(comp.getPreferredSize().height, UIConstants.TABLE_ROW_HEIGHT));
            }
            this.setRowHeight(row, rowHeight);
        }
    }
}

