/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Dimension;
import javax.swing.JTextField;
import jpos.ui.Fonts;
import jpos.ui.HintTextFieldUI;
import jpos.ui.UIConstants;

public class TouchTextField
extends JTextField {
    private String hint;
    private int fieldWidth = -1;
    private FontSize fontSize = FontSize.NORMAL;

    public TouchTextField() {
        this((String)null);
    }

    public TouchTextField(FontSize fontSize) {
        this(null, fontSize);
    }

    public TouchTextField(String text) {
        this(text, FontSize.NORMAL);
    }

    public TouchTextField(String text, FontSize fontSize) {
        super(text);
        this.fontSize = fontSize;
        this.init();
    }

    private void init() {
        if (this.fontSize == FontSize.NORMAL) {
            this.setFont(Fonts.PlainText);
        } else {
            this.setFont(Fonts.H2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    public int getFieldHeight() {
        return UIConstants.INPUT_HEIGHT;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.setUI(new HintTextFieldUI(hint, false));
    }

    @Override
    public String getText() {
        String typed = super.getText();
        return typed.equals(this.hint) ? "" : typed;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean oldVisible = this.isVisible();
        super.setVisible(visible);
        this.firePropertyChange("visible", oldVisible, visible);
    }

    public static enum FontSize {
        NORMAL,
        LARGE;

    }
}

