/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.voucher.BaseVoucher;

public class DlgVoucherAmount
extends PosDialog {
    private LabelSubHeading lTitle = new LabelSubHeading();
    private JPanel panelMain = new JPanel();
    private LabelNormal lBalance = new LabelNormal();
    private DecimalField dfBalance;
    private LabelNormal lPayment;
    private DecimalField dfPayment;
    private DialogButton bOk;
    private DialogButton bCancel;
    private GridBagLayout gridBagLayout1;
    private RetTranP retTranP;
    private boolean amountSet;
    private double startingAmount;

    public DlgVoucherAmount(PosFrame frParent, String title, RetTranP retTranP) {
        super(frParent, title, true);
        this.dfBalance = new DecimalField(SP.sParams.storeCurrency);
        this.lPayment = new LabelNormal();
        this.dfPayment = new DecimalField(SP.sParams.storeCurrency);
        this.bOk = new DialogButton("");
        this.bCancel = new DialogButton("");
        this.gridBagLayout1 = new GridBagLayout();
        this.amountSet = false;
        this.startingAmount = 0.0;
        this.retTranP = retTranP;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelMain.setLayout(this.gridBagLayout1);
        this.lTitle.setText(SP.getRS("Enter_Voucher_Amount"));
        this.dfBalance.setText(PosDouble.valueOf(this.getVoucher().getAvailableAmount()).toString());
        this.dfBalance.setFieldWidth(150);
        this.dfBalance.setHorizontalAlignment(4);
        this.dfBalance.setEnabled(false);
        this.dfPayment.setFieldWidth(150);
        this.dfPayment.setHorizontalAlignment(4);
        this.lBalance.setText(SP.getRS("Balance"));
        this.lPayment.setText(SP.getRS("Payment"));
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgVoucherAmount.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgVoucherAmount.this.cancelDialog();
            }
        });
        this.getContentPane().add(this.panelMain);
        this.panelMain.add((Component)this.lTitle, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(20, 20, 10, 20), 0, 0));
        this.panelMain.add((Component)this.lBalance, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelMain.add((Component)this.dfBalance, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelMain.add((Component)this.lPayment, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelMain.add((Component)this.dfPayment, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelMain.add((Component)this.bOk, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelMain.add((Component)this.bCancel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfPayment);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
        this.startingAmount = this.retTranP.getPayType().roundAmt(this.getVoucher().getAvailableAmount()) > this.retTranP.getAmount() ? this.retTranP.getAmount() : this.retTranP.getPayType().roundAmt(this.getVoucher().getAvailableAmount());
        this.dfPayment.setText(PosDouble.valueOf(this.startingAmount).toString());
    }

    @Override
    public void okDialog() {
        double amountRnd = this.retTranP.getPayType().roundAmt(this.dfPayment.getDouble());
        if (amountRnd != this.dfPayment.getDouble()) {
            this.dfPayment.setText(amountRnd);
        } else if (amountRnd < 0.0) {
            this.dfPayment.selectAll();
            this.amountSet = false;
        } else if (amountRnd > this.retTranP.getPayType().roundAmt(this.getVoucher().getAvailableAmount())) {
            DlgMessage.showMessage(this, SP.getRS("Voucher_Amount_Exceeds_Balance"), SP.getRS("Error"), 0);
            this.dfPayment.setText(PosDouble.valueOf(this.startingAmount).toString());
            this.dfPayment.selectAll();
            this.amountSet = false;
        } else if (amountRnd > this.retTranP.getAmount()) {
            DlgMessage.showMessage(this, SP.getRS("Voucher_Amount_Exceeds_Transaction"), SP.getRS("Error"), 0);
            this.dfPayment.setText(PosDouble.valueOf(this.startingAmount).toString());
            this.dfPayment.selectAll();
            this.amountSet = false;
        } else {
            this.retTranP.setAmount(amountRnd);
            this.amountSet = true;
            this.setVisible(false);
        }
    }

    private BaseVoucher getVoucher() {
        return this.retTranP.getVoucherAdapter().getBaseVoucher();
    }

    @Override
    public void cancelDialog() {
        this.amountSet = false;
        this.setVisible(false);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public boolean isAmountSet() {
        return this.amountSet;
    }
}

