/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.sql.Date;
import java.sql.Timestamp;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.voucher.BaseVoucher;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class Voucher
extends BaseVoucher {
    private VoucherType voucherType;
    private String voucherNumber;
    private String externalNumber;
    private String encryptPin;
    private boolean issued = false;
    private long gvcnidx = -1L;
    private double originalAmount = 0.0;
    private double usedAmount = 0.0;
    private Date expiryDate = null;
    private Timestamp issuedDate = null;
    private String issuedStore = "";
    private Timestamp lastUsedDate = null;
    private String lastUsedStore = "";
    private boolean posted = false;
    private String currencyIdx = "";
    private String currencyCode = "";

    public Voucher(VoucherType voucherType, String voucherNumber) {
        this.voucherType = voucherType;
        this.voucherNumber = voucherNumber;
        try {
            this.loadDetails();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public VoucherType getVoucherType() {
        return this.voucherType;
    }

    @Override
    public String getNumber() {
        return this.voucherNumber;
    }

    public String getDisplayNumber() {
        return StringUtils.nullOrEmptyToValue(this.externalNumber, this.voucherNumber);
    }

    public boolean verifyPin(String pin) {
        return pin.equals(VoucherUtils.decryptPin(this.encryptPin));
    }

    @Override
    public boolean isIssued() {
        return this.issued;
    }

    @Override
    public long getGvcnidx() {
        return this.gvcnidx;
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public double getOriginalAmount() {
        return this.originalAmount;
    }

    @Override
    public double getUsedAmount() {
        return this.usedAmount;
    }

    @Override
    public double getAvailableAmount() {
        return this.originalAmount - this.usedAmount;
    }

    @Override
    protected void loadDetails() throws Exception {
        this.originalAmount = 0.0;
        this.usedAmount = 0.0;
        this.issuedStore = "";
        this.lastUsedStore = "";
        this.externalNumber = "";
        if (this.voucherType == null) {
            throw new Exception("Voucher Type has not been set");
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT G.GVCNIDX, G.PIN, COALESCE(G.AMT,0), COALESCE(G.USED_AMT,0), G.EXPIRY_DATE, G.ISSUED_DATE, ISS_W.NAME, G.LAST_REDEEMED_DATE, RED_W.NAME, COALESCE(G.POSTED,0), G.EXTERNAL_NUM, G.CURRENCY_IDX, CURR.CODE AS CURRENCY_CODE FROM GVCN_MAINT G LEFT JOIN REFCODE ISS_W ON G.ISSUED_WIDX = ISS_W.RCIDX LEFT JOIN REFCODE RED_W ON G.LAST_REDEEMED_WIDX = RED_W.RCIDX LEFT JOIN REFCODE CURR ON G.CURRENCY_IDX = CURR.RCIDX WHERE G.\"TYPE\" = 0 AND G.\"ACTIVE\" = 1 AND TRIM(LEADING '0' FROM G.NUM) = TRIM(LEADING '0' FROM " + PosUtils.StringToSqlString(this.voucherNumber) + ")");){
            if (sql.next()) {
                this.issued = true;
                this.gvcnidx = sql.getLong(1);
                this.encryptPin = sql.getString(2);
                this.originalAmount = sql.getDouble(3);
                this.usedAmount = sql.getDouble(4);
                this.expiryDate = sql.getDate(5);
                this.issuedDate = sql.getTimestamp(6);
                this.issuedStore = sql.getString(7);
                this.lastUsedDate = sql.getTimestamp(8);
                this.lastUsedStore = sql.getString(9);
                this.posted = sql.getBoolean(10);
                this.externalNumber = sql.getString("EXTERNAL_NUM");
                this.currencyIdx = sql.getString("CURRENCY_IDX") == null ? "" : sql.getString("CURRENCY_IDX");
                this.currencyCode = sql.getString("CURRENCY_CODE") == null ? "" : sql.getString("CURRENCY_CODE");
            } else {
                this.gvcnidx = -1L;
                if (this.voucherType.getIssueType() == VoucherType.IssueType.SOLD || this.voucherType.isIssueWithSale()) {
                    this.issued = false;
                } else {
                    this.issued = true;
                    this.originalAmount = this.voucherType.getValuePromo(PosUtils.longVal(this.voucherNumber));
                    this.usedAmount = 0.0;
                    this.expiryDate = this.voucherType.getExpiryPromo(PosUtils.longVal(this.voucherNumber));
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public Timestamp getIssuedDate() {
        return this.issuedDate;
    }

    @Override
    public String getIssuedStore() {
        return this.issuedStore;
    }

    @Override
    public Timestamp getLastUsedDate() {
        return this.lastUsedDate;
    }

    @Override
    public String getLastUsedStore() {
        return this.lastUsedStore;
    }

    @Override
    public boolean isPosted() {
        return this.posted;
    }

    @Override
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public boolean isPinAvailable() {
        return this.encryptPin != null && !this.encryptPin.isEmpty();
    }

    public String getPin() {
        return this.encryptPin;
    }

    @Override
    public String getCurrencyIdx() {
        return this.currencyIdx;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }
}

