/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import jpos.ExceptionInjector;
import jpos.RegexOperation;
import jpos.RestRequest;
import jpos.StringUtils;
import jpos.voucher.vii.CheckBalanceRequest;
import jpos.voucher.vii.CheckBalanceResponse;
import jpos.voucher.vii.LoadRequest;
import jpos.voucher.vii.LoadResponse;
import jpos.voucher.vii.NewOrderRequest;
import jpos.voucher.vii.NewOrderResponse;
import jpos.voucher.vii.RedemptionRequest;
import jpos.voucher.vii.RedemptionResponse;
import jpos.voucher.vii.Request;
import jpos.voucher.vii.UndoRequest;
import jpos.voucher.vii.UndoResponse;
import jpos.voucher.vii.VerifyStoreRequest;
import jpos.voucher.vii.VerifyStoreResponse;
import jpos.voucher.vii.ViiApiException;
import jpos.voucher.vii.ViiConfig;
import jpos.voucher.vii.XmlSerialiser;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class ViiApi {
    public static final RequestConfig TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).setCookieSpec("standard").build();
    public static final RegexOperation[] LOG_MASKS = new RegexOperation[]{RegexOperation.generateHideXmlElementOperation("viiUserName", "***HIDDEN***"), RegexOperation.generateHideXmlElementOperation("viiPassword", "***HIDDEN***"), RegexOperation.generateHideXmlElementOperation("PIN", "***HIDDEN***")};
    private ViiConfig config;
    private Map<String, String> httpHeaders;

    public ViiApi(ViiConfig config) {
        this.config = config;
        this.httpHeaders = new HashMap<String, String>();
    }

    public CheckBalanceResponse CheckCardBalance(String cardNumber, String pin) throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_BALANCE_ENQUIRY, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(CheckBalanceResponse.class, new CheckBalanceRequest(this.config, cardNumber, pin), this.config.getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    public RedemptionResponse RedeemGiftVoucher(RedemptionRequest request) throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_REDEEM_VOUCHER, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(RedemptionResponse.class, request, this.config.getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    public LoadResponse LoadGiftVoucher(LoadRequest request) throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_LOAD_VOUCHER, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(LoadResponse.class, request, this.config.getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    public UndoResponse Undo(String cardNumber, String transactionId) throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_UNDO, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(UndoResponse.class, new UndoRequest(this.config, cardNumber, transactionId), this.config.getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    public VerifyStoreResponse VerifyStore() throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_VERIFY_STORE, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(VerifyStoreResponse.class, new VerifyStoreRequest(this.config), this.config.getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    public NewOrderResponse NewGiftVoucher(NewOrderRequest request) throws ViiApiException {
        ExceptionInjector.Inject(ExceptionInjector.Process.VII_NEWORDER_VOUCHER, new ViiApiException(true, "Injected Exception", new Object[0]));
        return ViiApi.apiPost(NewOrderResponse.class, request, this.config.getDigitalConfig().getUrl(), this.httpHeaders, TIMEOUT_OPEN10_READ30_AND_COOKIE_STANDARD, false);
    }

    private static <T> T apiPost(Class<T> responseClass, Request request, String url, Map<String, String> headers, RequestConfig reqConfig, boolean secret) throws ViiApiException {
        try {
            RestRequest.Response resp;
            RestRequest rest = new RestRequest();
            if (reqConfig != null) {
                rest.setConfig(reqConfig);
            }
            if (request != null) {
                rest.setPostXml(request.serialise());
                rest.setLogMasks(LOG_MASKS);
            }
            if (!(resp = rest.request((HttpRequestBase)new HttpPost(url), headers, secret)).isSuccess()) {
                throw new ViiApiException(true, "vii_fail_http", resp.StatusCode);
            }
            if (StringUtils.isNullOrEmpty(resp.Content)) {
                throw new ViiApiException(true, "vii_fail_empty", new Object[0]);
            }
            return responseClass != null ? (T)XmlSerialiser.deserialise(responseClass, resp.Content) : null;
        }
        catch (UnknownHostException e) {
            throw new ViiApiException(false, "vii_fail_unknown_host", e.getMessage());
        }
        catch (SocketTimeoutException e) {
            throw new ViiApiException(true, "vii_fail_timeout", new Object[0]);
        }
        catch (IOException | JAXBException e) {
            throw new ViiApiException(true, "vii_fail_exception", e.getMessage());
        }
    }
}

