/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jpos.Currency;
import jpos.PosUtils;
import jpos.ui.Colours;
import jpos.ui.TouchTextField;

public class DecimalField
extends TouchTextField {
    private DecimalFormatSymbols decimalFormatSymbols;
    private IDecimalFormatter formatter;
    private Toolkit toolkit;

    public DecimalField(DecimalFormat format, int precision) {
        this(format, precision, TouchTextField.FontSize.NORMAL);
    }

    public DecimalField(final DecimalFormat format, final int precision, TouchTextField.FontSize fontSize) {
        super(fontSize);
        this.formatter = new IDecimalFormatter(){

            @Override
            public Number parse(String value) throws ParseException {
                return format.parse(value);
            }

            @Override
            public String format(double value) {
                return format.format(PosUtils.scale(value, precision));
            }
        };
        this.decimalFormatSymbols = format.getDecimalFormatSymbols();
        this.init();
    }

    public DecimalField(Currency currency) {
        this(currency, TouchTextField.FontSize.NORMAL);
    }

    public DecimalField(final Currency currency, TouchTextField.FontSize fontSize) {
        super(fontSize);
        this.formatter = new IDecimalFormatter(){

            @Override
            public Number parse(String value) throws ParseException {
                return currency.parseDetail(value);
            }

            @Override
            public String format(double value) {
                return currency.formatDetail(value);
            }
        };
        this.decimalFormatSymbols = currency.getDetailDecimalFormatSymbols();
        this.init();
    }

    public void init() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setDisabledTextColor(Colours.BLACK);
        this.setHorizontalAlignment(4);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DecimalField.this.callf();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                DecimalField.this.this_focusLost(e);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DecimalField.this.this_actionPerformed(e);
            }
        });
    }

    private void callf() {
        this.selectAll();
    }

    private void this_focusLost(FocusEvent e) {
    }

    private void this_actionPerformed(ActionEvent e) {
    }

    @Override
    protected Document createDefaultModel() {
        return new DecimalDocument();
    }

    @Override
    public void setText(String t) {
        if ("".equals(t)) {
            super.setText(t);
        } else {
            super.setText(this.formatter.format(PosUtils.doubleValFormatted(t)));
        }
    }

    public void setText(double d) {
        super.setText(this.formatter.format(d));
    }

    public double getDouble() {
        try {
            return this.formatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    protected class DecimalDocument
    extends PlainDocument {
        protected DecimalDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            block2: {
                try {
                    DecimalField.this.formatter.parse(str);
                }
                catch (Exception e) {
                    if (str.length() <= 0) break block2;
                    DecimalFormatSymbols symbols = DecimalField.this.decimalFormatSymbols;
                    if (str.charAt(0) == symbols.getDecimalSeparator() || str.charAt(0) == symbols.getPercent() || str.indexOf(symbols.getCurrencySymbol()) != -1 || str.charAt(0) == symbols.getMinusSign() || str.charAt(0) == symbols.getGroupingSeparator()) break block2;
                    DecimalField.this.toolkit.beep();
                    return;
                }
            }
            super.insertString(offs, str, a);
        }
    }

    private static interface IDecimalFormatter {
        public Number parse(String var1) throws ParseException;

        public String format(double var1);
    }
}

