/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.swing.JPanel;
import jpos.DlgHistoryFilter_bCancel_actionAdapter;
import jpos.DlgHistoryFilter_bOk_actionAdapter;
import jpos.DlgMessage;
import jpos.HistoryOptions;
import jpos.HistorySearchType;
import jpos.PosDateField;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.crypt.PersonCrypt;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchLabel;
import jpos.ui.TouchTextField;

public class DlgHistoryFilter
extends PosDialog {
    private PosDateField tfDateFrom = new PosDateField(this);
    private PosDateField tfDateTo = new PosDateField(this);
    private TouchTextField tfPhone = new TouchTextField();
    private TouchTextField tfFirstname = new TouchTextField();
    private TouchTextField tfSurname = new TouchTextField();
    private TouchTextField tfTransactionNumber = new TouchTextField();
    private TouchTextField tfReceiptCartonNumber = new TouchTextField();
    private StoreParams sParams;
    BarcodeSearchField tfProductCode = new BarcodeSearchField(TouchTextField.FontSize.NORMAL){

        @Override
        public void actionSearch() {
            super.actionSearch();
            if (this.getidx() == 0L || this.getidx() == -1L) {
                this.actionValidate();
            }
        }
    };
    SearchPanel barcodeSearchPanel;
    private DialogButton bSearch = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private StringBuffer extraWhere;
    private boolean online;
    private HistoryOptions options;
    private StringBuffer result;
    private HistorySearchType.SearchType searchType;

    public DlgHistoryFilter(PosFrame frame, String title, boolean online, HistoryOptions options, StringBuffer extraWhere, StringBuffer result, HistorySearchType.SearchType searchType) {
        super(frame, title, true);
        this.extraWhere = extraWhere;
        this.online = online;
        this.options = options;
        this.result = result;
        this.searchType = searchType;
        try {
            if (!online) {
                PersonCrypt.getInstance().acquireKey(frame);
            }
            this.jbInit();
            this.populate();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public DlgHistoryFilter(PosFrame frame, String title, boolean online, HistoryOptions options, StringBuffer extraWhere, StringBuffer result) {
        this(frame, title, online, options, extraWhere, result, HistorySearchType.SearchType.OTHERS);
    }

    private void jbInit() throws Exception {
        this.tfProductCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgHistoryFilter.this.tfProductCode_actionPerformed(e);
            }
        });
        this.setupField(this.tfTransactionNumber, 200);
        this.setupField(this.tfPhone, 200);
        if (!this.online && !PersonCrypt.getInstance().keyExists()) {
            this.tfPhone.setEnabled(false);
            this.tfPhone.setHint(SP.getRS("Offline"));
        }
        this.setupField(this.tfFirstname, 200);
        this.setupField(this.tfSurname, 200);
        this.setupField(this.tfProductCode, 200);
        this.setupField(this.tfDateFrom, 100);
        this.setupField(this.tfDateTo, 100);
        this.setupField(this.tfReceiptCartonNumber, 200);
        this.barcodeSearchPanel = new SearchPanel(this.tfProductCode);
        this.bSearch.setActionCommand("bOk");
        this.bSearch.setText(StoreParams.res.getString("Search"));
        this.bSearch.addActionListener(new DlgHistoryFilter_bOk_actionAdapter(this));
        this.bCancel.setActionCommand("bCancel");
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new DlgHistoryFilter_bCancel_actionAdapter(this));
        JPanel paMain = new JPanel(new GridBagLayout());
        int yPosition = 0;
        this.getContentPane().add(paMain);
        JPanel paTopPadding = new JPanel(new GridBagLayout());
        paMain.add((Component)paTopPadding, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        if (this.options.searchTransactionNumber() || this.options.searchReferenceNumber()) {
            JPanel paTransactionNumber = new JPanel(new GridBagLayout());
            LabelNormal lTransactionNumber = new LabelNormal(StoreParams.res.getString("Transaction_Number"));
            this.setupLabel(lTransactionNumber);
            paTransactionNumber.add((Component)lTransactionNumber, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paTransactionNumber.add((Component)this.tfTransactionNumber, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paTransactionNumber, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (this.options.searchPhone()) {
            JPanel paPhone = new JPanel(new GridBagLayout());
            LabelNormal lPhone = new LabelNormal(StoreParams.res.getString("Phone_Email"));
            this.setupLabel(lPhone);
            paPhone.add((Component)lPhone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paPhone.add((Component)this.tfPhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paPhone, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (this.options.searchFirstname()) {
            JPanel paFirstname = new JPanel(new GridBagLayout());
            LabelNormal lFirstname = new LabelNormal(StoreParams.res.getString("First_Name"));
            this.setupLabel(lFirstname);
            paFirstname.add((Component)lFirstname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paFirstname.add((Component)this.tfFirstname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paFirstname, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (this.options.searchSurname()) {
            JPanel paSurname = new JPanel(new GridBagLayout());
            LabelNormal lSurname = new LabelNormal(StoreParams.res.getString("Surname"));
            this.setupLabel(lSurname);
            paSurname.add((Component)lSurname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paSurname.add((Component)this.tfSurname, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paSurname, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (this.options.searchProductCode()) {
            JPanel paProductCode = new JPanel(new GridBagLayout());
            LabelNormal lProductCode = new LabelNormal(StoreParams.res.getString("Product_Code"));
            this.setupLabel(lProductCode);
            paProductCode.add((Component)lProductCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paProductCode.add((Component)this.barcodeSearchPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paProductCode, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (SP.sParams.bReceiptPerCarton && this.options.searchReceiptCartonNumber()) {
            JPanel paCartonNumber = new JPanel(new GridBagLayout());
            LabelNormal lcartonNumber = new LabelNormal(StoreParams.res.getString("Receipt_Carton_Number"));
            this.setupLabel(lcartonNumber);
            paCartonNumber.add((Component)lcartonNumber, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paCartonNumber.add((Component)this.tfReceiptCartonNumber, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paCartonNumber, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        if (this.options.searchTransactionDates()) {
            JPanel paDates = new JPanel(new GridBagLayout());
            LabelNormal lFrom = new LabelNormal(StoreParams.res.getString("Date_From"));
            this.setupLabel(lFrom);
            LabelNormal lTo = new LabelNormal(StoreParams.res.getString("To"));
            SearchPanel fromDateSearchPanel = new SearchPanel(this.tfDateFrom, SearchButton.SearchIcon.CALENDAR);
            SearchPanel toDateSearchPanel = new SearchPanel(this.tfDateTo, SearchButton.SearchIcon.CALENDAR);
            paDates.add((Component)lFrom, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            paDates.add((Component)fromDateSearchPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            paDates.add((Component)lTo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            paDates.add((Component)toDateSearchPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            paMain.add((Component)paDates, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        JPanel paButtons = new JPanel(new GridBagLayout());
        paButtons.add((Component)this.bSearch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        paButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        paMain.add((Component)paButtons, new GridBagConstraints(0, yPosition++, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void okDialog() {
        if (!(this.bCancel.hasFocus() || this.tfProductCode.hasFocus() && this.tfProductCode.getText().length() > 0)) {
            this.bSearch.doClick();
        }
    }

    @Override
    public void cancelDialog() {
        this.bCancel.doClick();
    }

    void bOk_actionPerformed(ActionEvent e) {
        if (!this.tfDateFrom.isValidDate()) {
            this.tfDateFrom.actionValidate();
            if (!this.tfDateFrom.isValidDate()) {
                return;
            }
        }
        if (!this.tfDateTo.isValidDate()) {
            this.tfDateTo.actionValidate();
            if (!this.tfDateTo.isValidDate()) {
                return;
            }
        }
        if (!this.hasSelections() && DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("No_Selections_Message"), "\n"), SP.getRS("No_Selections"), 0, 2) != 0) {
            return;
        }
        this.save();
        switch (this.searchType) {
            case FLOOR_TO_DOOR_HISTORY: {
                this.appendTransactionNumberWhere_FloorToDoor();
                this.appendPhoneWhere_Default();
                this.appendNameWhere_FloorToDoor();
                break;
            }
            default: {
                this.appendTransactionNumberWhere_Default();
                this.appendPhoneWhere_Default();
                this.appendNameWhere_Default();
                this.appendProductWhere_Default();
                this.appendDateWhere_Default();
                this.appendCartonNumberWhere();
            }
        }
        this.result.setLength(0);
        this.result.append("OK");
        this.dispose();
    }

    private boolean hasSelections() {
        return !this.tfDateFrom.getText().isEmpty() || !this.tfPhone.getText().isEmpty() || !this.tfFirstname.getText().isEmpty() || !this.tfSurname.getText().isEmpty() || !this.tfTransactionNumber.getText().isEmpty() || !this.tfProductCode.getText().isEmpty() || !this.tfReceiptCartonNumber.getText().isEmpty();
    }

    private void appendDateWhere_Default() {
        if (this.options.searchTransactionDates()) {
            if (this.tfDateFrom.getText().length() > 0) {
                if (this.online) {
                    this.extraWhere.append(" AND H.TRAND >= TO_DATE('" + this.tfDateFrom.getDateFormatter().toStringInternal() + "', 'yyyy-MM-dd') ");
                } else {
                    this.extraWhere.append(" AND H.TRAND >= CAST('" + this.tfDateFrom.getDateFormatter().toStringInternal() + "' AS DATE) ");
                }
            }
            if (this.tfDateTo.getText().length() > 0) {
                if (this.online) {
                    this.extraWhere.append(" AND H.TRAND < TO_DATE('" + this.tfDateTo.getDateFormatter().toStringInternal() + "', 'yyyy-MM-dd') + 1 ");
                } else {
                    this.extraWhere.append(" AND H.TRAND < CAST('" + this.tfDateTo.getDateFormatter().toStringInternal() + "' AS DATE) + 1 ");
                }
            }
        }
    }

    private void appendTransactionNumberWhere_FloorToDoor() {
        if (this.options.searchTransactionNumber() && this.tfTransactionNumber.getText().length() > 0) {
            String transactionNumber = this.tfTransactionNumber.getText().toUpperCase();
            if (transactionNumber.startsWith("O")) {
                this.extraWhere.append(" AND WH.ORDER_NUMBER = " + PosUtils.StringToSqlString(transactionNumber));
            } else if (transactionNumber.startsWith("D")) {
                this.extraWhere.append(" AND WH.WEBSHIDX IN (SELECT T.WEBSHIDX FROM WEBSALES_TRANSACTIONS T JOIN RET_TRANH RH USING(VHIDX) WHERE RH.DOCKET_NUMBER = " + PosUtils.StringToSqlString(transactionNumber.substring(4)) + ")");
            } else {
                this.extraWhere.append(" AND WH.WEBSHIDX IN (SELECT T.WEBSHIDX FROM WEBSALES_TRANSACTIONS T JOIN RET_TRANH RH USING(VHIDX) WHERE RH.TRANS_NUMBER = " + PosUtils.StringToSqlString(transactionNumber) + ")");
            }
        }
    }

    private void appendTransactionNumberWhere_Default() {
        boolean useTransNumber = this.options.searchTransactionNumber() && this.tfTransactionNumber.getText().length() > 0;
        boolean useRefNumber = this.options.searchReferenceNumber() && this.tfTransactionNumber.getText().length() > 0 && this.online;
        StringBuffer transactionWhere = new StringBuffer();
        StringBuffer referenceWhere = new StringBuffer();
        if (useTransNumber) {
            String transactionNumber = this.tfTransactionNumber.getText().toUpperCase();
            if (transactionNumber.length() > 4 && (transactionNumber.startsWith("O") || transactionNumber.startsWith("L") || transactionNumber.startsWith("S"))) {
                String storeCode = transactionNumber.substring(1, 4);
                String number = transactionNumber.substring(4);
                transactionWhere.append("H.TRANS_NUMBER = " + PosUtils.StringToSqlString(number) + " AND W.STORENO = " + PosUtils.StringToSqlString(storeCode));
                if (transactionNumber.startsWith("O")) {
                    transactionWhere.append(" AND H.TR_TYPE IN (714,715)");
                } else if (transactionNumber.startsWith("L")) {
                    transactionWhere.append(" AND H.TR_TYPE IN (240,241,242)");
                } else {
                    transactionWhere.append(" AND H.TR_TYPE IN (243,244,245)");
                }
            } else {
                transactionWhere.append("H.TRANS_NUMBER = " + PosUtils.StringToSqlString(transactionNumber));
            }
        }
        if (useRefNumber) {
            referenceWhere.append("UPPER(H.CORDER) = " + PosUtils.StringToSqlString(this.tfTransactionNumber.getText().toUpperCase()));
        }
        if (transactionWhere.length() > 0 && referenceWhere.length() > 0) {
            this.extraWhere.append(" AND ((" + transactionWhere.toString() + ") OR (" + referenceWhere.toString() + ")) ");
        } else if (transactionWhere.length() > 0) {
            this.extraWhere.append(" AND " + transactionWhere.toString() + " ");
        } else if (referenceWhere.length() > 0) {
            this.extraWhere.append(" AND " + referenceWhere.toString() + " ");
        }
    }

    private void appendCartonNumberWhere() {
        String cartonNumber = this.tfReceiptCartonNumber.getText();
        if (this.options.searchReceiptCartonNumber() && cartonNumber.length() > 0) {
            this.extraWhere.append(" AND H.SSCC = " + PosUtils.StringToSqlString(cartonNumber));
        }
    }

    private void appendPhoneWhere_Default() {
        if (this.options.searchPhone() && this.tfPhone.getText().length() > 0) {
            this.tfPhone.setText(this.tfPhone.getText().replace("'", ""));
            if (this.online && this.options.searchDeliveryAddress()) {
                this.extraWhere.append(" AND EXISTS (SELECT 1 FROM PHONENUM PN WHERE PN.\"ACTIVE\" = 1 AND (PN.LOCNIDX = " + this.getSearchAlias() + ".DELIVERY_LOCNIDX OR PN.LOCNIDX = P.LOCNIDX) AND UPPER(PN.PHONENUM) LIKE '" + this.tfPhone.getText().toUpperCase() + "%') ");
            } else if (!this.online) {
                this.extraWhere.append(PersonCrypt.getInstance().getContactWhere("P", this.tfPhone.getText(), this.sParams.conn));
            } else {
                this.extraWhere.append(" AND EXISTS (SELECT 1 FROM PHONENUM PN WHERE PN.\"ACTIVE\" = 1 and PN.LOCNIDX = P.LOCNIDX AND UPPER(PN.PHONENUM) LIKE '" + this.tfPhone.getText().toUpperCase() + "%') ");
            }
        }
    }

    private void appendNameWhere_FloorToDoor() {
        boolean surname;
        StringBuffer personWhere = new StringBuffer();
        boolean firstname = this.options.searchFirstname() && this.tfFirstname.getText().length() > 0;
        boolean bl = surname = this.options.searchSurname() && this.tfSurname.getText().length() > 0;
        if (firstname || surname) {
            personWhere.append("EXISTS (SELECT 1 FROM PERSON P1 WHERE WH.PERIDX = P1.PERIDX AND ");
            if (firstname) {
                this.tfFirstname.setText(this.tfFirstname.getText().replace("'", ""));
                personWhere.append(" UPPER(P1.FIRSTNAME) LIKE '" + this.tfFirstname.getText().toUpperCase() + "%' ");
            }
            if (surname) {
                if (firstname) {
                    personWhere.append("AND");
                }
                this.tfSurname.setText(this.tfSurname.getText().replace("'", ""));
                personWhere.append(" UPPER(P1.SURNAME) LIKE '" + this.tfSurname.getText().toUpperCase() + "%' ");
            }
            personWhere.append(")");
        }
        if (personWhere.length() > 0) {
            this.extraWhere.append(" AND " + personWhere.toString() + " ");
        }
    }

    private void appendNameWhere_Default() {
        boolean includeDelivery;
        StringBuffer personWhere = new StringBuffer();
        StringBuffer deliveryWhere = new StringBuffer();
        boolean firstname = this.options.searchFirstname() && this.tfFirstname.getText().length() > 0;
        boolean surname = this.options.searchSurname() && this.tfSurname.getText().length() > 0;
        boolean bl = includeDelivery = this.options.searchDeliveryAddress() && this.online;
        if (firstname || surname) {
            personWhere.append(" EXISTS (SELECT 1 FROM PERSON P1 WHERE H.CLIENTIDX = P1.PERIDX AND ");
            if (firstname) {
                this.tfFirstname.setText(this.tfFirstname.getText().replace("'", ""));
                personWhere.append(" UPPER(P1.FIRSTNAME) LIKE '" + this.tfFirstname.getText().toUpperCase() + "%' ");
            }
            if (surname) {
                if (firstname) {
                    personWhere.append("AND");
                }
                this.tfSurname.setText(this.tfSurname.getText().replace("'", ""));
                personWhere.append(" UPPER(P1.SURNAME) LIKE '" + this.tfSurname.getText().toUpperCase() + "%' ");
            }
            personWhere.append(")");
        }
        if (includeDelivery && (firstname || surname)) {
            deliveryWhere.append(" EXISTS (SELECT 1 FROM LOCN LN WHERE LN.LOCNIDX = H.DELIVERY_LOCNIDX  AND UPPER(LN.CONTACT) LIKE '%" + this.tfFirstname.getText().toUpperCase() + "%'  AND UPPER(LN.CONTACT) LIKE '%" + this.tfSurname.getText().toUpperCase() + "%') ");
        }
        if (personWhere.length() > 0 && deliveryWhere.length() > 0) {
            this.extraWhere.append(" AND ((" + personWhere.toString() + ") OR (" + deliveryWhere.toString() + ")) ");
        } else if (personWhere.length() > 0) {
            this.extraWhere.append(" AND " + personWhere.toString() + " ");
        } else if (deliveryWhere.length() > 0) {
            this.extraWhere.append(" AND " + deliveryWhere.toString() + " ");
        }
    }

    private void appendProductWhere_Default() {
        if (this.options.searchProductCode() && this.tfProductCode.getText().length() > 0 && this.tfProductCode.getidx() > 0L) {
            this.extraWhere.append(" AND EXISTS (SELECT 1 FROM RET_TRAND D, SKU K, CLR C WHERE D.\"ACTIVE\" = 1 AND D.VHIDX = H.VHIDX AND D.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = " + this.tfProductCode.getidx() + ") ");
        }
    }

    void bCancel_actionPerformed(ActionEvent e) {
        this.result.setLength(0);
        this.frParent.bCanceled = true;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() {
        Statement stmt;
        ResultSet rs;
        block4: {
            rs = null;
            stmt = null;
            try {
                stmt = SP.sParams.getStmt();
                rs = stmt.executeQuery("SELECT CURRENT_DATE - HIST_FROM, CURRENT_DATE FROM STOREPARAMS");
                if (!rs.next()) break block4;
                this.tfDateFrom.setValue(rs.getTimestamp(1));
                this.tfDateTo.setValue(rs.getTimestamp(2));
            }
            catch (Exception e) {
                try {
                    PosUtils.logError(e);
                }
                catch (Throwable throwable) {
                    PosUtils.closeResultSet(rs);
                    PosUtils.closeStatement(stmt);
                    throw throwable;
                }
                PosUtils.closeResultSet(rs);
                PosUtils.closeStatement(stmt);
            }
        }
        PosUtils.closeResultSet(rs);
        PosUtils.closeStatement(stmt);
    }

    private void save() {
        if (this.options.searchTransactionDates()) {
            try {
                String sFrom;
                if (this.tfDateFrom.getText().length() > 0) {
                    sFrom = this.tfDateTo.getText().length() > 0 ? "CAST('" + this.tfDateTo.getDateFormatter().toStringInternal() + "' AS DATE) " : "current_date ";
                    sFrom = sFrom + " - CAST('" + this.tfDateFrom.getDateFormatter().toStringInternal() + "' AS DATE)";
                } else {
                    sFrom = "NULL";
                }
                Statement stmt = null;
                try {
                    stmt = SP.sParams.getStmt();
                    stmt.executeUpdate("UPDATE STOREPARAMS SET HIST_FROM = " + sFrom);
                }
                finally {
                    PosUtils.closeStatement(stmt);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void setupField(TouchTextField field, int width) {
        field.setFieldWidth(width);
    }

    private void setupLabel(TouchLabel label) {
        label.setLabelWidth(140);
        label.setHorizontalAlignment(4);
    }

    private void tfProductCode_actionPerformed(ActionEvent e) {
        StyleLine style;
        if (this.tfProductCode.getText().length() > 0 && (style = new StyleLine(this.tfProductCode.getText(), false, this.sParams)).isValid()) {
            this.tfProductCode.populate(style.getStyleidx());
        }
    }

    private String getSearchAlias() {
        if (this.searchType == HistorySearchType.SearchType.FLOOR_TO_DOOR_HISTORY) {
            return "WH";
        }
        return "H";
    }
}

