/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;

public class Location {
    private long locnidx;
    private String tradename;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String postcode;
    private String country;
    private String abn;

    public Location(long locnidx) {
        this.locnidx = locnidx;
        this.loadFromDatabase();
    }

    private void loadFromDatabase() {
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT L.TRADENAME, L.ADRS1, L.ADRS2, L.CITY, L.STATE, L.POSTCODE, L.COUNTRY, L.ABN FROM LOCN L WHERE L.LOCNIDX = " + this.locnidx);){
            if (sql.next()) {
                this.tradename = sql.getString("tradename");
                this.addressLine1 = sql.getString("adrs1");
                this.addressLine2 = sql.getString("adrs2");
                this.city = sql.getString("city");
                this.state = sql.getString("state");
                this.postcode = sql.getString("postcode");
                this.country = sql.getString("country");
                this.abn = sql.getString("abn");
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public long getLocnidx() {
        return this.locnidx;
    }

    public String getTradename() {
        return this.tradename;
    }

    public void setTradename(String tradename) {
        this.tradename = tradename;
    }

    public String getAddressLine1() {
        return StringUtils.nullToEmpty(this.addressLine1);
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return StringUtils.nullToEmpty(this.addressLine2);
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getCity() {
        return StringUtils.nullToEmpty(this.city);
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return StringUtils.nullToEmpty(this.state);
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostcode() {
        return StringUtils.nullToEmpty(this.postcode);
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getCountry() {
        return StringUtils.nullToEmpty(this.country);
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAbn() {
        return this.abn;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }
}

