/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DiscLine;
import jpos.DlgMessage;
import jpos.DlgReturnOverride;
import jpos.FrSales;
import jpos.Note;
import jpos.PaSales;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.coupons.DlgApplyCoupon;
import jpos.ui.FormButton;
import jpos.ui.FormCompleteButton;
import jpos.ui.LabelNormal;

public class PaSalesFoot
extends JPanel {
    protected FormCompleteButton bPayment = new FormCompleteButton(StoreParams.res.getString("Enter_the_payment"));
    protected FormButton bDisc = new FormButton(StoreParams.res.getString("Enter_a_discount"));
    protected FormButton bDelete = new FormButton(StoreParams.res.getString("Delete_the_selected"));
    protected FormButton bLayBy = new FormButton(StatusBar.status_LaybySearch);
    protected FormButton bSpecialOrder = new FormButton(StatusBar.status_SpecialOrderSearch);
    protected FormButton bReset = new FormButton(StoreParams.res.getString("Clear_the_current"));
    protected FormButton bCancelLayBy = new FormButton(StoreParams.res.getString("Cancel_this_Layby"));
    protected FormButton bReturn = new FormButton(StoreParams.res.getString("Return_the_item_s_on"));
    protected FormButton bHold = new FormButton(StatusBar.status_RecallSale);
    protected FormButton bPerson = new FormButton(StoreParams.res.getString("attach_person"));
    protected FormButton bReserve = new FormButton(StoreParams.res.getString("Reserve_Stock"));
    protected FormButton bAccountSearch = new FormButton(StoreParams.res.getString("Debtor_Sale_Search"));
    protected FormCompleteButton bRefresh = new FormCompleteButton(StoreParams.res.getString("Refresh"));
    protected FormButton bKit = new FormButton(StoreParams.res.getString("Kit_entry"));
    protected FormButton bHistory = new FormButton(StoreParams.res.getString("F8_payment_history"));
    protected FormButton bChangeSalesRep = new FormButton(StoreParams.res.getString("Change_Sales_Rep"));
    protected FormButton bCustOrder = new FormButton(StatusBar.status_CustOrderSearch);
    protected FormButton bCancelCustOrder = new FormButton(StatusBar.status_CancelCustOrder);
    protected FormButton bPrintPickList = new FormButton(StatusBar.status_PrintPickList);
    protected FormButton bReprintLabels = new FormButton(StatusBar.status_ReprintLabels);
    protected FormButton bReassignOrder = new FormButton(StatusBar.status_ReassignOrder);
    protected FormButton bCoupon = new FormButton(StatusBar.status_ApplyCoupon);
    protected LabelNormal lCoupon = new LabelNormal();
    protected LabelNormal lOnHold = new LabelNormal();
    protected FormButton bSelfFit = new FormButton(StoreParams.res.getString("Self_Fit"));
    protected FormButton bAssociation = new FormButton(StoreParams.res.getString("Associations"));
    protected StatusBar statusBar = new StatusBar();
    private FrSales sales;
    private StoreParams sParams;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private boolean reserveExecuting = false;
    private boolean couponsEnabled = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.REDEEM_COUPONS_AT_POS) > 0L;
    private GridBagConstraints R1C1 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0);
    private GridBagConstraints R1C2 = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 2, 2), 0, 0);
    private GridBagConstraints R1C3 = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 2, 2), 0, 0);
    private GridBagConstraints R1C4 = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 2, 2, 5), 0, 0);
    private GridBagConstraints R2C1 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0);
    private GridBagConstraints R2C2 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
    private GridBagConstraints R2C3 = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
    private GridBagConstraints R2C4 = new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0);
    private GridBagConstraints R3C1 = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 2), 0, 0);
    private GridBagConstraints R3C2 = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 5, 2), 0, 0);
    private GridBagConstraints R3C3 = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 5, 2), 0, 0);
    private GridBagConstraints R3C4 = new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 5, 5), 0, 0);
    private GridBagConstraints R2C3Debtor = new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
    private GridBagConstraints R3C3Debtor = new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 5, 2), 0, 0);
    private JPanel middleGroupPanel = new JPanel(new GridBagLayout());
    private GridBagConstraints middleGroupConstraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(2, 5, 5, 5), 0, 0);
    private GridBagConstraints AssociationFlagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 5, 5, 5), 5, 0);
    private GridBagConstraints couponLabelConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(2, 5, 5, 5), 0, 0);
    private GridBagConstraints paymentConstraints = new GridBagConstraints(4, 1, 1, 2, 0.0, 0.0, 13, 1, new Insets(2, 5, 5, 5), 0, 0);
    private GridBagConstraints refreshConstraints = new GridBagConstraints(3, 1, 1, 2, 0.0, 0.0, 13, 1, new Insets(2, 5, 5, 5), 0, 0);
    private GridBagConstraints statusBarConstraints = new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
    private GridBagConstraints onHoldLabelConstraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.5, 13, 3, new Insets(2, 5, 5, 5), 0, 0);
    private JPanel bottomGroupPanel = new JPanel(new GridBagLayout());
    private GridBagConstraints bottomGroupConstraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 5, 5), 0, 0);
    private GridBagConstraints SelfFitFlagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 5, 5, 5), 5, 0);
    private GridBagConstraints couponButtonConstraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 5, 5), 0, 0);
    private ImageIcon imgChecked;
    private ImageIcon imgUnchecked;

    public PaSalesFoot(PosFrame pFrame) {
        this.imgChecked = new ImageIcon(SP.sParams.imagepath + "tick32x32.png");
        this.imgUnchecked = new ImageIcon(SP.sParams.imagepath + "unchecked.png");
        try {
            this.sales = (FrSales)pFrame;
            this.sParams = this.sales.sParams;
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.bPayment.setText(StoreParams.res.getString("F9_Payment"));
        this.bPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bPayment_actionPerformed(e);
            }
        });
        this.bHistory.setText(StoreParams.res.getString("F8_payment_history"));
        this.bHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bHistory_actionPerformed(e);
            }
        });
        this.bChangeSalesRep.setText(StoreParams.res.getString("Alt_S_Change_Sales_Rep"));
        this.bChangeSalesRep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bChangeSalesRep_actionPerformed(e);
            }
        });
        this.bRefresh.setText(StoreParams.res.getString("F6_Refresh"));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bRefresh_actionPerformed(e);
            }
        });
        this.bKit.setText(StoreParams.res.getString("Alt+K_Kit"));
        this.bKit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bKit_actionPerformed(e);
            }
        });
        this.bDisc.setText(StoreParams.res.getString("F4_Discount"));
        this.bDisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bDisc_actionPerformed(e);
            }
        });
        this.bDelete.setText(StoreParams.res.getString("F2_Delete"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bDelete_actionPerformed(e);
            }
        });
        this.bLayBy.setText(StoreParams.res.getString("F6_Layby"));
        this.bLayBy.setVisible(this.sParams.bUsingLaybys);
        this.bLayBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bLayBy_actionPerformed(e);
            }
        });
        this.bSpecialOrder.setText(StoreParams.res.getString("F5_SpecialOrders"));
        this.bSpecialOrder.setVisible(this.sParams.bUsingSpecialOrders);
        this.bSpecialOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bSpecialOrder_actionPerformed(e);
            }
        });
        this.bCustOrder.setText(StoreParams.res.getString("F5_CustOrderSearch"));
        this.bCustOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bCustOrder_actionPerformed(e);
            }
        });
        this.bCancelCustOrder.setText(StoreParams.res.getString("F6_Cancel_Order"));
        this.bCancelCustOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bCancelCustOrder_actionPerformed(e);
            }
        });
        this.bPrintPickList.setText(StoreParams.res.getString("F7_Print_Picklist"));
        this.bPrintPickList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bPrintPickList_actionPerformed(e);
            }
        });
        this.bReassignOrder.setEnabled(false);
        this.bReassignOrder.setText(StoreParams.res.getString("Alt_R_Reassign_Order"));
        this.bReassignOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bReassignOrder_actionPerformed(e);
            }
        });
        this.bReprintLabels.setEnabled(false);
        this.bReprintLabels.setText(StoreParams.res.getString("Reprint_Labels"));
        this.bReprintLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bReprintLabels_actionPerformed(e);
            }
        });
        this.bReset.setText(StoreParams.res.getString("F3_Reset"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bReset_actionPerformed(e);
            }
        });
        this.bCancelLayBy.setText(StoreParams.res.getString("F6_Cancel_LB"));
        this.bCancelLayBy.setVisible(this.sParams.bUsingLaybys);
        this.bCancelLayBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bCancelLayBy_actionPerformed(e);
            }
        });
        this.bReturn.setText(StoreParams.res.getString("F7_Return"));
        this.bReturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bReturn_actionPerformed(e);
            }
        });
        this.bHold.setText(StoreParams.res.getString("Recall_Sale"));
        this.bHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bHold_actionPerformed(e);
            }
        });
        this.changeAttachPersonButton(false);
        this.bPerson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bPerson_actionPerformed(e);
            }
        });
        this.bReserve.setText(StoreParams.res.getString("AltZ"));
        this.bReserve.setMultiClickThreshhold(5000L);
        this.bReserve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bReserve_actionPerformed(e);
            }
        });
        this.bAccountSearch.setText(StoreParams.res.getString("F5_Search"));
        this.bAccountSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bAccountSearch_actionPerformed(e);
            }
        });
        this.bCoupon.setText(SP.getRS("Coupons_ApplyCouponButton_Text"));
        this.bCoupon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bCoupon_actionPerformed(e);
            }
        });
        this.bCoupon.setVisible(this.couponsEnabled);
        this.lCoupon.setLabelWidth(this.bCoupon.getButtonWidth());
        this.lCoupon.setHorizontalAlignment(0);
        this.lCoupon.setVerticalAlignment(3);
        this.lCoupon.setText("");
        this.lCoupon.setVisible(this.couponsEnabled);
        this.lOnHold.setHorizontalAlignment(0);
        this.lOnHold.setVerticalAlignment(3);
        this.lOnHold.setText(StoreParams.res.getString("Order_On_Hold_Title"));
        this.lOnHold.setVisible(false);
        this.bSelfFit.setText(StoreParams.res.getString("Self_Fit"));
        this.bSelfFit.setIcon(this.imgChecked);
        this.bSelfFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bSelfFit_actionPerformed(e);
            }
        });
        this.bAssociation.setText(StoreParams.res.getString("Associations"));
        this.bAssociation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSalesFoot.this.bAssociation_actionPerformed(e);
            }
        });
        this.setLayout(this.gridBagLayout);
        this.add((Component)this.statusBar, this.statusBarConstraints);
        if (this.sales.frameType == 1) {
            this.add((Component)this.bSpecialOrder, this.R1C1);
            this.add((Component)this.bChangeSalesRep, this.R1C2);
            this.add((Component)this.bHistory, this.R1C3);
            this.add((Component)this.bLayBy, this.R2C1);
            this.add((Component)this.bCancelLayBy, this.R2C1);
            this.add((Component)this.bReturn, this.R2C2);
            this.add((Component)this.bHold, this.R2C3);
            this.add((Component)this.bReserve, this.R2C4);
            this.add((Component)this.bDisc, this.R3C1);
            this.add((Component)this.bReset, this.R3C2);
            this.add((Component)this.bDelete, this.R3C3);
            this.add((Component)this.bPerson, this.R3C4);
            if (this.sParams.bAllowAssociationByLine) {
                this.middleGroupPanel.add((Component)this.bAssociation, this.AssociationFlagConstraints);
            }
            if (this.sParams.bMyFit) {
                this.bottomGroupPanel.add((Component)this.bSelfFit, this.SelfFitFlagConstraints);
            }
            if (this.couponsEnabled) {
                this.middleGroupPanel.add((Component)this.lCoupon, this.couponLabelConstraints);
                this.bottomGroupPanel.add((Component)this.bCoupon, this.couponButtonConstraints);
            }
            this.add((Component)this.middleGroupPanel, this.middleGroupConstraints);
            this.add((Component)this.bottomGroupPanel, this.bottomGroupConstraints);
            this.add((Component)this.bPayment, this.paymentConstraints);
        } else if (this.sales.frameType == 10) {
            this.add((Component)this.bAccountSearch, this.R2C1);
            this.add((Component)this.bReturn, this.R2C2);
            if (this.sParams.kitOrderEntry) {
                this.add((Component)this.bKit, this.R2C3Debtor);
            } else {
                this.bKit.setEnabled(false);
                this.add((Component)new LabelNormal(), this.R2C3Debtor);
            }
            this.add((Component)this.bDisc, this.R3C1);
            this.add((Component)this.bReset, this.R3C2);
            this.add((Component)this.bDelete, this.R3C3Debtor);
            this.add((Component)this.bRefresh, this.refreshConstraints);
            this.add((Component)this.bPayment, this.paymentConstraints);
            this.bDisc.setEnabled(false);
        } else if (this.sales.frameType == 12) {
            this.add((Component)this.bCustOrder, this.R1C1);
            this.add((Component)this.bChangeSalesRep, this.R1C2);
            this.add((Component)this.bHistory, this.R1C3);
            this.add((Component)this.bPrintPickList, this.R1C4);
            if (SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.SHIP_FROM_STORE) > 0L) {
                this.add((Component)this.bReassignOrder, this.R2C1);
                this.add((Component)this.bReprintLabels, this.R2C2);
            }
            if (this.sParams.kitOrderEntry) {
                this.add((Component)this.bKit, this.R2C3);
            } else {
                this.bKit.setEnabled(false);
            }
            this.add((Component)this.bCancelCustOrder, this.R2C4);
            this.add((Component)this.bDisc, this.R3C1);
            this.add((Component)this.bReset, this.R3C2);
            this.add((Component)this.bDelete, this.R3C3);
            this.add((Component)this.bPerson, this.R3C4);
            if (this.sParams.bAllowAssociationByLine) {
                this.middleGroupPanel.add((Component)this.bAssociation, this.AssociationFlagConstraints);
            }
            if (this.sParams.bMyFit) {
                this.bottomGroupPanel.add((Component)this.bSelfFit, this.SelfFitFlagConstraints);
            }
            if (this.couponsEnabled) {
                this.middleGroupPanel.add((Component)this.lCoupon, this.couponLabelConstraints);
                this.bottomGroupPanel.add((Component)this.bCoupon, this.couponButtonConstraints);
            }
            this.add((Component)this.middleGroupPanel, this.middleGroupConstraints);
            this.add((Component)this.bottomGroupPanel, this.bottomGroupConstraints);
            this.add((Component)this.lOnHold, this.onHoldLabelConstraints);
            this.add((Component)this.bPayment, this.paymentConstraints);
            this.bPayment.setText(StoreParams.res.getString("F9_Pack_Pay"));
        }
    }

    void bPayment_actionPerformed(ActionEvent e) {
        if (this.bPayment.isEnabled()) {
            if (this.sales.isCustOrderOnHold()) {
                DlgMessage.showMessage(this.sales, StoreParams.res.getString("Cannot_Pack_On_Hold_Order"), StoreParams.res.getString("Error"), 1);
                return;
            }
            if (this.sales.isLoggedIn(true) && !this.sales.isModalChildVisible()) {
                if (this.sales.frameType == 1 && ((PaSales)this.sales.paBody).tblStyles.confirmReturnMode() && !((PaSales)this.sales.paBody).tblStyles.isQtyValid()) {
                    DlgMessage.showMessage(this.sales, StoreParams.res.getString("No_Valid_Qty"));
                    return;
                }
                if (!((PaSales)this.sales.paBody).tblStyles.validateTransactionForOverReturns()) {
                    DlgReturnOverride override = new DlgReturnOverride(this.sales, ((PaSales)this.sales.paBody).tblStyles.getAllTransactionReturnErrors());
                    override.setVisible(true);
                    boolean result = override.getResult();
                    if (!result) {
                        this.sales.setCursor(StoreParams.normalCursor);
                        this.sales.setFocus();
                        return;
                    }
                }
                this.bPayment.setEnabled(false);
                ((PaSales)this.sales.paBody).payment();
                this.bPayment.setEnabled(this.sales.editable);
            }
            this.sales.setFocus();
        }
    }

    void bDisc_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            ((PaSales)this.sales.paBody).addDisc();
        }
        this.sales.setFocus();
    }

    void bDelete_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.sales.delLines();
        }
        this.sales.setFocus();
    }

    void bLayBy_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bLayBy.setEnabled(false);
            ((PaSales)this.sales.paBody).layby();
            this.bLayBy.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bSpecialOrder_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bSpecialOrder.setEnabled(false);
            if (this.bSpecialOrder.getText().equals(StoreParams.res.getString("F5_CancelSpecialOrder"))) {
                ((PaSales)this.sales.paBody).cancelSpecialOrder();
            } else {
                ((PaSales)this.sales.paBody).specialOrder();
            }
            this.bSpecialOrder.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bReset_actionPerformed(ActionEvent e) {
        this.sales.voidTrans(true, true, true);
    }

    void bCancelLayBy_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bCancelLayBy.setEnabled(false);
            ((PaSales)this.sales.paBody).cancelLayby();
            this.bCancelLayBy.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bReturn_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            int numStyles = 0;
            for (int i = 0; i < ((PaSales)this.sales.paBody).tblStyles.getRowCount(); ++i) {
                if (((PaSales)this.sales.paBody).tblStyles.getItemAt(i) instanceof StyleLine) {
                    ++numStyles;
                }
                if (numStyles > 1) break;
            }
            if (numStyles == 1) {
                ((PaSales)this.sales.paBody).tblStyles.setRowSelectionInterval(0, 0);
            } else {
                int[] rows;
                for (int i : rows = ((PaSales)this.sales.paBody).tblStyles.getSelectedRows()) {
                    Object line = ((PaSales)this.sales.paBody).tblStyles.getItemAt(i);
                    if (line instanceof DiscLine) {
                        int discNum = ((DiscLine)line).getStyleParent().getDiscLines().indexOf(line);
                        ((PaSales)this.sales.paBody).tblStyles.addRowSelectionInterval(i - discNum - 1, i - discNum - 1);
                        ((PaSales)this.sales.paBody).tblStyles.removeRowSelectionInterval(i, i);
                        continue;
                    }
                    if (!(line instanceof Note)) continue;
                    int numNotesDiscs = ((Note)line).styleParent.getDiscLines().size() + ((Note)line).styleParent.getNotes().indexOf(line);
                    ((PaSales)this.sales.paBody).tblStyles.addRowSelectionInterval(i - numNotesDiscs - 1, i - numNotesDiscs - 1);
                    ((PaSales)this.sales.paBody).tblStyles.removeRowSelectionInterval(i, i);
                }
            }
            int[] rows = ((PaSales)this.sales.paBody).tblStyles.getSelectedRows();
            if (rows.length == 0) {
                DlgMessage.showMessage(this.sales, StoreParams.res.getString("You_must_select_a"), StoreParams.res.getString("No_rows_selected"), 1);
                return;
            }
            if (this.sales.checkGiftVoucherLines(rows)) {
                DlgMessage.showMessage(this.sales, StoreParams.res.getString("cannot_return_vouchers"), StoreParams.res.getString("Error"), 1);
                return;
            }
            if (this.sales.checkReturnLines(rows)) {
                DlgMessage.showMessage(this.sales, StoreParams.res.getString("cannot_return_returns"), StoreParams.res.getString("Error"), 1);
                return;
            }
            this.sales.returnGoods(rows);
        }
        this.sales.setFocus();
    }

    void setButtons(int tr_type) {
        if (tr_type == 239) {
            this.bSpecialOrder.setText(StoreParams.res.getString("F5_SpecialOrders"));
            this.bSpecialOrder.setMessage(StatusBar.status_SpecialOrderSearch);
            this.bSpecialOrder.setEnabled(true);
            this.bCancelLayBy.setVisible(false);
            this.bReturn.setVisible(true);
            this.bLayBy.setVisible(this.sParams.bUsingLaybys);
            this.bLayBy.setEnabled(true);
            this.bHold.setVisible(true);
            this.bReserve.setVisible(Settings.isScreenEnabled(11));
            this.bPerson.setVisible(true);
            this.lCoupon.setVisible(this.couponsEnabled);
            this.bCoupon.setVisible(this.couponsEnabled);
            ((PaSales)this.sales.paBody).pOSBalance.setVisible(false);
        } else if (tr_type == 242 || tr_type == 241) {
            this.bSpecialOrder.setText(StoreParams.res.getString("F5_SpecialOrders"));
            this.bSpecialOrder.setMessage(StatusBar.status_SpecialOrderSearch);
            this.bSpecialOrder.setEnabled(false);
            this.bCancelLayBy.setVisible(this.sParams.bUsingLaybys);
            this.bLayBy.setVisible(false);
            this.bLayBy.setEnabled(true);
            this.bHold.setEnabled(false);
            this.bReserve.setEnabled(false);
            this.bPerson.setEnabled(false);
            this.lCoupon.setVisible(this.couponsEnabled);
            this.bCoupon.setVisible(this.couponsEnabled);
            ((PaSales)this.sales.paBody).pOSBalance.setVisible(true);
            if (this.sales.lbsoComplete) {
                this.bReturn.setEnabled(true);
            } else {
                this.bReturn.setEnabled(false);
            }
        } else if (tr_type == 245 || tr_type == 244) {
            this.bSpecialOrder.setText(StoreParams.res.getString("F5_CancelSpecialOrder"));
            this.bSpecialOrder.setMessage(StatusBar.status_SpecialOrderCancel);
            this.bSpecialOrder.setEnabled(true);
            this.bCancelLayBy.setVisible(false);
            this.bReturn.setEnabled(false);
            this.bLayBy.setVisible(this.sParams.bUsingLaybys);
            this.bLayBy.setEnabled(false);
            this.bHold.setEnabled(false);
            this.bReserve.setEnabled(false);
            this.bPerson.setEnabled(false);
            this.lCoupon.setVisible(this.couponsEnabled);
            this.bCoupon.setVisible(this.couponsEnabled);
            ((PaSales)this.sales.paBody).pOSBalance.setVisible(true);
        } else if (tr_type == 714) {
            this.bCustOrder.setEnabled(true);
            this.bReturn.setEnabled(false);
            this.bHold.setEnabled(false);
            this.bPerson.setEnabled(true);
            this.lCoupon.setVisible(this.couponsEnabled);
            this.bCoupon.setVisible(this.couponsEnabled);
            ((PaSales)this.sales.paBody).pOSBalance.setVisible(true);
        } else if (tr_type == 715) {
            this.bCustOrder.setEnabled(true);
            this.bReturn.setEnabled(false);
            this.bHold.setEnabled(false);
            this.bPerson.setEnabled(false);
            this.lCoupon.setVisible(this.couponsEnabled);
            this.bCoupon.setVisible(this.couponsEnabled);
            ((PaSales)this.sales.paBody).pOSBalance.setVisible(true);
        }
    }

    void bHold_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.sales.HoldRecall();
        }
        this.sales.setFocus();
    }

    void bPerson_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            if (!(this.sales.isRecallSale() && !this.sales.isPersonValid() || this.sales.isReturningSale() || this.sales.transRoot == null || this.sales.transRoot.getAttributeValue("vhidx") == null || this.sales.transRoot.getAttributeValue("vhidx").isEmpty())) {
                this.sales.changePersonOnExistingTransaction();
            } else {
                this.sales.attachPerson("", false);
            }
        }
        this.sales.setFocus();
    }

    void bReserve_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true) && !this.reserveExecuting) {
            try {
                this.reserveExecuting = true;
                this.bReserve.setEnabled(false);
                this.sales.reserveStk();
            }
            finally {
                this.reserveExecuting = false;
                this.bReserve.setEnabled(true);
            }
        }
        this.sales.setFocus();
    }

    void bHistory_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            ((PaSales)this.sales.paBody).history();
        }
        this.sales.setFocus();
    }

    void bChangeSalesRep_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            if (this.sParams.bAllowSalesRepByLine) {
                ((PaSales)this.sales.paBody).changeSalesRep();
            } else {
                this.sales.changeSalesRep();
            }
        }
        this.sales.setFocus();
    }

    void bRefresh_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            ((PaSales)this.sales.paBody).refresh(false);
        }
        this.sales.setFocus();
    }

    void bKit_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            if (this.sales.frameType == 10) {
                this.sales.kitEntryDebtor();
            } else if (this.sales.frameType == 12) {
                this.sales.kitEntryCustOrder();
            }
        }
        this.sales.setFocus();
    }

    void bAccountSearch_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.sales.secSearch(556, "", false);
        }
        this.sales.setFocus();
    }

    void bCoupon_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            DlgApplyCoupon couponDlg = new DlgApplyCoupon(this.sales, this.sales.getCouponCode());
            couponDlg.setVisible(true);
            if (couponDlg.getAccepted() && !couponDlg.getCode().trim().equalsIgnoreCase(this.sales.getCouponCode())) {
                this.sales.setCouponCode(couponDlg.getCode());
            }
        }
        this.sales.setFocus();
    }

    void bCustOrder_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bCustOrder.setEnabled(false);
            ((PaSales)this.sales.paBody).searchCustOrders();
            this.bCustOrder.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bCancelCustOrder_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bCancelCustOrder.setEnabled(false);
            ((PaSales)this.sales.paBody).custOrderCancelRemaining();
            this.bCancelCustOrder.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bPrintPickList_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bPrintPickList.setEnabled(false);
            ((PaSales)this.sales.paBody).printCustOrderPickList();
            this.bPrintPickList.setEnabled(true);
        }
        this.sales.setFocus();
    }

    void bReassignOrder_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bReassignOrder.setEnabled(false);
            try {
                this.sales.reassignDespatchLocation();
            }
            finally {
                this.bReassignOrder.setEnabled(true);
            }
        }
        this.sales.setFocus();
    }

    void bReprintLabels_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            this.bReprintLabels.setEnabled(false);
            try {
                ((PaSales)this.sales.paBody).reprintLabels();
            }
            finally {
                this.bReprintLabels.setEnabled(true);
            }
        }
        this.sales.setFocus();
    }

    void bSelfFit_actionPerformed(ActionEvent e) {
        if (this.sales.selfFit == 1L) {
            this.sales.selfFit = 0L;
            this.bSelfFit.setIcon(this.imgUnchecked);
        } else {
            this.sales.selfFit = 1L;
            this.bSelfFit.setIcon(this.imgChecked);
        }
        this.sales.setFocus();
    }

    void bAssociation_actionPerformed(ActionEvent e) {
        if (this.sales.isLoggedIn(true)) {
            ((PaSales)this.sales.paBody).changeAssoc();
        }
        this.sales.setFocus();
    }

    public void setSelfFit(long selffit) {
        this.sales.selfFit = selffit;
        if (this.sales.selfFit == 1L) {
            this.bSelfFit.setIcon(this.imgChecked);
        } else {
            this.bSelfFit.setIcon(this.imgUnchecked);
        }
    }

    public void changeAttachPersonButton(boolean changeMode) {
        if (changeMode) {
            this.bPerson.setText(StoreParams.res.getString("AltC_Change_Person"));
        } else {
            this.bPerson.setText(StoreParams.res.getString("AltC"));
        }
    }
}

