/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jpos.PosComboBox;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;

public class PosDateSearch
extends JDialog
implements KeyEventDispatcher {
    private JPanel panelMain = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel panelNorth = new JPanel();
    private JPanel panelCenter = new JPanel();
    private JPanel panelSouth = new JPanel();
    private JPanel panelButtons = new JPanel();
    private GridLayout gridLayout1 = new GridLayout(7, 7);
    private FlowLayout flowLayout1 = new FlowLayout();
    private PosComboBox<String> comboMonth;
    private PosComboBox<String> comboYear;
    private FlowLayout flowLayout2 = new FlowLayout();
    private FlowLayout flowLayout3 = new FlowLayout();
    private LJButton[] dateLJButton = new LJButton[42];
    private LabelNormal[] days = new LabelNormal[7];
    private LabelNormal labelPrev = new LabelNormal();
    private LabelNormal labelCurr = new LabelNormal();
    private LabelNormal labelNext = new LabelNormal();
    private DialogButton bOk = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private int year;
    private int month;
    private int day;
    private int yearBegin;
    private int yearEnd;
    private LJButton clickedButton;
    private PosDateFormatter dateFormatterReference;
    private PosDateFormatter dateFormatter;
    private Vector<Object> focusManager = new Vector();

    public PosDateSearch(Window parent, String title, boolean modal, PosDateFormatter dateFormatter, int yearsBeforeToday, int yearsAfterToday) {
        super(parent, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.dateFormatterReference = dateFormatter;
        this.dateFormatter = dateFormatter != null && dateFormatter.getTimestamp() != null ? new PosDateFormatter(new Timestamp(dateFormatter.getTimestamp().getTime()), 3, 3, 0) : new PosDateFormatter(null, 3, 3, 0);
        GregorianCalendar currDate = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        currDate.setTime(new Date());
        this.year = currDate.get(1);
        this.month = currDate.get(2) + 1;
        this.day = currDate.get(5);
        if (yearsBeforeToday < 0) {
            yearsBeforeToday = 50;
        }
        if (yearsAfterToday < 0) {
            yearsAfterToday = 50;
        }
        this.yearBegin = this.year - yearsBeforeToday;
        this.yearEnd = this.year + yearsAfterToday;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    void jbInit() throws Exception {
        this.panelMain.setLayout(this.borderLayout1);
        this.panelNorth.setLayout(this.flowLayout1);
        this.panelNorth.setPreferredSize(new Dimension(300, 48));
        this.panelCenter.setLayout(this.gridLayout1);
        this.panelCenter.setPreferredSize(new Dimension(300, 300));
        this.panelSouth.setLayout(this.flowLayout2);
        this.panelSouth.setPreferredSize(new Dimension(300, 30));
        this.panelButtons.setLayout(this.flowLayout3);
        this.panelButtons.setPreferredSize(new Dimension(300, 48));
        this.labelPrev.setText("<<");
        this.labelPrev.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PosDateSearch.this.labelPrev_mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.labelCurr.setText(SP.getRS("Current"));
        this.labelNext.setText(">>");
        this.labelNext.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PosDateSearch.this.labelNext_mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        if (this.dateFormatter != null && this.dateFormatter.getTimestamp() != null) {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            calendar.setTime(this.dateFormatter.getTimestamp());
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
            this.day = calendar.get(5);
        }
        this.comboYear = new PosComboBox<String>(this.getYears());
        if (this.comboYear.getItemCount() > 0) {
            this.comboYear.setSelectedItem(String.valueOf(this.year));
        }
        this.comboYear.setFieldWidth(100);
        this.comboYear.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PosDateSearch.this.comboYear_actionValidate();
            }
        });
        this.comboMonth = new PosComboBox<String>(this.getMonths());
        if (this.comboMonth.getItemCount() > 0) {
            this.comboMonth.setSelectedIndex(this.month - 1);
        }
        this.comboMonth.setFieldWidth(100);
        this.comboMonth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PosDateSearch.this.comboMonth_actionValidate();
            }
        });
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosDateSearch.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosDateSearch.this.cancelDialog();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    PosDateSearch.this.cancelDialog();
                } else if (e.getKeyCode() == 10) {
                    PosDateSearch.this.okDialog();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.panelMain.add((Component)this.panelNorth, "North");
        this.panelNorth.add(this.comboMonth, null);
        this.panelNorth.add(this.comboYear, null);
        this.panelMain.add((Component)this.panelCenter, "Center");
        this.panelSouth.add((Component)this.labelPrev, null);
        this.panelSouth.add((Component)this.labelCurr, null);
        this.panelSouth.add((Component)this.labelNext, null);
        this.panelButtons.add((Component)this.bOk, null);
        this.panelButtons.add((Component)this.bCancel, null);
        this.panelMain.add((Component)this.panelSouth, "South");
        this.setFocusCycleRoot(true);
        this.addDateFields();
        this.popDateFields(this.year, this.month, this.day);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }

    private void cancelDialog() {
        this.dispose();
    }

    private void okDialog() {
        if (this.dateFormatter != null && this.dateFormatter.getTimestamp() != null) {
            this.dateFormatterReference.setTime(this.dateFormatter.getTimestamp().getTime());
        }
        this.dispose();
    }

    private Vector<String> getMonths() {
        Vector<String> months = new Vector<String>();
        months.add(SP.getRS("Jan"));
        months.add(SP.getRS("Feb"));
        months.add(SP.getRS("Mar"));
        months.add(SP.getRS("Apr"));
        months.add(SP.getRS("May"));
        months.add(SP.getRS("Jun"));
        months.add(SP.getRS("Jul"));
        months.add(SP.getRS("Aug"));
        months.add(SP.getRS("Sep"));
        months.add(SP.getRS("Oct"));
        months.add(SP.getRS("Nov"));
        months.add(SP.getRS("Dec"));
        return months;
    }

    private Vector<String> getYears() {
        Vector<String> years = new Vector<String>();
        for (int cnt = this.yearBegin; cnt <= this.yearEnd; ++cnt) {
            years.add(String.valueOf(cnt));
        }
        return years;
    }

    private void addDateFields() {
        int cnt;
        for (cnt = 0; cnt < 7; ++cnt) {
            this.days[cnt] = new LabelNormal();
            this.days[cnt].setHorizontalAlignment(0);
            switch (cnt) {
                case 0: {
                    this.days[cnt].setText(SP.getRS("Sun"));
                    break;
                }
                case 1: {
                    this.days[cnt].setText(SP.getRS("Mon"));
                    break;
                }
                case 2: {
                    this.days[cnt].setText(SP.getRS("Tue"));
                    break;
                }
                case 3: {
                    this.days[cnt].setText(SP.getRS("Wed"));
                    break;
                }
                case 4: {
                    this.days[cnt].setText(SP.getRS("Thu"));
                    break;
                }
                case 5: {
                    this.days[cnt].setText(SP.getRS("Fri"));
                    break;
                }
                case 6: {
                    this.days[cnt].setText(SP.getRS("Sat"));
                    break;
                }
            }
            this.panelCenter.add((Component)this.days[cnt], null);
        }
        for (cnt = 0; cnt < 42; ++cnt) {
            this.dateLJButton[cnt] = new LJButton(this);
            if (UIManager.getBorder("Button.border").toString().indexOf("XP") > 0) {
                this.dateLJButton[cnt].setBorder(new EmptyBorder(2, 2, 2, 2));
            } else {
                this.dateLJButton[cnt].setBorder(BorderFactory.createEtchedBorder());
            }
            this.panelCenter.add((Component)this.dateLJButton[cnt], null);
        }
    }

    private void popDateFields(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        calendar.set(year, month - 1, 1, 0, 0, 0);
        int dayOfW = calendar.get(7);
        int daysInM = ((Calendar)calendar).getActualMaximum(5);
        if (daysInM < day) {
            day = daysInM;
        }
        int beginIndex = dayOfW - 1;
        int endIndex = beginIndex + daysInM - 1;
        this.focusManager.clear();
        this.focusManager.add(this.comboMonth);
        this.focusManager.add(this.comboYear);
        for (int cnt = 0; cnt < 42; ++cnt) {
            if (cnt >= beginIndex & cnt <= endIndex) {
                this.dateLJButton[cnt].setText(String.valueOf(cnt - beginIndex + 1));
                this.dateLJButton[cnt].setEnabled(true);
                this.focusManager.add(this.dateLJButton[cnt]);
                if (cnt - beginIndex + 1 != day) continue;
                this.dateLJButton[cnt].actionMouseClicked();
                continue;
            }
            this.dateLJButton[cnt].setText("");
            this.dateLJButton[cnt].setEnabled(false);
            if (cnt - beginIndex + 1 != day) continue;
            this.clickedButton.setClicked(false);
            this.clickedButton = null;
        }
        Vector<Component> v = new Vector<Component>();
        v.add(this.bOk);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    public boolean actionEdit() {
        return true;
    }

    void labelPrev_mouseClicked(MouseEvent e) {
        if (this.month > 1) {
            this.comboMonth.setSelectedIndex(this.month - 2);
            this.comboMonth_actionValidate();
        } else if (this.year > this.yearBegin) {
            this.month = 12;
            this.comboMonth.setSelectedIndex(this.month - 1);
            this.comboYear.setSelectedItem(String.valueOf(this.year - 1));
            this.comboYear_actionValidate();
        }
    }

    void labelNext_mouseClicked(MouseEvent e) {
        if (this.month < 12) {
            this.comboMonth.setSelectedIndex(this.month);
            this.comboMonth_actionValidate();
        } else if (this.year < this.yearEnd) {
            this.month = 1;
            this.comboMonth.setSelectedIndex(this.month - 1);
            this.comboYear.setSelectedItem(String.valueOf(this.year + 1));
            this.comboYear_actionValidate();
        }
    }

    void comboMonth_actionValidate() {
        this.month = this.comboMonth.getSelectedIndex() + 1;
        this.popDateFields(this.year, this.month, this.day);
    }

    void comboYear_actionValidate() {
        this.year = PosUtils.intVal(this.comboYear.getSelectedItem().toString());
        this.popDateFields(this.year, this.month, this.day);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    class LJButton
    extends JButton {
        private PosDateSearch parent;
        private boolean enabled = false;
        private boolean clicked = false;

        public LJButton() {
            this.setHorizontalAlignment(0);
        }

        public LJButton(PosDateSearch parent) {
            this.parent = parent;
            this.setHorizontalAlignment(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LJButton.this.actionMouseClicked();
                    if (e.getClickCount() == 2) {
                        LJButton.this.actionMouseDoubleClicked();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    LJButton.this.actionMouseEntered();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    LJButton.this.actionMouseExited();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 10 && e.getKeyCode() != 16) {
                        LJButton.this.actionMouseClicked();
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean enable) {
            this.enabled = enable;
        }

        public void setClicked(boolean clicked) {
            this.setSelected(clicked);
            this.clicked = clicked;
            if (this.clicked) {
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
                calendar.set(this.parent.year, this.parent.month - 1, this.parent.day);
                PosDateSearch.this.dateFormatter.setTime(calendar.getTimeInMillis());
                this.parent.labelCurr.setText(PosDateSearch.this.dateFormatter.toString());
                this.setForeground(Colours.RED);
            } else {
                this.parent.labelCurr.setText(SP.getRS("None"));
                this.setForeground(Colours.BLACK);
            }
        }

        public void actionMouseClicked() {
            if (!this.enabled) {
                return;
            }
            if (this.parent != null && this.parent.clickedButton != null) {
                PosDateSearch.this.clickedButton.setClicked(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LJButton.this.requestFocus();
                }
            });
            if (this.parent != null) {
                this.parent.day = PosUtils.intVal(this.getText());
            }
            this.setClicked(true);
            if (this.parent != null) {
                this.parent.clickedButton = this;
            }
        }

        private void actionMouseDoubleClicked() {
            if (!this.enabled) {
                return;
            }
            this.parent.okDialog();
        }

        private void actionMouseEntered() {
            if (!this.enabled) {
                return;
            }
        }

        private void actionMouseExited() {
            if (!this.enabled) {
                return;
            }
        }
    }
}

