/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import jpos.IActionDetailLogWriter;
import jpos.LinkedReturn;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.pay.eftpos.EftposUtils;
import jpos.person.Country;
import org.jdom.Element;

public class PosUtils {
    public static int intVal(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long longVal(Object val) {
        try {
            if (val instanceof String) {
                return Long.parseLong((String)val);
            }
            if (val instanceof Double) {
                return ((Double)val).longValue();
            }
            if (val instanceof Long) {
                return (Long)val;
            }
            return 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static double doubleValFormatted(String str) {
        double returnDouble = 0.0;
        try {
            Number testDouble = SP.sParams.currFormat.parse(str);
            if (testDouble != null) {
                returnDouble = testDouble.doubleValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnDouble;
    }

    public static double doubleValInternal(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static double doubleValObject(Object val) {
        try {
            if (val instanceof String) {
                return PosUtils.doubleValFormatted((String)val);
            }
            if (val instanceof Double) {
                return (Double)val;
            }
            if (val instanceof Long) {
                return ((Long)val).doubleValue();
            }
            return 0.0;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static Integer IntegerVal(String str) {
        if (str == null) {
            return new Integer(0);
        }
        return new Integer(str);
    }

    public static boolean booleanVal(String str) {
        return str != null && !str.isEmpty() && !str.equals("0") && !str.equalsIgnoreCase("false");
    }

    public static boolean booleanVal(int val) {
        return val != 0;
    }

    public static boolean isInteger(Object obj) {
        try {
            if (obj instanceof String) {
                new BigInteger((String)obj);
            } else if (obj instanceof Double) {
                new BigInteger(((Double)obj).toString());
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static double scale(double val, int numdp) {
        try {
            BigDecimal bdVal = BigDecimal.valueOf(val);
            BigDecimal bdPrec = BigDecimal.valueOf(Math.pow(10.0, numdp));
            if (val < 0.0) {
                BigDecimal bdMult = bdVal.multiply(bdPrec).multiply(BigDecimal.valueOf(-1L));
                return 0.0 - (double)Math.round(bdMult.doubleValue()) / bdPrec.doubleValue();
            }
            BigDecimal bdMult = bdVal.multiply(bdPrec);
            return (double)Math.round(bdMult.doubleValue()) / bdPrec.doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static boolean startTrans(Connection con) throws SQLException {
        con.setAutoCommit(false);
        EftposUtils.debugPoint(null, "Database transaction started\nAuto Commit = " + con.getAutoCommit());
        return true;
    }

    public static boolean endTrans(Connection con) {
        boolean result = true;
        try {
            con.commit();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            result = false;
        }
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            result = false;
        }
        try {
            EftposUtils.debugPoint(null, "Database transaction committed\nAuto Commit = " + con.getAutoCommit());
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    public static boolean releaseTrans(Connection con) {
        boolean result = true;
        try {
            con.rollback();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            result = false;
        }
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            result = false;
        }
        try {
            EftposUtils.debugPoint(null, "Database transaction rolled back\nAuto Commit = " + con.getAutoCommit());
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    public static String padZeroes(long num, int length) {
        String retval = num + "";
        for (int i = retval.length(); i < length; ++i) {
            retval = "0" + retval;
        }
        return retval;
    }

    public static String PadLeft(String s, int pad, String sChar) {
        int length;
        if (s == null) {
            s = "";
        }
        if (sChar == null || sChar.length() == 0) {
            sChar = " ";
        }
        if ((length = s.length()) > pad) {
            s = s.substring(0, pad);
        } else {
            for (int count = length; count < pad; ++count) {
                s = s + sChar;
            }
        }
        return s;
    }

    public static String PadRight(String s, int pad, String sChar) {
        int length;
        if (s == null) {
            s = "";
        }
        if (sChar == null || sChar.length() == 0) {
            sChar = " ";
        }
        if ((length = s.length()) > pad) {
            s = s.substring(0, pad);
        } else {
            for (int count = length; count < pad; ++count) {
                s = sChar + s;
            }
        }
        return s;
    }

    public static Date calcExpiryDate(int nExpiryMonths) {
        if (nExpiryMonths == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        int nDay = cal.get(5);
        cal.set(5, 1);
        cal.add(2, nExpiryMonths);
        if (PosUtils.getLastDayOfMonth(cal) < nDay) {
            cal.add(2, 1);
        } else {
            cal.set(5, nDay);
        }
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    private static int getLastDayOfMonth(GregorianCalendar inCalender) {
        int lastDay = 0;
        switch (inCalender.get(2)) {
            case 0: {
                lastDay = 31;
                break;
            }
            case 1: {
                if (inCalender.isLeapYear(inCalender.get(1))) {
                    lastDay = 29;
                    break;
                }
                lastDay = 28;
                break;
            }
            case 2: {
                lastDay = 31;
                break;
            }
            case 3: {
                lastDay = 30;
                break;
            }
            case 4: {
                lastDay = 31;
                break;
            }
            case 5: {
                lastDay = 30;
                break;
            }
            case 6: {
                lastDay = 31;
                break;
            }
            case 7: {
                lastDay = 31;
                break;
            }
            case 8: {
                lastDay = 30;
                break;
            }
            case 9: {
                lastDay = 31;
                break;
            }
            case 10: {
                lastDay = 30;
                break;
            }
            case 11: {
                lastDay = 31;
            }
        }
        return lastDay;
    }

    public static String removeNonNumericChars(String text) {
        StringBuffer sbOriginal = new StringBuffer(text);
        StringBuffer sbReturn = new StringBuffer();
        for (int i = 0; i < sbOriginal.length(); ++i) {
            if (sbOriginal.charAt(i) < '0' || sbOriginal.charAt(i) > '9') continue;
            sbReturn.append(sbOriginal.charAt(i));
        }
        return sbReturn.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getDefaultBarcode(String barcode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProductBarcode(String barcode) {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM BARCODE B JOIN SKU K ON B.SKUIDX = K.SKUIDX WHERE B.CODE = ? AND K.ACTIVE = 1 ", barcode);){
            boolean bl = qry.next();
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getDefaultBarcode(long skuidx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.getConnection().clearWarnings();
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void centreWindow(Window window) {
        try {
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension windowSize = window.getSize();
            window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logActivity(String actionDescription) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO ACTIVITY_LOG (ALIDX, TILL_NUMBER, ACTION_DESC, CRDT) VALUES (?, ?, ?, CURRENT_TIMESTAMP)");){
            stmt.setLong(1, SP.sParams.nextVal("XACTIVITY_LOG"));
            stmt.setString(2, SP.sParams.tillnum);
            stmt.setString(3, actionDescription);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void logUserAction(String action, long transType, long transidx, long memidx, long clientidx, Vector<IActionDetailLogWriter> actionDetailLogWriters) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO ACTION_LOG (LOGIDX, TILL_NUMBER, USER_ACTION, TRANS_TYPE, TRANSIDX, MEMIDX, CLIENTIDX, LOG_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP)");){
            long logidx = SP.sParams.nextVal("XACTION_LOG");
            stmt.setLong(1, logidx);
            stmt.setString(2, SP.sParams.tillnum);
            stmt.setString(3, action);
            stmt.setLong(4, transType);
            if (transidx > 0L) {
                stmt.setLong(5, transidx);
            } else {
                stmt.setNull(5, 4);
            }
            stmt.setLong(6, memidx);
            if (clientidx != 0L) {
                stmt.setLong(7, clientidx);
            } else {
                stmt.setNull(7, 4);
            }
            stmt.executeUpdate();
            if (actionDetailLogWriters != null) {
                for (IActionDetailLogWriter writer : actionDetailLogWriters) {
                    writer.writeActionDetailLog(logidx);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static PlainDocument createIntegerValidationDocument(final boolean allowNegative) {
        PlainDocument doc = new PlainDocument();
        doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                Document doc = fb.getDocument();
                StringBuilder sb = new StringBuilder();
                sb.append(doc.getText(0, doc.getLength()));
                sb.insert(offset, string);
                if (sb.toString().isEmpty() || this.testForLong(sb.toString())) {
                    super.insertString(fb, offset, string, attr);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                Document doc = fb.getDocument();
                StringBuilder sb = new StringBuilder();
                sb.append(doc.getText(0, doc.getLength()));
                sb.replace(offset, offset + length, text);
                if (sb.toString().isEmpty() || this.testForLong(sb.toString())) {
                    super.replace(fb, offset, length, text, attrs);
                }
            }

            private boolean testForLong(String text) {
                try {
                    if (allowNegative && text.equals("-")) {
                        return true;
                    }
                    long number = Long.parseLong(text);
                    return allowNegative || number >= 0L;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAp21VersionNumber(boolean includeZero) {
        try (FileInputStream buildNumbersFile = new FileInputStream("BuildNumbers.properties");){
            String[] splits;
            Properties properties = new Properties();
            properties.load(buildNumbersFile);
            String ap21Version = properties.getProperty("Ap21Version");
            if (ap21Version == null) {
                String string2 = "0";
                return string2;
            }
            if (!includeZero && (splits = ap21Version.split("\\.")).length > 1 && splits[1].equals("0")) {
                ap21Version = splits[0];
            }
            String string = ap21Version;
            return string;
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static void logError(Throwable e) {
        System.out.print(PosUtils.getStackTrace(e));
    }

    public static void logError(String s) {
        System.out.println(s);
    }

    /*
     * Exception decompiling
     */
    public static String getStackTrace(Throwable e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static String getPassword(String schema) {
        String subs = "5739";
        if (schema.equalsIgnoreCase("BASS")) {
            return "saab5";
        }
        StringBuffer password = new StringBuffer("5739".length() + schema.length());
        int i = 0;
        while (i < schema.length() | i < "5739".length()) {
            if (i < schema.length()) {
                password.append(schema.charAt(i));
            }
            if (i < "5739".length()) {
                password.append("5739".charAt(i));
            }
            ++i;
        }
        return password.toString();
    }

    public static String nextValSyntax(String sSequenceName) {
        return "GEN_ID(" + sSequenceName + ",1)";
    }

    public static String StringToSqlString(String sCode) {
        int nlPos;
        sCode = StringUtils.nullToEmpty(sCode);
        String slOutStr = new String();
        int nlLen = sCode.length();
        if (nlLen == 0 || sCode.charAt(0) == '\u0000') {
            return "NULL";
        }
        while (nlLen > 0) {
            nlPos = sCode.indexOf(39);
            if (nlPos < 0) {
                nlPos = nlLen;
            }
            slOutStr = slOutStr + sCode.substring(0, nlPos);
            if ((nlLen -= nlPos) == 0) break;
            slOutStr = slOutStr + "''";
            sCode = sCode.substring(sCode.length() - --nlLen);
        }
        String slString2 = new String(slOutStr);
        nlLen = slString2.length();
        slOutStr = "";
        if (nlLen == 0) {
            return "NULL";
        }
        while (nlLen > 0) {
            nlPos = slString2.indexOf(92);
            if (nlPos < 0) {
                nlPos = nlLen;
            }
            slOutStr = slOutStr + slString2.substring(0, nlPos);
            if ((nlLen -= nlPos) == 0) break;
            slOutStr = slOutStr + "\\\\";
            slString2 = slString2.substring(slString2.length() - --nlLen);
        }
        return '\'' + slOutStr + '\'';
    }

    public static Country getCountryOfOrigin() {
        Country countryOfOrigin = new Country();
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT L.COUNTRY FROM LOCN L, REFCODE R WHERE L.LOCNIDX = R.LINKIDX AND R.RCIDX = " + SP.sParams.getStoreIdx());){
            if (sql.next()) {
                countryOfOrigin = new Country(sql.getString(1));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        if (countryOfOrigin.getCode().isEmpty()) {
            countryOfOrigin = new Country(Locale.getDefault().getCountry());
        }
        return countryOfOrigin;
    }

    public static String getDatabaseRecordAsText(Connection c, String table, String where) {
        StringBuffer builder = new StringBuffer();
        builder.append("TABLE: ");
        builder.append(table);
        builder.append("\n");
        builder.append("CONDITION: ");
        builder.append(where);
        builder.append("\n");
        try (SqlQuery query = new SqlQuery(c, "SELECT * FROM " + table + " WHERE " + where);){
            ResultSetMetaData metaData = query.getMetaData();
            boolean foundRecord = false;
            while (query.next()) {
                foundRecord = true;
                StringBuffer columns = new StringBuffer();
                StringBuffer values = new StringBuffer();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    if (StringUtils.isNullOrEmpty(query.getString(i))) continue;
                    if (columns.length() > 0) {
                        columns.append(", ");
                        values.append(", ");
                    }
                    columns.append(metaData.getColumnName(i));
                    values.append(PosUtils.StringToSqlString(query.getString(i)));
                }
                builder.append(columns);
                builder.append("\n");
                builder.append(values);
                builder.append("\n");
            }
            if (!foundRecord) {
                builder.append("NO RECORDS FOUND\n");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return builder.toString();
    }

    public static String getDatabaseColumnAsText(Connection c, String table, String column, String where) {
        StringBuffer builder = new StringBuffer();
        builder.append("TABLE: ");
        builder.append(table);
        builder.append("\n");
        builder.append("CONDITION: ");
        builder.append(where);
        builder.append("\n");
        try (SqlQuery query = new SqlQuery(c, "SELECT " + column + " FROM " + table + " WHERE " + where);){
            boolean foundRecord = false;
            while (query.next()) {
                if (!foundRecord) {
                    builder.append(column + ": ");
                    foundRecord = true;
                } else {
                    builder.append(", ");
                }
                builder.append(PosUtils.StringToSqlString(query.getString(1)));
            }
            if (!foundRecord) {
                builder.append("NO RECORDS FOUND\n");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFreightSku() {
        String stylecode = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.AUTO_FREIGHT_CALCULATION);
        if (StringUtils.isNullOrEmpty(stylecode)) return 0L;
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT K.SKUIDX FROM STYLE S, CLR C, SKU K, BARCODE B WHERE S.STYLEIDX = C.STYLEIDX AND C.CLRIDX = K.CLRIDX AND K.SKUIDX = B.SKUIDX AND S.\"ACTIVE\" = 1 AND C.\"ACTIVE\" = 1 AND K.\"ACTIVE\" = 1 AND S.STYLECODE = " + PosUtils.StringToSqlString(stylecode.trim()));){
            if (!sql.next()) return 0L;
            long l = sql.getLong(1);
            return l;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return 0L;
    }

    public static String HashData(String data) {
        if (data != null) {
            StringBuilder newData = new StringBuilder();
            if (data.length() > 10) {
                newData.append(data.substring(0, 3));
                for (int i = 3; i < data.length() - 3; ++i) {
                    newData.append("*");
                }
                newData.append(data.substring(data.length() - 3, data.length()));
                return newData.toString();
            }
            return data.replaceAll(".", "*");
        }
        return null;
    }

    public static String loyaltyCardNoPrefixToUpperCase(String cardNo) {
        if (cardNo.toUpperCase().startsWith("LM")) {
            cardNo = "LM" + cardNo.substring(2);
        } else if (cardNo.toUpperCase().startsWith("L")) {
            cardNo = "L" + cardNo.substring(1);
        }
        return cardNo;
    }

    public static ArrayList<LinkedReturn> getLinkedCustOrderReturns(String custOrderNumber) {
        ArrayList<LinkedReturn> returns = new ArrayList<LinkedReturn>();
        if (SP.sParams.checkIConn()) {
            Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_customer_order_linked_returns", custOrderNumber).getXML();
            for (Element ret : response.getChildren("return")) {
                try {
                    String retSkuidx = ret.getAttribute("skuidx").getValue();
                    String retDate = ret.getAttribute("return_date").getValue();
                    double origQty = ret.getAttribute("original_qty").getDoubleValue();
                    double retQty = ret.getAttribute("returned_qty").getDoubleValue();
                    String store = ret.getAttribute("store").getValue();
                    String customisation = ret.getAttribute("customisation").getValue();
                    LinkedReturn entry = new LinkedReturn(retSkuidx, retDate, store, origQty, retQty, customisation);
                    returns.add(entry);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        return returns;
    }

    public static ArrayList<LinkedReturn> getLinkedReturns(String widx, String docketnum) {
        ArrayList<LinkedReturn> returns = new ArrayList<LinkedReturn>();
        if (SP.sParams.checkIConn()) {
            String data = widx + "," + docketnum;
            Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_transaction_linked_returns", data).getXML();
            for (Element ret : response.getChildren("return")) {
                try {
                    String retSkuidx = ret.getAttribute("skuidx").getValue();
                    String retDate = ret.getAttribute("return_date").getValue();
                    String store = ret.getAttribute("store").getValue();
                    double origQty = ret.getAttribute("original_qty").getDoubleValue();
                    double retQty = ret.getAttribute("returned_qty").getDoubleValue();
                    String customisation = ret.getAttribute("customisation").getValue();
                    LinkedReturn entry = new LinkedReturn(retSkuidx, retDate, store, origQty, retQty, customisation);
                    returns.add(entry);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        } else {
            String fbirdSQL = "select d.skuidx, rh.trand as RETURN_DATE, d.qty as ORIG_QTY, sum(rd.qty) as RETURNED_QTY, rd.customisation as CUSTOMISATION from ret_tranh h join ret_trand d on d.vhidx = h.vhidx and d.line_type = 0 and d.active = 1 join ret_trand rd on rd.orig_vshidx = d.vshidx and rd.skuidx = d.skuidx and rd.line_type = 0 and rd.active = 1 and rd.qty < 0 and coalesce(d.customisation, 'n/a') = coalesce(rd.customisation, 'n/a')join ret_tranh rh on rh.vhidx = rd.vhidx and rh.widx = h.widx and rh.active = 1 join sku k on d.skuidx = k.skuidx where h.widx = " + widx + " and h.docket_number = '" + docketnum + "' group by d.skuidx, d.qty, rh.trand, rh.docket_number, rd.customisation";
            try (SqlQuery qry = new SqlQuery(SP.sParams.conn, fbirdSQL);){
                while (qry.next()) {
                    String skuidx = qry.getString("SKUIDX");
                    String retDate = qry.getString("RETURN_DATE");
                    double origQty = qry.getDouble("ORIG_QTY");
                    double retQty = qry.getDouble("RETURNED_QTY");
                    String customisation = qry.getString("CUSTOMISATION");
                    LinkedReturn ret = new LinkedReturn(skuidx, retDate, "this Store", origQty, retQty, customisation);
                    returns.add(ret);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return returns;
    }
}

