/*
 * Decompiled with CFR 0.152.
 */
package jpos.Promotions;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jpos.PosUtils;
import jpos.Promotions.DataSetHelper;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JRetailPromotions
extends JcpObject {
    private int engineInstanceID = -1;
    private int promotionsVersion = -1;
    private NamespaceContext microsoftNamespaceContext = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            String uri = prefix.equals("xs") ? "http://www.w3.org/2001/XMLSchema" : (prefix.equals("msdata") ? "urn:schemas-microsoft-com:xml-msdata" : (prefix.equals("msprop") ? "urn:schemas-microsoft-com:xml-msprop" : null));
            return uri;
        }

        public Iterator<?> getPrefixes(String val) {
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }
    };

    private int getEngineInstanceID() {
        if (this.engineInstanceID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"RetailPromotions.Firebird.PromotionsEngine", (Object[])new Object[]{StoreParams.getDbHost(), StoreParams.getDbUser(), StoreParams.getDbPassword(), StoreParams.getDbFile(), String.valueOf(SP.sParams.getStoreIdx())});
                if (!result.getSuccess()) {
                    throw new Exception(result.getCustomMessage() + "\r\n" + result.getErrorMessage() + "\r\n" + result.getStackTrace());
                }
                this.engineInstanceID = result.getRequestResultAsInt();
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.engineInstanceID = -1;
            }
        }
        return this.engineInstanceID;
    }

    private void preinitialiseEngine() {
        this.engineInstanceID = -1;
        this.getEngineInstanceID();
    }

    public JRetailPromotions() {
        this.preinitialiseEngine();
        this.promotionsVersion = this.GetPromotionsVersionFromPosDatabase();
        if (this.promotionsVersion > 100000) {
            this.resetPromotionsVersion();
            this.promotionsVersion = 1;
        }
    }

    private int GetPromotionsVersionFromPosDatabase() {
        int version = -1;
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT version FROM PROMOTIONS_VERSION");){
            if (sql.next()) {
                version = sql.getInt("version");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return version;
    }

    private void resetPromotionsVersion() {
        try (Statement stmt = SP.sParams.conn.createStatement();){
            stmt.executeUpdate("UPDATE PROMOTIONS_VERSION SET VERSION = 1");
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean promotionsVersionsMatch() {
        boolean match = false;
        if (this.promotionsVersion == this.GetPromotionsVersionFromPosDatabase()) {
            match = true;
        }
        return match;
    }

    public String ProcessTransactionsFromXmlDataSet(String dataSet, String perIdx, boolean enablePromotions, HashMap<String, String> extraProperties) throws Exception {
        if (this.getEngineInstanceID() > 0) {
            JcpRequestResult result;
            if (!enablePromotions) {
                dataSet = this.setDatasetExtendedProperty(dataSet, "disable_promotion_calculations", "");
            }
            if (extraProperties != null) {
                for (String key : extraProperties.keySet()) {
                    dataSet = this.setDatasetExtendedProperty(dataSet, key, extraProperties.get(key));
                }
            }
            if (SP.sParams.getPromoCachePurgeFlag()) {
                dataSet = this.setDatasetExtendedProperty(dataSet, "purge_promotion_cache_for_customer", "");
                SP.sParams.setPromoCachePurgeFlag(false);
            }
            if ((result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.engineInstanceID, (String)"ProcessTransactionsFromXmlDataSet", (Object[])new Object[]{dataSet, perIdx})).getSuccess()) {
                return result.getRequestResultAsString();
            }
            throw new Exception(result.getErrorMessage());
        }
        return dataSet;
    }

    private String setDatasetExtendedProperty(String dataSet, String name, String value) throws Exception {
        Document doc = DataSetHelper.getDatasetFromXml(dataSet);
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(this.microsoftNamespaceContext);
        Element element = (Element)xPath.evaluate("/NewDataSet/xs:schema/xs:element", doc, XPathConstants.NODE);
        Attr attr = doc.createAttributeNS("urn:schemas-microsoft-com:xml-msprop", "msprop:" + name);
        attr.setNodeValue(value == null ? "" : value);
        element.getAttributes().setNamedItem(attr);
        return DataSetHelper.getXmlStringFromXmlDocument(doc);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.engineInstanceID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.engineInstanceID);
            this.engineInstanceID = -1;
        }
    }
}

