/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;

public class Reference {
    private String name;
    private String code = "";
    private long rcidx = -1L;
    private long rpcidx = -1L;
    private long rgidx;
    private String grpSName;
    private String grpLName;
    private String extend;
    private String blobText;
    private double linkidx;
    private boolean showName = false;

    public Reference(String pname, String pcode, long prcidx, long prgidx, String pextend, double plinkidx) {
        this.name = pname;
        this.code = pcode;
        this.rcidx = prcidx;
        this.rgidx = prgidx;
        this.extend = pextend;
        this.linkidx = plinkidx;
    }

    public Reference(long prcidx, long prgidx, String pcode, String pname, double plinkidx, String pextend, String pblobText, String pGrpSName, String pGrpLName) {
        this.name = pname;
        this.code = pcode;
        this.rcidx = prcidx;
        this.rgidx = prgidx;
        this.extend = pextend;
        this.linkidx = plinkidx;
        this.blobText = pblobText;
        this.grpSName = pGrpSName;
        this.grpLName = pGrpLName;
    }

    public Reference(long prcidx) {
        this(prcidx, false);
    }

    public Reference(long prcidx, Connection db) {
        this(prcidx, false, db);
    }

    public Reference(long prcidx, boolean includeInactive) {
        this(prcidx, includeInactive, SP.sParams.conn);
    }

    public Reference(long prcidx, boolean includeInactive, Connection db) {
        this.rcidx = prcidx;
        String extra = includeInactive ? "" : " AND R.\"ACTIVE\" = 1 ";
        try (PreparedStatement stmt = db.prepareStatement("SELECT CODE, NAME, LINKIDX, \"EXTEND\", BLOBTEXT, R.RGIDX, G.S_NAME, G.L_NAME FROM REFGRP G, REFCODE R LEFT JOIN BLOBTEXT B ON R.LINKIDX = B.BLOBIDX WHERE G.RGIDX = R.RGIDX AND R.RCIDX = ? " + extra);){
            stmt.setLong(1, this.rcidx);
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    this.code = result.getString(1);
                    this.name = result.getString(2);
                    this.linkidx = result.getDouble(3);
                    this.extend = result.getString(4);
                    this.blobText = result.getString(5);
                    this.rgidx = result.getLong(6);
                    this.grpSName = result.getString(7);
                    this.grpLName = result.getString(8);
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public Reference(long prgidx, String pcode, boolean includeInactive) {
        String extra = includeInactive ? "" : " AND R.\"ACTIVE\" = 1 ";
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT R.RCIDX, R.NAME, R.LINKIDX, R.\"EXTEND\", R.RGIDX, B.BLOBTEXT FROM REFCODE R LEFT JOIN BLOBTEXT B ON R.LINKIDX = B.BLOBIDX WHERE R.RGIDX = ? AND R.CODE = ? " + extra);){
            stmt.setLong(1, prgidx);
            stmt.setString(2, pcode);
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    this.rcidx = result.getLong(1);
                    this.code = pcode;
                    this.name = result.getString(2);
                    this.linkidx = result.getDouble(3);
                    this.extend = result.getString(4);
                    this.rgidx = result.getLong(5);
                    this.blobText = result.getString(6);
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public Reference(String pname, String pcode, long prcidx) {
        this.name = pname;
        this.code = pcode;
        this.rcidx = prcidx;
    }

    public Reference(String pname, String pcode, long prcidx, long prpcidx) {
        this.name = pname;
        this.code = pcode;
        this.rcidx = prcidx;
        this.rpcidx = prpcidx;
    }

    public String toString() {
        return this.showName ? this.name : this.code;
    }

    public String getExtend() {
        return this.extend;
    }

    public String getName() {
        return StringUtils.nullToEmpty(this.name);
    }

    public String getCode() {
        return StringUtils.nullToEmpty(this.code);
    }

    public long getIdx() {
        return this.rcidx;
    }

    public long getParentIdx() {
        return this.rpcidx;
    }

    public String getBlobText() {
        return this.blobText;
    }

    public String getGroupName() {
        return this.grpLName;
    }

    public String getGroupCode() {
        return this.grpSName;
    }

    public long getGroupIdx() {
        return this.rgidx;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public boolean getShowName() {
        return this.showName;
    }

    public double getLinkidx() {
        return this.linkidx;
    }
}

