/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import jpos.DlgMessage;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.RemPosReportRun;
import jpos.SearchProvider;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.swing.BJTable;
import jpos.basscom.swing.BJTableSel;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.Utils;
import jpos.ui.DialogButton;

public class RemPosReport
extends JDialog
implements KeyEventDispatcher {
    public static final int PRINT = 1;
    public static final int PREVIEW = 0;
    ToServ toserv = null;
    Connection connivDB;
    Cacher cacher;
    String[] saivInOut = new String[9];
    String title;
    long nGenRepIdx;
    long nMemidx;
    int nOpts;
    boolean bShowSelections;
    boolean bShowOptions;
    boolean bFBLocal;
    Frame frParent;
    String sSecWhere;
    private boolean offlineReport = false;
    DialogButton jbPreview = new DialogButton("");
    DialogButton jbPrint = new DialogButton("");
    DialogButton jbCancel = new DialogButton("");
    StringBuffer sComSend = new StringBuffer("");
    public JPanel selectionsPanel = new JPanel();
    public BorderLayout borderLayout1 = new BorderLayout();
    public PosScrollPane selectionsScroll = new PosScrollPane();
    public JPanel optionsPanel = new JPanel();
    public BorderLayout borderLayout2 = new BorderLayout();
    public PosScrollPane optionsScroll = new PosScrollPane();
    public JPanel buttonsPanel = new JPanel();
    public BJTableSel selectionsTable = new BJTableSel(1);
    public BJTable optionsTable = new BJTable();
    public BJTextField searchField = new BJTextField();
    StoreParams sParams;

    public RemPosReport() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public RemPosReport(Connection connDB, Frame parent, boolean modal, long memidx, long genRepIdx, StoreParams sParams) {
        super(parent, "", modal);
        this.sParams = sParams;
        this.frParent = parent;
        this.connivDB = connDB;
        this.nGenRepIdx = genRepIdx;
        this.nMemidx = memidx;
        try {
            this.jbInit();
            this.setTitle("Selections for " + this.title);
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        block121: {
            try (SqlQuery sql = new SqlQuery(this.connivDB, "SELECT REPNAME, COALESCE(BLOBIDX, 0) FROM GENREP WHERE GENREPIDX = " + this.nGenRepIdx);){
                if (sql.next() && StringUtils.isNullOrEmpty(sql.getString(1)) && sql.getLong(2) > 0L) {
                    this.offlineReport = true;
                }
            }
            catch (Exception e) {
                Utils.logError(e);
            }
            this.jbPreview.setText(StoreParams.res.getString("Alt_V_Preview"));
            this.jbPrint.setText(StoreParams.res.getString("Alt_P_Print"));
            this.jbCancel.setText(StoreParams.res.getString("Cancel"));
            this.optionsTable.setEditMsgToParent(false);
            this.selectionsTable.setEditMsgToParent(false);
            this.optionsTable.setTableHeader(new JTableHeader(this.optionsTable.getColumnModel()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = 0;
                    return d;
                }
            });
            Vector<String> vAddedAlias = new Vector<String>();
            this.nOpts = 0;
            this.selectionsPanel.setLayout(this.borderLayout1);
            this.selectionsPanel.setPreferredSize(new Dimension(650, 250));
            this.optionsPanel.setLayout(this.borderLayout2);
            this.optionsPanel.setPreferredSize(new Dimension(650, 100));
            this.searchField.setVisible(false);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        RemPosReport.this.jbCancel_actionPerformed();
                    } else if (e.getKeyCode() == 80 && e.isAltDown()) {
                        RemPosReport.this.jbPrint_actionPerformed();
                    } else if (e.getKeyCode() == 86 && e.isAltDown()) {
                        RemPosReport.this.jbPreview_actionPerformed();
                    }
                }
            });
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            this.jbPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemPosReport.this.jbPrint_actionPerformed();
                }
            });
            this.jbPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemPosReport.this.jbPreview_actionPerformed();
                }
            });
            this.jbCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemPosReport.this.jbCancel_actionPerformed();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RemPosReport.this.fini();
                }
            });
            try {
                String sTblDesc;
                String sQtype;
                this.bShowSelections = false;
                try (SqlQuery sql = new SqlQuery(this.connivDB, "SELECT 1 FROM REFSEL WHERE GENREPIDX = " + this.nGenRepIdx);){
                    if (sql.next()) {
                        this.bShowSelections = true;
                    }
                }
                int nHoSearch = 0;
                sql = new SqlQuery(this.connivDB, "SELECT COALESCE(HO_SEARCH_FLAG, 0) FROM GENREP WHERE GENREPIDX = " + this.nGenRepIdx);
                var19_13 = null;
                try {
                    if (sql.next()) {
                        nHoSearch = sql.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    var19_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var19_13 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var19_13.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                this.bShowOptions = false;
                sql = new SqlQuery(this.connivDB, "SELECT 1 FROM REFOPT WHERE GENREPIDX = " + this.nGenRepIdx);
                var19_13 = null;
                try {
                    if (sql.next()) {
                        this.bShowOptions = true;
                    }
                }
                catch (Throwable throwable) {
                    var19_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var19_13 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var19_13.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                sql = new SqlQuery(this.connivDB, "SELECT DESCRIP FROM GENREP WHERE GENREPIDX = " + this.nGenRepIdx);
                var19_13 = null;
                try {
                    if (sql.next()) {
                        this.title = sql.getString(1);
                    }
                }
                catch (Throwable throwable) {
                    var19_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var19_13 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var19_13.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                this.optionsScroll.setPreferredSize(new Dimension(260, 100));
                if (!this.bShowSelections) {
                    this.selectionsPanel.setPreferredSize(new Dimension(260, 100));
                    this.selectionsScroll.setPreferredSize(new Dimension(260, 100));
                }
                this.optionsTable.setRowSelectionAllowed(true);
                this.optionsTable.setEditMsgToParent(false);
                this.selectionsTable.setEditMsgToParent(false);
                this.getContentPane().add((Component)this.searchField, "North");
                this.getContentPane().add((Component)this.buttonsPanel, "South");
                if (this.bShowSelections || this.bShowOptions) {
                    this.getContentPane().add((Component)this.selectionsPanel, "North");
                    this.selectionsPanel.add((Component)this.selectionsScroll, "Center");
                }
                if (this.bShowSelections && this.bShowOptions) {
                    this.getContentPane().add((Component)this.optionsPanel, "Center");
                    this.optionsPanel.add((Component)this.optionsScroll, "West");
                }
                this.buttonsPanel.add(this.jbPrint);
                this.buttonsPanel.add(this.jbPreview);
                this.buttonsPanel.add(this.jbCancel);
                if (this.bShowSelections) {
                    this.selectionsScroll.getViewport().add((Component)this.selectionsTable, null);
                    if (this.bShowOptions) {
                        this.optionsScroll.getViewport().add((Component)this.optionsTable, null);
                    } else {
                        this.optionsTable.setVisible(false);
                    }
                } else {
                    if (this.bShowOptions) {
                        this.selectionsScroll.getViewport().add((Component)this.optionsTable, null);
                    } else {
                        this.optionsTable.setVisible(false);
                    }
                    this.selectionsTable.setVisible(false);
                }
                this.toserv = new ToServ(this.connivDB);
                this.toserv.setSearchProvider(new SearchProvider(this.sParams));
                if (this.bShowSelections) {
                    if (nHoSearch == 1) {
                        this.selectionsTable.setToServ(this.toserv);
                    }
                    this.selectionsTable.setConnection(this.connivDB);
                    this.selectionsTable.setSearchField(this.searchField);
                    this.cacher = new Cacher(1L, this.connivDB);
                    this.selectionsTable.setCacher(this.cacher);
                    this.sSecWhere = "";
                    sql = new SqlQuery(this.connivDB, "SELECT QTYPE, COALESCE(TBLIDX, 0), COALESCE(QUIDX, 0), COALESCE(RGIDX, 0), DBTABLE, DBCOLUMN, TABLEDESC, EXTABLE, EXWHERE, COALESCE(SECTBLIDX,0) FROM REFSEL WHERE GENREPIDX = " + this.nGenRepIdx + " ORDER BY XORD ");
                    var19_13 = null;
                    try {
                        while (sql.next()) {
                            String sSecWhereTmp = "";
                            sQtype = sql.getString(1);
                            long nTblidx = sql.getLong(2);
                            long nQuidx = sql.getLong(3);
                            long nRgidx = sql.getLong(4);
                            String sDbTable = this.nvlS(sql.getString(5));
                            String sDbColumn = this.nvlS(sql.getString(6));
                            sTblDesc = this.nvlS(sql.getString(7));
                            String sExTable = this.nvlS(sql.getString(8));
                            String sExWhere = this.nvlS(sql.getString(9));
                            int nSecTblIdx = sql.getInt(10);
                            if (nSecTblIdx > 0) {
                                int workgroupType = Utils.getWorkgroupTypeForRefObject(nSecTblIdx);
                                if (vAddedAlias.indexOf(sDbTable) < 0) {
                                    sSecWhereTmp = Utils.GetWhseSecWhereSQL(this.connivDB, this.sParams.getStoreIdx(), workgroupType, sDbTable, 1);
                                    if (sSecWhereTmp != null && sSecWhereTmp.length() > 0) {
                                        this.sSecWhere = this.sSecWhere + " AND " + sSecWhereTmp;
                                    }
                                    vAddedAlias.add(sDbTable);
                                }
                            }
                            if (sQtype.equals("Cache")) {
                                if (sSecWhereTmp != null && sSecWhereTmp.length() > 0) {
                                    sExWhere = sExWhere + " AND " + sSecWhereTmp;
                                }
                                this.selectionsTable.addCache(nQuidx, sDbTable, sTblDesc, sDbColumn, sExTable, sExWhere);
                            }
                            if (sQtype.equals("Date")) {
                                this.selectionsTable.addDate(sDbTable, sTblDesc, sDbColumn);
                            }
                            if (sQtype.equals("RefObj")) {
                                this.selectionsTable.addRefObj(nTblidx, sDbTable, sTblDesc, nSecTblIdx, this.sParams.getStoreIdx());
                            }
                            if (!sQtype.equals("RefGrp")) continue;
                            this.selectionsTable.addRefGrp(nRgidx, sDbTable, sTblDesc, sDbColumn, nSecTblIdx, this.sParams.getStoreIdx());
                        }
                    }
                    catch (Throwable workgroupType) {
                        var19_13 = workgroupType;
                        throw workgroupType;
                    }
                    finally {
                        if (sql != null) {
                            if (var19_13 != null) {
                                try {
                                    sql.close();
                                }
                                catch (Throwable workgroupType) {
                                    var19_13.addSuppressed(workgroupType);
                                }
                            } else {
                                sql.close();
                            }
                        }
                    }
                }
                if (!this.bShowOptions) break block121;
                String[] saNames = new String[2];
                String[] saTitles = new String[2];
                int[] naAlignments = new int[2];
                int[] naWidths = new int[2];
                int[] naColumnTypes = new int[2];
                saNames[0] = "colOption";
                saTitles[0] = "Option";
                naAlignments[0] = 2;
                naWidths[0] = 200;
                naColumnTypes[0] = 0;
                saNames[1] = "colVal";
                saTitles[1] = "Selection";
                naAlignments[1] = 0;
                naWidths[1] = 40;
                naColumnTypes[1] = 4;
                this.optionsTable.setUp(saNames, saTitles, naAlignments, naWidths, naColumnTypes, 2, false, true, false);
                try (SqlQuery sql = new SqlQuery(this.connivDB, "SELECT QTYPE, DESCRIP FROM REFOPT WHERE GENREPIDX = " + this.nGenRepIdx + " ORDER BY XORD ");){
                    while (sql.next()) {
                        sQtype = this.nvlS(sql.getString(1));
                        sTblDesc = this.nvlS(sql.getString(2));
                        this.optionsTable.addNewRow();
                        int row = this.optionsTable.getLastRow();
                        this.optionsTable.setRowHdrValueAt(sTblDesc, row);
                        this.optionsTable.setCellValueAt("false", row, "colVal");
                        ++this.nOpts;
                    }
                }
            }
            catch (Exception e) {
                this.showMsg(PosUtils.getStackTrace(e));
            }
        }
        if (this.selectionsTable.getRowCount() > 0) {
            this.selectionsTable.setRowSelectionInterval(0, 0);
        }
        if (this.optionsTable.getRowCount() > 0) {
            this.optionsTable.setRowSelectionInterval(0, 0);
        }
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.selectionsTable);
        v.add(this.optionsTable);
        v.add(this.jbPrint);
        v.add(this.jbPreview);
        v.add(this.jbCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    void showMsg(String sMsg) {
        DlgMessage.showMessage(this, Utils.stringWrap(sMsg, 100, false), "Msg", 1);
    }

    void jbPrint_actionPerformed() {
        this.makeReport(1);
    }

    void fini() {
        this.toserv = null;
        this.dispose();
    }

    void jbPreview_actionPerformed() {
        this.makeReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeReport(int action) {
        if (!this.performScreenValidations()) {
            return;
        }
        RemPosReportRun remotePosReportRun = null;
        this.setCursor(StoreParams.waitCursor);
        try {
            this.sComSend.setLength(0);
            this.sComSend.append(this.nMemidx + "\u0003" + this.nOpts + "\u0003" + this.nGenRepIdx + "\u0003");
            String sWhere = "";
            String sReadable = "";
            if (this.bShowSelections) {
                this.selectionsTable.extract(this.offlineReport ? 1 : 0);
                sReadable = this.selectionsTable.getReadableSelections();
                sWhere = this.selectionsTable.getWhere();
                if (sWhere == null) {
                    sWhere = "1=1";
                }
                if (sWhere.equals("")) {
                    sWhere = "1=1";
                }
                sWhere = sWhere + this.sSecWhere;
                this.sComSend.append(sWhere + "\u0003");
            } else {
                this.sComSend.append("1=1\u0003");
            }
            if (sReadable == null || sReadable.length() == 0) {
                sReadable = " ";
            }
            this.sComSend.append(sReadable + "\u0003");
            if (this.bShowOptions) {
                for (int row = 0; row < this.optionsTable.getRowCount(); ++row) {
                    if (this.optionsTable.getCellValueAt(row, "colVal").equals("true")) {
                        this.sComSend.append("1\u0003");
                        continue;
                    }
                    this.sComSend.append("0\u0003");
                }
            }
            remotePosReportRun = new RemPosReportRun(this.connivDB, null, true, this.toserv, this.title, this.sComSend, action, this.nGenRepIdx, this.nMemidx);
        }
        finally {
            this.setCursor(StoreParams.normalCursor);
        }
        if (remotePosReportRun != null) {
            if (action == 1) {
                remotePosReportRun.doPrint();
                remotePosReportRun.Close();
            } else {
                remotePosReportRun.setVisible(true);
                remotePosReportRun.dispose();
            }
        }
    }

    private boolean performScreenValidations() {
        this.selectionsTable.doLoseFocus();
        return !this.selectionsTable.isBusy() && this.selectionsTable.isValidationOk();
    }

    void jbCancel_actionPerformed() {
        this.fini();
    }

    public String nvlS(String sNull) {
        if (sNull == null) {
            return "";
        }
        return sNull;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }
}

