/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import jpos.PosUtils;
import jpos.StringUtils;

public class SqlQuery
implements AutoCloseable {
    private Statement stmt;
    private ResultSet resultSet;

    public SqlQuery(Connection conn, String sql) throws SQLException {
        this.stmt = conn.createStatement();
        this.resultSet = this.stmt.executeQuery(sql);
    }

    public SqlQuery(Connection conn, String sql, Object ... binds) throws SQLException {
        this.stmt = conn.prepareStatement(sql);
        SqlQuery.addBinds((PreparedStatement)this.stmt, binds);
        this.resultSet = ((PreparedStatement)this.stmt).executeQuery();
    }

    @Override
    public void close() {
        PosUtils.closeResultSet(this.resultSet);
        PosUtils.closeStatement(this.stmt);
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex);
    }

    public String getString(int columnIndex, String defaultValue) throws SQLException {
        return StringUtils.nullToValue(this.resultSet.getString(columnIndex), defaultValue);
    }

    public String getString(String columnLabel) throws SQLException {
        return this.resultSet.getString(columnLabel);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    public int getInt(String columnLabel) throws SQLException {
        return this.resultSet.getInt(columnLabel);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex);
    }

    public long getLong(String columnLabel) throws SQLException {
        return this.resultSet.getLong(columnLabel);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex);
    }

    public double getDouble(String columnLabel) throws SQLException {
        return this.resultSet.getDouble(columnLabel);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.resultSet.getBoolean(columnLabel);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.resultSet.getTimestamp(columnLabel);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex, calendar);
    }

    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(columnLabel, calendar);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.resultSet.getDate(columnIndex);
    }

    public Date getDate(String columnLabel) throws SQLException {
        return this.resultSet.getDate(columnLabel);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.resultSet.getBytes(columnLabel);
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public static int executeUpdate(Connection con, String sql) throws SQLException {
        try (Statement stmt = con.createStatement();){
            int n = stmt.executeUpdate(sql);
            return n;
        }
    }

    public static int executeUpdate(Connection con, String sql, Object ... binds) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(sql);){
            SqlQuery.addBinds(stmt, binds);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private static void addBinds(PreparedStatement stmt, Object ... binds) throws SQLException {
        for (int i = 0; i < binds.length; ++i) {
            if (binds[i] == null) {
                stmt.setNull(i + 1, 4);
                continue;
            }
            stmt.setObject(i + 1, binds[i]);
        }
    }
}

