/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Vector;
import jpos.DiscLine;
import jpos.DlgReason;
import jpos.IActionDetailLogWriter;
import jpos.MultiLineDisc;
import jpos.Note;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosDualValue;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SalesRep;
import jpos.SkuPrice;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.associations.Association;
import jpos.rewards.Gift;
import jpos.ui.Colours;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherUtils;
import org.jdom.Element;

public class StyleLine
implements IActionDetailLogWriter {
    public static final int PRICE_OVERRIDE_REASONS = 435;
    public static final int STYLE = 1;
    public static final int CLR = 2;
    public static final int SKU = 3;
    public static final int MAX_L_DISC = 10;
    public static final int QTY_ORIG = 1;
    public static final int QTY_CURR = 2;
    public static final int QTY_DIFF = 3;
    public static final int QTY_LAST = 4;
    public static final int QTY_AVAIL = 5;
    public static final int QTY_REQ = 6;
    public static final int PACKED_ORIG = 7;
    public static final int PACKED_CURR = 8;
    public static final int PACKED_DIFF = 9;
    public static final int QTY_ADJUSTED_TO = 10;
    protected String stylecode = "";
    protected String styledesc = "";
    protected String clrcode = "";
    protected String clrdesc = "";
    protected String size = "";
    protected String customisation = "";
    protected double weight = 0.0;
    private boolean nonReturnable = false;
    private double availableQty = -1.0;
    private boolean availQtyChanged = false;
    private boolean bGenPurchaseOrder = false;
    private boolean bGenProduct = false;
    private boolean bChangeCost = false;
    private boolean bGenTransferOrder = false;
    private double qty = 0.0;
    private double qtyAdjustedTo = 0.0;
    private double qtyReturned = 0.0;
    private double qtyOrig = 0.0;
    private double cost = 0.0;
    private String sDelTo = "";
    private long nDelToIdx = 0L;
    private double origQty = 0.0;
    private double backedUpQtyBeforeSave = 0.0;
    private double lastQty = 0.0;
    private double priceBeforeUserChange = 0.0;
    private boolean bPriceChangedByUser = false;
    private boolean qtySohAvailable = false;
    private double qtySoh = 0.0;
    private double pickUpQty = 0.0;
    private double packedQty = 0.0;
    private double takenQty = 0.0;
    private double origPackedQty = 0.0;
    private double taxper = 0.0;
    private double extendedTaxRate = 0.0;
    private String extendedTaxCode = "";
    private long skuidx = -1L;
    private long styleidx = 0L;
    private long clridx = 0L;
    private String barcode = "";
    private double reqQty = 0.0;
    private String gvNum = null;
    private String voucherGatewayIdx = null;
    private boolean voucherDeferred;
    private double voucherBalance;
    private String voucherReceiptNumber = "";
    private String voucherAuthCode;
    private Timestamp voucherIssueDate;
    private Date voucherExpiryDate;
    private String voucherReference;
    private String _voucherRecipientName;
    private String _voucherRecipientSurname;
    private String _voucherRecipientEmail;
    private String _message;
    private boolean _isDigitalVoucher = false;
    private boolean _isRefundVoucher = false;
    private int stkFlag = 1;
    private boolean valid = false;
    private boolean descripChanged = false;
    private boolean bDoNotRefreshTax = false;
    private String pickSlipRun = "";
    private boolean useLoadedHO = false;
    private long vshidx = -1L;
    private long pos_vshidx = -1L;
    public StringBuffer reasonIdx = new StringBuffer("-1");
    public StringBuffer reasonNotes = new StringBuffer();
    private SalesRep returnOverrideSalesRep = null;
    private StringBuffer priceOverrideReasonIdx = new StringBuffer("-1");
    private StringBuffer priceOverrideNotes = new StringBuffer();
    private StoreParams sParams;
    private boolean newStyle = true;
    private long pozdidx = -1L;
    private boolean bDebtorAccount = false;
    private boolean bLinked = false;
    private String salesRepName = "";
    private long salesRepIdx = 0L;
    private Vector<Association> associations = null;
    private boolean bIsTransferRequest = false;
    private boolean useDiscAdjustment = false;
    private boolean adjustedQtySet = false;
    private Vector<DiscLine> discLines = new Vector();
    private Vector<Note> notes = new Vector();
    private Vector<String> overReturns = new Vector();
    private boolean recallProd = false;
    private long recalLogIdx = 0L;
    private Date expiryDate;
    private SkuPrice skuPrice = new SkuPrice();
    private long attachedPromoIdx = 0L;
    private long sozdidx = -1L;
    private String setValErrorMessage = "";
    private StyleLine splitFromStyleLine = null;
    private Gift gift = null;
    private boolean giftOnly = false;

    public StyleLine(StoreParams psParams) {
        this.sParams = psParams;
    }

    public StyleLine(String barcode, boolean allowNonStkd, StoreParams psParams) {
        this(barcode, allowNonStkd, psParams, false);
    }

    public StyleLine(String barcode, boolean allowNonStkd, StoreParams psParams, boolean loadStockOnHand) {
        this.sParams = psParams;
        this.barcode = barcode.trim();
        String qryString = "SELECT S.STYLEIDX, COALESCE(S.STYLECODE, ''), COALESCE(S.NAME, ''), C.CLRIDX,  COALESCE(C.CLRCODE, ''), K.SKUIDX, COALESCE(K.SIZEVAL, ''), NULL, COALESCE(C.CLRNAME, ''),  S.TAXPER, S.STKFLAG, NULL, COALESCE(S.RECALL,0), COALESCE(S.RECALL_LOGIDX,0), COALESCE(S.EXT_TAXRATE,0), COALESCE(S.GIFT_ONLY,0), COALESCE(K.WEIGHT,0) FROM STYLE S, CLR C, SKU K, BARCODE B WHERE B.CODE = " + PosUtils.StringToSqlString(this.barcode) + " AND B.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX AND  S.\"ACTIVE\"=1 AND C.\"ACTIVE\" = 1 AND K.\"ACTIVE\" = 1 " + this.sParams.sExcludeDefSkusWhere;
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, qryString);){
            if (sql.next()) {
                this.styleidx = sql.getLong(1);
                this.stylecode = sql.getString(2);
                this.styledesc = sql.getString(3) + " " + sql.getString(9);
                this.clridx = sql.getLong(4);
                this.clrcode = sql.getString(5);
                this.clrdesc = sql.getString(9);
                this.skuidx = sql.getLong(6);
                this.qty = 1.0;
                this.skuPrice = new SkuPrice(this.skuidx);
                this.size = sql.getString(7);
                this.setTaxPer(sql.getDouble(10));
                this.stkFlag = sql.getInt(11);
                if (!allowNonStkd && this.stkFlag == 0) {
                    this.stylecode = StoreParams.res.getString("non_stk") + " : " + this.stylecode;
                } else {
                    this.valid = true;
                }
                this.recallProd = sql.getBoolean(13);
                this.recalLogIdx = sql.getLong(14);
                this.setExtTaxPer(sql.getDouble(15));
                this.giftOnly = sql.getBoolean(16);
                this.weight = sql.getDouble(17);
                this.fetchExtendedTaxCode(this.styleidx);
                this.setSpecialOrderFlags(this.styleidx);
                if (loadStockOnHand && this.stkFlag == 1) {
                    this.fetchStockOnHandQuantity(this.skuidx);
                }
            } else {
                this.stylecode = StoreParams.res.getString("INVALID_APN");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public StyleLine(long sku, double pqty, StoreParams psParams) {
        this(sku, pqty, psParams, false);
    }

    public StyleLine(long sku, double pqty, StoreParams psParams, boolean loadStockOnHand) {
        this.sParams = psParams;
        this.qty = pqty;
        String sqlQueryStr = "SELECT S.STYLEIDX, COALESCE(S.STYLECODE, ''), COALESCE(S.NAME, ''), C.CLRIDX, COALESCE(C.CLRCODE, ''), K.SKUIDX, COALESCE(K.SIZEVAL, ''), NULL, COALESCE(C.CLRNAME, ''), S.TAXPER, COALESCE(DB.CODE, ''), S.STKFLAG, NULL, COALESCE(S.RECALL,0), COALESCE(S.RECALL_LOGIDX,0), COALESCE(S.EXT_TAXRATE,0), COALESCE(S.GIFT_ONLY,0), COALESCE(K.WEIGHT, 0) FROM STYLE S, CLR C, SKU K, DEFAULT_BARCODE DB WHERE K.SKUIDX=" + sku + " AND DB.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX";
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, sqlQueryStr);){
            if (sql.next()) {
                this.styleidx = sql.getLong(1);
                this.stylecode = sql.getString(2);
                this.styledesc = sql.getString(3) + " " + sql.getString(9);
                this.clridx = sql.getLong(4);
                this.clrcode = sql.getString(5);
                this.clrdesc = sql.getString(9);
                this.skuidx = sql.getLong(6);
                this.barcode = sql.getString(11);
                this.origQty = this.qty = pqty;
                this.skuPrice = new SkuPrice(this.skuidx);
                this.size = sql.getString(7);
                this.setTaxPer(sql.getDouble(10));
                this.stkFlag = sql.getInt(12);
                this.recallProd = sql.getBoolean(14);
                this.recalLogIdx = sql.getLong(15);
                this.setExtTaxPer(sql.getDouble(16));
                this.giftOnly = sql.getBoolean(17);
                this.valid = true;
                this.weight = sql.getDouble(18);
                this.fetchExtendedTaxCode(this.styleidx);
                this.setSpecialOrderFlags(this.styleidx);
                if (loadStockOnHand && this.stkFlag == 1) {
                    this.fetchStockOnHandQuantity(this.skuidx);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private String getStyleDescDisplay() {
        if (this.getStkFlag() != 0 && this.skuPrice.getSkuidx() > 0L && this.skuPrice.getOrigPrice() > this.skuPrice.getPrice()) {
            String rgb = String.format("rgb(%s,%s,%s)", Colours.BLUE.getRed(), Colours.BLUE.getGreen(), Colours.BLUE.getBlue());
            return String.format("<html>%s<BR><span style=\"font-size:10px;color:%s\">%s: %s, %s: %s</span></html>", this.styledesc, rgb, SP.getRS("Original_Price"), new PosDouble(this.skuPrice.getOrigPrice()), SP.getRS("Savings"), new PosDouble(this.skuPrice.getOrigPrice() - this.skuPrice.getPrice()));
        }
        return this.styledesc;
    }

    public Vector<String> getOverReturns() {
        return this.overReturns;
    }

    public double getReturnedQuantity() {
        return this.qtyReturned;
    }

    public void setReturnedQuantity(double returnedQuantity) {
        this.qtyReturned = returnedQuantity;
    }

    public double getOriginalQuantity() {
        return this.qtyOrig;
    }

    public void setOriginalQuantity(double originalQuantity) {
        this.qtyOrig = originalQuantity;
    }

    private void fetchStockOnHandQuantity(long skuidx) {
        if (this.sParams.checkIConn()) {
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("soh_qty", this.sParams.getStoreIdx() + "," + skuidx).getXML();
            if (this.sParams.root != null && this.sParams.root.getName().equals("stk")) {
                if (this.sParams.root.getChildren().size() > 0) {
                    Element element0 = (Element)this.sParams.root.getChildren().get(0);
                    this.setQtySoh(new PosDouble(element0.getAttribute("soh_qty").getValue()).doubleValue());
                } else {
                    this.setQtySoh(0.0);
                }
            }
        }
    }

    public double getStockQuantity(int formulaId) {
        if (this.sParams.checkIConn()) {
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("product_stk_value", this.sParams.getStoreIdx() + "," + formulaId + "," + this.skuidx).getXML();
            if (this.sParams.root != null && this.sParams.root.getName().equals("product_stk_value") && this.sParams.root.getChildren().size() > 0) {
                Element element0 = (Element)this.sParams.root.getChildren().get(0);
                return new PosDouble(element0.getAttribute("stk").getValue()).doubleValue();
            }
        }
        return 0.0;
    }

    public void setDebtorAccountSale(boolean pDebtorAccount) {
        this.bDebtorAccount = pDebtorAccount;
    }

    public void db_insertline() throws SQLException {
        if (this.qty != 0.0 || this.packedQty != 0.0 || this.pickUpQty != 0.0) {
            String db_descrip2 = this.reqQty > 0.0 ? String.valueOf(this.reqQty) : (this.reasonIdx.toString().equals("-1") ? null : this.reasonNotes.toString());
            long newVshidx = this.sParams.nextVal("XRET_TRAND");
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRAND(VSHIDX, VHIDX, \"ACTIVE\", SKUIDX, QTY, DESCRIP1, DESCRIP2, RET_REASIDX,  GROSS, NET, PRICE, SEQUENCE_NUMBER, LINE_CODE, LINE_TYPE, STKFLAG, TAXPER,  POZDIDX, GVNUM, QTY_AVAIL, DELIVER_WIDX, PURCHASE_COST, ORIG_EXPIRY_DATE, EXPIRY_DATE, ORIG_PRICE,  POS_MKDMSGIDX, EXT_TAXRATE, TAKEN, PACKED, ORIG_VSHIDX, PROMOIDX, PRICE_OVERRIDE_IDX,  PRICE_OVERRIDE_NOTES, OLD_HELD_VALUE, EXTENDED_TAX_CODE, GIFT_IDX, TAX_DONOTREFRESH_FLAG, VOUCHER_GATEWAY_IDX,  GVGATE_DEFERRED_FLAG, GVGATE_BALANCE, GVGATE_RECEIPT_NUM, GVGATE_AUTHCODE, GVGATE_ISSUE_DATE, GVGATE_EXPIRY_DATE,  GVGATE_REFERENCE, GVGATE_ISDIGITAL, GVGATE_REC_EMAIL, OVERRIDE_SREPIDX, CUSTOMISATION, SREPIDX, ASSOC_RCIDX) SELECT ?, ?, 1, ?, ?, ?, ?, ?,  ?, ?, ?, COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ? FROM RET_TRAND WHERE VHIDX = ?");){
                prepStmt.setLong(1, newVshidx);
                prepStmt.setLong(2, this.sParams.currVal("XRET_TRANH"));
                prepStmt.setLong(3, this.skuidx);
                prepStmt.setDouble(4, this.qty);
                prepStmt.setString(5, this.descripChanged ? this.styledesc : null);
                prepStmt.setString(6, db_descrip2);
                if (this.reasonIdx.toString().equals("-1")) {
                    prepStmt.setNull(7, 4);
                } else {
                    prepStmt.setLong(7, PosUtils.longVal(this.reasonIdx.toString()));
                }
                prepStmt.setDouble(8, this.bDebtorAccount ? this.getGrossLessTax() : this.getGross(2));
                prepStmt.setDouble(9, this.bDebtorAccount ? this.getGrossLessTax() : this.getGross(2));
                prepStmt.setDouble(10, this.bDebtorAccount ? this.getPriceLessTax() : this.getPrice());
                prepStmt.setString(11, this.gvNum != null ? this.gvNum : this.barcode);
                prepStmt.setInt(12, this.gvNum != null ? 2 : 0);
                prepStmt.setInt(13, this.stkFlag);
                prepStmt.setDouble(14, this.gvNum != null ? 0.0 : this.getTaxPer());
                if (this.pozdidx == -1L) {
                    prepStmt.setNull(15, 4);
                } else {
                    prepStmt.setLong(15, this.pozdidx);
                }
                if (this.gvNum == null) {
                    prepStmt.setString(16, this.gvNum);
                } else {
                    int maxGvNumLength = 20;
                    if (this.gvNum.length() < maxGvNumLength) {
                        maxGvNumLength = this.gvNum.length();
                    }
                    prepStmt.setString(16, this.gvNum.substring(0, maxGvNumLength));
                }
                if (this.availableQty == -1.0) {
                    prepStmt.setNull(17, 2);
                } else {
                    prepStmt.setDouble(17, this.availableQty);
                }
                if (this.bGenPurchaseOrder && this.getDelToIdx() > 0L) {
                    prepStmt.setLong(18, this.getDelToIdx());
                } else {
                    prepStmt.setNull(18, 4);
                }
                if (this.bChangeCost && this.getCost() > 0.0) {
                    prepStmt.setDouble(19, this.getCost());
                } else {
                    prepStmt.setNull(19, 2);
                }
                prepStmt.setDate(20, this.expiryDate);
                prepStmt.setDate(21, this.expiryDate);
                prepStmt.setDouble(22, this.bDebtorAccount ? this.getOrigPriceLessTax() : this.getOrigPrice());
                prepStmt.setLong(23, this.skuPrice.getMkdMsgidx());
                prepStmt.setDouble(24, this.gvNum != null ? 0.0 : this.getExtTaxPer());
                prepStmt.setDouble(25, this.pickUpQty);
                prepStmt.setDouble(26, this.packedQty);
                if (this.pos_vshidx != -1L) {
                    prepStmt.setLong(27, this.pos_vshidx);
                } else {
                    prepStmt.setNull(27, 2);
                }
                if (this.attachedPromoIdx != 0L) {
                    prepStmt.setLong(28, this.attachedPromoIdx);
                } else {
                    prepStmt.setNull(28, 2);
                }
                if (this.priceOverrideReasonIdx.toString().equals("-1")) {
                    prepStmt.setNull(29, 4);
                } else {
                    prepStmt.setLong(29, PosUtils.longVal(this.priceOverrideReasonIdx.toString()));
                }
                prepStmt.setString(30, this.priceOverrideNotes.length() > 0 ? this.priceOverrideNotes.toString() : null);
                prepStmt.setInt(31, this.isNew() ? 0 : 1);
                prepStmt.setString(32, this.getExtendedTaxCode());
                if (this.gift == null || this.gift.getGiftId() == 0L) {
                    prepStmt.setNull(33, 4);
                } else {
                    prepStmt.setLong(33, this.gift.getGiftId());
                }
                prepStmt.setInt(34, this.getDoNotRefreshTax() ? 1 : 0);
                prepStmt.setString(35, this.getVoucherGatewayIdx());
                if (!StringUtils.isNullOrEmpty(this.getVoucherGatewayIdx())) {
                    prepStmt.setBoolean(36, this.voucherDeferred);
                    prepStmt.setDouble(37, this.voucherBalance);
                    prepStmt.setString(38, this.voucherReceiptNumber);
                    prepStmt.setString(39, this.voucherAuthCode);
                    prepStmt.setTimestamp(40, this.voucherIssueDate);
                    prepStmt.setDate(41, this.voucherExpiryDate);
                    prepStmt.setString(42, this.voucherReference);
                    prepStmt.setBoolean(43, this._isDigitalVoucher);
                    prepStmt.setString(44, this._voucherRecipientEmail);
                } else {
                    prepStmt.setNull(36, 4);
                    prepStmt.setNull(37, 2);
                    prepStmt.setNull(38, 12);
                    prepStmt.setNull(39, 12);
                    prepStmt.setNull(40, 91);
                    prepStmt.setNull(41, 91);
                    prepStmt.setNull(42, 12);
                    prepStmt.setBoolean(43, this._isDigitalVoucher);
                    prepStmt.setNull(44, 12);
                }
                if (this.returnOverrideSalesRep != null) {
                    prepStmt.setLong(45, this.returnOverrideSalesRep.getPeridx());
                } else {
                    prepStmt.setNull(45, 4);
                }
                prepStmt.setString(46, this.customisation);
                prepStmt.setLong(47, this.salesRepIdx);
                String assocString = "";
                if (this.associations != null) {
                    for (int i = 0; i < this.associations.size(); ++i) {
                        assocString = this.associations.get(i) != null ? assocString + this.associations.get(i).getAscID() + "," : assocString + ",";
                    }
                    assocString = assocString.substring(0, assocString.length() - 1);
                }
                prepStmt.setString(48, assocString);
                prepStmt.setLong(49, this.sParams.currVal("XRET_TRANH"));
                prepStmt.executeUpdate();
            }
            if (this.gvNum != null && this.gvNum.length() > 0 && StringUtils.isNullOrEmpty(this.getVoucherGatewayIdx())) {
                prepStmt = this.sParams.conn.prepareStatement("INSERT INTO GVCN_MAINT(GVCNIDX, \"TYPE\", NUM, AMT, USED_AMT, EXPIRY_DATE, ORIG_EXPIRY_DATE, ISSUE_VHIDX, ISSUED_WIDX, ISSUED_DATE, \"ACTIVE\") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, 1)");
                var5_4 = null;
                try {
                    prepStmt.setLong(1, this.sParams.nextVal("XGVCN_MAINT"));
                    prepStmt.setInt(2, 0);
                    prepStmt.setString(3, this.gvNum);
                    prepStmt.setDouble(4, this.bDebtorAccount ? this.getGrossLessTax() : this.getGross(2));
                    prepStmt.setDouble(5, 0.0);
                    prepStmt.setDate(6, this.expiryDate);
                    prepStmt.setDate(7, this.expiryDate);
                    prepStmt.setLong(8, this.sParams.currVal("XRET_TRANH"));
                    prepStmt.setLong(9, this.sParams.getStoreIdx());
                    prepStmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    var5_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (prepStmt != null) {
                        if (var5_4 != null) {
                            try {
                                prepStmt.close();
                            }
                            catch (Throwable throwable) {
                                var5_4.addSuppressed(throwable);
                            }
                        } else {
                            prepStmt.close();
                        }
                    }
                }
            }
            this.vshidx = newVshidx;
        }
    }

    protected void db_saveStkTake(long vhidx, long st_vshidx) throws SQLException {
        if (this.vshidx != -1L) {
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_STTD SET QTY = " + this.qty + " WHERE VHIDX = " + vhidx + " AND VSHIDX = " + this.vshidx);
            }
        }
        if (this.qty != 0.0) {
            String dbSkuidx = this.valid ? String.valueOf(this.skuidx) : "null";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT " + this.sParams.nextVal("XRET_STTD") + " FROM DUAL");){
                if (sql.next()) {
                    this.vshidx = sql.getLong(1);
                }
            }
            var7_9 = null;
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("INSERT INTO RET_STTD(VSHIDX, VHIDX, ST_VSHIDX, \"ACTIVE\", SKUIDX, QTY, SEQUENCE_NUMBER, LINE_CODE) SELECT " + this.vshidx + ", " + vhidx + ", " + st_vshidx + ", 1, " + dbSkuidx + ", " + this.qty + ", COALESCE(MAX(SEQUENCE_NUMBER), -1)+1, " + PosUtils.StringToSqlString(this.barcode) + " FROM RET_STTD WHERE VHIDX = " + vhidx + " AND ST_VSHIDX = " + st_vshidx);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
        }
    }

    protected void db_delLine() {
        if (this.vshidx != -1L) {
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("DELETE FROM RET_STTD WHERE VSHIDX = " + this.vshidx);
                this.vshidx = -1L;
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public double getQty() {
        return this.qty;
    }

    public Object getVal(int colIndex, int type) {
        Object val;
        block102: {
            try {
                block1 : switch (type) {
                    case 1: {
                        switch (colIndex) {
                            case 1: {
                                if (this.nonReturnable) {
                                    String rgb = String.format("rgb(%s,%s,%s)", Colours.RED.getRed(), Colours.RED.getGreen(), Colours.RED.getBlue());
                                    val = String.format("<html>%s<BR><span style=\"font-size:10px;color:%s\">%s</span></html>", this.stylecode, rgb, SP.getRS("non_returnable_msg"));
                                    break;
                                }
                                val = this.stylecode;
                                break;
                            }
                            case 2: {
                                val = this.getStyleDescDisplay();
                                if (!StringUtils.isNullOrEmpty(this.customisation)) {
                                    val = String.format("<html>%s<BR>%s</html>", StringUtils.nullToEmpty((String)val), SP.getRS("Customisation_Text", this.customisation));
                                    break;
                                }
                                break block102;
                            }
                            case 3: {
                                val = this.clrcode;
                                break;
                            }
                            case 4: {
                                val = this.size;
                                break;
                            }
                            case 5: {
                                val = this.salesRepName;
                                break;
                            }
                            case 0: {
                                String localPath = this.sParams.getPosPath().replace("\\", "/");
                                if (localPath.equals("")) {
                                    PosUtils.logError("Unable to find local path - please contact support for help");
                                }
                                if (this.bLinked) {
                                    val = String.format("<html><img width=15 height=15 src='file:///%s/%s%s'></img></html>", localPath, SP.sParams.imagepath, "Linked.png");
                                    break;
                                }
                                val = "";
                                break;
                            }
                            case 6: {
                                val = new PosDouble(this.getQty());
                                break;
                            }
                            case 9: {
                                val = new PosDouble(this.getPrice());
                                break;
                            }
                            case 8: {
                                val = new PosDouble(this.getReturnedQuantity());
                                break;
                            }
                            case 7: {
                                val = new PosDouble(this.getOriginalQuantity());
                                break;
                            }
                            case 10: {
                                val = new PosDouble(this.getExtTaxPer(), 4);
                                break;
                            }
                            case 11: {
                                val = new PosDouble(this.getTax());
                                break;
                            }
                            case 12: {
                                val = new PosDouble(this.getDisc());
                                break;
                            }
                            case 13: {
                                val = new PosDouble(this.getNet());
                                break;
                            }
                            case 14: {
                                val = this.getDelTo();
                                break;
                            }
                            case 15: {
                                val = new PosDouble(this.getCost());
                                break;
                            }
                            default: {
                                val = null;
                                break;
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (colIndex) {
                            case 1: {
                                val = this.stylecode;
                                break block1;
                            }
                            case 2: {
                                val = this.styledesc;
                                break block1;
                            }
                            case 3: {
                                val = this.clrcode;
                                break block1;
                            }
                            case 4: {
                                val = this.size;
                                break block1;
                            }
                            case 5: {
                                val = this.salesRepName;
                                break block1;
                            }
                            case 0: {
                                String localPath = this.sParams.getPosPath().replace("\\", "/");
                                if (localPath.equals("")) {
                                    PosUtils.logError("Unable to find local path - please contact support for help");
                                }
                                if (this.bLinked) {
                                    val = String.format("<html><img width=15 height=15 src='file:///%s/%s%s'></img></html>", localPath, SP.sParams.imagepath, "Linked.png");
                                    break block1;
                                }
                                val = "";
                                break block1;
                            }
                            case 6: {
                                val = new PosDouble(this.getQty());
                                break block1;
                            }
                            case 7: {
                                val = new PosDouble(this.getPrice());
                                break block1;
                            }
                            case 8: {
                                val = new PosDouble(this.getDisc());
                                break block1;
                            }
                            case 9: {
                                val = new PosDouble(this.getNet());
                                break block1;
                            }
                        }
                        val = null;
                        break;
                    }
                    case 12: {
                        switch (colIndex) {
                            case 1: {
                                if (this.nonReturnable) {
                                    String rgb = String.format("rgb(%s,%s,%s)", Colours.RED.getRed(), Colours.RED.getGreen(), Colours.RED.getBlue());
                                    val = String.format("<html>%s<BR><span style=\"font-size:10px;color:%s\">%s</span></html>", this.stylecode, rgb, SP.getRS("non_returnable_msg"));
                                    break;
                                }
                                val = this.stylecode;
                                break;
                            }
                            case 2: {
                                val = this.getStyleDescDisplay();
                                if (!StringUtils.isNullOrEmpty(this.customisation)) {
                                    val = String.format("<html>%s<BR>%s</html>", StringUtils.nullToEmpty((String)val), SP.getRS("Customisation_Text", this.customisation));
                                    break;
                                }
                                break block102;
                            }
                            case 3: {
                                val = this.clrcode;
                                break;
                            }
                            case 4: {
                                val = this.size;
                                break;
                            }
                            case 5: {
                                val = this.salesRepName;
                                break;
                            }
                            case 0: {
                                String localPath = this.sParams.getPosPath().replace("\\", "/");
                                if (localPath.equals("")) {
                                    PosUtils.logError("Unable to find local path - please contact support for help");
                                }
                                if (this.bLinked) {
                                    val = String.format("<html><img width=15 height=15 src='file:///%s/%s%s'></img></html>", localPath, SP.sParams.imagepath, "Linked.png");
                                    break;
                                }
                                val = "";
                                break;
                            }
                            case 6: {
                                if (this.qtySohAvailable && this.sParams.bUsingSOHInCustOrders && this.stkFlag == 1) {
                                    val = new PosDualValue(this.getOutstandingQty(), this.qtySoh, this.qtySoh < this.getOutstandingQty());
                                    break;
                                }
                                val = new PosDouble(this.getOutstandingQty());
                                break;
                            }
                            case 8: {
                                val = new PosDouble(this.getOutstandingPackedQty());
                                break;
                            }
                            case 9: {
                                val = new PosDouble(this.getTakenQty());
                                break;
                            }
                            case 10: {
                                val = new PosDouble(this.getPickUpQty());
                                break;
                            }
                            case 11: {
                                val = new PosDouble(this.getPrice());
                                break;
                            }
                            case 12: {
                                val = new PosDouble(this.getExtTaxPer(), 4);
                                break;
                            }
                            case 13: {
                                val = new PosDouble(this.getTax());
                                break;
                            }
                            case 14: {
                                val = new PosDouble(this.getDisc());
                                break;
                            }
                            case 15: {
                                val = new PosDouble(this.getNet());
                                break;
                            }
                            default: {
                                val = null;
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (colIndex) {
                            case 0: {
                                val = this.stylecode;
                                break block1;
                            }
                            case 1: {
                                val = this.styledesc;
                                break block1;
                            }
                            case 2: {
                                val = this.clrcode;
                                break block1;
                            }
                            case 3: {
                                val = this.size;
                                break block1;
                            }
                            case 4: {
                                if (this.qtySohAvailable && this.sParams.bUsingSOHInStockReceipts && this.stkFlag == 1) {
                                    val = new PosDualValue(this.getQty(6), this.qtySoh, this.qtySoh < this.getQty(6));
                                    break block1;
                                }
                                val = new PosDouble(this.getQty(6));
                                break block1;
                            }
                            case 5: {
                                val = new PosDouble(this.getQty(1));
                                break block1;
                            }
                            case 6: {
                                val = new PosDouble(this.getQty(3));
                                break block1;
                            }
                        }
                        val = null;
                        break;
                    }
                    case 2: {
                        switch (colIndex) {
                            case 0: {
                                val = this.stylecode;
                                break block1;
                            }
                            case 1: {
                                val = this.styledesc;
                                break block1;
                            }
                            case 2: {
                                val = this.clrcode;
                                break block1;
                            }
                            case 3: {
                                val = this.size;
                                break block1;
                            }
                            case 4: {
                                val = new PosDouble(this.getQty(6));
                                break block1;
                            }
                            case 5: {
                                val = new PosDouble(this.getQty());
                                break block1;
                            }
                        }
                        val = null;
                        break;
                    }
                    case 9: {
                        switch (colIndex) {
                            case 0: {
                                val = this.stylecode;
                                break block1;
                            }
                            case 1: {
                                val = this.styledesc;
                                break block1;
                            }
                            case 2: {
                                val = this.clrcode;
                                break block1;
                            }
                            case 3: {
                                val = this.size;
                                break block1;
                            }
                            case 4: {
                                val = new PosDouble(this.getQty());
                                break block1;
                            }
                        }
                        val = null;
                        break;
                    }
                    case 5: {
                        switch (colIndex) {
                            case 0: {
                                val = this.barcode;
                                break block1;
                            }
                            case 1: {
                                val = this.stylecode;
                                break block1;
                            }
                            case 2: {
                                val = this.styledesc;
                                break block1;
                            }
                            case 3: {
                                val = this.clrcode;
                                break block1;
                            }
                            case 4: {
                                val = this.size;
                                break block1;
                            }
                            case 5: {
                                val = new PosDouble(this.getQty());
                                break block1;
                            }
                        }
                        val = null;
                        break;
                    }
                    default: {
                        val = null;
                        break;
                    }
                }
            }
            catch (Exception e) {
                val = null;
                PosUtils.logError(e);
            }
        }
        return val;
    }

    public boolean setVal(int colIndex, Object val, int type) {
        boolean bChanged;
        block123: {
            bChanged = false;
            this.setValErrorMessage = "";
            if (val == null) {
                val = "";
            }
            try {
                switch (type) {
                    case 1: {
                        switch (colIndex) {
                            case 2: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 6: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    if (!this.canEditPromoLine()) {
                                        this.setValErrorMessage = SP.getRS("cant_modify_order_with_promo");
                                        break;
                                    }
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 9: {
                                double newPrice = 0.0;
                                try {
                                    if (val != null && !val.equals("")) {
                                        newPrice = this.sParams.rnd(this.sParams.currFormat.parse((String)val).doubleValue());
                                    }
                                    if (newPrice < 0.0 || newPrice > 9.99999999E8) {
                                        bChanged = false;
                                        break;
                                    }
                                    if (newPrice == this.getPrice()) break block123;
                                    if (this.gvNum != null && this.gvNum.length() > 0 && VoucherGatewayManager.isGatewayInUse() && VoucherGatewayManager.isGatewayReady()) {
                                        if (this.styledesc.indexOf(this.gvNum) != -1) {
                                            IVoucherGateway gateway = VoucherGatewayManager.getInstance().getGateway();
                                            if (newPrice < gateway.getMinValue() || newPrice > gateway.getMaxValue()) {
                                                this.setValErrorMessage = MessageFormat.format(SP.getRS("voucher_load_amount_invalid"), this.sParams.currFormat.format(gateway.getMinValue()), this.sParams.currFormat.format(gateway.getMaxValue()));
                                                bChanged = false;
                                                break;
                                            }
                                            this.setPrice(newPrice);
                                            bChanged = true;
                                            break;
                                        }
                                        break block123;
                                    }
                                    if (!this.promptForPriceOverrideReason()) {
                                        bChanged = false;
                                        break;
                                    }
                                    this.setPrice(newPrice);
                                    bChanged = true;
                                }
                                catch (ParseException gateway) {}
                                break;
                            }
                            case 10: {
                                double newExtTax = 0.0;
                                if (val != null && !val.equals("")) {
                                    newExtTax = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                }
                                if (newExtTax < 0.0 || newExtTax >= 100.0) {
                                    bChanged = false;
                                    break;
                                }
                                if (newExtTax != this.getExtTaxPer()) {
                                    this.setExtTaxPer(newExtTax);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 11: {
                                double newExtTaxAmt = 0.0;
                                if (val != null && !val.equals("")) {
                                    newExtTaxAmt = this.sParams.rnd(this.sParams.currFormat.parse((String)val).doubleValue());
                                }
                                if (newExtTaxAmt < 0.0) {
                                    bChanged = false;
                                    break;
                                }
                                if (newExtTaxAmt != this.getTax()) {
                                    this.setExtTaxPerFromTaxAmt(newExtTaxAmt);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 14: {
                                String newDelTo = (String)val;
                                if (!newDelTo.equals(this.sDelTo)) {
                                    if (!newDelTo.equals("")) {
                                        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT RCIDX FROM REFCODE WHERE RGIDX = 7 AND CODE = " + PosUtils.StringToSqlString(newDelTo));){
                                            if (sql.next()) {
                                                this.nDelToIdx = sql.getLong(1);
                                            }
                                            this.nDelToIdx = 0L;
                                        }
                                    } else {
                                        this.nDelToIdx = 0L;
                                    }
                                    this.sDelTo = newDelTo;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 15: {
                                double newCost = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if (newCost != this.cost) {
                                    this.cost = newCost;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (colIndex) {
                            case 2: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 6: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 7: {
                                double newPrice = 0.0;
                                if (val != null && !val.equals("")) {
                                    newPrice = this.sParams.rnd(this.sParams.currFormat.parse((String)val).doubleValue());
                                }
                                if (newPrice < 0.0 || newPrice > 9.99999999E8) {
                                    bChanged = false;
                                    break;
                                }
                                if (newPrice != this.getPrice()) {
                                    this.setPrice(newPrice);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (colIndex) {
                            case 2: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 6: {
                                double newOutstandingQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.getOutstandingQty() >= 0.0 || newOutstandingQty < 0.0) && this.getOutstandingQty() != newOutstandingQty && !(newOutstandingQty > 9999999.0) && !(newOutstandingQty < -9999999.0)) {
                                    if (!this.canEditPromoLine()) {
                                        this.setValErrorMessage = SP.getRS("cant_modify_order_with_promo");
                                        break;
                                    }
                                    double newQty = PosUtils.scale(newOutstandingQty + this.takenQty, 4);
                                    if (newOutstandingQty < this.getOutstandingPackedQty()) {
                                        this.packedQty = newQty;
                                        if (newOutstandingQty < this.getPickUpQty()) {
                                            this.pickUpQty = newOutstandingQty;
                                        }
                                    }
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 8: {
                                double newPackedQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.getOutstandingPackedQty() >= 0.0 || newPackedQty < 0.0) && this.getOutstandingPackedQty() != newPackedQty && !(newPackedQty > 9999999.0) && !(newPackedQty < -9999999.0)) {
                                    if (newPackedQty > this.getOutstandingQty()) {
                                        this.setValErrorMessage = SP.getRS("packed_needs_less_than_outstanding");
                                        break;
                                    }
                                    if (newPackedQty < this.getPickUpQty()) {
                                        this.setValErrorMessage = SP.getRS("packed_needs_greater_than_pickup");
                                        break;
                                    }
                                    this.packedQty = PosUtils.scale(newPackedQty + this.takenQty, 4);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 10: {
                                double newPickupQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.pickUpQty >= 0.0 || newPickupQty < 0.0) && this.pickUpQty != newPickupQty && !(newPickupQty > 9999999.0) && !(newPickupQty < -9999999.0)) {
                                    if (newPickupQty > this.getOutstandingPackedQty()) {
                                        this.setValErrorMessage = SP.getRS("pickup_needs_less_than_packed");
                                        break;
                                    }
                                    this.pickUpQty = newPickupQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 11: {
                                double newPrice = 0.0;
                                try {
                                    if (val != null && !val.equals("")) {
                                        newPrice = this.sParams.rnd(this.sParams.currFormat.parse((String)val).doubleValue());
                                    }
                                    if (newPrice < 0.0 || newPrice > 9.99999999E8) {
                                        bChanged = false;
                                        break;
                                    }
                                    if (newPrice != this.getPrice()) {
                                        if (!this.promptForPriceOverrideReason()) {
                                            bChanged = false;
                                            break;
                                        }
                                        this.setPrice(newPrice);
                                        bChanged = true;
                                    }
                                    break block123;
                                }
                                catch (ParseException newDelTo) {}
                                break;
                            }
                            case 12: {
                                double newExtTax = 0.0;
                                if (val != null && !val.equals("")) {
                                    newExtTax = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                }
                                if (newExtTax < 0.0 || newExtTax >= 100.0) {
                                    bChanged = false;
                                    break;
                                }
                                if (newExtTax != this.getExtTaxPer()) {
                                    this.setExtTaxPer(newExtTax);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 13: {
                                double newExtTaxAmt = 0.0;
                                if (val != null && !val.equals("")) {
                                    newExtTaxAmt = this.sParams.rnd(this.sParams.currFormat.parse((String)val).doubleValue());
                                }
                                if (newExtTaxAmt < 0.0) {
                                    bChanged = false;
                                    break;
                                }
                                if (newExtTaxAmt != this.getTax()) {
                                    this.setExtTaxPerFromTaxAmt(newExtTaxAmt);
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (colIndex) {
                            case 1: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 4: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 6: {
                                double newQty1 = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if (newQty1 != this.qty && !(newQty1 > 9999999.0) && !(newQty1 < -9999999.0)) {
                                    this.qty = newQty1;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 0: {
                                this.stylecode = String.valueOf(val);
                                break;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (colIndex) {
                            case 1: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 5: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        switch (colIndex) {
                            case 1: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 4: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (colIndex) {
                            case 2: {
                                if (!val.equals(this.styledesc)) {
                                    this.descripChanged = true;
                                    this.styledesc = (String)val;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            case 5: {
                                double newQty = PosUtils.scale(PosUtils.doubleValFormatted(val.toString()), 4);
                                if ((this.qty >= 0.0 || newQty < 0.0) && this.qty != newQty && !(newQty > 9999999.0) && !(newQty < -9999999.0)) {
                                    this.qty = newQty;
                                    bChanged = true;
                                    break;
                                }
                                break block123;
                            }
                            default: {
                                bChanged = false;
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        bChanged = false;
                    }
                }
            }
            catch (Exception e) {
                bChanged = false;
                PosUtils.logError(e);
            }
        }
        return bChanged;
    }

    public boolean promptForPriceOverrideReason() {
        if (!this.isNew() || this.stkFlag != 1 || !SP.sParams.getPromptForPriceOverrideReason()) {
            return true;
        }
        StringBuffer reasonIdx = new StringBuffer("-1");
        StringBuffer notes = new StringBuffer();
        DlgReason reason = new DlgReason(PosMenuController.getInstance().getOpenFrame(), SP.getRS("Price_Override_Reason"), true, 435L, reasonIdx, notes, true, "", 250, true, false);
        reason.setVisible(true);
        if (reasonIdx.toString().equals("-1")) {
            return false;
        }
        this.priceOverrideReasonIdx = reasonIdx;
        this.priceOverrideNotes = notes;
        return true;
    }

    public void setReqQty(double preqQty) {
        this.reqQty = PosUtils.scale(preqQty, 4);
    }

    public double getReqQty() {
        return this.reqQty;
    }

    public void setQty(double pqty) {
        this.lastQty = this.qty;
        this.qty = PosUtils.scale(pqty, 4);
    }

    public void setCost(double pCost) {
        this.cost = this.sParams.storeCurrency.round(pCost);
    }

    public double getCost() {
        return this.cost;
    }

    public void setDelTo(String psDelTo) {
        this.sDelTo = psDelTo;
    }

    public String getDelTo() {
        return this.sDelTo;
    }

    public void setDelToIdx(long pnDelToIdx) {
        this.nDelToIdx = pnDelToIdx;
    }

    public long getDelToIdx() {
        return this.nDelToIdx;
    }

    public void setQty(int qtyType, double pqty) {
        pqty = PosUtils.scale(pqty, 4);
        switch (qtyType) {
            case 2: {
                this.lastQty = this.qty;
                this.qty = pqty;
                break;
            }
            case 1: {
                this.origQty = pqty;
                break;
            }
            case 4: {
                this.lastQty = pqty;
                break;
            }
            case 5: {
                if (this.availableQty == pqty) break;
                this.availQtyChanged = true;
                this.availableQty = pqty;
                break;
            }
            case 6: {
                this.reqQty = pqty;
                break;
            }
            case 10: {
                this.qtyAdjustedTo = pqty;
                this.adjustedQtySet = true;
                break;
            }
            default: {
                this.setQty(2, pqty);
            }
        }
    }

    public void initOrigQtys() {
        this.origQty = this.qty;
        this.origPackedQty = this.packedQty;
    }

    public void setOrigQty(double pqty) {
        this.origQty = PosUtils.scale(pqty, 4);
    }

    public double getBackedUpQtyBeforeSave() {
        return this.backedUpQtyBeforeSave;
    }

    public void setPrice(double pprice) {
        this.skuPrice.setPrice(this.sParams.storeCurrency.round(pprice));
    }

    public void setOrigPrice(double pprice) {
        this.skuPrice.setOrigPrice(this.sParams.storeCurrency.round(pprice));
    }

    public void setTaxPer(double pTax) {
        this.taxper = pTax;
    }

    public void setExtTaxPer(double pExtTax) {
        this.extendedTaxRate = pExtTax;
    }

    public void setExtTaxPerFromTaxAmt(double taxAmount) {
        double nNetExTax = this.sParams.rnd(this.qty * this.getPrice() - this.getDisc());
        if (nNetExTax != 0.0) {
            this.setExtTaxPer(Math.abs(taxAmount / nNetExTax * 100.0));
        }
    }

    public void fetchExtendedTaxCode(long styleidx) {
        block45: {
            this.extendedTaxCode = "";
            if (!this.sParams.bUsingExtendedTax) {
                return;
            }
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT TAX_CODE FROM EXTENDED_TAX_BY_PRODUCT WHERE STYLEIDX = " + styleidx);){
                if (sql.next() && !StringUtils.nullToEmpty(sql.getString(1)).isEmpty()) {
                    this.extendedTaxCode = sql.getString(1);
                    break block45;
                }
                long rgidx = PosUtils.longVal(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.USE_EXTENDED_TAX));
                if (rgidx == 0L) {
                    return;
                }
                try (SqlQuery sql2 = new SqlQuery(this.sParams.conn, "SELECT RG_ORD FROM REFTBL WHERE TBLIDX = 99 AND RGIDX = " + rgidx);){
                    if (!sql2.next()) break block45;
                    String refNum = sql2.getString(1);
                    try (SqlQuery sql3 = new SqlQuery(this.sParams.conn, "SELECT T.TAX_CODE FROM EXTENDED_TAX_BY_REFERENCE T, STYLE S WHERE S.STYLEIDX = " + styleidx + " AND S.REF" + refNum + " = T.RCIDX");){
                        if (sql3.next()) {
                            this.extendedTaxCode = sql3.getString(1);
                        }
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void setPozdidx(long pPozdidx) {
        this.pozdidx = pPozdidx;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public boolean getGenTransferOrder() {
        return this.bGenTransferOrder;
    }

    public boolean getGenPurchaseOrder() {
        return this.bGenPurchaseOrder;
    }

    public boolean getGenProduct() {
        return this.bGenProduct;
    }

    public boolean getChangeCost() {
        return this.bChangeCost;
    }

    public void setGenTransferOrder(boolean b) {
        this.bGenTransferOrder = b;
    }

    public void setGenPurchaseOrder(boolean b) {
        this.bGenPurchaseOrder = b;
    }

    public void setGenProduct(boolean b) {
        this.bGenProduct = b;
    }

    public void setChangeCost(boolean b) {
        this.bChangeCost = b;
    }

    public boolean isNew() {
        return this.newStyle;
    }

    public void setNew(boolean pnew) {
        this.newStyle = pnew;
    }

    public void setNonReturnable(boolean nonReturnable) {
        this.nonReturnable = nonReturnable;
    }

    public void removeTax() {
        if (!this.bDoNotRefreshTax) {
            double currPriceWithoutTax = this.getPriceLessTax();
            double origPriceWithoutTax = this.getOrigPriceLessTax();
            this.setPrice(currPriceWithoutTax);
            this.setTaxPer(0.0);
            this.setOrigPrice(origPriceWithoutTax);
        }
        this.bDoNotRefreshTax = true;
    }

    public boolean getDoNotRefreshTax() {
        return this.bDoNotRefreshTax;
    }

    public void setDoNotRefreshTax(boolean bDoNotRefreshTax) {
        this.bDoNotRefreshTax = bDoNotRefreshTax;
    }

    public boolean isValid() {
        return this.valid;
    }

    public double getNet() {
        if (this.sParams.bUsingExtendedTax) {
            double nNetExTax = this.sParams.rnd(this.qty * this.getPrice() - this.getDisc());
            return this.sParams.rnd(nNetExTax + nNetExTax * this.getExtTaxPer() / 100.0);
        }
        return this.sParams.rnd(this.qty * this.getPrice()) - this.getDisc();
    }

    public double getNetForBackedUpQty() {
        if (this.sParams.bUsingExtendedTax) {
            double nNetExTax = this.sParams.rnd(this.getBackedUpQtyBeforeSave() * this.getPrice() - this.getDisc());
            return this.sParams.rnd(nNetExTax + nNetExTax * this.getExtTaxPer() / 100.0);
        }
        return this.sParams.rnd(this.getBackedUpQtyBeforeSave() * this.getPrice()) - this.getDisc();
    }

    public double getPickupNet() {
        if (this.sParams.bUsingExtendedTax) {
            double nNetExTax = this.sParams.rnd(this.pickUpQty * this.getPrice() - this.getPickupDisc());
            return this.sParams.rnd(nNetExTax + nNetExTax * this.getExtTaxPer() / 100.0);
        }
        return this.sParams.rnd(this.pickUpQty * this.getPrice()) - this.getPickupDisc();
    }

    public double getTakenNet() {
        if (this.sParams.bUsingExtendedTax) {
            double nNetExTax = this.sParams.rnd(this.takenQty * this.getPrice() - this.getTakenDisc());
            return this.sParams.rnd(nNetExTax + nNetExTax * this.getExtTaxPer() / 100.0);
        }
        return this.sParams.rnd(this.takenQty * this.getPrice()) - this.getTakenDisc();
    }

    public double getGross(int qtyType) {
        return this.sParams.rnd(this.getQty(qtyType) * this.getPrice());
    }

    public double getGrossLessTax() {
        return this.sParams.rnd(this.qty * this.getPriceLessTax());
    }

    public double getTax() {
        return this.sParams.rnd(this.getNet() / ((this.getTaxPer() + this.getExtTaxPer()) / 100.0 + 1.0) * ((this.getTaxPer() + this.getExtTaxPer()) / 100.0));
    }

    public double getTaxfForOldLayBy() {
        return this.sParams.rnd(this.getNetForBackedUpQty() / ((this.getTaxPer() + this.getExtTaxPer()) / 100.0 + 1.0) * ((this.getTaxPer() + this.getExtTaxPer()) / 100.0));
    }

    public double getTaxPer() {
        if (this.sParams.bUsingExtendedTax) {
            return 0.0;
        }
        return this.taxper;
    }

    public double getExtTaxPer() {
        if (this.sParams.bUsingExtendedTax) {
            return this.extendedTaxRate;
        }
        return 0.0;
    }

    public String getExtendedTaxCode() {
        return this.extendedTaxCode;
    }

    public double getPrice() {
        return this.skuPrice.getPrice();
    }

    public double getOrigPrice() {
        return this.skuPrice.getOrigPrice();
    }

    public boolean hasMarkdown() {
        return this.skuPrice.getOrigPrice() > this.skuPrice.getPriceBeforeAnyOverride();
    }

    public double getPriceBeforeUserChange() {
        if (!this.bPriceChangedByUser) {
            this.priceBeforeUserChange = this.getPrice();
            this.bPriceChangedByUser = true;
        }
        return this.priceBeforeUserChange;
    }

    public double getPriceLessTax() {
        return this.sParams.rnd(this.getPrice() / (1.0 + this.getTaxPer() / 100.0));
    }

    public double getOrigPriceLessTax() {
        return this.sParams.rnd(this.getOrigPrice() / (1.0 + this.getTaxPer() / 100.0));
    }

    public double getDisc() {
        double totdisc = 0.0;
        for (int i = 0; i < this.discLines.size(); ++i) {
            totdisc += this.discLines.elementAt(i).getNet();
        }
        return totdisc;
    }

    public double getPickupDisc() {
        double totdisc = 0.0;
        double disc = 0.0;
        double discPerQty = 0.0;
        for (int i = 0; i < this.discLines.size(); ++i) {
            disc = this.discLines.elementAt(i).getNet();
            discPerQty = this.qty != 0.0 ? disc / this.qty : 0.0;
            totdisc += discPerQty * this.pickUpQty;
        }
        return this.sParams.rnd(totdisc);
    }

    public double getTakenDisc() {
        double totdisc = 0.0;
        double disc = 0.0;
        double discPerQty = 0.0;
        for (int i = 0; i < this.discLines.size(); ++i) {
            disc = this.discLines.elementAt(i).getNet();
            discPerQty = this.qty != 0.0 ? disc / this.qty : 0.0;
            totdisc += discPerQty * this.takenQty;
        }
        return this.sParams.rnd(totdisc);
    }

    public int getNumDiscs() {
        return this.discLines.size();
    }

    public boolean hasNonLoyaltyDisc() {
        return this.discLines.size() > 0 && !this.discLines.elementAt(0).isLoyalty();
    }

    public double getQty(int qtyType) {
        switch (qtyType) {
            case 2: {
                return this.qty;
            }
            case 3: {
                return this.qty - this.origQty;
            }
            case 1: {
                return this.origQty;
            }
            case 4: {
                return this.lastQty;
            }
            case 5: {
                return this.availableQty;
            }
            case 6: {
                return this.reqQty;
            }
            case 8: {
                return this.packedQty;
            }
            case 9: {
                return this.packedQty - this.origPackedQty;
            }
            case 7: {
                return this.origPackedQty;
            }
            case 10: {
                return this.qtyAdjustedTo;
            }
        }
        return this.qty;
    }

    public double getNetBeforePromotion(int qtyType, MultiLineDisc currentPromotion) {
        double nReturn = this.getGross(qtyType);
        boolean addPromotions = currentPromotion != null && currentPromotion.isPromotion();
        for (int i = 0; i < this.discLines.size(); ++i) {
            DiscLine disc = this.discLines.elementAt(i);
            if (addPromotions && disc.getDiscParent() == currentPromotion) {
                addPromotions = false;
            }
            if (disc.isManualDiscount() && !disc.isPromVoucher()) {
                nReturn -= this.sParams.rnd(disc.getDiscParent().getCurrDiscPer() * this.getGross(qtyType));
                continue;
            }
            if (!addPromotions || !disc.isPromotion()) continue;
            nReturn -= this.sParams.rnd(disc.getDiscParent().getCurrDiscPer() * nReturn);
        }
        return this.sParams.rnd(nReturn);
    }

    public double getNetBeforeLoyalty(int qtyType) {
        double nReturn = this.getNetBeforePromotion(qtyType, null);
        for (int i = 0; i < this.discLines.size(); ++i) {
            if (!this.discLines.elementAt(i).isPromotion()) continue;
            nReturn -= this.sParams.rnd(this.discLines.elementAt(i).getDiscParent().getCurrDiscPer() * nReturn);
        }
        return this.sParams.rnd(nReturn);
    }

    public boolean addDisc(DiscLine pDisc) {
        if (pDisc.isManualDiscount() && pDisc.isNew()) {
            if (this.discLines.size() > 0 && this.discLines.elementAt(0).isManualDiscount()) {
                return false;
            }
            this.discLines.add(0, pDisc);
        } else {
            this.discLines.add(pDisc);
        }
        return true;
    }

    public boolean allowDisc() {
        return this.discLines.size() <= 0 || !this.discLines.elementAt(0).isManualDiscount();
    }

    public boolean removeDisc(DiscLine disc) {
        return this.discLines.remove(disc);
    }

    public void setVoucher(String gvNum, Date expiryDate, String gatewayIdx, boolean isDigital, String recEmail) {
        if (expiryDate != null) {
            PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(expiryDate.getTime()));
            dateFormatter.setFormat(3, 0);
            Object[] objs = new Object[]{gvNum, dateFormatter.toString()};
            this.styledesc = VoucherUtils.getCreditNoteGiftVoucherSKU() != null && VoucherUtils.getCreditNoteGiftVoucherSKU().equals(String.valueOf(this.skuidx)) ? MessageFormat.format(StoreParams.res.getString("refund_GV_Num_Exp"), objs) : MessageFormat.format(StoreParams.res.getString("GV_Num_Exp"), objs);
        } else {
            Object[] objs = new Object[]{gvNum};
            this.styledesc = isDigital ? MessageFormat.format(SP.getRS("Dig_GV_Num"), this.voucherReceiptNumber.length() > 0 ? this.voucherReceiptNumber : gvNum) : MessageFormat.format(StoreParams.res.getString("GV_Num"), objs);
        }
        this.descripChanged = true;
        this._isDigitalVoucher = isDigital;
        this._voucherRecipientEmail = recEmail;
        this.gvNum = gvNum;
        this.expiryDate = expiryDate;
        this.voucherGatewayIdx = !StringUtils.isNullOrEmpty(gatewayIdx) ? gatewayIdx : null;
    }

    public void setDigitalVoucherDetails(String firstname, String surname, String email, String message) {
        this._isDigitalVoucher = true;
        this._voucherRecipientName = firstname;
        this._voucherRecipientSurname = surname;
        this._voucherRecipientEmail = email;
        this._message = message;
    }

    public String GetVoucherRecipientName() {
        return this._voucherRecipientName;
    }

    public String GetVoucherRecipientSurname() {
        return this._voucherRecipientSurname;
    }

    public String GetVoucherRecipientEmail() {
        return this._voucherRecipientEmail;
    }

    public boolean IsDigitalVoucher() {
        return this._isDigitalVoucher;
    }

    public boolean IsRefundVoucher() {
        return this._isRefundVoucher;
    }

    public void setIsRefundVoucher(boolean isRefund) {
        this._isRefundVoucher = isRefund;
    }

    public String GetMessage() {
        return this._message;
    }

    public void SetMessage(String value) {
        this._message = value;
    }

    public void setNewGatewayVoucherNum(String voucherNumber) throws SQLException {
        this.styledesc = this._isDigitalVoucher ? MessageFormat.format(SP.getRS("Dig_GV_Num"), this.voucherReceiptNumber.length() == 0 ? this._voucherRecipientEmail : this.voucherReceiptNumber) : MessageFormat.format(SP.getRS("GV_Num"), voucherNumber);
        this.gvNum = voucherNumber;
        this.descripChanged = true;
        this.expiryDate = null;
        this.voucherGatewayIdx = String.valueOf(VoucherGatewayManager.getInstance().getGatewayRcidx());
        if (this.vshidx != -1L) {
            SqlQuery.executeUpdate(this.sParams.conn, "UPDATE RET_TRAND SET DESCRIP1 = ?, LINE_CODE = ?, GVNUM = ?, GVGATE_ISDIGITAL = ?, GVGATE_REC_EMAIL = ? WHERE VSHIDX = ?", this.styledesc, this.gvNum, this.gvNum, this._isDigitalVoucher, this._voucherRecipientEmail, this.vshidx);
        }
    }

    public void setGatewayVoucherLoadDetails(GatewayVoucher voucher) throws SQLException {
        if (voucher != null) {
            this.voucherDeferred = voucher.isDeferred();
            this.voucherBalance = voucher.getAvailableAmount();
            this.voucherReceiptNumber = voucher.getReceiptNumber();
            this.voucherAuthCode = voucher.getAuthCode();
            this.voucherIssueDate = voucher.getIssuedDate();
            this.voucherExpiryDate = voucher.getExpiryDate();
            this.expiryDate = this.voucherExpiryDate != null ? new Date(this.voucherExpiryDate.getTime()) : null;
            this.voucherReference = voucher.getReference();
            if (this._isDigitalVoucher && !this.voucherDeferred) {
                this.setNewGatewayVoucherNum(this.voucherReceiptNumber);
            }
        } else {
            this.voucherDeferred = false;
            this.voucherBalance = 0.0;
            this.voucherReceiptNumber = null;
            this.voucherAuthCode = null;
            this.voucherIssueDate = null;
            this.voucherExpiryDate = null;
            this.expiryDate = null;
            this.voucherReference = null;
        }
        if (this.vshidx != -1L) {
            SqlQuery.executeUpdate(this.sParams.conn, "UPDATE RET_TRAND SET GVGATE_DEFERRED_FLAG = ?, GVGATE_BALANCE = ?, GVGATE_RECEIPT_NUM = ?, GVGATE_AUTHCODE = ?, GVGATE_ISSUE_DATE = ?, GVGATE_EXPIRY_DATE = ?, ORIG_EXPIRY_DATE = ?, EXPIRY_DATE = ?, GVGATE_REFERENCE = ?, GVGATE_ISDIGITAL = ?, GVGATE_REC_EMAIL = ? WHERE VSHIDX = ?", this.voucherDeferred, this.voucherBalance, this.voucherReceiptNumber, this.voucherAuthCode, this.voucherIssueDate, this.voucherExpiryDate, this.expiryDate, this.expiryDate, this.voucherReference, this._isDigitalVoucher, this._voucherRecipientEmail, this.vshidx);
        }
    }

    public void setAdjustment() {
        this.setQty(10, this.getQty());
        this.setQty(this.getQty(3));
        this.setPackedQty(this.getQty(9));
    }

    public void setUseDiscountAdjustmentFlag(boolean useDiscAdjustment) {
        this.useDiscAdjustment = useDiscAdjustment;
    }

    public void setLoadFromHOFlag(boolean useLoadedHO) {
        this.useLoadedHO = useLoadedHO;
    }

    public boolean adjustDiscountNet() {
        return this.useDiscAdjustment && this.adjustedQtySet;
    }

    public boolean getUseLoadedHO() {
        return this.useLoadedHO;
    }

    public void setTransferRequest(boolean b) {
        this.bIsTransferRequest = b;
    }

    public boolean isTransferRequest() {
        return this.bIsTransferRequest;
    }

    private void setSpecialOrderFlags(long nStyleIdx) {
        if (this.sParams.bUsingSpecialOrders && this.sParams.specialOrdersRef != null && !this.sParams.specialOrdersRef.equals("")) {
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT M.GEN_PO_FLAG, M.GEN_NEWSTYLE_FLAG, M.MAINTAIN_COST_FLAG, M.GEN_TRANSFER_FLAG FROM STYLE S, MTM_RULES M WHERE S." + this.sParams.specialOrdersRef + " =  M.RCIDX AND S.STYLEIDX = " + nStyleIdx);){
                if (sql.next()) {
                    if (sql.getInt(1) == 1) {
                        this.setGenPurchaseOrder(true);
                        if (this.getDelToIdx() == 0L) {
                            this.setDelTo(this.sParams.getStore().getCode());
                            this.setDelToIdx(this.sParams.getStoreIdx());
                        }
                    }
                    if (sql.getInt(2) == 1) {
                        this.setGenProduct(true);
                    }
                    if (sql.getInt(3) == 1) {
                        this.setChangeCost(true);
                    }
                    if (sql.getInt(4) == 1) {
                        this.setGenTransferOrder(true);
                    }
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    public boolean isAvailQtyChanged() {
        return this.availQtyChanged;
    }

    public void setAvailQtyChanged(boolean availQtyChanged) {
        this.availQtyChanged = availQtyChanged;
    }

    public Vector<Note> getNotes() {
        return this.notes;
    }

    public boolean isRecallProd() {
        return this.recallProd;
    }

    public long getRecalLogIdx() {
        return this.recalLogIdx;
    }

    public Vector<DiscLine> getDiscLines() {
        return this.discLines;
    }

    public String getGvNum() {
        return this.gvNum;
    }

    public String getVoucherGatewayIdx() {
        return this.voucherGatewayIdx;
    }

    public long getSkuidx() {
        return this.skuidx;
    }

    public long getStyleidx() {
        return this.styleidx;
    }

    public long getClridx() {
        return this.clridx;
    }

    public SkuPrice getSkuPrice() {
        return this.skuPrice;
    }

    public int getStkFlag() {
        return this.stkFlag;
    }

    public long getVshidx() {
        return this.vshidx;
    }

    public boolean isDescripChanged() {
        return this.descripChanged;
    }

    public void changeStyleDescription(String newDescription) {
        this.styledesc = newDescription;
        this.descripChanged = true;
    }

    public void setVshidx(long vshidx) {
        this.vshidx = vshidx;
    }

    public void setPosVshidx(long pos_vshidx) {
        this.pos_vshidx = pos_vshidx;
    }

    public long getPosVshidx() {
        return this.pos_vshidx;
    }

    public double getPickUpQty() {
        return this.pickUpQty;
    }

    public void setPickUpQty(double pickUpQty) {
        this.pickUpQty = PosUtils.scale(pickUpQty, 4);
    }

    public double getPackedQty() {
        return this.packedQty;
    }

    public void setPackedQty(double packedQty) {
        this.packedQty = PosUtils.scale(packedQty, 4);
    }

    public double getTakenQty() {
        return this.takenQty;
    }

    public void setTakenQty(double takenQty) {
        this.takenQty = PosUtils.scale(takenQty, 4);
    }

    public double getOutstandingQty() {
        return this.qty - this.takenQty;
    }

    public double getOutstandingPackedQty() {
        return this.packedQty - this.takenQty;
    }

    public String getSetValErrorMessage() {
        return this.setValErrorMessage;
    }

    public void setQtySoh(double value) {
        this.qtySoh = value;
        this.qtySohAvailable = true;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double value) {
        this.weight = value;
    }

    public void setSplitFromStyleLine(StyleLine styleLine) {
        this.splitFromStyleLine = styleLine;
        if (styleLine != null && styleLine.qtySohAvailable) {
            this.setQtySoh(styleLine.qtySoh);
        }
    }

    public StyleLine getSplitFromStyleLine() {
        return this.splitFromStyleLine;
    }

    public long getAttachedPromoIdx() {
        return this.attachedPromoIdx;
    }

    public void setAttachedPromoIdx(long attachedPromoIdx) {
        this.attachedPromoIdx = attachedPromoIdx;
    }

    public boolean canEditPromoLine() {
        return this.isNew() || this.getAttachedPromoIdx() <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeActionDetailLog(long logidx) {
        PreparedStatement stmt = null;
        try {
            stmt = SP.sParams.conn.prepareStatement("INSERT INTO STYLE_DETAILS_ACTION_LOG (DETAIL_LOGIDX, LOGIDX, SKUIDX, DESCRIPTION, QTY, PRICE, TAX_PERCENT, DISCOUNT, NET) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setLong(1, SP.sParams.nextVal("XSTYLE_DETAILS_ACTION_LOG"));
            stmt.setLong(2, logidx);
            stmt.setLong(3, this.getSkuidx());
            stmt.setString(4, this.styledesc);
            stmt.setDouble(5, this.getQty());
            stmt.setDouble(6, this.getPrice());
            stmt.setDouble(7, this.sParams.bUsingExtendedTax ? this.getExtTaxPer() : this.getTaxPer());
            stmt.setDouble(8, this.getDisc());
            stmt.setDouble(9, this.getNet());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                PosUtils.logError(e);
            }
            catch (Throwable throwable) {
                PosUtils.closeStatement(stmt);
                throw throwable;
            }
            PosUtils.closeStatement(stmt);
        }
        PosUtils.closeStatement(stmt);
    }

    public String getSkuCode() {
        return String.format("%s.%s.%s", StringUtils.nullToEmpty(this.stylecode), StringUtils.nullToEmpty(this.clrcode), StringUtils.nullToEmpty(this.size));
    }

    public String getSkuDescription() {
        if (!StringUtils.isNullOrEmpty(this.customisation)) {
            return String.format("%s %s\n%s", StringUtils.nullToEmpty(this.styledesc), StringUtils.nullToEmpty(this.size), SP.getRS("Customisation_Text", this.customisation));
        }
        return String.format("%s %s", StringUtils.nullToEmpty(this.styledesc), StringUtils.nullToEmpty(this.size));
    }

    public String getLongSkuDescription() {
        String description = String.format("%s %s %s", StringUtils.nullToEmpty(this.stylecode), StringUtils.nullToEmpty(this.styledesc), StringUtils.nullToEmpty(this.size));
        if (!StringUtils.isNullOrEmpty(this.customisation)) {
            return String.format("<html>%s<BR>%s</html>", StringUtils.nullToEmpty(description), SP.getRS("Customisation_Text", this.customisation));
        }
        return description;
    }

    public String getFullSkuDescription() {
        return String.format("%s %s %s %s %s", StringUtils.nullToEmpty(this.stylecode), StringUtils.nullToEmpty(this.styledesc), StringUtils.nullToEmpty(this.clrcode), StringUtils.nullToEmpty(this.clrdesc), StringUtils.nullToEmpty(this.size));
    }

    public boolean requiresTaxLookup() {
        return this.isNew() || this.qty < 0.0;
    }

    public String getTaxOverrideReason() {
        if (!this.isNew() && this.qty < 0.0) {
            return SP.getRS("Return");
        }
        return "";
    }

    public void backupQtyBeforeSave() {
        this.backedUpQtyBeforeSave = this.qty;
    }

    public Gift getGift() {
        return this.gift;
    }

    public void setGift(Gift gift) {
        this.gift = gift;
    }

    public boolean isGiftOnly() {
        return this.giftOnly;
    }

    public long getSozdidx() {
        return this.sozdidx;
    }

    public void setSozdidx(long sozdidx) {
        this.sozdidx = sozdidx;
    }

    public String getPickSlipRun() {
        return this.pickSlipRun;
    }

    public void setPickSlipRun(String pickSlipRun) {
        this.pickSlipRun = pickSlipRun;
    }

    public SalesRep getReturnOverrideSalesRep() {
        return this.returnOverrideSalesRep;
    }

    public void setReturnOverrideSalesRep(SalesRep returnOverrideSalesRep) {
        this.returnOverrideSalesRep = returnOverrideSalesRep;
    }

    public void setCustomisation(String customisation) {
        this.customisation = customisation;
    }

    public String getCustomisation() {
        return this.customisation;
    }

    public void addReturnData(String data) {
        this.overReturns.add(data);
    }

    public Vector<String> getReturnData() {
        return this.overReturns;
    }

    public void setLinked(boolean bLinking) {
        this.bLinked = bLinking;
    }

    public Boolean getLinked() {
        return this.bLinked;
    }

    public void setSalesRep(long sRepIdx, String salesRepName) {
        this.salesRepIdx = sRepIdx;
        this.salesRepName = salesRepName;
    }

    public String getSalesRepName() {
        return this.salesRepName;
    }

    public long getSalesRepIdx() {
        return this.salesRepIdx;
    }

    public Vector<Association> getAssociations() {
        return this.associations;
    }

    public void setAssociations(Vector<Association> associations) {
        this.associations = associations;
    }
}

