/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.cache;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import jpos.basscom.utils.Utils;

public class CacheProvider
implements Serializable {
    private Hashtable<String, String> cacheMap = new Hashtable();
    private Hashtable<String, Hashtable<String, Hashtable<String, String>>> cacheMapAttributes = new Hashtable();
    private String memidx;
    private String sParFrom;
    private String sParWhere;
    private String curWhere;
    private String curFrom;
    private String curAlias;
    private StringBuffer sbSql = new StringBuffer("");
    private Connection con;

    public CacheProvider(long memidx, Connection con) {
        this.con = con;
        this.memidx = memidx + "";
    }

    public String getCacheSql(long cacheidx, String mandTable, String fromTable, String where) throws Exception {
        this.loadCacheSql(cacheidx, mandTable, fromTable, where);
        this.sbSql.setLength(0);
        if (this.con.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") >= 0) {
            this.sbSql.append("SELECT /*+ FIRST_ROWS */ ");
        } else {
            this.sbSql.append("SELECT ");
        }
        this.sbSql.append(this.cacheMap.get(cacheidx + "select"));
        this.sbSql.append(" FROM ");
        this.sbSql.append(this.cacheMap.get(cacheidx + "finfrom"));
        this.sbSql.append(this.cacheMap.get(cacheidx + "finwhere"));
        return this.sbSql.toString();
    }

    public String getCacheSelect(long cacheidx, String mandTable, String fromTable, String where) throws Exception {
        this.loadCacheSql(cacheidx, mandTable, fromTable, where);
        return this.cacheMap.get(cacheidx + "select");
    }

    public String getCacheFrom(long cacheidx, String mandTable, String fromTable, String where) throws Exception {
        this.loadCacheSql(cacheidx, mandTable, fromTable, where);
        return this.cacheMap.get(cacheidx + "finfrom");
    }

    public String getCacheWhere(long cacheidx, String mandTable, String fromTable, String where) throws Exception {
        this.loadCacheSql(cacheidx, mandTable, fromTable, where);
        return this.cacheMap.get(cacheidx + "finwhere");
    }

    public void loadCacheSql(long cacheidx, String mandTable, String fromTable, String where) throws Exception {
        if (!this.cacheMap.containsKey(cacheidx + "cacheint")) {
            try {
                this.setCache(cacheidx);
            }
            catch (SQLException e) {
                Utils.logError(e);
            }
        }
        if (!this.nvl(this.cacheMap.get(cacheidx + "mandtable")).equals(this.nvl(mandTable))) {
            this.setMand(cacheidx, mandTable);
        }
        if (!this.nvl(this.cacheMap.get(cacheidx + "extrafrom")).equals(this.nvl(fromTable))) {
            this.setFrom(cacheidx, fromTable);
        }
        if (!this.nvl(this.cacheMap.get(cacheidx + "extrawhere")).equals(this.nvl(where))) {
            this.setWhere(cacheidx, where);
        }
    }

    public boolean getColAttribs(long cacheidx, Hashtable<String, Hashtable<String, String>> colHash) {
        Hashtable<String, Hashtable<String, String>> ca = this.cacheMapAttributes.get(cacheidx + "");
        if (ca == null) {
            return false;
        }
        int co = ca.size();
        for (int c = 1; c <= co; ++c) {
            Hashtable<String, String> colsVec = ca.get(c + "");
            Hashtable<String, String> newVec = new Hashtable<String, String>();
            Enumeration<String> e = colsVec.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                newVec.put(key, colsVec.get(key));
            }
            colHash.put(c + "", newVec);
        }
        return true;
    }

    public int getColCount(long cacheidx) {
        if (!this.cacheMap.containsKey(cacheidx + "cacheint")) {
            return -1;
        }
        return Integer.parseInt(this.cacheMap.get(cacheidx + "colCount"));
    }

    public String getCacheName(long cacheidx) {
        if (!this.cacheMap.containsKey(cacheidx + "cacheint")) {
            return null;
        }
        return this.cacheMap.get(cacheidx + "cachename");
    }

    public String getColWidth(String colName, long cacheidx) {
        return this.getColAttribute("COLWIDTH", colName, cacheidx);
    }

    public String getColAlign(String colName, long cacheidx) {
        return this.getColAttribute("COLALIGN", colName, cacheidx);
    }

    public String getColTitle(String colName, long cacheidx) {
        return this.getColAttribute("COLTITLE", colName, cacheidx);
    }

    public String getColName(long colNum, long cacheidx) {
        return this.getColAttribute("COLNAME", colNum, cacheidx);
    }

    public String getColWidth(long colNum, long cacheidx) {
        return this.getColAttribute("COLWIDTH", colNum, cacheidx);
    }

    public String getColAlign(long colNum, long cacheidx) {
        return this.getColAttribute("COLALIGN", colNum, cacheidx);
    }

    public String getColTitle(long colNum, long cacheidx) {
        return this.getColAttribute("COLTITLE", colNum, cacheidx);
    }

    public String getUniqueidxName(long cacheidx) {
        return this.cacheMap.get(cacheidx + "uniqueidx");
    }

    public String getColAttribute(String AttribName, String colName, long cacheidx) {
        Hashtable<String, Hashtable<String, String>> cacheAttribs = this.cacheMapAttributes.get(cacheidx + "");
        int colNum = 0;
        int cols = Integer.parseInt(this.cacheMap.get(cacheidx + "colCount"));
        int wCol = 1;
        while (wCol <= cols & cacheAttribs.containsKey(wCol + "")) {
            Hashtable<String, String> hTemp = cacheAttribs.get(wCol + "");
            if (hTemp.get("COLNAME").equals(colName)) {
                colNum = wCol;
                break;
            }
            ++wCol;
        }
        if (colNum == 0) {
            return null;
        }
        return this.actualGetColAttribute(AttribName, colNum, cacheidx, cacheAttribs);
    }

    public String getColAttribute(String AttribName, long colNum, long cacheidx) {
        if (colNum == 0L) {
            return null;
        }
        return this.actualGetColAttribute(AttribName, colNum, cacheidx, this.cacheMapAttributes.get(cacheidx + ""));
    }

    public void overwriteCache(long cacheidx, String from, String where) {
        try {
            this.loadCacheSql(cacheidx, "", "", "");
            this.cacheMap.put(cacheidx + "finfrom", from);
            this.cacheMap.put(cacheidx + "curfrom", from);
            this.cacheMap.put(cacheidx + "finwhere", where);
            this.cacheMap.put(cacheidx + "curwhere", where);
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void setFrom(long cacheidx, String fromTable) {
        this.sParFrom = fromTable.trim();
        this.curFrom = this.cacheMap.get(cacheidx + "curfrom");
        if (!this.sParFrom.equals("")) {
            this.curFrom = this.sParFrom.substring(0, 1).equals(",") ? this.curFrom + " " + this.sParFrom : this.curFrom + "," + this.sParFrom;
        }
        this.cacheMap.put(cacheidx + "finfrom", this.curFrom);
        this.cacheMap.put(cacheidx + "extrafrom", fromTable);
    }

    private void setWhere(long cacheidx, String where) {
        this.sParWhere = where.trim();
        this.curWhere = this.cacheMap.get(cacheidx + "curwhere");
        if (!this.sParWhere.equals("")) {
            if (this.curWhere.equals("")) {
                this.curWhere = " WHERE 1 = 1 ";
            }
            this.curWhere = this.sParWhere.substring(0, 3).equals("AND") ? this.curWhere + " " + this.sParWhere : this.curWhere + " AND " + this.sParWhere;
        }
        this.cacheMap.put(cacheidx + "finwhere", this.curWhere);
        this.cacheMap.put(cacheidx + "extrawhere", where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMand(long cacheidx, String mandTable) {
        this.curAlias = this.cacheMap.get(cacheidx + "queryalias");
        this.curFrom = this.cacheMap.get(cacheidx + "basefrom");
        this.curWhere = this.cacheMap.get(cacheidx + "basewhere");
        if (!mandTable.equals("")) {
            Statement stmt = null;
            try {
                stmt = this.con.createStatement();
                ResultSet result = null;
                try {
                    result = stmt.executeQuery("SELECT T.TBLALIAS, T.TBLNAME || ' ' || T.TBLALIAS as TABCOL, T.TBLJOIN FROM CACHE_TBL T WHERE T.CTBLIDX IN (" + mandTable + " ) ORDER BY T.CTBLIDX");
                    while (result.next()) {
                        int nlFound = this.curAlias.indexOf("[" + result.getString(1) + "]");
                        if (nlFound != -1) continue;
                        this.curAlias = this.curAlias + "[" + result.getString(1) + "]";
                        this.curFrom = this.curFrom + "," + result.getString(2);
                        String slJoin = "";
                        slJoin = this.nvl(result.getString(3));
                        if (slJoin.equals("")) continue;
                        if (this.curWhere.equals(" WHERE ")) {
                            this.curWhere = this.curWhere + slJoin;
                            continue;
                        }
                        this.curWhere = this.curWhere + " AND " + slJoin;
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeResultSet(result);
                    throw throwable;
                }
                Utils.closeResultSet(result);
            }
            catch (SQLException e) {
                Utils.logError(e);
            }
            finally {
                Utils.closeStatement(stmt);
            }
        }
        this.cacheMap.put(cacheidx + "mandtable", mandTable);
        this.cacheMap.put(cacheidx + "curfrom", this.curFrom);
        this.cacheMap.put(cacheidx + "curwhere", this.curWhere);
        this.cacheMap.put(cacheidx + "finfrom", this.curFrom);
        this.cacheMap.put(cacheidx + "finwhere", this.curWhere);
    }

    private boolean setCache(long cacheidx) throws Exception {
        long nCacheInstanceidx = this.getCacheInstance(cacheidx);
        this.cacheMap.put(cacheidx + "cacheint", nCacheInstanceidx + "");
        this.setBaseSql(cacheidx + "", nCacheInstanceidx + "");
        this.getColumnDetails(cacheidx + "");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setBaseSql(String cacheidx, String cacheInstance) throws Exception {
        String slQueryWhere = " WHERE ";
        String slQuerySelect = " ";
        String slQueryFrom = " ";
        String slQueryAliasList = "[]";
        String slTemp = "";
        String slJoin = "";
        Statement stmtOuter = null;
        try {
            ResultSet rSetCache1;
            block28: {
                stmtOuter = this.con.createStatement();
                rSetCache1 = null;
                try {
                    rSetCache1 = stmtOuter.executeQuery("SELECT CACHENAME FROM CACHE_INSTANCE WHERE CINTIDX = " + cacheInstance);
                    if (!rSetCache1.next()) break block28;
                    this.cacheMap.put(cacheidx + "cachename", rSetCache1.getString(1));
                    int nlFound = 0;
                    Statement stmtInner = null;
                    try {
                        ResultSet rSetCache2;
                        block29: {
                            stmtInner = this.con.createStatement();
                            rSetCache2 = null;
                            try {
                                rSetCache2 = stmtInner.executeQuery("SELECT KEYCOL, CODECOL, null, JOIN1.TBLALIAS, JOIN2.TBLALIAS, null, JOIN1.TBLNAME, JOIN2.TBLNAME,  null, JOIN1.TBLJOIN, JOIN2.TBLJOIN, null  FROM \"CACHE\" C, CACHE_TBL JOIN1, CACHE_TBL JOIN2  WHERE C.CACHEIDX = " + cacheidx + " AND C.KEYTBLIDX = JOIN1.CTBLIDX  AND C.CODETBLIDX = JOIN2.CTBLIDX ");
                                if (!rSetCache2.next()) break block29;
                                slQuerySelect = slQuerySelect + rSetCache2.getString(1);
                                this.cacheMap.put(cacheidx + "uniqueidx", slQuerySelect);
                                slQueryAliasList = "[" + rSetCache2.getString(4) + "]";
                                slQueryFrom = slQueryFrom + ", " + rSetCache2.getString(7) + " " + rSetCache2.getString(4);
                                slTemp = this.nvl(rSetCache2.getString(10));
                                if (slTemp.length() > 0) {
                                    slQueryWhere = slQueryWhere.equals(" WHERE ") ? slQueryWhere + slTemp : slQueryWhere + " AND " + slTemp;
                                }
                                slTemp = this.nvl(rSetCache2.getString(5));
                                nlFound = slQueryAliasList.indexOf("[" + slTemp + "]");
                                if (nlFound != -1) break block29;
                                slQueryAliasList = slQueryAliasList + "[" + slTemp + "]";
                                slQueryFrom = slQueryFrom + "," + rSetCache2.getString(8) + " " + slTemp;
                                slTemp = this.nvl(rSetCache2.getString(11));
                                if (!slTemp.equals("")) {
                                    slQueryWhere = slQueryWhere.equals(" WHERE ") ? slQueryWhere + slTemp : slQueryWhere + " AND " + slTemp;
                                }
                            }
                            catch (Throwable throwable) {
                                Utils.closeResultSet(rSetCache2);
                                throw throwable;
                            }
                        }
                        Utils.closeResultSet(rSetCache2);
                        ResultSet rSetCache3 = null;
                        try {
                            rSetCache3 = stmtInner.executeQuery(" SELECT T.TBLALIAS, T.TBLNAME || ' ' || T.TBLALIAS as TABCOL, T.TBLJOIN, T.SECTBLIDX, BASS_UTILS.GET_SECWHERE_SQL(T.SECTBLIDX," + this.memidx + ", T.TBLALIAS) AS SECWHERE  FROM CACHE_TBL T  WHERE T.CACHEIDX =" + cacheidx + " AND T.SECTBLIDX > 0  ORDER BY T.SECTBLIDX ");
                            while (rSetCache3.next()) {
                                slTemp = this.nvl(rSetCache3.getString(5));
                                if (slTemp.length() <= 1 || (nlFound = slQueryAliasList.indexOf("[" + rSetCache3.getString(1) + "]")) >= 0) continue;
                                slQueryAliasList = slQueryAliasList + "[" + rSetCache3.getString(1) + "]";
                                slQueryFrom = slQueryFrom + "," + rSetCache3.getString(2);
                                slJoin = "";
                                slJoin = this.nvl(rSetCache3.getString(3));
                                if (slJoin.equals("")) continue;
                                if (slQueryWhere.equals(" WHERE ")) {
                                    slQueryWhere = slQueryWhere + slJoin + " AND " + slTemp;
                                    continue;
                                }
                                slQueryWhere = slQueryWhere + " AND " + slJoin + " AND " + slTemp;
                            }
                        }
                        catch (SQLException sQLException) {
                            Utils.closeResultSet(rSetCache3);
                            catch (Throwable throwable) {
                                Utils.closeResultSet(rSetCache3);
                                throw throwable;
                            }
                        }
                        Utils.closeResultSet(rSetCache3);
                        ResultSet rSetCache4 = null;
                        try {
                            rSetCache4 = stmtInner.executeQuery(" SELECT C.CCOLIDX,A.CTBLIDX,C.CINTIDX,C.COLNAME,C.COLTITLE,C.COLALIGN,C.COLWIDTH,C.COLORDER, C.GROUPBY,C.REFCODE,C.REFJOIN,C.REFALIAS,T.TBLALIAS, T.TBLNAME || ' ' || T.TBLALIAS as TABCOL, T.TBLJOIN AS TBLJOIN, T.SECTBLIDX  FROM CACHE_COL C, CACHE_TBL T, CACHE_ALIAS A  WHERE C.CINTIDX = " + cacheInstance + " AND A.CCOLIDX = C.CCOLIDX  AND A.CTBLIDX = T.CTBLIDX  ORDER BY C.COLORDER ");
                            int nlColAs = 2;
                            while (rSetCache4.next()) {
                                slQuerySelect = slQuerySelect + "," + rSetCache4.getString(4) + " as c" + nlColAs;
                                ++nlColAs;
                                slTemp = this.nvl(rSetCache4.getString(12));
                                if (slTemp.equals("")) {
                                    slTemp = rSetCache4.getString(13);
                                }
                                if ((nlFound = slQueryAliasList.indexOf("[" + slTemp + "]")) != -1) continue;
                                slQueryAliasList = slQueryAliasList + "[" + rSetCache4.getString(13) + "]";
                                String slFromTmp = rSetCache4.getString(14);
                                if (slFromTmp.length() > 240) {
                                    slFromTmp = slFromTmp.substring(0, 240);
                                }
                                slJoin = this.nvl(rSetCache4.getString(15));
                                String slRefCode = "";
                                slRefCode = this.nvl(rSetCache4.getString(10));
                                if (slRefCode != null && !slRefCode.equals("") && !slRefCode.equals("0")) {
                                    slJoin = rSetCache4.getString(13) + "." + rSetCache4.getString(11) + " = " + rSetCache4.getString(12) + ".RCIDX(+) ";
                                    slFromTmp = " REFCODE " + rSetCache4.getString(12);
                                }
                                slQueryFrom = slQueryFrom + "," + slFromTmp;
                                if (slJoin.equals("")) continue;
                                if (slQueryWhere.equals(" WHERE ")) {
                                    slQueryWhere = slQueryWhere + slJoin;
                                    continue;
                                }
                                slQueryWhere = slQueryWhere + " AND " + slJoin;
                            }
                        }
                        catch (Throwable throwable) {
                            Utils.closeResultSet(rSetCache4);
                            throw throwable;
                        }
                        Utils.closeResultSet(rSetCache4);
                    }
                    finally {
                        Utils.closeStatement(stmtInner);
                    }
                    if (slQueryWhere.equals(" WHERE ")) {
                        slQueryWhere = slQueryWhere + " 1 = 1 ";
                    }
                    if (slQueryFrom.equals(" ")) break block28;
                    slQueryFrom = slQueryFrom.substring(2);
                }
                catch (Throwable throwable) {
                    Utils.closeResultSet(rSetCache1);
                    throw throwable;
                }
            }
            Utils.closeResultSet(rSetCache1);
        }
        catch (Exception e) {
            Utils.logError(e);
            throw e;
        }
        finally {
            Utils.closeStatement(stmtOuter);
        }
        this.cacheMap.put(cacheidx + "select", slQuerySelect);
        this.cacheMap.put(cacheidx + "basefrom", slQueryFrom);
        this.cacheMap.put(cacheidx + "basewhere", slQueryWhere);
        this.cacheMap.put(cacheidx + "queryalias", slQueryAliasList);
        this.cacheMap.put(cacheidx + "mandtable", "");
        this.cacheMap.put(cacheidx + "curfrom", slQueryFrom);
        this.cacheMap.put(cacheidx + "curwhere", slQueryWhere);
        this.cacheMap.put(cacheidx + "finfrom", slQueryFrom);
        this.cacheMap.put(cacheidx + "finwhere", slQueryWhere);
        this.cacheMap.put(cacheidx + "extrafrom", "");
        this.cacheMap.put(cacheidx + "extrawhere", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCacheInstance(long cacheidx) {
        StringBuffer sql = new StringBuffer();
        Statement stmt = null;
        try {
            stmt = this.con.createStatement();
            long lret = -1L;
            sql.append(" SELECT CINTIDX FROM CACHE_INSTANCE  WHERE CACHEIDX =" + cacheidx + " AND MEMIDX =" + this.memidx + "  ORDER BY CINTIDX ");
            ResultSet rSetCache1 = null;
            try {
                rSetCache1 = stmt.executeQuery(sql.toString());
                if (rSetCache1.next()) {
                    lret = rSetCache1.getLong(1);
                }
            }
            catch (Throwable throwable) {
                Utils.closeResultSet(rSetCache1);
                throw throwable;
            }
            Utils.closeResultSet(rSetCache1);
            if (lret == -1L) {
                sql.setLength(0);
                sql.append(" SELECT CINTIDX FROM CACHE_INSTANCE  WHERE CACHEIDX =" + cacheidx + " AND GRPIDX IN (SELECT GRPIDX FROM GRPMEM WHERE MEMIDX = " + this.memidx + ")  ORDER BY CINTIDX ");
                ResultSet rSetCache2 = null;
                try {
                    rSetCache2 = stmt.executeQuery(sql.toString());
                    if (rSetCache2.next()) {
                        lret = rSetCache2.getLong(1);
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeResultSet(rSetCache2);
                    throw throwable;
                }
                Utils.closeResultSet(rSetCache2);
                if (lret == -1L) {
                    ResultSet rSetCache3;
                    block15: {
                        sql.setLength(0);
                        sql.append(" SELECT CINTIDX FROM CACHE_INSTANCE  WHERE CACHEIDX =" + cacheidx + "  ORDER BY CINTIDX ");
                        rSetCache3 = null;
                        try {
                            rSetCache3 = stmt.executeQuery(sql.toString());
                            if (!rSetCache3.next()) break block15;
                            lret = rSetCache3.getLong(1);
                        }
                        catch (Throwable throwable) {
                            Utils.closeResultSet(rSetCache3);
                            throw throwable;
                        }
                    }
                    Utils.closeResultSet(rSetCache3);
                }
            }
            long l = lret;
            return l;
        }
        catch (Exception e) {
            Utils.logError(e);
        }
        finally {
            Utils.closeStatement(stmt);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getColumnDetails(String cacheidx) {
        block11: {
            Statement stmt = null;
            try {
                stmt = this.con.createStatement();
                if (!stmt.execute(" SELECT COLNAME, COLTITLE, COLALIGN, COLWIDTH, COLSORT FROM CACHE_COL WHERE CINTIDX =" + this.cacheMap.get(cacheidx + "cacheint") + " ORDER BY COLORDER")) break block11;
                ResultSet rset = null;
                try {
                    rset = stmt.getResultSet();
                    ResultSetMetaData meta = rset.getMetaData();
                    Hashtable cacheAttribs = new Hashtable();
                    int cols = meta.getColumnCount();
                    int colCount = 0;
                    while (rset.next()) {
                        Hashtable<String, String> hAttribute = new Hashtable<String, String>(cols);
                        String slValue = "0";
                        ++colCount;
                        for (int i = 1; i <= cols; ++i) {
                            slValue = this.nvl(rset.getString(i));
                            if (slValue.equals("")) {
                                slValue = "0";
                            }
                            String colLabel = meta.getColumnName(i);
                            colLabel = colLabel.toUpperCase();
                            hAttribute.put(colLabel, slValue);
                        }
                        cacheAttribs.put(colCount + "", hAttribute);
                    }
                    this.cacheMapAttributes.put(cacheidx + "", cacheAttribs);
                    this.cacheMap.put(cacheidx + "colCount", colCount + "");
                }
                finally {
                    Utils.closeResultSet(rset);
                }
            }
            catch (Exception e) {
                Utils.logError(e);
            }
            finally {
                Utils.closeStatement(stmt);
            }
        }
        return true;
    }

    private String actualGetColAttribute(String AttribName, long colNum, long cacheidx, Hashtable<String, Hashtable<String, String>> cacheAttribs) {
        if (cacheAttribs.containsKey(colNum + "")) {
            Hashtable<String, String> hTemp = cacheAttribs.get(colNum + "");
            String xTemp = null;
            if (hTemp.containsKey(AttribName)) {
                try {
                    xTemp = hTemp.get(AttribName);
                }
                catch (Exception e) {
                    Utils.logError(e);
                }
                return xTemp;
            }
            return xTemp;
        }
        return null;
    }

    public String nvl(String sNull) {
        if (sNull == null) {
            return new String("");
        }
        return sNull;
    }
}

