/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.cache;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;

public class CookieMan
implements Serializable {
    private Hashtable<String, String> cookieHash = new Hashtable();

    public void saveCookie(URL servletURL, HttpURLConnection servletConn) {
        try {
            String URLpath = servletURL.getHost() + servletURL.getPath();
            String cookie = servletConn.getHeaderField("Set-Cookie");
            if (cookie != null && !cookie.equals("")) {
                int index = cookie.indexOf(";");
                if (index >= 0) {
                    cookie = cookie.substring(0, index);
                }
                this.cookieHash.put(URLpath, cookie);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putCookie(URL servletURL, HttpURLConnection servletConn) {
        try {
            String cookie = this.cookieHash.get(servletURL.getHost() + servletURL.getPath());
            if (cookie != null && !cookie.equals("")) {
                servletConn.setRequestProperty("Cookie", cookie);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

