/*
 * Decompiled with CFR 0.152.
 */
package jpos.browser;

import bass.eftpos.StringUtils;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.HttpStatus;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import jpos.PosUtils;
import jpos.Settings;

public class BrowserEngine {
    private Engine engine = null;
    private static BrowserEngine instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserEngine() {
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        System.setProperty("jxbrowser.dmp.dir", "");
        System.setProperty("jxbrowser.license.key", "1BNDIEOFAZ3Z3O0RU2VV46AUG6E6ZJ79A69SHOTOEFANQFQ256AVYS3YV2RQZ7RKKXTB7F");
        InterceptUrlRequestCallback interceptJarCallback = params -> {
            try {
                UrlRequest urlrequest = params.urlRequest();
                String url = urlrequest.url().replace("//file", "file:");
                URL path = new URL(url);
                UrlRequestJob job = params.newUrlRequestJob(UrlRequestJob.Options.newBuilder((HttpStatus)HttpStatus.OK).addHttpHeader(HttpHeader.of((String)"Content-Type", (String)BrowserEngine.getMimeType(path.toString()))).build());
                try (InputStream inputStream = path.openStream();
                     DataInputStream stream = new DataInputStream(inputStream);){
                    byte[] data = new byte[stream.available()];
                    stream.readFully(data);
                    job.write(data);
                }
                job.complete();
                return InterceptUrlRequestCallback.Response.intercept((UrlRequestJob)job);
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return InterceptUrlRequestCallback.Response.proceed();
            }
        };
        EngineOptions.Builder buildOptions = EngineOptions.newBuilder((RenderingMode)RenderingMode.HARDWARE_ACCELERATED).addScheme(Scheme.JAR, interceptJarCallback).userDataDir(Paths.get("browser_data", new String[0]));
        if (Settings.showBrowserDebugger()) {
            buildOptions.addSwitch("--remote-debugging-port=9222");
        }
        EngineOptions options = buildOptions.build();
        try (PrintStream tempOut = BrowserEngine.createDummyStream();
             PrintStream tempErr = BrowserEngine.createDummyStream();){
            System.setOut(tempOut);
            System.setErr(tempErr);
            this.engine = Engine.newInstance((EngineOptions)options);
        }
        finally {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
    }

    public static synchronized BrowserEngine getInstance() {
        if (instance == null) {
            instance = new BrowserEngine();
        }
        return instance;
    }

    public Browser newBrowser() {
        return BrowserEngine.getInstance().engine.newBrowser();
    }

    public void close() {
        if (instance != null) {
            BrowserEngine.instance.engine.close();
            instance = null;
        }
    }

    private static String getMimeType(String path) {
        if (path.endsWith(".html")) {
            return "text/html";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".js")) {
            return "text/javascript";
        }
        if (path.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (path.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (path.endsWith(".png")) {
            return "image/png";
        }
        String guessedType = URLConnection.guessContentTypeFromName(path);
        return StringUtils.nullOrEmptyToValue((String)guessedType, (String)"text/html");
    }

    private static PrintStream createDummyStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
    }
}

