/*
 * Decompiled with CFR 0.152.
 */
package jpos.browser;

import com.teamdev.jxbrowser.js.JsAccessible;
import jpos.Currency;
import jpos.PosDateFormatter;
import jpos.SP;

public class JSPosUtils {
    private static final ThreadLocal<PosDateFormatter> shortDateFormat = new ThreadLocal<PosDateFormatter>(){

        @Override
        protected PosDateFormatter initialValue() {
            return new PosDateFormatter(null, 3, 3, 0);
        }
    };
    private Currency storeCurrency;

    public JSPosUtils() {
        this.storeCurrency = SP.sParams.storeCurrency;
    }

    @JsAccessible
    public String translate(String key) {
        return SP.getRS(key);
    }

    @JsAccessible
    public String getCurrencyTot(double amount) {
        return this.storeCurrency.formatTotal(amount);
    }

    @JsAccessible
    public String getCurrencyDet(double amount) {
        return this.storeCurrency.formatDetail(amount);
    }

    @JsAccessible
    public String addCurrencySymbol(String value) {
        return this.storeCurrency.prependSymbol(value);
    }

    @JsAccessible
    public String getShortDateFormat() {
        return shortDateFormat.get().getDatePattern();
    }
}

