/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import jpos.DlgManualLoyaltyDiscount;
import jpos.LoyaltyRedemptionPanel;
import jpos.PosUtils;
import jpos.RestRequest;
import jpos.browser.BrowserControl;
import jpos.capillary.CapillaryLoyaltySetup;
import jpos.capillary.CapillaryRedemption;
import jpos.capillary.CapillaryUtils;

public class CapillaryLoyaltyRedemptionPanel
extends LoyaltyRedemptionPanel {
    private BrowserControl browserControl;
    private String baseUrl;
    private String redeemRewardJson;
    private String username;
    private String password;
    private String externalId;
    private double pointsToBeRedeemed;
    private double pointsBalance;
    private String couponCode;

    public CapillaryLoyaltyRedemptionPanel(DlgManualLoyaltyDiscount parentDlg) {
        super(parentDlg);
        try {
            this.init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void init() {
        this.getParentDlg().setAcceptOnEnter(false);
        this.setLayout(new BorderLayout());
        CapillaryLoyaltySetup setup = new CapillaryLoyaltySetup();
        this.baseUrl = RestRequest.formatBaseURL(setup.getRedemptionScreenUrl());
        this.username = setup.getUsername();
        this.password = CapillaryUtils.getMd5Password(setup.getPassword());
        this.browserControl = new BrowserControl();
        this.browserControl.getBrowser().set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
            JsObject value = (JsObject)params.frame().executeJavaScript("window");
            value.putProperty("storeportal", (Object)new JavaBridge());
            return InjectJsCallback.Response.proceed();
        }));
        this.browserControl.getBrowser().on(TitleChanged.class, event -> this.getParentDlg().setTitle(event.browser().title()));
        this.add((Component)this.browserControl, "Center");
        this.setPreferredSize(new Dimension(600, 600));
        this.browserControl.initialiseSplitterPosition(600);
    }

    @Override
    public void destroyPanel() {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
    }

    @Override
    public void load() {
        this.loadPage();
    }

    public void loadPage() {
        String url = this.baseUrl;
        url = url + "?till=" + this.username;
        url = url + "&password=" + this.password;
        url = url + "&externalId=" + this.getLoyaltyInfo().getCardNo();
        url = url + "&balanceAmount=" + this.getTransactionTotal();
        this.browserControl.loadURL(url);
    }

    public String getRedeemRewardJson() {
        return this.redeemRewardJson;
    }

    public double getPoints() {
        return this.pointsToBeRedeemed;
    }

    public void setPoints(double points) {
        this.pointsToBeRedeemed = points;
    }

    public double getPointsBalance() {
        return this.pointsBalance;
    }

    public void setPointsBalance(double points) {
        this.pointsBalance = points;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public class JavaBridge {
        @JsAccessible
        public void memberProfile_redemptiondata(String redeemJson) {
            CapillaryLoyaltyRedemptionPanel.this.redeemRewardJson = redeemJson;
            CapillaryRedemption redeemData = CapillaryUtils.loadCapillaryRedemptionData(redeemJson);
            if (redeemData != null) {
                if (redeemData.isRedeemable) {
                    CapillaryLoyaltyRedemptionPanel.this.setAmount(redeemData.maxAmountCanBeRedeemed);
                    CapillaryLoyaltyRedemptionPanel.this.setPoints(redeemData.pointsToBeRedeemed);
                    CapillaryLoyaltyRedemptionPanel.this.setPointsBalance(redeemData.currentPointsBalance);
                }
                if (redeemData.couponCode != null) {
                    CapillaryLoyaltyRedemptionPanel.this.setCouponCode(redeemData.couponCode);
                }
            }
            CapillaryLoyaltyRedemptionPanel.this.getParentDlg().okDialog();
        }
    }
}

