/*
 * Decompiled with CFR 0.152.
 */
package jpos.coupons;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class Coupon {
    private long id;
    private String code;
    private String name;
    private long campaignId;
    private long promoIdx;
    private LocalDate validTo;

    public Coupon(long id, String code, String name, long campaignId, long promoIdx) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.campaignId = campaignId;
        this.promoIdx = promoIdx;
    }

    public Coupon(long id, String code, String name, long campaignId, long promoIdx, LocalDate validTo) {
        this(id, code, name, campaignId, promoIdx);
        this.validTo = validTo;
    }

    public long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public long getCampaignId() {
        return this.campaignId;
    }

    public long getPromoIdx() {
        return this.promoIdx;
    }

    public LocalDate getValidTo() {
        return this.validTo;
    }

    public String getValidToString() {
        if (this.validTo == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/YYYY");
        return "- Expires " + formatter.format(this.validTo);
    }

    public String getCouponDetails() {
        return String.format("<html><b style=\"font-size:1.25em; \">%s</b><br> <p>%s %s</p></html>", this.name, this.code, this.getValidToString());
    }
}

