/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import jpos.DiscLine;
import jpos.FrSales;
import jpos.OmniChannel;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.pay.eftpos.EftposUtils;
import jpos.taxlookup.ITaxLookup;
import jpos.taxlookup.TaxLookupDeliveryInfo;
import jpos.taxlookup.TaxLookupFactory;
import jpos.taxlookup.TaxLookupPerson;

public class CustomerOrderSale {
    private long saleVhidx;
    private long custOrdVhidx;
    private Vector<Object> detailLines;
    private boolean commitTaxLookup;
    private FrSales frSales = null;
    private String taxLookupError = "";
    private long ownerWidx;
    private String docketNumber;
    private long saleTypeIdx;

    public CustomerOrderSale(FrSales frSales, long custOrdVhidx, Vector<Object> detailLines, boolean commitTaxLookup, long ownerWidx, String docketNumber, long saleTypeIdx) {
        this.frSales = frSales;
        this.custOrdVhidx = custOrdVhidx;
        this.detailLines = detailLines;
        this.commitTaxLookup = commitTaxLookup;
        this.saleVhidx = 0L;
        this.ownerWidx = ownerWidx;
        this.docketNumber = docketNumber;
        this.saleTypeIdx = saleTypeIdx;
    }

    public long getSaleVhidx() {
        return this.saleVhidx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createSaleTransaction(long selfFit, String myFitSession) {
        long saleVhidx = 0L;
        this.saleVhidx = 0L;
        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("SELECT SUM(TAKEN) FROM RET_TRAND WHERE \"ACTIVE\" = 1 AND VHIDX = ?");){
            block60: {
                prepStmt.setLong(1, this.custOrdVhidx);
                try (ResultSet result = prepStmt.executeQuery();){
                    if (!result.next() || result.getInt(1) <= 0) break block60;
                    this.docketNumber = StringUtils.isNullOrEmpty(this.docketNumber) ? PosUtils.padZeroes(SP.sParams.getNextDocketNum("CustomerOrderSale.createSaleTransaction"), 8) : this.docketNumber;
                    long saleWidx = this.isOwnedByAnotherStore() ? this.ownerWidx : SP.sParams.getStore().getWidx();
                    saleVhidx = SP.sParams.nextVal("XRET_TRANH");
                    if (!this.insertHeader(this.custOrdVhidx, saleVhidx, this.docketNumber, saleWidx, this.saleTypeIdx, selfFit, myFitSession)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.insertDetails()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.insertPayment(saleVhidx)) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean taxLookupSuccess = false;
                    if (this.commitTaxLookup) {
                        taxLookupSuccess = this.commitTax(this.docketNumber);
                    }
                    try (Statement stmt = SP.sParams.conn.createStatement();){
                        stmt.executeUpdate("UPDATE RET_TRANH SET TAX_LOOKUP = " + (taxLookupSuccess ? "1" : "0") + " WHERE VHIDX = " + saleVhidx);
                    }
                    SP.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + saleVhidx);
                }
            }
            this.saleVhidx = saleVhidx;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertHeader(long custOrdVhidx, long saleVhidx, String docketNumber, long saleWidx, long saleTypeIdx, long selfFit, String myFitSession) {
        try (PreparedStatement prepStmtInsert = SP.sParams.conn.prepareStatement("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, DOCKET_NUMBER, WIDX, SREPIDX, CLIENTIDX, MEMBER_GENERATEDIDX, NOTES1, REF1, REF2, REF3, REF4, REF5, REF6, REF7, REF8, REF9, REF10, STAFF_SALE_FLAG, TILL_NUMBER, TRAND, TRANS_NUMBER, \"ACTIVE\", COMPLETE, ORIG_TRANIDX, NOTES2, CORDER, TRANSMEMIDX, TRANSSREPIDX, SALE_DATE, CONNUM, CARRIERIDX, CARRIER_CODE, SERVICETYPE_IDX, DELIVERY_LOCNIDX, BILLING_LOCNIDX, ORIGIN, POINTS_PARTNER_RCIDX, POINTS_PARTNER_NUM, COUNTRY_CODE, DESPATCH_WIDX, SALE_TYPE_IDX, SELFFIT, FITSESSION) SELECT ?, ?, ?, ?, H.SREPIDX, H.CLIENTIDX, H.MEMBER_GENERATEDIDX, H.NOTES1, H.REF1, H.REF2, H.REF3, H.REF4, H.REF5, H.REF6, H.REF7, H.REF8, H.REF9, H.REF10, H.STAFF_SALE_FLAG, H.TILL_NUMBER, H.TRAND, H.TRANS_NUMBER, H.\"ACTIVE\", H.COMPLETE, H.VHIDX, H.NOTES2, H.CORDER, H.TRANSMEMIDX, H.TRANSSREPIDX, CURRENT_DATE, H.CONNUM, H.CARRIERIDX, H.CARRIER_CODE, H.SERVICETYPE_IDX, DELIVERY_LOCNIDX, BILLING_LOCNIDX, ORIGIN, H.POINTS_PARTNER_RCIDX, H.POINTS_PARTNER_NUM, H.COUNTRY_CODE, ?, ?, ?, ?FROM RET_TRANH H WHERE H.VHIDX = ?");){
            prepStmtInsert.setLong(1, saleVhidx);
            prepStmtInsert.setInt(2, 239);
            prepStmtInsert.setString(3, docketNumber);
            prepStmtInsert.setLong(4, saleWidx);
            prepStmtInsert.setLong(5, SP.sParams.getStore().getWidx());
            if (saleTypeIdx != 0L) {
                prepStmtInsert.setLong(6, saleTypeIdx);
            } else {
                prepStmtInsert.setNull(6, 4);
            }
            prepStmtInsert.setLong(7, selfFit);
            prepStmtInsert.setString(8, myFitSession);
            prepStmtInsert.setLong(9, custOrdVhidx);
            prepStmtInsert.executeUpdate();
            if (this.isOwnedByAnotherStore()) {
                OmniChannel.consumeDocketNumber(SP.sParams.conn, saleWidx, docketNumber);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private boolean insertDetails() {
        try {
            for (int i = 0; i < this.detailLines.size(); ++i) {
                if (this.detailLines.elementAt(i) instanceof StyleLine) {
                    ((StyleLine)this.detailLines.elementAt(i)).setQty(((StyleLine)this.detailLines.elementAt(i)).getPickUpQty());
                    ((StyleLine)this.detailLines.elementAt(i)).setPackedQty(0.0);
                    ((StyleLine)this.detailLines.elementAt(i)).setPickUpQty(0.0);
                    ((StyleLine)this.detailLines.elementAt(i)).db_insertline();
                    continue;
                }
                if (!(this.detailLines.elementAt(i) instanceof DiscLine)) continue;
                ((DiscLine)this.detailLines.elementAt(i)).db_insertline();
            }
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertPayment(long saleVhidx) {
        Throwable throwable;
        double total;
        block48: {
            SqlQuery query;
            total = 0.0;
            if (SP.sParams.bUsingExtendedTax) {
                try {
                    query = new SqlQuery(SP.sParams.conn, "SELECT LINE_TYPE, NET, EXT_TAXRATE FROM RET_TRAND WHERE \"ACTIVE\" = 1 AND VHIDX = ? ORDER BY SEQUENCE_NUMBER, VSHIDX", saleVhidx);
                    throwable = null;
                    try {
                        double taxPercent = 0.0;
                        double itemNet = 0.0;
                        total = 0.0;
                        while (query.next()) {
                            double net = query.getDouble(2);
                            int lineType = query.getInt(1);
                            if (lineType == 6 || lineType == 7) {
                                itemNet += net;
                                continue;
                            }
                            if ((itemNet = SP.sParams.storeCurrency.round(itemNet)) != 0.0) {
                                total += SP.sParams.storeCurrency.round(itemNet + itemNet * taxPercent / 100.0);
                            }
                            itemNet = net;
                            taxPercent = query.getDouble(3);
                        }
                        if ((itemNet = SP.sParams.storeCurrency.round(itemNet)) != 0.0) {
                            total += SP.sParams.storeCurrency.round(itemNet + itemNet * taxPercent / 100.0);
                        }
                        break block48;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (query != null) {
                            if (throwable != null) {
                                try {
                                    query.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                query.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    return false;
                }
            }
            try {
                query = new SqlQuery(SP.sParams.conn, "SELECT SUM(NET) FROM RET_TRAND WHERE \"ACTIVE\" = 1 AND VHIDX = " + saleVhidx);
                throwable = null;
                try {
                    if (query.next()) {
                        total = query.getDouble(1);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (query != null) {
                        if (throwable != null) {
                            try {
                                query.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            query.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return false;
            }
        }
        try {
            throwable = null;
            try (PreparedStatement prepStmtInsert = SP.sParams.conn.prepareStatement("INSERT INTO RET_TRANP(VSHIDX, VHIDX, \"ACTIVE\", PAYMENT_AMOUNT, PAYMENT_TYPEIDX, SEQUENCE_NUMBER, CASHOUT_AMOUNT, CRDT) VALUES(?, ?, 1, ?, ?, 0, 0, CURRENT_TIMESTAMP)");){
                prepStmtInsert.setLong(1, SP.sParams.nextVal("XRET_TRANP"));
                prepStmtInsert.setLong(2, saleVhidx);
                prepStmtInsert.setDouble(3, total);
                prepStmtInsert.setLong(4, 730L);
                prepStmtInsert.executeUpdate();
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private boolean commitTax(String docketNumber) {
        this.taxLookupError = "";
        ITaxLookup taxLookup = TaxLookupFactory.getTaxLookup();
        if (taxLookup != null) {
            EftposUtils.debugPoint(this.frSales, "Getting Extended Tax Rate from 3rd Party\nVHIDX: " + this.saleVhidx + ", Complete: 1, Docket Number: " + docketNumber);
            TaxLookupPerson taxPerson = new TaxLookupPerson(this.frSales.getPerson());
            TaxLookupDeliveryInfo taxDelivInfo = new TaxLookupDeliveryInfo(this.frSales.deliveryInfo, this.frSales.despatchInfo);
            Vector<StyleLine> styleLines = this.getTaxLookupStyleLines();
            if (taxLookup.commitTax("D" + SP.sParams.getStore().getStoreNo() + docketNumber, false, SP.getRS("Customer_Order_Pickup"), this.frSales.getUser().getMemName(), styleLines, taxPerson, taxDelivInfo, true)) {
                return true;
            }
            this.taxLookupError = taxLookup.getLastErrorMessage();
        }
        return false;
    }

    private Vector<StyleLine> getTaxLookupStyleLines() {
        Vector<StyleLine> styleLines = new Vector<StyleLine>();
        for (Object line : this.detailLines) {
            StyleLine styleLine;
            if (!(line instanceof StyleLine) || (styleLine = (StyleLine)line).getQty() == 0.0) continue;
            styleLines.add(styleLine);
        }
        return styleLines;
    }

    public String getTaxLookupError() {
        return this.taxLookupError;
    }

    private boolean isOwnedByAnotherStore() {
        return this.ownerWidx > 0L && this.ownerWidx != SP.sParams.getStore().getWidx();
    }
}

