/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import com.google.gson.Gson;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.custorder.auspost.ReprintManifestTable;
import jpos.custorder.auspost.ReprintManifestTableModel;
import jpos.logging.RollingLog;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import org.jdom.Element;

public class DlgReprintManifest
extends PosDialog {
    private LabelSubHeading headingLabel;
    private ReprintManifestTable manifestTable;
    private DialogButton selectAllButton = new DialogButton("");
    private DialogButton okButton = new DialogButton("");
    private boolean result = false;

    public DlgReprintManifest(PosFrame frame) {
        super(frame, SP.getRS("Reprint_Manifest_Header"), true);
        this.setAcceptOnEnter(false);
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.headingLabel = new LabelSubHeading(SP.getRS("Reprint_Manifest_Subheader"));
        ReprintManifestTableModel manifestTableModel = new ReprintManifestTableModel();
        this.manifestTable = new ReprintManifestTable((Window)this, manifestTableModel);
        this.manifestTable.populate();
        this.manifestTable.getScrollPane().setPreferredSize(new Dimension(600, 402));
        this.selectAllButton.setText(StoreParams.res.getString("F8_Select_All"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReprintManifest.this.selectAllButton.setEnabled(false);
                DlgReprintManifest.this.selectAll();
                DlgReprintManifest.this.selectAllButton.setEnabled(true);
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReprintManifest.this.okDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelHeader.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(7, 10, 0, 10), 0, 0));
        panelBody.add((Component)this.manifestTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        panelFooter.add((Component)this.selectAllButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        panelFooter.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 10, 20), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.manifestTable);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    public boolean getResult() {
        return this.result;
    }

    public boolean isFullyManifested() {
        return this.manifestTable.isFullyManifested();
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (this.manifestSelected()) {
            this.result = true;
            this.dispose();
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 119 && this.selectAllButton.isVisible() && this.selectAllButton.isEnabled()) {
            this.selectAllButton.doClick();
            return true;
        }
        return false;
    }

    private void selectAll() {
        this.manifestTable.selectAll();
    }

    public int getRowCount() {
        return this.manifestTable.getModel().getRowCount();
    }

    private boolean manifestSelected() {
        int i;
        Vector<Manifest> manifestIds = new Vector<Manifest>();
        for (i = 0; i < this.manifestTable.getModel().getRowCount(); ++i) {
            if (!((Boolean)this.manifestTable.getValueAt(i, 4)).booleanValue()) continue;
            String manifestId = (String)this.manifestTable.getValueAt(i, 1);
            String carrier = (String)this.manifestTable.getValueAt(i, 0);
            String name = (String)this.manifestTable.getValueAt(i, 3);
            manifestIds.add(new Manifest(carrier, manifestId, name));
        }
        for (i = 0; i < manifestIds.size(); ++i) {
            Gson gson = new Gson();
            String json = gson.toJson(manifestIds.get(i));
            RollingLog.LogType log = RollingLog.LogType.AUSPOST;
            if (((Manifest)manifestIds.get((int)i)).carrierName == "StarTrack Express") {
                log = RollingLog.LogType.STARTRACK;
            }
            RollingLog.log(log, Level.INFO, "Manifest Request" + System.lineSeparator() + json);
            Element shipmentResult = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_get_manifest", json).getXML();
            String manifestId = XMLUtils.getValue(shipmentResult, "manifestId");
            String base64Content = XMLUtils.getValue(shipmentResult, "base64Content");
            byte[] data = this.decodeBase64String(base64Content);
            String filename = this.generateFileName(manifestId);
            boolean fileCreated = this.createPDFFromByteArray(data, filename);
            if (!fileCreated) {
                DlgMessage.showMessage(this, "Unable to create manifest file");
                return false;
            }
            RollingLog.log(log, Level.INFO, "Manifest Response" + System.lineSeparator() + "Manifest ID: " + manifestId);
            this.printManifest(filename);
        }
        return true;
    }

    public boolean printManifest(String fileToPrint) {
        String printError = null;
        try {
            String labelError = SP.sParams.PrinterProvider.openDocument(fileToPrint);
            if (!StringUtils.isNullOrEmpty(labelError)) {
                printError = labelError;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return StringUtils.isNullOrEmpty(printError);
    }

    public byte[] decodeBase64String(String base64String) {
        return Base64.getDecoder().decode(base64String);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createPDFFromByteArray(byte[] data, String outputFilePath) {
        try (FileOutputStream fos = new FileOutputStream(outputFilePath);){
            fos.write(data);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String generateFileName(String manifestId) {
        return SP.sParams.getDeliveryLabelDirectory() + File.separator + manifestId + "_manifest_" + new Date().getTime() + ".pdf";
    }

    class Manifest {
        String carrierIdx;
        String manifestId;
        String carrierName;

        public Manifest(String carrier, String id, String CarrierName) {
            this.carrierIdx = carrier;
            this.manifestId = id;
            this.carrierName = CarrierName;
        }
    }

    class Payload {
        private String carrierIdx;
        private String manifestId;

        public Payload(String carrier, String manifest) {
            this.carrierIdx = carrier;
            this.manifestId = manifest;
        }
    }
}

