/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jpos.PosDateFormatter;
import jpos.PosTable;
import jpos.SP;
import jpos.SystemSettings;
import jpos.XMLUtils;
import jpos.custorder.outstanding.CustomerOrder;
import jpos.custorder.outstanding.CustomerOrderTableColumn;
import jpos.custorder.outstanding.CustomerOrderTableModel;
import jpos.custorder.outstanding.OrderTypeIconRenderer;
import jpos.custorder.outstanding.OrderTypeString;
import org.jdom.Element;

public class CustomerOrderTable
extends PosTable {
    private static final int defaultMaxOrders = 200;
    private static final String pickToolip = SP.getRS("Check_All");
    private static final CustomerOrderTableColumn[] defaultColumns = new CustomerOrderTableColumn[]{CustomerOrderTableColumn.IconTimer, CustomerOrderTableColumn.CustOrderNum, CustomerOrderTableColumn.Carrier, CustomerOrderTableColumn.Status, CustomerOrderTableColumn.Pick};
    private CustomerOrderTableModel model = (CustomerOrderTableModel)this.getModel();
    private long totalOrders = 0L;
    private long maxOrders = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.OUTSTANDING_ORDER_DIALOG);

    public CustomerOrderTable(Window parentWindow) {
        super(parentWindow, new CustomerOrderTableModel());
        if (this.maxOrders < 1L) {
            this.maxOrders = 200L;
        }
        this.setDefaultRenderer(OrderTypeString.class, new OrderTypeIconRenderer(this));
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.configureColumn(e);
            }

            private void configureColumn(TableColumnModelEvent e) {
                final int index = e.getToIndex();
                CustomerOrderTableColumn col = CustomerOrderTable.this.model.getColumnType(index);
                if (col != null) {
                    JTableHeader header;
                    final TableColumn tableCol = CustomerOrderTable.this.getColumnModel().getColumn(index);
                    if (col.getWidth() > 0) {
                        tableCol.setPreferredWidth(col.getWidth());
                        if (!col.isResizable()) {
                            tableCol.setMinWidth(col.getWidth());
                            tableCol.setMaxWidth(col.getWidth());
                            tableCol.setResizable(false);
                        }
                    }
                    if (col == CustomerOrderTableColumn.Pick && (header = CustomerOrderTable.this.getTableHeader()) != null) {
                        MouseAdapter listener = new MouseAdapter(){
                            boolean state = false;

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (CustomerOrderTable.this.columnAtPoint(e.getPoint()) == index) {
                                    boolean bl = this.state = !this.state;
                                    if (CustomerOrderTable.this.isEditing()) {
                                        CustomerOrderTable.this.getCellEditor().stopCellEditing();
                                    }
                                    for (int i = 0; i < CustomerOrderTable.this.getRowCount(); ++i) {
                                        CustomerOrderTable.this.setValueAt(this.state, i, index);
                                    }
                                }
                            }

                            @Override
                            public void mouseDragged(MouseEvent e) {
                                this.updateTooltip(e);
                            }

                            @Override
                            public void mouseMoved(MouseEvent e) {
                                this.updateTooltip(e);
                            }

                            private void updateTooltip(MouseEvent e) {
                                TableCellRenderer renderer;
                                int col = header.columnAtPoint(e.getPoint());
                                TableCellRenderer tableCellRenderer = renderer = tableCol.getHeaderRenderer() != null ? tableCol.getHeaderRenderer() : header.getDefaultRenderer();
                                if (renderer instanceof JComponent) {
                                    if (col == index) {
                                        ((JComponent)((Object)renderer)).setToolTipText(pickToolip);
                                    } else {
                                        ((JComponent)((Object)renderer)).setToolTipText(null);
                                    }
                                    header.repaint();
                                }
                            }
                        };
                        header.addMouseListener(listener);
                        header.addMouseMotionListener(listener);
                    }
                }
            }
        });
        this.createColumns();
    }

    private void createColumns() {
        String[] cols = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.OUTSTANDING_ORDER_DIALOG).trim().split("\\W+");
        for (int i = 0; i < cols.length; ++i) {
            try {
                int colId = Integer.parseInt(cols[i]);
                CustomerOrderTableColumn col = CustomerOrderTableColumn.getById(colId);
                if (col == null) continue;
                this.model.addColumn(col);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.model.getColumnCount() == 0) {
            for (CustomerOrderTableColumn col : defaultColumns) {
                this.model.addColumn(col);
            }
        }
    }

    public void addColumn(CustomerOrderTableColumn column) {
        this.model.addColumn(column);
    }

    public void addOrders(List<CustomerOrder> orders, boolean overwrite) {
        this.model.addOrders(orders, overwrite);
    }

    public void addOrder(CustomerOrder order) {
        this.model.addOrder(order);
    }

    public CustomerOrder getOrder(int row) {
        return this.model.getOrder(row);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public boolean populateOutstandingOrders(boolean limited) {
        long maxOrders;
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.totalOrders = 0L;
        long l = maxOrders = limited ? this.maxOrders : -1L;
        if (SP.sParams.checkIConn()) {
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("outst_web_orders", Long.toString(SP.sParams.getStoreIdx()) + ',' + Long.toString(maxOrders)).getXML();
            if (result != null) {
                this.totalOrders = XMLUtils.getLongValue(result, "count");
                ArrayList<CustomerOrder> orders = new ArrayList<CustomerOrder>();
                PosDateFormatter formatter = new PosDateFormatter(null, 3, 3, 2);
                List orderElements = result.getChildren();
                for (Object order : orderElements) {
                    orders.add(new CustomerOrder((Element)order, formatter));
                }
                this.model.addOrders(orders, true);
            }
            return true;
        }
        return false;
    }

    public long getTotalOrderCount() {
        return this.totalOrders;
    }

    public CustomerOrder getSelectedOrder() {
        return this.model.getOrder(this.getSelectedRow());
    }

    public List<String> getOrderDocketsToPrint() {
        return this.model.getOrderDocketsToPrint();
    }

    public List<CustomerOrder> getOrdersToPrint() {
        return this.model.getOrdersToPrint();
    }

    public boolean isPrintColumnVisible() {
        return this.model.isPrintColumnVisible();
    }

    public void filter(String searchString) {
        this.model.filter(searchString);
        this.selectFirstRow();
    }

    public void removeOrder(CustomerOrder order) {
        int row = this.model.getOrderRow(order);
        int col = this.model.columns.indexOf(CustomerOrderTableColumn.Pick);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.setValueAt(false, row, col);
        this.model.removeOrder(order);
    }
}

