/*
 * Decompiled with CFR 0.152.
 */
package jpos.display.device;

import ReceiptPrinter.Gen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import jpos.ErrorHandler;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.display.device.DisplayDeviceCaps;
import jpos.display.device.DisplayDeviceProvider;

public class PosSaleDisplayDevice {
    private StoreParams storeParams;
    private DisplayDeviceProvider displayProvider;
    private DisplayDeviceCaps deviceCaps;
    private double lastDiscountAmount;
    private boolean isDisabled;
    private boolean makeNextWelcomeMessageAThankYouInstead;
    private DecimalFormat dfDet;

    public PosSaleDisplayDevice(StoreParams sparams) {
        this.storeParams = sparams;
        this.displayProvider = new DisplayDeviceProvider(this.storeParams.displayDeviceName);
        try {
            this.deviceCaps = this.displayProvider.getDeviceCaps();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.deviceCaps = new DisplayDeviceCaps();
            this.deviceCaps.characterCount = 20;
            this.deviceCaps.lineCount = 2;
        }
        StringBuffer sDet = new StringBuffer();
        StringBuffer sTot = new StringBuffer();
        StringBuffer sPrec = new StringBuffer();
        Gen.getCurrencyFmt(this.storeParams.conn, sTot, sDet, sPrec);
        this.dfDet = new DecimalFormat(sDet.toString());
        this.lastDiscountAmount = 0.0;
    }

    public void setIsDisabled(boolean value) {
        this.isDisabled = value;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    private Boolean useThankyouMessage() {
        return new File(this.getThankyouFileName()).exists();
    }

    private String getThankyouFileName() {
        return "./DisplayDeviceThankyouMessage.txt";
    }

    public void ambushNextWelcomeWithAThankyou() {
        if (this.useThankyouMessage().booleanValue()) {
            this.makeNextWelcomeMessageAThankYouInstead = true;
        }
    }

    public void displayWelcomeMessage() {
        if (this.isDisabled) {
            return;
        }
        if (this.makeNextWelcomeMessageAThankYouInstead) {
            this.displayThankyouMessage();
            return;
        }
        this.displayMessage(MessageFormat.format(StoreParams.res.getString("line_device_welcome_message"), this.storeParams.getStore().getName()), true);
        this.lastDiscountAmount = 0.0;
    }

    public void displayThankyouMessage() {
        if (this.isDisabled) {
            return;
        }
        this.makeNextWelcomeMessageAThankYouInstead = false;
        if (this.useThankyouMessage().booleanValue()) {
            this.displayMessage(this.getThankyouMessage(), true);
        }
        this.lastDiscountAmount = 0.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getThankyouMessage() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getThankyouFileName()));){
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void clearDisplayScreen() {
        if (this.isDisabled) {
            return;
        }
        this.displayMessage("", false);
        this.lastDiscountAmount = 0.0;
    }

    public void productChange(long skuIdx, double price, boolean quantityIncreased, double totalDiscount) {
        if (this.isDisabled) {
            return;
        }
        double calculatedDiscountChange = PosUtils.scale(totalDiscount - this.lastDiscountAmount, this.storeParams.storeCurrency.getPrecision());
        this.lastDiscountAmount = totalDiscount;
        String productName = this.getProductName(skuIdx);
        String formattedPrice = this.formatInCurrency(price, quantityIncreased);
        String formattedDiscount = this.formatInCurrency(Math.abs(calculatedDiscountChange), !(calculatedDiscountChange >= 0.0));
        int characterWidth = this.deviceCaps.characterCount;
        String productLine = this.mergeStrings(productName, formattedPrice, characterWidth);
        String discountLine = this.mergeStrings("Discount", formattedDiscount, characterWidth);
        this.displayMessage(String.format("%s\r\n%s", productLine, calculatedDiscountChange == 0.0 ? "" : discountLine), false);
    }

    public void discountChange(double newTotalDiscount) {
        if (this.isDisabled) {
            return;
        }
        double calculatedDiscountChange = PosUtils.scale(newTotalDiscount - this.lastDiscountAmount, this.storeParams.storeCurrency.getPrecision());
        this.lastDiscountAmount = newTotalDiscount;
        int characterWidth = this.deviceCaps.characterCount;
        String formattedDiscount = this.formatInCurrency(Math.abs(calculatedDiscountChange), !(calculatedDiscountChange >= 0.0));
        String discountLine = this.mergeStrings("Discount", formattedDiscount, characterWidth);
        this.displayMessage(discountLine, false);
    }

    public void showPaymentTotal(double totalDiscount, double totalDue) {
        if (this.isDisabled) {
            return;
        }
        String formattedDiscount = this.formatInCurrency(Math.abs(totalDiscount), !(totalDiscount >= 0.0));
        String formattedPrice = this.formatInCurrency(Math.abs(totalDue), totalDue >= 0.0);
        int characterWidth = this.deviceCaps.characterCount;
        String discountLine = this.mergeStrings("Discount", formattedDiscount, characterWidth);
        String dueLine = this.mergeStrings("Total Due", formattedPrice, characterWidth);
        this.displayMessage(String.format("%s\r\n%s", discountLine, dueLine), false);
    }

    public void ResetDiscounts() {
        if (this.isDisabled) {
            return;
        }
        this.lastDiscountAmount = 0.0;
    }

    private void displayMessage(String message, boolean scroll) {
        try {
            if (!this.displayProvider.displayMessage(message, scroll)) {
                ErrorHandler.logMessage(StoreParams.res.getString("failed_to_display"));
            }
        }
        catch (Exception e) {
            ErrorHandler.logMessage(e.getMessage());
        }
    }

    private String mergeStrings(String leftString, String rightString, int characterWidth) {
        int maxLeftStringLength = characterWidth - rightString.length() - 1;
        if (maxLeftStringLength == leftString.length()) {
            return String.format("%s %s", leftString, rightString);
        }
        if (maxLeftStringLength < leftString.length()) {
            return String.format("%s %s", leftString.substring(0, Math.min(maxLeftStringLength, leftString.length())), rightString);
        }
        return String.format("%s %s", PosUtils.PadLeft(leftString, maxLeftStringLength, " "), rightString);
    }

    private String formatInCurrency(double amount, boolean quantityIncreased) {
        return (quantityIncreased ? "" : "-") + this.dfDet.format(amount);
    }

    /*
     * Exception decompiling
     */
    private String getProductName(long skuIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

