/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import jpos.PosDateFormatter;
import jpos.XMLUtils;
import org.jdom.Element;

public class FITSession {
    private static final DateTimeFormatter INSTANT_CREATOR = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneOffset.UTC);
    private long mySessionID = 0L;
    private String memName = "";
    private String custName = "";
    private String myFitSessionID = "";
    private String timeCreated;
    private long sRepPeridx = 0L;
    private long personIdx = 0L;

    public FITSession(Element session, PosDateFormatter dateFormatter) {
        this.mySessionID = XMLUtils.getLongValue(session, "ms_id");
        this.memName = XMLUtils.getValue(session, "salesrep");
        this.custName = XMLUtils.getValue(session, "person");
        this.myFitSessionID = XMLUtils.getValue(session, "myfitsession_id");
        this.timeCreated = XMLUtils.getValue(session, "time_created");
        this.sRepPeridx = XMLUtils.getLongValue(session, "sRepPeridx");
        this.personIdx = XMLUtils.getLongValue(session, "personIdx");
    }

    public long getSessionID() {
        return this.mySessionID;
    }

    public long getsRepPeridx() {
        return this.sRepPeridx;
    }

    public long getPersonIdx() {
        return this.personIdx;
    }

    public String getMemName() {
        return this.memName;
    }

    public String getCustName() {
        return this.custName;
    }

    public String getFitSession() {
        return this.myFitSessionID;
    }

    public String getTimeCreated() {
        return this.timeCreated;
    }

    public boolean search(String searchString) {
        String[] words;
        boolean found = false;
        for (String word : words = searchString.trim().toUpperCase().split("\\s+")) {
            if (word.length() <= 0) continue;
            if (this.custName.toUpperCase().contains(word)) {
                found = true;
            }
            if (!this.memName.toUpperCase().contains(word)) continue;
            found = true;
        }
        return found;
    }
}

