/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.labelprinting.TemplateParser;

public class LabelWriter {
    private Vector<NameValuePair> values = new Vector();
    private Boolean escapeStrings = false;
    private String labelTemplate;

    public LabelWriter(String labelTemplate) {
        this.labelTemplate = StringUtils.nullToEmpty(labelTemplate);
    }

    public Boolean getEscapeStrings() {
        return this.escapeStrings;
    }

    public void setEscapeStrings(Boolean escapeStrings) {
        this.escapeStrings = escapeStrings;
    }

    public void addValue(String key, String value) {
        if (key == null) {
            return;
        }
        this.values.add(new NameValuePair(key, value));
    }

    public String toString() {
        String result = "";
        try {
            TemplateParser parser = new TemplateParser(this.labelTemplate);
            for (NameValuePair value : this.values) {
                parser.replaceToken(value.getName(), this.escapeStrings != false ? this.escapeDoubleQuotes(value.getValue()) : value.getValue());
            }
            parser.processConditions();
            result = parser.toString();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return result;
    }

    public void clearList() {
        this.values.clear();
    }

    private String escapeDoubleQuotes(String value) {
        if (value == null || value == "") {
            return "";
        }
        return value.replace("\"", "\"\"");
    }

    public boolean sendLabelToDestination(int quantity) {
        try {
            String directoryName = SP.sParams.getLabelPrintingPath();
            String destinationFileName = "";
            if (!directoryName.startsWith("\\\\") && !directoryName.startsWith("//")) {
                boolean folderExists = true;
                File printDirectory = new File(directoryName);
                if (!printDirectory.exists()) {
                    folderExists = printDirectory.mkdirs();
                }
                if (!folderExists) {
                    return false;
                }
                destinationFileName = "label_" + String.valueOf(new Date().getTime()) + ".txt";
                while (new File(directoryName + destinationFileName).exists()) {
                    destinationFileName = "label_" + String.valueOf(new Date().getTime()) + ".txt";
                }
            }
            try (OutputStreamWriter outStream = new OutputStreamWriter(new FileOutputStream(directoryName + destinationFileName));){
                for (int i = 0; i < quantity; ++i) {
                    outStream.write(this.toString());
                    outStream.write("\r\n");
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class NameValuePair {
        private String name;
        private String value;

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

