/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.StringUtils;
import jpos.labelprinting.ITemplateFunction;
import jpos.labelprinting.IThreeParamCheckCondition;
import jpos.labelprinting.ITwoParamCheckCondition;

public class TemplateParser {
    private String templateContent;

    public TemplateParser(String templateContent) {
        this.templateContent = templateContent;
    }

    public void replaceToken(String token, String replaceWith) {
        Matcher matcher;
        if (token == null || this.templateContent == null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\{" + token + "((:([0-9]*?))|(:([a-zA-Z]?)))*?\\}", 2);
        while ((matcher = pattern.matcher(this.templateContent)).find()) {
            int length;
            String replacement;
            String string = replacement = replaceWith == null ? "" : replaceWith;
            if (matcher.group(5) != null) {
                switch (matcher.group(5).toUpperCase().charAt(0)) {
                    case 'U': {
                        replacement = replacement.toUpperCase();
                        break;
                    }
                    case 'L': {
                        replacement = replacement.toLowerCase();
                        break;
                    }
                    case 'S': {
                        replacement = replacement.replaceAll(".", "_");
                    }
                }
            }
            if (matcher.group(3) != null && (length = PosUtils.intVal(matcher.group(3))) > 0 && length < replacement.length()) {
                replacement = replacement.substring(0, length);
            }
            this.templateContent = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
        }
    }

    private void processFunctions() {
        for (Function function : Function.values()) {
            Matcher matcher;
            Pattern pattern = this.generateOperatorPattern(function.getCommand(), 2, true);
            while ((matcher = pattern.matcher(this.templateContent)).find()) {
                String replacement = "";
                String value1 = StringUtils.nullToEmpty(matcher.group(1));
                String value2 = StringUtils.nullToEmpty(matcher.group(2));
                replacement = function.evaluate(value1, value2);
                this.templateContent = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
            }
        }
    }

    public void processConditions() {
        String value2;
        String value1;
        String replacement;
        Matcher matcher;
        Pattern pattern;
        this.processFunctions();
        for (TwoParamCondition twoParamCondition : TwoParamCondition.values()) {
            pattern = this.generateOperatorPattern(twoParamCondition.getCommand(), 3, false);
            while ((matcher = pattern.matcher(this.templateContent)).find()) {
                replacement = "";
                value1 = StringUtils.nullToEmpty(matcher.group(1));
                if (twoParamCondition.check(value1, value2 = StringUtils.nullToEmpty(matcher.group(2)))) {
                    replacement = StringUtils.nullToEmpty(matcher.group(3));
                }
                this.templateContent = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
            }
        }
        for (Enum enum_ : ThreeParamCondition.values()) {
            pattern = this.generateOperatorPattern(((ThreeParamCondition)enum_).getCommand(), 4, false);
            while ((matcher = pattern.matcher(this.templateContent)).find()) {
                String value3;
                replacement = "";
                value1 = StringUtils.nullToEmpty(matcher.group(1));
                if (((ThreeParamCondition)enum_).check(value1, value2 = StringUtils.nullToEmpty(matcher.group(2)), value3 = StringUtils.nullToEmpty(matcher.group(3)))) {
                    replacement = StringUtils.nullToEmpty(matcher.group(4));
                }
                this.templateContent = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
            }
        }
    }

    private Pattern generateOperatorPattern(String conditionName, int parameters, boolean lazyParameterMatch) {
        StringBuilder patternText = new StringBuilder("\\{" + conditionName);
        for (int i = 0; i < parameters; ++i) {
            patternText.append(":\\((.*" + (lazyParameterMatch ? "?" : "") + ")\\)");
        }
        patternText.append("\\}");
        return Pattern.compile(patternText.toString(), 2);
    }

    public void removeXMLTag(String tag, boolean emptyTagOnly) {
        Matcher matcher;
        if (tag == null || this.templateContent == null) {
            return;
        }
        Pattern pattern = !emptyTagOnly ? Pattern.compile("\\<" + tag + ">[\\s\\S]*?<\\/" + tag + ">", 8) : Pattern.compile("\\<" + tag + ">[\\s]*?<\\/" + tag + ">", 8);
        while ((matcher = pattern.matcher(this.templateContent)).find()) {
            String replacement = "";
            this.templateContent = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
        }
    }

    public String toString() {
        return this.templateContent;
    }

    private static enum Function {
        MAX("MAX", (value1, value2) -> {
            double dVal2;
            double dVal1 = new PosDouble(value1).doubleValue();
            if (dVal1 > (dVal2 = new PosDouble(value2).doubleValue())) {
                return value1;
            }
            return value2;
        }),
        MIN("MIN", (value1, value2) -> {
            double dVal2;
            double dVal1 = new PosDouble(value1).doubleValue();
            if (dVal1 < (dVal2 = new PosDouble(value2).doubleValue())) {
                return value1;
            }
            return value2;
        });

        private String command;
        private ITemplateFunction function;

        private Function(String command, ITemplateFunction function) {
            this.command = command;
            this.function = function;
        }

        public String getCommand() {
            return this.command;
        }

        public String evaluate(String value1, String value2) {
            return this.function.evaluate(value1, value2);
        }
    }

    private static enum ThreeParamCondition {
        BETWEEN_INCLUSIVE("BETWEEN_IN", (value1, value2, value3) -> {
            double dVal1 = new PosDouble(value1).doubleValue();
            double dVal2 = new PosDouble(value2).doubleValue();
            double dVal3 = new PosDouble(value3).doubleValue();
            return dVal2 >= dVal1 && dVal3 >= dVal2;
        }),
        BETWEEN_EXCLUSIVE("BETWEEN_EX", (value1, value2, value3) -> {
            double dVal1 = new PosDouble(value1).doubleValue();
            double dVal2 = new PosDouble(value2).doubleValue();
            double dVal3 = new PosDouble(value3).doubleValue();
            return dVal2 > dVal1 && dVal3 > dVal2;
        });

        private String command;
        private IThreeParamCheckCondition operation;

        private ThreeParamCondition(String command, IThreeParamCheckCondition operation) {
            this.command = command;
            this.operation = operation;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean check(String value1, String value2, String value3) {
            return this.operation.check(value1, value2, value3);
        }
    }

    private static enum TwoParamCondition {
        STRING_EQUAL("STREQU", (value1, value2) -> value1.equals(value2)),
        STRING_NOT_EQUAL("STRNEQ", (value1, value2) -> !value1.equals(value2)),
        EQUAL("EQU", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) == 0),
        NOT_EQUAL("NEQ", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) != 0),
        LESS_THAN("LSS", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) < 0),
        LESS_THAN_OR_EQUAL("LEQ", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) <= 0),
        GREATER_THAN("GTR", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) > 0),
        GREATER_THAN_OR_EQUAL("GEQ", (value1, value2) -> new PosDouble(value1).compareTo(new PosDouble(value2)) >= 0);

        private String command;
        private ITwoParamCheckCondition operation;

        private TwoParamCondition(String command, ITwoParamCheckCondition operation) {
            this.command = command;
            this.operation = operation;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean check(String value1, String value2) {
            return this.operation.check(value1, value2);
        }
    }
}

