/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import jpos.StyleLine;
import jpos.User;
import jpos.logging.RollingLog;
import jpos.omneo.OmneoAPI;
import jpos.omneo.OmneoDataTransaction;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RewardsAccount;

public class OmneoApiManager
implements IRewardsApiManager {
    private OmneoDataTransaction dataTransaction;
    private OmneoAPI api;
    private RedemptionState state = RedemptionState.UNUSED;

    public OmneoApiManager() {
        this.api = new OmneoAPI();
        this.dataTransaction = new OmneoDataTransaction();
        this.reverseAllIncompleteRedemptions();
    }

    @Override
    public boolean requestBalance(String cardNo, long peridx) {
        this.reverseAllIncompleteRedemptions();
        return this.api.requestBalance(cardNo);
    }

    @Override
    public boolean hasUncommittedRedemption() {
        return this.state == RedemptionState.REDEEMED;
    }

    @Override
    public boolean hasRequestedRedemption() {
        return this.state == RedemptionState.REQUESTED;
    }

    @Override
    public void setCardNo(String cardNo) {
        this.dataTransaction.setCardNumber(cardNo);
    }

    @Override
    public void setPerIdx(long perIdx) {
    }

    @Override
    public void setRequestAmount(double amount) {
        this.dataTransaction.setAmount(amount);
        RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("Requested redemption of %s from loyalty card %s", amount, this.dataTransaction.getCardNumber()));
        this.state = amount > 0.0 ? RedemptionState.REQUESTED : RedemptionState.UNUSED;
    }

    @Override
    public void setRequestGifts(Vector<StyleLine> gifts) {
        if (gifts != null && gifts.size() > 0) {
            throw new UnsupportedOperationException("Omneo has no concept of gifts");
        }
    }

    @Override
    public double getBalance() {
        return this.api.getBalance();
    }

    @Override
    public String getLastError() {
        return this.api.getLastError();
    }

    @Override
    public boolean redeem(User user) {
        if (this.state == RedemptionState.REDEEMED) {
            return true;
        }
        if (this.dataTransaction != null && this.state == RedemptionState.REQUESTED) {
            if (this.api.requestRedeem(this.dataTransaction.getCardNumber(), user.getMemidx(), this.dataTransaction.getAmount())) {
                String omneoTransactionId = this.api.getRedemptionId();
                this.dataTransaction.saveRedeption(omneoTransactionId, user.getMemidx());
                this.state = RedemptionState.REDEEMED;
                RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("successfully redeemed %s from card %s", this.dataTransaction.getAmount(), this.dataTransaction.getCardNumber()));
                return true;
            }
            RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("Failed to redeem %s from card %s\nError: %s", this.dataTransaction.getAmount(), this.dataTransaction.getCardNumber(), this.api.getLastError()));
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseTransaction() {
        if (this.dataTransaction != null && this.state == RedemptionState.REDEEMED) {
            if (this.api.requestReverse(this.dataTransaction.getCardNumber(), this.dataTransaction.getOmneoTransactionId())) {
                this.dataTransaction.reverseRedeption();
                this.state = RedemptionState.CANCELED;
                RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("successfully reversed %s from card %s", this.dataTransaction.getAmount(), this.dataTransaction.getCardNumber()));
                return true;
            }
            this.dataTransaction.logFailedReversal();
            RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("Failed to reverse %s from card %s\nError: %s", this.dataTransaction.getAmount(), this.dataTransaction.getCardNumber(), this.api.getLastError()));
            return false;
        }
        return false;
    }

    @Override
    public boolean commitTransaction(long vhidx) {
        if (this.dataTransaction != null && this.state == RedemptionState.REDEEMED && this.dataTransaction.finishRedeption(vhidx)) {
            this.state = RedemptionState.COMPLETED;
            RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("Completed transaction vhidx %s ", vhidx));
            return true;
        }
        return false;
    }

    @Override
    public void reverseAllIncompleteRedemptions() {
        ArrayList<OmneoDataTransaction> list = OmneoDataTransaction.getAllTransactionsToReverse();
        for (OmneoDataTransaction o : list) {
            if (this.api.requestReverse(o.getCardNumber(), o.getOmneoTransactionId())) {
                o.reverseRedeption();
                RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("successfully reversed %s from card %s", o.getAmount(), o.getCardNumber()));
                continue;
            }
            o.logFailedReversal();
            RollingLog.log(RollingLog.LogType.OMNEO, Level.INFO, String.format("Failed to reverse %s from card %s\nError: %s", o.getAmount(), o.getCardNumber(), this.api.getLastError()));
        }
    }

    @Override
    public boolean loadAccount(long peridx) {
        return false;
    }

    @Override
    public long getAccountId() {
        return 0L;
    }

    @Override
    public boolean signUp(long peridx, long programId, User user) {
        return false;
    }

    @Override
    public RewardsAccount getAccount() {
        return null;
    }

    @Override
    public double getTierMinimumSpend() {
        return 0.0;
    }

    private static enum RedemptionState {
        UNUSED,
        REQUESTED,
        REDEEMED,
        CANCELED,
        COMPLETED;

    }
}

