/*
 * Decompiled with CFR 0.152.
 */
package jpos.onlinequeries;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.Settings;
import jpos.StoreParams;
import jpos.onlinequeries.OnlineQuery;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class OnlineQueryProvider
extends JcpObject {
    private int onlineQueryProviderID = -1;
    private StoreParams storeparams;

    public OnlineQueryProvider(StoreParams storeparams) {
        this.storeparams = storeparams;
    }

    public StoreParams getStoreParams() {
        return this.storeparams;
    }

    private int getOnlineQueryProviderInstance() {
        if (this.onlineQueryProviderID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.OnlineQueryProvider", (Object[])new Object[0]);
                if (!result.getSuccess()) {
                    throw new Exception(result.getCustomMessage() + "\r\n" + result.getErrorMessage() + "\r\n" + result.getStackTrace());
                }
                this.onlineQueryProviderID = result.getRequestResultAsInt();
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.onlineQueryProviderID = -1;
            }
        }
        return this.onlineQueryProviderID;
    }

    public OnlineQuery getOnlineQuery(String queryType, String data) {
        return new OnlineQuery(this, queryType, data.replace("\u0003", "#{CHR3};"), true);
    }

    public OnlineQuery getOnlineQuery(String queryType, String data, boolean loggingAllowed) {
        return new OnlineQuery(this, queryType, data.replace("\u0003", "#{CHR3};"), loggingAllowed);
    }

    public Element executeAndReturnElement(OnlineQuery onlineQuery, boolean showDialogs) throws Exception {
        if (this.getOnlineQueryProviderInstance() > 0 && !this.storeparams.misMatchVersion) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.onlineQueryProviderID, (String)"ExecuteQuery", (Object[])new Object[]{onlineQuery.getQueryType(), onlineQuery.getQueryData()});
            if (result.getSuccess()) {
                Element element = this.processResult(result, onlineQuery, showDialogs);
                return element;
            }
            throw new Exception(result.getErrorMessage());
        }
        return null;
    }

    private Element processResult(JcpRequestResult result, OnlineQuery onlineQuery, boolean showDialogs) {
        try {
            String resultString = result.getRequestResultAsXmlString();
            OnlineQueryProvider.logOnlineQuery(resultString, onlineQuery);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(resultString));
            Element returnXml = doc.getRootElement();
            if (returnXml.getName().equals("Error")) {
                if (returnXml.getAttribute("desc").getValue().equals("LinkDown")) {
                    this.storeparams.getStatusListener().setStatus(false);
                    return null;
                }
                if (!returnXml.getAttribute("desc").getValue().equals("No Docket")) {
                    if (returnXml.getChild("Exception") != null) {
                        String error_message = returnXml.getChild("Exception").getAttributeValue("error_message").replace("\n", "\r\n");
                        PosUtils.logError(String.format("%s\r\n%s", returnXml.getAttribute("desc").getValue(), error_message));
                    } else if (showDialogs) {
                        DlgMessage.showMessage(null, returnXml.getAttribute("desc").getValue(), StoreParams.res.getString("Error"), -1, 0);
                    }
                }
                return null;
            }
            return returnXml;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    private static void logOnlineQuery(String payload, OnlineQuery onlineQuery) {
        block26: {
            try {
                if (!onlineQuery.isLoggingAllowed() || !Settings.isOnlineQueryWriteToDisk()) break block26;
                PosUtils.createDirectory("OnlineQueryOutput");
                long uniqueId = Calendar.getInstance().getTimeInMillis();
                File queryDataFile = new File("OnlineQueryOutput", String.format("IIS_%s_%d.txt", onlineQuery.getQueryType(), uniqueId));
                queryDataFile.createNewFile();
                try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(queryDataFile), "UTF8"));){
                    out.write(onlineQuery.getQueryData());
                }
                File queryOutputFile = new File("OnlineQueryOutput", String.format("IIS_%s_%d.xml", onlineQuery.getQueryType(), uniqueId));
                queryOutputFile.createNewFile();
                try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(queryOutputFile), "UTF8"));){
                    out.write(payload);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.onlineQueryProviderID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.onlineQueryProviderID);
            this.onlineQueryProviderID = -1;
        }
    }
}

