/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DespatchInfo;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;

public class CustOrderPaymentDlg
extends PayDialog {
    private boolean finaliseOrder = false;
    private double outstanding = 0.0;
    private double totalOutstandingBalance = 0.0;
    private RetTranP lastRetTranP;
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelNormal lPickupTotal = new LabelNormal();
    private DecimalField dfPickupTotal;
    private double pickupTotal;
    private LabelNormal lTotalPaid;
    private DecimalField dfTotalPaid;
    private double totalPaid;
    private LabelNormal lBalanceDue;
    private DecimalField dfBalanceDue;
    private double balanceDue;
    private double balanceDueDisplay;
    private LabelNormal lThisPayment;
    private DecimalField dfThisPayment;
    private double thisPayment;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;
    private DialogButton bReverseLast;

    public CustOrderPaymentDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfPickupTotal = new DecimalField(SP.sParams.storeCurrency);
        this.lTotalPaid = new LabelNormal();
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency);
        this.lBalanceDue = new LabelNormal();
        this.dfBalanceDue = new DecimalField(SP.sParams.storeCurrency);
        this.lThisPayment = new LabelNormal();
        this.dfThisPayment = new DecimalField(SP.sParams.storeCurrency);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        this.bReverseLast = new DialogButton("", this){

            @Override
            public int getButtonWidth() {
                return 160;
            }
        };
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lPickupTotal.setText(SP.getRS("pickup_total"));
        this.setAmtFieldProp(this.dfPickupTotal);
        this.dfPickupTotal.setEnabled(false);
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.setAmtFieldProp(this.dfTotalPaid);
        this.dfTotalPaid.setEnabled(false);
        this.lBalanceDue.setText(SP.getRS("balance_due"));
        this.setAmtFieldProp(this.dfBalanceDue);
        this.dfBalanceDue.setEnabled(false);
        this.lThisPayment.setText(SP.getRS("this_payment"));
        this.setAmtFieldProp(this.dfThisPayment);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)this.lPickupTotal, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfPickupTotal, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lBalanceDue, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfBalanceDue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lThisPayment, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDets.add((Component)this.dfThisPayment, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.panelDets.add((Component)this.bReverseLast, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.dfPickupTotal.setText("");
        this.dfTotalPaid.setText("");
        this.dfBalanceDue.setText("");
        this.dfThisPayment.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.bReverseLast.setText(SP.getRS("reverse_last_payment"));
        this.bReverseLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CustOrderPaymentDlg.this.isRunning && CustOrderPaymentDlg.this.isVisible()) {
                    CustOrderPaymentDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustOrderPaymentDlg.this.ReverseLast();
                            CustOrderPaymentDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 1, 1));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 1, 1));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.dfThisPayment);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public boolean initDialog() {
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        this.dfBalanceDue.setText(this.balanceDueDisplay);
        this.dfTotalPaid.setText(this.totalPaid);
        this.dfPickupTotal.setText(this.pickupTotal);
        this.dfThisPayment.setText(this.thisPayment);
        this.bReverseLast.setEnabled(this.lastRetTranP != null);
    }

    public double getPaymentAmt() {
        return this.dfThisPayment.getDouble();
    }

    @Override
    public void okDialog() {
        double thisPayment = PayType.roundDec(this.dfThisPayment.getDouble());
        if (this.finaliseOrder && thisPayment != this.balanceDue) {
            DlgMessage.showMessage(this, StoreParams.res.getString("cust_order_balance_must_be_paid"), StoreParams.res.getString("cust_order_payment"), 1);
            this.dfThisPayment.setText(this.balanceDue);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        if (thisPayment > this.outstanding) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cust_order_max_payment"), PosDouble.valueOf(this.outstanding).toString()), StoreParams.res.getString("cust_order_payment"), 1);
            this.dfThisPayment.setText(this.outstanding);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        if (thisPayment < this.balanceDue) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cust_order_min_payment"), PosDouble.valueOf(this.balanceDue).toString()), StoreParams.res.getString("cust_order_payment"), 1);
            this.dfThisPayment.setText(this.balanceDue);
            this.dfThisPayment.requestFocus();
            this.dfThisPayment.selectAll();
            return;
        }
        this.thisPayment = this.dfThisPayment.getDouble();
        super.okDialog();
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.setVisible(false);
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 117) {
            this.bReverseLast.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setOrderDets(double pDueTotal, double pPickupTotal, double pTakenTotal, List<?> pOldTendersXML, boolean finaliseOrder, DeliveryInfo deliveryInfo, boolean refundOrder) {
        Vector<RetTranP> vOldRetTranPs = new Vector<RetTranP>();
        this.finaliseOrder = finaliseOrder;
        double paidPreviously = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, vOldRetTranPs);
        this.totalPaid = paidPreviously - pTakenTotal;
        this.lastRetTranP = PayUtils.tendersXMLToLastLaybyRetTranP(pOldTendersXML);
        double outstanding = PayType.roundDec(pDueTotal - paidPreviously);
        this.outstanding = outstanding < 0.0 && !finaliseOrder && !refundOrder ? 0.0 : outstanding;
        this.totalOutstandingBalance = outstanding;
        this.balanceDue = deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT || refundOrder ? this.outstanding : PayType.roundDec(pPickupTotal - this.totalPaid);
        this.balanceDueDisplay = this.balanceDue < 0.0 && !finaliseOrder && !refundOrder ? 0.0 : this.balanceDue;
        this.pickupTotal = pPickupTotal;
        this.lPickupTotal.setText(SP.getRS("pickup_total"));
        if (finaliseOrder) {
            this.setTitle(SP.getRS("cust_order_payment_finalise"));
        } else {
            this.setTitle(SP.getRS("cust_order_payment"));
        }
        this.thisPayment = this.balanceDueDisplay;
    }

    public void ReverseLast() {
        if (this.lastRetTranP != null) {
            this.dfThisPayment.setText(this.lastRetTranP.getAmount());
            super.okDialog();
        }
    }

    @Override
    protected boolean inStealthMode() {
        return this.thisPayment == 0.0 && (this.totalOutstandingBalance == 0.0 || this.frSales.despatchInfo != null && this.frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH);
    }

    @Override
    protected void stealthModeAction() {
        this.setStealthModeDone(true);
        this.okDialog();
    }
}

