/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.afterpay;

import java.awt.Window;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import jpos.DlgMessage;
import jpos.ExceptionInjector;
import jpos.PosDateFormatter;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.pay.PaymentGatewayConfig;
import jpos.pay.afterpay.AfterpayOnlineAPI;
import jpos.pay.afterpay.AfterpayOnlineAPIEntity;
import jpos.pay.afterpay.AfterpayOnlineAPIErrorException;
import jpos.pay.afterpay.AfterpayTran;

public class AfterpayGateway {
    private static final String NOT_FOUND_CODE = "not_found";
    private static AfterpayGateway gateway;
    private StoreParams storeParams;
    private AfterpayOnlineAPI api;

    public static AfterpayGateway getInstance() {
        if (gateway == null) {
            gateway = new AfterpayGateway();
        }
        return gateway;
    }

    public static void initialise() {
        AfterpayGateway.getInstance().initialiseGateway(SP.sParams);
        try {
            AfterpayGateway.reverseIncompleteAfterpayTrans(PosMenuController.getInstance().getOpenFrame());
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static boolean exists() {
        return AfterpayGateway.getInstance().isConfigured();
    }

    private boolean initialiseGateway(StoreParams params) {
        this.storeParams = params;
        this.api = null;
        PaymentGatewayConfig afterpay = null;
        afterpay = params.getPaymentGatewayConfig(PaymentGatewayConfig.PaymentGatewayType.AFTER_PAY);
        if (afterpay == null) {
            return false;
        }
        String apiUrl = afterpay.getApiUrl();
        String merchantId = afterpay.getMerchantID();
        String key = afterpay.getPassword();
        if (StringUtils.isNullOrEmpty(apiUrl) || StringUtils.isNullOrEmpty(merchantId) || StringUtils.isNullOrEmpty(merchantId)) {
            return false;
        }
        String userAgent = MessageFormat.format("AfterpayGateway/1.0.0 (AP21POS/{0}; Java/{1}; Merchant/{2})", AfterpayGateway.cleanString(StoreParams.VERSION), AfterpayGateway.cleanString(System.getProperty("java.version")), AfterpayGateway.cleanString(merchantId));
        this.api = new AfterpayOnlineAPI(apiUrl, userAgent, merchantId, key);
        return true;
    }

    private static String cleanString(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("[^a-zA-Z0-9._ ]+", "");
    }

    public boolean isConfigured() {
        return this.api != null;
    }

    private AfterpayOnlineAPIEntity.RefundResponse getRefund(Window parent, String orderId, String refundRequestId, String refundReference, double amount) throws AfterpayOnlineAPIErrorException {
        while (true) {
            try {
                ExceptionInjector.Inject(ExceptionInjector.Process.AFTERPAYGATEWAY_GET_REFUND_FAILURE, new AfterpayOnlineAPIErrorException("Injected Failure Exception", new AfterpayOnlineAPIEntity.ErrorResponse("injected_exception", "0000", "Injected Failure Exception", 400)));
                ExceptionInjector.Inject(ExceptionInjector.Process.AFTERPAYGATEWAY_GET_REFUND_UNKNOWN, new AfterpayOnlineAPIErrorException("Injected Unknown Exception"));
                AfterpayOnlineAPIEntity.OrderResponse order = this.api.getOrder(orderId);
                if (order.refunds != null) {
                    for (AfterpayOnlineAPIEntity.RefundResponse refund : order.refunds) {
                        if (!refundRequestId.equals(refund.requestId) || !refundReference.equals(refund.merchantReference)) continue;
                        return refund;
                    }
                }
                return null;
            }
            catch (AfterpayOnlineAPIErrorException e) {
                if (e.getHttpStatusCode() != 404 || !e.getErrorCode().equals(NOT_FOUND_CODE)) continue;
                return null;
                if (e.isResultUnknown() && DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_retry_get_refund"), "\n", SP.sParams.storeCurrency.formatDetailNoScale(amount), orderId, e.getErrorMessage()), SP.getRS("afterpay_dlg_error"), 0, 0) == 0) continue;
                throw e;
            }
            break;
        }
    }

    private AfterpayOnlineAPIEntity.RefundResponse createRefund(Window parent, AfterpayOnlineAPIEntity.RefundRequest request, String orderId) throws AfterpayOnlineAPIErrorException {
        while (true) {
            try {
                ExceptionInjector.Inject(ExceptionInjector.Process.AFTERPAYGATEWAY_CREATE_REFUND_FAILURE, new AfterpayOnlineAPIErrorException("Injected Failure Exception", new AfterpayOnlineAPIEntity.ErrorResponse("injected_exception", "0000", "Injected Failure Exception", 400)));
                ExceptionInjector.Inject(ExceptionInjector.Process.AFTERPAYGATEWAY_CREATE_REFUND_UNKNOWN_FAILURE, new AfterpayOnlineAPIErrorException("Injected Unknown Failure Exception"));
                AfterpayOnlineAPIEntity.RefundResponse response = this.api.createRefund(request, orderId);
                ExceptionInjector.Inject(ExceptionInjector.Process.AFTERPAYGATEWAY_CREATE_REFUND_UNKNOWN_SUCCESS, new AfterpayOnlineAPIErrorException("Injected Unknown Success Exception"));
                return response;
            }
            catch (AfterpayOnlineAPIErrorException e) {
                if (e.isResultUnknown() && DlgMessage.showMessage(parent, e.getErrorMessage() + "\n\n" + SP.getRS("afterpay_process_retry"), SP.getRS("afterpay_dlg_error"), 0, 0) == 0) continue;
                throw e;
            }
            break;
        }
    }

    public boolean createAfterpayTran(Window parent, AfterpayTran tran, long vhidx, StringBuilder processMessage) {
        if (!tran.getRefund()) {
            processMessage.append(SP.getRS("afterpay_cannot_reverse"));
            return false;
        }
        if (!this.isConfigured()) {
            processMessage.append(SP.getRS("afterpay_not_configured"));
            return false;
        }
        try {
            AfterpayOnlineAPIEntity.RefundRequest request = new AfterpayOnlineAPIEntity.RefundRequest(tran.getReference(), tran.getAmount());
            tran.setRequestId(request.requestId);
            tran.setRequestAt(Instant.now());
            if (!this.logRequest(vhidx, request.requestId, request.merchantReference, tran.getAmount(), tran.getOrigStan(), "Refund", tran.getRequestAt())) {
                return false;
            }
            AfterpayOnlineAPIEntity.RefundResponse response = this.createRefund(parent, request, tran.getOrigStan());
            tran.setStan(response.refundId);
            tran.setResponseAt(response.getRefundedAt());
            this.updateResponse(request.requestId, 201, response.refundId, response.getRefundedAt(), null, null, false);
            return true;
        }
        catch (AfterpayOnlineAPIErrorException e) {
            if (e.isResultUnknown()) {
                try {
                    AfterpayOnlineAPIEntity.RefundResponse response = this.getRefund(parent, tran.getOrigStan(), tran.getRequestId(), tran.getReference(), tran.getAmount());
                    if (response != null) {
                        this.updateResponse(tran.getRequestId(), 201, response.refundId, response.getRefundedAt(), null, null, false);
                        processMessage.append(SP.getRS("afterpay_refund_already_processed"));
                        return true;
                    }
                    this.updateResponse(tran.getRequestId(), e.getHttpStatusCode(), null, null, e.getErrorCode(), e.getErrorMessage(), false);
                    processMessage.append(SP.getRS("afterpay_refund_not_processed"));
                    return false;
                }
                catch (AfterpayOnlineAPIErrorException ex) {
                    this.updateResponse(tran.getRequestId(), e.getHttpStatusCode(), null, null, e.getErrorCode(), e.getErrorMessage(), true);
                    AfterpayGateway.markManualResolutionRequired(tran.getRequestId());
                    PosDateFormatter formatter = new PosDateFormatter(Timestamp.from(tran.getRequestAt()));
                    processMessage.append(MessageFormat.format(SP.getRS("afterpay_refund_no_result"), "\n", formatter.toString(), SP.sParams.storeCurrency.formatDetailNoScale(tran.getAmount()), tran.getOrigStan()));
                    return false;
                }
            }
            processMessage.append(e.getErrorMessage());
            this.updateResponse(tran.getRequestId(), e.getHttpStatusCode(), null, null, e.getErrorCode(), e.getErrorMessage(), false);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean logRequest(long vhidx, String requestId, String merchantRef, double amount, String origOrderId, String requestType, Instant requestedAt) {
        try (PreparedStatement stmt = this.storeParams.conn.prepareStatement("INSERT INTO AFTERPAY_REQUEST(MERCHANT_REF, REQUEST_ID, REQUEST_TIME, AMOUNT, ORIGINAL_ORDER_ID, REQUEST_TYPE, VHIDX, TILL_NAME, IN_PROGRESS) VALUES(?, ?, ?, ?, ?, ?, ?, ?, 1) ");){
            stmt.setString(1, merchantRef);
            stmt.setString(2, requestId);
            stmt.setTimestamp(3, Timestamp.from(requestedAt));
            stmt.setDouble(4, amount);
            stmt.setString(5, origOrderId);
            stmt.setString(6, requestType);
            stmt.setLong(7, vhidx);
            stmt.setString(8, this.storeParams.tillnum);
            stmt.execute();
            if (!this.storeParams.conn.getAutoCommit()) {
                PosUtils.endTrans(this.storeParams.conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateResponse(String requestId, int httpStatus, String responseId, Instant responseTime, String errorCode, String errorMessage, boolean unknownState) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE AFTERPAY_REQUEST SET RESPONSE_HTTP_STATUS = ?, RESPONSE_ID = ?, RESPONSE_TIME = ?, RESPONSE_ERROR_CODE = ?, RESPONSE_ERROR_MESSAGE = ?, UNKNOWN_STATE = ?");
        if (httpStatus < 200 || httpStatus >= 300) {
            sql.append(", IN_PROGRESS = NULL");
        }
        sql.append(" WHERE REQUEST_ID = ?");
        try (PreparedStatement stmt = this.storeParams.conn.prepareStatement(sql.toString());){
            if (httpStatus >= 200 && httpStatus < 300) {
                stmt.setInt(1, httpStatus);
                stmt.setString(2, responseId);
                stmt.setTimestamp(3, Timestamp.from(responseTime));
                stmt.setString(4, null);
                stmt.setString(5, null);
                stmt.setInt(6, unknownState ? 1 : 0);
                stmt.setString(7, requestId);
            } else {
                stmt.setInt(1, httpStatus);
                stmt.setString(2, null);
                stmt.setTimestamp(3, null);
                stmt.setString(4, errorCode);
                stmt.setString(5, errorMessage);
                stmt.setInt(6, unknownState ? 1 : 0);
                stmt.setString(7, requestId);
            }
            stmt.execute();
            if (!this.storeParams.conn.getAutoCommit()) {
                PosUtils.endTrans(this.storeParams.conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private static boolean notifyOfIncompleteRefunds(Window parent) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT REFUND.REQUEST_ID, REFUND.REQUEST_TIME, REFUND.RESPONSE_ID, REFUND.ORIGINAL_ORDER_ID, REFUND.AMOUNT FROM AFTERPAY_REQUEST REFUND LEFT OUTER JOIN AFTERPAY_REQUEST PAY ON REFUND.ORIGINAL_ORDER_ID = PAY.RESPONSE_ID WHERE REFUND.IN_PROGRESS = 1 AND REFUND.TILL_NAME = ? AND REFUND.RESPONSE_ID IS NOT NULL AND REFUND.REQUEST_TYPE = 'Refund' AND (PAY.REQUEST_ID IS NULL OR PAY.IN_PROGRESS IS NULL)");){
            stmt.setString(1, SP.sParams.tillnum);
            try (ResultSet result = stmt.executeQuery();){
                while (result.next()) {
                    String requestId = result.getString(1);
                    Timestamp requestTime = result.getTimestamp(2);
                    String refundId = result.getString(3);
                    String orderId = result.getString(4);
                    double refundAmount = result.getDouble(5);
                    AfterpayGateway.markManualResolutionRequired(requestId);
                    AfterpayGateway.removeInProgressFlag(refundId, false);
                    PosDateFormatter formatter = new PosDateFormatter(requestTime);
                    DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_incomplete_refund"), "\n", refundId, formatter.toString(), SP.sParams.storeCurrency.formatDetailNoScale(refundAmount), orderId), SP.getRS("warning_trans_failure"), -1, 2);
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkAndNotifyOfUnknownStateRefunds(Window parent) {
        AfterpayGateway afterpay = AfterpayGateway.getInstance();
        try (PreparedStatement getRequestStmt = SP.sParams.conn.prepareStatement("SELECT REFUND.REQUEST_ID, REFUND.REQUEST_TIME, REFUND.AMOUNT, REFUND.ORIGINAL_ORDER_ID, REFUND.MERCHANT_REF FROM AFTERPAY_REQUEST REFUND WHERE REFUND.IN_PROGRESS = 1 AND REFUND.TILL_NAME = ? AND REFUND.RESPONSE_ID IS NULL AND REFUND.REQUEST_TYPE = 'Refund' AND REFUND.RESPONSE_HTTP_STATUS IS NULL ");
             PreparedStatement setProgressStmt = SP.sParams.conn.prepareStatement("UPDATE AFTERPAY_REQUEST SET IN_PROGRESS = NULL WHERE REQUEST_ID = ?");){
            getRequestStmt.setString(1, SP.sParams.tillnum);
            try (ResultSet result = getRequestStmt.executeQuery();){
                while (result.next()) {
                    String requestId = result.getString(1);
                    Timestamp requestTime = result.getTimestamp(2);
                    double amount = result.getDouble(3);
                    String orderId = result.getString(4);
                    String merchantReference = result.getString(5);
                    PosDateFormatter formatter = new PosDateFormatter(requestTime);
                    DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_unknown_state"), "\n", formatter.toString(), SP.sParams.storeCurrency.formatDetailNoScale(amount), orderId), SP.getRS("warning_trans_failure"), 2);
                    if (!afterpay.isConfigured()) {
                        DlgMessage.showMessage(parent, SP.getRS("afterpay_not_configured_unknown_state"), SP.getRS("Error"), -1, 0);
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        AfterpayOnlineAPIEntity.RefundResponse response = afterpay.getRefund(parent, orderId, requestId, merchantReference, amount);
                        if (response != null) {
                            afterpay.updateResponse(requestId, 201, response.refundId, response.getRefundedAt(), null, null, false);
                            AfterpayGateway.markManualResolutionRequired(requestId);
                            DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_incomplete_refund"), "\n", response.refundId, formatter.toString(), SP.sParams.storeCurrency.formatDetailNoScale(amount), orderId), SP.getRS("warning_trans_failure"), -1, 0);
                        } else {
                            afterpay.updateResponse(requestId, 404, null, null, null, "Not found on order", false);
                            DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_incomplete_refund_unsuccessful"), "\n", SP.sParams.storeCurrency.formatDetailNoScale(amount), orderId), SP.getRS("warning_trans_failure"), -1, 1);
                        }
                    }
                    catch (AfterpayOnlineAPIErrorException ex) {
                        afterpay.updateResponse(requestId, ex.getHttpStatusCode(), null, null, ex.getErrorCode(), ex.getErrorMessage(), true);
                        AfterpayGateway.markManualResolutionRequired(requestId);
                        DlgMessage.showMessage(parent, MessageFormat.format(SP.getRS("afterpay_refund_no_result"), "\n", formatter.toString(), SP.sParams.storeCurrency.formatDetailNoScale(amount), orderId), SP.getRS("warning_trans_failure"), -1, 0);
                    }
                    setProgressStmt.setString(1, requestId);
                    setProgressStmt.execute();
                    if (SP.sParams.conn.getAutoCommit()) continue;
                    PosUtils.endTrans(SP.sParams.conn);
                }
                return true;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean removeInProgressFlag(long vhidx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE AFTERPAY_REQUEST SET IN_PROGRESS = NULL WHERE VHIDX = ?");){
            stmt.setLong(1, vhidx);
            stmt.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public static boolean removeInProgressFlag(String responseId) {
        return AfterpayGateway.removeInProgressFlag(responseId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean removeInProgressFlag(String responseId, boolean cascade) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE AFTERPAY_REQUEST SET IN_PROGRESS = NULL WHERE RESPONSE_ID = ?");
        if (cascade) {
            sql.append(" OR ORIGINAL_ORDER_ID = ?");
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement(sql.toString());){
            stmt.setString(1, responseId);
            if (cascade) {
                stmt.setString(2, responseId);
            }
            stmt.execute();
            if (!SP.sParams.conn.getAutoCommit()) {
                PosUtils.endTrans(SP.sParams.conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean markManualResolutionRequired(String requestId) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE AFTERPAY_REQUEST SET MANUAL_RESOLUTION_REQUIRED = 1 WHERE REQUEST_ID = ?");){
            stmt.setString(1, requestId);
            stmt.execute();
            if (!SP.sParams.conn.getAutoCommit()) {
                PosUtils.endTrans(SP.sParams.conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public static void reverseIncompleteAfterpayTrans(Window parent) {
        if (!AfterpayGateway.checkAndNotifyOfUnknownStateRefunds(parent)) {
            return;
        }
        if (!AfterpayGateway.notifyOfIncompleteRefunds(parent)) {
            return;
        }
    }
}

