/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.afterpay;

import java.time.Instant;
import java.util.UUID;
import jpos.SP;

public class AfterpayOnlineAPIEntity {
    public static String API_CURRENCY = SP.sParams.storeCurrency.getCode().toUpperCase();

    public static class ErrorResponse {
        public String errorCode;
        public String errorId;
        public String message;
        public int httpStatusCode;

        public ErrorResponse(String errorCode, String errorId, String message, int httpStatusCode) {
            this.errorCode = errorCode;
            this.errorId = errorId;
            this.message = message;
            this.httpStatusCode = httpStatusCode;
        }
    }

    public static class OrderResponse {
        public String id;
        public String status;
        public String created;
        public String merchantReference;
        public Amount originalAmount;
        public RefundResponse[] refunds;
    }

    public static class RefundResponse
    extends RefundRequest {
        public String refundId;
        public String refundedAt;

        public RefundResponse(String merchantReference, double amount) {
            super(merchantReference, amount);
        }

        public Instant getRefundedAt() {
            return Instant.parse(this.refundedAt);
        }
    }

    public static class RefundRequest {
        public String requestId = UUID.randomUUID().toString();
        public String merchantReference;
        public Amount amount;

        public RefundRequest(String merchantReference, double amount) {
            this.amount = new Amount(amount);
            this.merchantReference = merchantReference;
        }
    }

    public static class Amount {
        public String amount;
        public String currency;

        public Amount(double amount) {
            this.amount = Double.toString(amount);
            this.currency = API_CURRENCY;
        }

        public double getAmount() {
            try {
                return Double.parseDouble(this.amount);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
    }
}

