/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.openpay;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.RetTranP;
import jpos.pay.openpay.Openpay;
import jpos.pay.openpay.OpenpayTran;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;

public class DlgWaitingForConfirmationOpenpay
extends JDialog {
    protected JPanel panelAll = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private LabelSubHeading lWaitingForConfirmation = new LabelSubHeading();
    private LabelSubHeading lCountdown = new LabelSubHeading();
    private DialogButton cancelButton = new DialogButton("");
    protected boolean result = false;
    int kedCount = 0;
    protected static final int PAD0 = 0;
    protected static final int PAD1 = 5;
    protected static final int PAD2 = 10;
    protected static final int PAD3 = 20;
    Component initComp;
    private Timer timer;
    private long timeOutSecs;
    private LocalTime startTime;
    private LocalTime endTime;
    private LocalTime nextPollTime;
    Duration durationLeft;
    Openpay openpay;
    OpenpayTran openpayTran;
    RetTranP retTranP;
    ReentrantLock lock = new ReentrantLock();
    StringBuilder retMessage = new StringBuilder();
    PollingRunnable polling;

    public DlgWaitingForConfirmationOpenpay(PayDialog parent, String title, RetTranP retTranP) {
        super(parent, title, true);
        this.openpay = SP.sParams.getOpenpay();
        this.openpayTran = (OpenpayTran)retTranP.getETran();
        this.retTranP = retTranP;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lWaitingForConfirmation.setText(SP.getRS("openpay_waiting_for_confirmation"));
        this.lCountdown.setText(String.valueOf(this.timeOutSecs));
        this.cancelButton.setText("Cancel");
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lWaitingForConfirmation, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.panelAll.add((Component)this.lCountdown, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.panelAll.add((Component)this.cancelButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.startTime = LocalTime.now();
        this.endTime = this.startTime.plusSeconds(300L);
        this.durationLeft = Duration.between(this.startTime, this.endTime);
        this.timeOutSecs = this.durationLeft.getSeconds();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgWaitingForConfirmationOpenpay.this.nextPollTime = LocalTime.now();
                DlgWaitingForConfirmationOpenpay.this.cancelDialog();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgWaitingForConfirmationOpenpay.this.cancelDialog();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DlgWaitingForConfirmationOpenpay.this.timer = new Timer();
                        DlgWaitingForConfirmationOpenpay.this.timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                String timestring = String.format("%02d:%02d", DlgWaitingForConfirmationOpenpay.this.timeOutSecs / 60L, DlgWaitingForConfirmationOpenpay.this.timeOutSecs % 60L);
                                DlgWaitingForConfirmationOpenpay.this.lCountdown.setText(String.valueOf(timestring));
                                DlgWaitingForConfirmationOpenpay.this.getContentPane().repaint();
                                if (DlgWaitingForConfirmationOpenpay.this.endTime.isAfter(LocalTime.now())) {
                                    DlgWaitingForConfirmationOpenpay.this.durationLeft = Duration.between(LocalTime.now(), DlgWaitingForConfirmationOpenpay.this.endTime);
                                    DlgWaitingForConfirmationOpenpay.this.timeOutSecs = DlgWaitingForConfirmationOpenpay.this.durationLeft.getSeconds();
                                } else {
                                    DlgWaitingForConfirmationOpenpay.this.cancelDialog();
                                }
                                if (DlgWaitingForConfirmationOpenpay.this.polling != null && DlgWaitingForConfirmationOpenpay.this.polling.finished) {
                                    DlgWaitingForConfirmationOpenpay.this.lock.lock();
                                    try {
                                        if (DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().OrderStatus != Openpay.OrderStatus.Received && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().PlanStatus != Openpay.PlanStatus.Expired && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().OrderStatus != Openpay.OrderStatus.Received && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().PlanStatus != Openpay.PlanStatus.NotProcessed && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().OrderStatus != Openpay.OrderStatus.Received && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().PlanStatus != Openpay.PlanStatus.BeingProcessed && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().OrderStatus != Openpay.OrderStatus.Refused && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().PlanStatus != Openpay.PlanStatus.NotProcessed) {
                                            DlgWaitingForConfirmationOpenpay.this.timer.cancel();
                                            if (DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().OrderStatus == Openpay.OrderStatus.Approved && DlgWaitingForConfirmationOpenpay.this.openpayTran.getOpenpayStatus().PlanStatus == Openpay.PlanStatus.Active) {
                                                DlgWaitingForConfirmationOpenpay.this.okDialog();
                                            } else {
                                                DlgWaitingForConfirmationOpenpay.this.cancelDialog();
                                            }
                                            return;
                                        }
                                    }
                                    finally {
                                        DlgWaitingForConfirmationOpenpay.this.lock.unlock();
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DlgWaitingForConfirmationOpenpay.this.startPolling(DlgWaitingForConfirmationOpenpay.this.startTime);
                                    }
                                });
                            }
                        }, 0L, 1000L);
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(null);
        super.setVisible(visible);
    }

    public void cancelDialog() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lock.lock();
        try {
            if (this.polling != null) {
                this.polling.enabled = false;
            }
            if (this.openpayTran.getOpenpayStatus().OrderStatus != Openpay.OrderStatus.Received || this.openpayTran.getOpenpayStatus().PlanStatus != Openpay.PlanStatus.Expired || this.openpayTran.getOpenpayStatus().OrderStatus == null && this.openpayTran.getOpenpayStatus().PlanStatus == null) {
                StringBuilder processMsg = new StringBuilder();
                try {
                    this.openpay.CancelPaymentRequest(this.retTranP, processMsg);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.result = false;
        this.setVisible(false);
    }

    public void okDialog() {
        this.result = true;
        this.setVisible(false);
    }

    public boolean getResult() {
        return this.result;
    }

    private void startPolling(LocalTime sTime) {
        if (this.openpayTran.getOpenpayStatus().OrderStatus == Openpay.OrderStatus.Received || this.openpayTran.getOpenpayStatus().OrderStatus == null) {
            if (this.polling == null) {
                this.polling = new PollingRunnable(sTime);
            }
            if (this.polling.finished && this.polling.enabled) {
                new Thread(this.polling).start();
            }
        }
    }

    public String getPollingMessage() {
        return this.retMessage.toString();
    }

    public class PollingRunnable
    implements Runnable {
        boolean enabled = true;
        boolean finished = true;

        public PollingRunnable(LocalTime sTime) {
            DlgWaitingForConfirmationOpenpay.this.nextPollTime = sTime.plusSeconds(15L);
        }

        @Override
        public void run() {
            if (this.enabled) {
                DlgWaitingForConfirmationOpenpay.this.lock.lock();
                try {
                    this.finished = false;
                    DlgWaitingForConfirmationOpenpay.this.retMessage.setLength(0);
                    while (LocalTime.now().isBefore(DlgWaitingForConfirmationOpenpay.this.nextPollTime)) {
                    }
                    if (DlgWaitingForConfirmationOpenpay.this.endTime.isAfter(LocalTime.now())) {
                        DlgWaitingForConfirmationOpenpay.this.openpay.GetOrderStatusRequest(DlgWaitingForConfirmationOpenpay.this.retTranP, Openpay.PollingBy.OrderId, DlgWaitingForConfirmationOpenpay.this.retMessage);
                        DlgWaitingForConfirmationOpenpay.this.nextPollTime = LocalTime.now().plusSeconds(5L);
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                finally {
                    this.finished = true;
                    DlgWaitingForConfirmationOpenpay.this.lock.unlock();
                }
            }
        }
    }
}

