/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.openpay;

import JCP.JcpApi;
import JCP.JcpRequestResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.logging.RollingLog;
import jpos.pay.PayTypes;
import jpos.pay.PaymentGatewayConfig;
import jpos.pay.RetTranP;
import jpos.pay.openpay.CartItem;
import jpos.pay.openpay.CustomerJourney;
import jpos.pay.openpay.OpenpayTran;

public class Openpay {
    private Credentials cred;
    private StoreParams sParams;

    public Openpay(StoreParams sParams, PaymentGatewayConfig gatewayConfig) {
        this.cred = new Credentials(sParams.getStore().getCode(), gatewayConfig.getPassword(), gatewayConfig.getApiUrl());
        this.sParams = sParams;
    }

    public boolean RequestPayment(RetTranP retTranP, StringBuilder processMsg) throws Exception {
        String vhidx = "";
        if (retTranP.vhIdx.isNotNull()) {
            vhidx = retTranP.vhIdx.toString();
        }
        OpenpayTran openpayTran = (OpenpayTran)retTranP.getETran();
        String retailerOrderNo = SP.sParams.getStore() + "-" + vhidx;
        PaymentRequest paymentRequest = new PaymentRequest(vhidx, retailerOrderNo, openpayTran.getCustomerJourney(), (int)Math.round(retTranP.getAmount() * 100.0), openpayTran.getCart());
        this.saveRequest(paymentRequest, RequestTypes.OrderRequest);
        this.cred.RequestType = RequestTypes.OrderRequest.toString();
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Payment Request" + System.lineSeparator() + this.requestLogging(paymentRequest, this.cred));
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        String resultJson = Openpay.processReqeustViaProvider(RequestTypes.OrderRequest, json.toJson((Object)paymentRequest), json.toJson((Object)this.cred));
        PaymentResult paymentResult = (PaymentResult)json.fromJson(resultJson, PaymentResult.class);
        paymentResult.RequestType = RequestTypes.OrderRequest.toString();
        paymentResult.Vhidx = vhidx;
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Payment Result" + System.lineSeparator() + this.resultLogging(paymentResult));
        this.updateResponse(paymentResult);
        if (paymentResult.IsSucess()) {
            openpayTran.setOpenpayStatus(null, null);
            openpayTran.setStan(String.valueOf(paymentResult.OrderId));
            return true;
        }
        if (paymentResult.OrderId == null && paymentResult.HttpStatusCode == 0) {
            StringBuilder processMessage = new StringBuilder();
            OrderStatusResult statusResult = this.GetOrderStatusRequest(retTranP, PollingBy.RetailerOrderNo, processMessage);
            if (!statusResult.OrderId.isEmpty() && statusResult.OrderId != null) {
                openpayTran.setOpenpayStatus(statusResult.OrderStatus, statusResult.PlanStatus);
                openpayTran.setStan(String.valueOf(statusResult.OrderId));
                return this.UpdatePaymentId(vhidx, statusResult.OrderId);
            }
        }
        this.SetProcessMessage(processMsg, paymentResult);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean UpdatePaymentId(String vhidx, String orderId) {
        String sqlStmnt = "UPDATE OPENPAY_REQUEST   SET PAYMENT_ID = ?   WHERE VHIDX = ?  AND REQUEST_TYPE = 'PAYMENT' ";
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement(sqlStmnt);){
            stmt.setString(1, orderId);
            stmt.setInt(2, Integer.parseInt(vhidx));
            stmt.execute();
            if (!this.sParams.conn.getAutoCommit()) {
                PosUtils.endTrans(this.sParams.conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    public OrderStatusResult GetOrderStatusRequest(RetTranP retTranP, PollingBy pollingby, StringBuilder processMsg) throws Exception {
        OpenpayTran openpayTran = (OpenpayTran)retTranP.getETran();
        String orderId = null;
        String retailerOrderNo = null;
        if (pollingby == PollingBy.OrderId) {
            orderId = openpayTran.getStan();
        } else if (pollingby == PollingBy.RetailerOrderNo) {
            retailerOrderNo = SP.sParams.getStore() + "-" + retTranP.vhIdx.toString();
        }
        OrderStatusRequest pollingRequest = new OrderStatusRequest(orderId, retailerOrderNo);
        this.cred.RequestType = RequestTypes.OrderStatusRequest.toString();
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Poll Payment Request" + System.lineSeparator() + this.requestLogging(pollingRequest, this.cred));
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        String resultJson = Openpay.processReqeustViaProvider(RequestTypes.OrderStatusRequest, json.toJson((Object)pollingRequest), json.toJson((Object)this.cred));
        OrderStatusResult pollingResult = (OrderStatusResult)json.fromJson(resultJson, OrderStatusResult.class);
        openpayTran.setOpenpayStatus(pollingResult.OrderStatus, pollingResult.PlanStatus);
        pollingResult.RequestType = RequestTypes.OrderStatusRequest.toString();
        pollingResult.Vhidx = retTranP.vhIdx.toString();
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Poll Payment Result" + System.lineSeparator() + this.resultLogging(pollingResult));
        this.updateResponse(pollingResult);
        this.SetProcessMessage(processMsg, pollingResult);
        return pollingResult;
    }

    public boolean CancelPaymentRequest(RetTranP retTranP, StringBuilder processMsg) throws Exception {
        OpenpayTran openpayTran = (OpenpayTran)retTranP.getETran();
        if (openpayTran.getStan() != null && !openpayTran.getStan().isEmpty()) {
            this.cred.RequestType = RequestTypes.CancelOrderRequest.toString();
            CancelPaymentRequest voidRequest = new CancelPaymentRequest(openpayTran.getStan());
            RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Reverse Payment Request" + System.lineSeparator() + this.requestLogging(voidRequest, this.cred));
            Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
            String resultJson = Openpay.processReqeustViaProvider(RequestTypes.CancelOrderRequest, json.toJson((Object)voidRequest), json.toJson((Object)this.cred));
            PaymentResult cancelResult = (PaymentResult)json.fromJson(resultJson, PaymentResult.class);
            RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Reverse Payment Result" + System.lineSeparator() + this.resultLogging(cancelResult));
            cancelResult.RequestType = RequestTypes.CancelOrderRequest.toString();
            cancelResult.Vhidx = retTranP.vhIdx.toString();
            this.updateResponse(cancelResult);
            if (cancelResult.IsSucess()) {
                return true;
            }
            this.SetProcessMessage(processMsg, cancelResult);
        } else {
            processMsg.append("Original payment reference is empty");
        }
        return false;
    }

    public boolean RefundPayment(RetTranP retTranP, StringBuilder processMsg, Boolean isReverse) throws Exception {
        OpenpayTran openpayTran = (OpenpayTran)retTranP.getETran();
        this.cred.RequestType = RequestTypes.RefundRequest.toString();
        String stan = isReverse != false ? openpayTran.getStan() : openpayTran.getOrigStan();
        RefundRequest refundRequest = new RefundRequest(retTranP.vhIdx.toString(), stan, (int)Math.abs(Math.round(retTranP.getAmount() * 100.0)), false);
        this.saveRequest(refundRequest, RequestTypes.RefundRequest);
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Refund Request" + System.lineSeparator() + this.requestLogging(refundRequest, this.cred));
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        String resultJson = Openpay.processReqeustViaProvider(RequestTypes.RefundRequest, json.toJson((Object)refundRequest), json.toJson((Object)this.cred));
        RefundResult refundResult = (RefundResult)json.fromJson(resultJson, RefundResult.class);
        refundResult.RequestType = RequestTypes.RefundRequest.toString();
        refundResult.Vhidx = retTranP.vhIdx.toString();
        refundResult.isReversed = isReverse;
        this.updateResponse(refundResult);
        RollingLog.log(RollingLog.LogType.OPENPAY, Level.INFO, "Openpay Refund Result" + System.lineSeparator() + this.resultLogging(refundResult));
        if (refundResult.IsSucess()) {
            return true;
        }
        this.SetProcessMessage(processMsg, refundResult);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ReverseIncompleteOpenpayTrans() throws Exception {
        OpenpayTran openpayTran = null;
        try (PreparedStatement getRequestStmt = SP.sParams.conn.prepareStatement("SELECT H.VHIDX,  O.PAYMENT_ID,  O.AMOUNT FROM OPENPAY_REQUEST O, RET_TRANH H WHERE O.VHIDX = H.VHIDX AND COALESCE(CANCELLED,0) <> 1  AND COALESCE(REVERSED,0) <> 1 AND H.ACTIVE = 1 AND O.PAYMENT_ID IS NOT NULL AND O.PAYMENT_ID NOT IN ('','null') AND H.COMPLETE = 0  AND O.REQUEST_TYPE = 'PAYMENT' ORDER BY O.VHIDX DESC ");
             ResultSet result = getRequestStmt.executeQuery();){
            while (result.next()) {
                PreparedStatement stmt;
                block39: {
                    StringBuilder processMessage = new StringBuilder();
                    int vhidx = result.getInt(1);
                    String paymentId = result.getString(2);
                    double amount = result.getDouble(3);
                    openpayTran = new OpenpayTran(false, amount);
                    openpayTran.setSalesRepName("POS");
                    openpayTran.setStan(paymentId);
                    RetTranP retTranP = new RetTranP(PayTypes.getPayType(850L), amount / 100.0);
                    retTranP.vhIdx.setValue(vhidx);
                    retTranP.setEFTTran(openpayTran);
                    OrderStatusResult statusResult = this.GetOrderStatusRequest(retTranP, PollingBy.OrderId, processMessage);
                    if (statusResult.OrderStatus == OrderStatus.Approved && statusResult.PlanStatus == PlanStatus.Active) {
                        this.RefundPayment(retTranP, processMessage, true);
                        continue;
                    }
                    if (statusResult.OrderStatus == OrderStatus.Received && statusResult.PlanStatus == PlanStatus.NotProcessed || statusResult.OrderStatus == OrderStatus.Received && statusResult.PlanStatus == PlanStatus.BeingProcessed) {
                        this.CancelPaymentRequest(retTranP, processMessage);
                        continue;
                    }
                    if ((statusResult.OrderStatus != OrderStatus.Approved || statusResult.PlanStatus != PlanStatus.Refunded) && (statusResult.OrderStatus != OrderStatus.Received || statusResult.PlanStatus != PlanStatus.Expired)) continue;
                    String sqlStmnt = "UPDATE OPENPAY_REQUEST  SET IN_PROGRESS = 0 ,  REVERSED = 1  WHERE VHIDX = ?  AND REQUEST_TYPE = 'PAYMENT' ";
                    stmt = this.sParams.conn.prepareStatement(sqlStmnt);
                    Throwable throwable = null;
                    try {
                        stmt.setInt(1, vhidx);
                        stmt.execute();
                        if (!this.sParams.conn.getAutoCommit()) {
                            PosUtils.endTrans(this.sParams.conn);
                        }
                        if (stmt == null) continue;
                        if (throwable == null) break block39;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (stmt == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            stmt.close();
                            throw throwable3;
                        }
                    }
                    try {
                        stmt.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                stmt.close();
            }
            return;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void saveRequest(Request request, RequestTypes requesttype) throws SQLException {
        if (requesttype == RequestTypes.OrderRequest || requesttype == RequestTypes.RefundRequest) {
            try (PreparedStatement stmt = this.sParams.conn.prepareStatement("INSERT INTO OPENPAY_REQUEST(VHIDX, TILL_NAME, REQUEST_TIME, REQUEST_TYPE, AMOUNT, PAYMENT_ID, IN_PROGRESS ) VALUES(?, ?, ?, ?, ?, ?, 1)");){
                String vhidx = request.Vhidx;
                double amount = requesttype == RequestTypes.OrderRequest ? (double)((PaymentRequest)request).OrderAmount : (double)((RefundRequest)request).RefundAmount;
                stmt.setString(1, vhidx);
                stmt.setString(2, this.sParams.tillnum);
                stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                stmt.setString(4, requesttype == RequestTypes.OrderRequest ? "PAYMENT" : "REFUND");
                stmt.setDouble(5, amount);
                stmt.setString(6, requesttype == RequestTypes.OrderRequest ? "" : String.valueOf(((RefundRequest)request).OrderId));
                stmt.execute();
                if (!this.sParams.conn.getAutoCommit()) {
                    PosUtils.endTrans(this.sParams.conn);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateResponse(Result result) throws SQLException {
        Throwable throwable;
        PreparedStatement stmt;
        String sqlStmnt;
        String reversed = " NULL ";
        if (result.RequestType == RequestTypes.OrderRequest.toString() || result.RequestType == RequestTypes.CancelOrderRequest.toString() || result.RequestType == RequestTypes.RefundRequest.toString()) {
            String paymentId;
            sqlStmnt = "UPDATE OPENPAY_REQUEST   SET RESPONSE_HTTP_STATUS = ? ,  RESPONSE_TIME = ?,  RESPONSE_ERROR_CODE = ? ,  RESPONSE_ERROR_MESSAGE = ? ,  CANCELLED = ~CANCELLED ,  IN_PROGRESS = ~INPROGRESS ,  PAYMENT_ID =  ~PAYMENT_ID ,  REVERSED =  ~REVERSED  WHERE VHIDX = ? ";
            String errorMsg = result.ErrorMessage != null && !result.ErrorMessage.isEmpty() ? result.ErrorMessage.substring(0, Math.min(result.ErrorMessage.length(), 249)) : null;
            String errorDetails = result.ErrorDetails != null && !result.ErrorDetails.isEmpty() ? result.ErrorDetails.substring(0, Math.min(result.ErrorDetails.length(), 1999)) : null;
            String inProgress = result.RequestType == RequestTypes.OrderRequest.toString() ? "1" : (result.RequestType == RequestTypes.RefundRequest.toString() || result.RequestType == RequestTypes.CancelOrderRequest.toString() ? "0" : " IN_PROGRESS ");
            sqlStmnt = sqlStmnt.replace("~INPROGRESS", inProgress);
            String cancelled = result.RequestType == RequestTypes.CancelOrderRequest.toString() ? "1" : (result.RequestType == RequestTypes.OrderStatusRequest.toString() ? " CANCELLED " : " NULL ");
            sqlStmnt = sqlStmnt.replace("~CANCELLED", cancelled);
            if (result.RequestType == RequestTypes.OrderRequest.toString() || result.RequestType == RequestTypes.CancelOrderRequest.toString()) {
                PaymentResult paymentResult = (PaymentResult)result;
                paymentId = "'" + paymentResult.OrderId + "'";
            } else if (result.RequestType == RequestTypes.RefundRequest.toString()) {
                RefundResult refundResult = (RefundResult)result;
                paymentId = "'" + refundResult.OrderId + "'";
                if (refundResult.isReversed.booleanValue()) {
                    reversed = "1";
                }
            } else {
                paymentId = " PAYMENT_ID ";
            }
            sqlStmnt = sqlStmnt.replace("~PAYMENT_ID", paymentId);
            sqlStmnt = sqlStmnt.replace("~REVERSED", reversed);
            stmt = this.sParams.conn.prepareStatement(sqlStmnt);
            throwable = null;
            try {
                stmt.setInt(1, result.HttpStatusCode);
                stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                stmt.setString(3, errorMsg);
                stmt.setString(4, errorDetails);
                stmt.setInt(5, Integer.parseInt(result.Vhidx));
                stmt.execute();
                if (!this.sParams.conn.getAutoCommit()) {
                    PosUtils.endTrans(this.sParams.conn);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        if (result.RequestType != RequestTypes.OrderStatusRequest.toString()) return;
        if (((OrderStatusResult)result).OrderStatus == OrderStatus.Received && ((OrderStatusResult)result).PlanStatus == PlanStatus.Expired || ((OrderStatusResult)result).OrderStatus == OrderStatus.Approved && ((OrderStatusResult)result).PlanStatus == PlanStatus.Active) {
            sqlStmnt = "UPDATE OPENPAY_REQUEST   SET IN_PROGRESS = 0 ,  ORDER_STATUS_REQUEST_COUNT = COALESCE(ORDER_STATUS_REQUEST_COUNT,0)+ 1  WHERE VHIDX = ?  AND IN_PROGRESS = 1 ";
            stmt = this.sParams.conn.prepareStatement(sqlStmnt);
            throwable = null;
            try {
                stmt.setInt(1, Integer.parseInt(result.Vhidx));
                stmt.execute();
                if (this.sParams.conn.getAutoCommit()) return;
                PosUtils.endTrans(this.sParams.conn);
                return;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        sqlStmnt = "UPDATE OPENPAY_REQUEST   SET ORDER_STATUS_REQUEST_COUNT = COALESCE(ORDER_STATUS_REQUEST_COUNT,0)+ 1   WHERE VHIDX = ? ";
        stmt = this.sParams.conn.prepareStatement(sqlStmnt);
        throwable = null;
        try {
            stmt.setInt(1, Integer.parseInt(result.Vhidx));
            stmt.execute();
            if (this.sParams.conn.getAutoCommit()) return;
            PosUtils.endTrans(this.sParams.conn);
            return;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    private static String processReqeustViaProvider(RequestTypes requestType, String json, String jsonCredentials) throws Exception {
        String command;
        switch (requestType) {
            case OrderRequest: {
                command = "SendPaymentRequest";
                break;
            }
            case RefundRequest: {
                command = "SendRefundRequest";
                break;
            }
            case CancelOrderRequest: {
                command = "SendCancelPaymentRequest";
                break;
            }
            case OrderStatusRequest: {
                command = "SendPollingRequest";
                break;
            }
            default: {
                command = "SendPollingRequest";
            }
        }
        JcpRequestResult result = JcpApi.InvokeStaticMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.OpenpayProvider", (String)command, (Object[])new Object[]{json, jsonCredentials});
        if (result.getSuccess()) {
            return result.getRequestResultAsString();
        }
        throw new Exception(result.getErrorMessage());
    }

    private void SetProcessMessage(StringBuilder processMsg, Result result) {
        if (result.ErrorDetails != null && !result.ErrorDetails.isEmpty()) {
            processMsg.append(result.ErrorDetails);
        }
    }

    private String requestLogging(Request request, Credentials cred) {
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return prettyJson.toJson((Object)request) + "\n" + prettyJson.toJson((Object)cred).replace(cred.Password, PosUtils.HashData(cred.Password));
    }

    private String resultLogging(Result result) {
        try {
            if (result == null) {
                return "null";
            }
            Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            for (String key : result.RequestResponseLog.keySet()) {
                if (!key.toLowerCase().contains("body") && !key.toLowerCase().equals("delete response")) continue;
                JsonElement jElement = (JsonElement)prettyJson.fromJson((String)result.RequestResponseLog.get(key), JsonElement.class);
                result.RequestResponseLog.replace(key, jElement);
            }
            return prettyJson.toJson((Object)result);
        }
        catch (Exception e) {
            return new Gson().toJson((Object)result);
        }
    }

    public class RefundResult
    extends Result {
        public String OrderId;
        public Boolean isReversed;
    }

    public class MinMaxResult
    extends Result {
        public int MinPrice;
        public int MaxPrice;
    }

    public class OrderStatusResult
    extends Result {
        public String OrderId;
        public int PurchasePrice;
        public int RetailerAmount;
        public OrderStatus OrderStatus;
        public PlanStatus PlanStatus;
    }

    public class PaymentResult
    extends Result {
        public String OrderId;
        public int BlackListMatch;
        @SerializedName(value="nextAction")
        public NextAction NAction;

        public class FormField {
            @SerializedName(value="fieldName")
            String FieldName;
            @SerializedName(value="fieldValue")
            String FieldValue;
        }

        public class FormPost {
            @SerializedName(value="formPostUrl")
            String FormPostUrl;
        }

        public class NextAction {
            @SerializedName(value="type")
            String Type;
            @SerializedName(value="formPost")
            FormPost FmPost;
        }
    }

    public abstract class Result {
        protected transient String tranReference;
        public int HttpStatusCode;
        public Map<String, Object> RequestResponseLog;
        public String ErrorMessage;
        public String ErrorDetails;
        public String RequestType;
        public transient String Vhidx;

        public boolean IsSucess() {
            return this.HttpStatusCode >= 200 && this.HttpStatusCode <= 299;
        }
    }

    public class CancelPaymentRequest
    extends Request {
        public String OrderId;

        public CancelPaymentRequest(String paymentId) {
            this.OrderId = paymentId;
        }
    }

    public class RefundRequest
    extends Request {
        @SerializedName(value="newPurchasePrice")
        public int NewPurchasePrice;
        @SerializedName(value="reducePriceBy")
        public int RefundAmount;
        @SerializedName(value="fullRefund")
        public Boolean FullRefund;
        public String OrderId;

        public RefundRequest(String vhidx, String paymentId, int amount, Boolean fullRefund) {
            ((Request)this).Vhidx = vhidx;
            this.RefundAmount = amount;
            this.OrderId = paymentId;
            this.FullRefund = fullRefund;
        }
    }

    public class OrderStatusRequest
    extends Request {
        public String OrderId;
        public String RetailOrderNo;

        public OrderStatusRequest(String paymentId, String retailerOrderNo) {
            this.OrderId = paymentId;
            this.RetailOrderNo = retailerOrderNo;
        }
    }

    public class PaymentRequest
    extends Request {
        @SerializedName(value="customerJourney")
        public CustomerJourney CustomerJourney;
        @SerializedName(value="purchasePrice")
        public int OrderAmount;
        @SerializedName(value="retailerOrderNo")
        public String OrderNo;
        @SerializedName(value="source")
        public String Source;
        public Vector<CartItem> Cart;

        public PaymentRequest(String vhidx, String orderNumber, CustomerJourney custJourney, int amount, Vector<CartItem> cart) {
            this.Source = "Apparel21-POS";
            this.CustomerJourney = custJourney;
            this.OrderNo = orderNumber;
            ((Request)this).Vhidx = vhidx;
            this.OrderAmount = amount;
            this.Cart = cart;
        }
    }

    public class Credentials {
        public String Username;
        public String Password;
        public String ApiUrl;
        public Integer Timeout;
        public String RequestType;

        public Credentials(String username, String password, String apiUrl) {
            this.Username = username;
            this.Password = password;
            this.ApiUrl = apiUrl;
            this.Timeout = 20000;
        }
    }

    public class Request {
        private transient String Vhidx;
    }

    public static enum PollingBy {
        OrderId,
        RetailerOrderNo;

    }

    public static enum PlanStatus {
        NotProcessed,
        BeingProcessed,
        Active,
        Refunded,
        Finished,
        Errored,
        Refused,
        Lodged,
        Expired;

    }

    public static enum OrderStatus {
        Received,
        Approved,
        Rejected,
        Refused,
        Pending,
        Unknown;

    }

    public static enum RequestTypes {
        None,
        OrderRequest,
        RefundRequest,
        OrderStatusRequest,
        CancelOrderRequest;

    }
}

