/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.qantas;

import java.util.logging.Level;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.SP;
import jpos.logging.RollingLog;
import jpos.pay.qantas.QantasTransaction;
import jpos.pay.qantas.QantasTransactionStatus;
import org.jdom.Element;

public class Qantas {
    public boolean startTransaction(FrSales parent, QantasTransaction transaction, String membershipNumber) {
        if (!SP.sParams.checkIConn()) {
            DlgMessage.showMessage(parent, SP.getRS("qantas_error_offline"));
            return false;
        }
        Element response = null;
        try {
            String payload = membershipNumber + "," + transaction.getAmount();
            String maskedPayload = QantasTransaction.maskCharacters(membershipNumber) + "," + transaction.getAmount();
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Start Transaction Request" + System.lineSeparator() + maskedPayload);
            response = SP.sParams.OnlineQueryProvider.getOnlineQuery("qantas_start", payload).getXML();
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Polling Response" + System.lineSeparator() + response);
            if (response == null) {
                throw new Exception(SP.getRS("qantas_error_failed_start"));
            }
            if (!response.getAttributeValue("status_code").contentEquals("200")) {
                throw new Exception(response.getAttributeValue("message"));
            }
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, "An error occured while contacting Qantas: \n" + e.getMessage());
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, SP.getRS("qantas_error") + " \n" + e.getMessage());
            return false;
        }
        String qantasTransactionId = null;
        try {
            qantasTransactionId = response.getAttributeValue("qantasTransactionId");
            if (qantasTransactionId.length() == 0 || qantasTransactionId == null) {
                throw new Exception(SP.getRS("qantas_error_no_data"));
            }
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "Error: " + e.getMessage());
            return false;
        }
        String ap21QantasId = null;
        try {
            ap21QantasId = response.getAttributeValue("ap21QantasId");
            if (ap21QantasId.length() == 0 || ap21QantasId == null) {
                DlgMessage.showMessage(parent, "No Apparel 21 Qantas Id was received. Unable to continue");
                return false;
            }
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "An error occured processing Apparel21 Qantas Transaction Id: " + e.getMessage());
            return false;
        }
        String qantasTransactionStatus = null;
        try {
            qantasTransactionStatus = response.getAttributeValue("status");
            if (qantasTransactionStatus.length() == 0) {
                DlgMessage.showMessage(parent, SP.getRS("qantas_error_no_status"));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String lastKnownVersion = null;
        try {
            lastKnownVersion = response.getAttributeValue("last_known_version");
            if (lastKnownVersion.length() == 0) {
                DlgMessage.showMessage(parent, SP.getRS("qantas_error_no_version"));
                return false;
            }
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, SP.getRS("qantas_error") + " \n" + e.getMessage());
            return false;
        }
        int timeout = 60;
        try {
            String timeoutStr = response.getAttributeValue("timeout");
            if (timeoutStr.length() == 0) {
                DlgMessage.showMessage(parent, "No timeout provided for Qantas. Defaulting to 60 seconds.");
            }
            timeout = Integer.parseInt(response.getAttributeValue("timeout"));
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, SP.getRS("qantas_error") + " \n" + e.getMessage());
            return false;
        }
        transaction.setMembershipNumber(membershipNumber);
        transaction.setQantasTransactionId(qantasTransactionId);
        transaction.setAp21TransactionId(ap21QantasId);
        transaction.setTimeout(timeout);
        try {
            transaction.setStatus(this.parseStatus(qantasTransactionStatus));
        }
        catch (IllegalArgumentException e) {
            DlgMessage.showMessage(parent, "Invalid transaction status data received. Unable to continue");
            return false;
        }
        try {
            transaction.setVersion(Integer.parseInt(lastKnownVersion));
        }
        catch (IllegalArgumentException e) {
            DlgMessage.showMessage(parent, "Invalid version data received: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean pollForUpdate(FrSales parent, QantasTransaction transaction) {
        String burnReference;
        Element response;
        block28: {
            block27: {
                if (!SP.sParams.checkIConn()) {
                    return false;
                }
                response = null;
                try {
                    String payload = transaction.getTransactionNumber() + "," + transaction.getAp21TransactionId();
                    RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Polling Request" + System.lineSeparator() + payload);
                    response = SP.sParams.OnlineQueryProvider.getOnlineQuery("qantas_poll", payload).getXML();
                    if (response == null) {
                        throw new Exception("No transaction data returned.");
                    }
                    if (!response.getAttributeValue("status_code").contentEquals("200")) {
                        throw new Exception(response.getAttributeValue("message"));
                    }
                    RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Polling Response" + System.lineSeparator() + response);
                }
                catch (Exception e) {
                    DlgMessage.showMessage(parent, "An error occured while contacting Qantas: \n" + e.getMessage());
                    RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while contacting Qantas: \n" + e.getMessage());
                    return false;
                }
                try {
                    String status = response.getAttributeValue("status");
                    if (status.length() > 0) {
                        try {
                            transaction.setStatus(this.parseStatus(status));
                            break block27;
                        }
                        catch (IllegalArgumentException e) {
                            throw new Exception("Invalid input string for enum: " + e.getMessage());
                        }
                    }
                    throw new Exception("Invalid transaction status data received. Unable to continue");
                }
                catch (Exception e) {
                    DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
                    RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
                    return false;
                }
            }
            try {
                String version = response.getAttributeValue("version");
                if (version.length() > 0) {
                    try {
                        transaction.setVersion(Integer.parseInt(version));
                        break block28;
                    }
                    catch (IllegalArgumentException e) {
                        throw new Exception("Invalid input string for version: " + e.getMessage());
                    }
                }
                DlgMessage.showMessage(parent, "Invalid transaction status data received. Unable to continue");
                return false;
            }
            catch (Exception e) {
                DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
                RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
                return false;
            }
        }
        if (transaction.getStatus() == QantasTransactionStatus.BurnSelected) {
            try {
                String pointsBurnt = response.getAttributeValue("points_burnt");
                if (pointsBurnt.length() == 0) {
                    DlgMessage.showMessage(null, "Invalid data was received from Qantas. Unable to continue");
                    return false;
                }
                try {
                    transaction.setPointsBurnt(Integer.parseInt(pointsBurnt));
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Invalid input string for points burnt: " + e.getMessage());
                }
            }
            catch (Exception e) {
                DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
                RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
                return false;
            }
            try {
                String value = response.getAttributeValue("dollar_value");
                if (value.length() == 0) {
                    DlgMessage.showMessage(parent, "Invalid transaction points data was received from Qantas. Unable to continue");
                    return false;
                }
                try {
                    transaction.setSelectedValue(Double.parseDouble(value));
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Invalid input string for dollar value: " + e.getMessage());
                }
            }
            catch (Exception e) {
                DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
                RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
                return false;
            }
            transaction.setBurnSelected(true);
        }
        if (transaction.getStatus() == QantasTransactionStatus.Complete && (burnReference = response.getAttributeValue("burnReference")) != null && burnReference.length() != 0) {
            transaction.setBurnReference(burnReference);
        }
        return true;
    }

    public boolean completeTransaction(FrSales parent, QantasTransaction tran, StringBuffer retMessage) {
        return this.updateTransaction(parent, tran, "Complete");
    }

    public boolean cancelTransaction(FrSales parent, QantasTransaction tran) {
        return this.updateTransaction(parent, tran, "Cancelled");
    }

    public boolean updateTransaction(FrSales parent, QantasTransaction tran, String status) {
        if (!SP.sParams.checkIConn()) {
            return false;
        }
        Element response = null;
        try {
            double value = tran.getSelectedValue() == 0.0 ? tran.getAmount() : tran.getSelectedValue();
            String payload = tran.getTransactionNumber() + "," + tran.getAp21TransactionId() + "," + status + "," + tran.getVersion();
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Update Transaction Request" + System.lineSeparator() + payload);
            response = SP.sParams.OnlineQueryProvider.getOnlineQuery("qantas_update", payload).getXML();
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Update Transaction Response" + System.lineSeparator() + response);
            if (response == null) {
                this.pollForUpdate(parent, tran);
                if (status.contentEquals("Complete")) {
                    if (tran.getStatus() == QantasTransactionStatus.Complete) {
                        return true;
                    }
                    throw new Exception("Transaction cannot be completed at this time. Please try again.");
                }
                if (status.contentEquals("Cancelled")) {
                    if (tran.getStatus() == QantasTransactionStatus.Cancelled) {
                        return true;
                    }
                    throw new Exception("Transaction cannot be cancelled at this time. Please try again.");
                }
                throw new Exception("No transaction data returned.");
            }
            if (!response.getAttributeValue("status_code").contentEquals("200")) {
                throw new Exception(response.getAttributeValue("message"));
            }
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, "An error occured while contacting Qantas: \n" + e.getMessage());
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while contacting Qantas: \n" + e.getMessage());
            return false;
        }
        try {
            String newStatus = response.getAttributeValue("status");
            if (status.length() > 0) {
                try {
                    tran.setStatus(this.parseStatus(newStatus));
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Invalid input string for enum: " + e.getMessage());
                }
            } else {
                DlgMessage.showMessage(parent, "Invalid transaction status data received. Unable to continue");
                return false;
            }
            String burnReference = response.getAttributeValue("burnReference");
            if (burnReference != null && burnReference.length() != 0) {
                tran.setBurnReference(burnReference);
            }
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean undoTransaction(FrSales parent, QantasTransaction tran, String action) {
        if (!SP.sParams.checkIConn()) {
            String errorMessage = "It looks like there is a connection problem. \nPlease contact head office if points got used.";
            DlgMessage.showMessage(parent, errorMessage);
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, errorMessage + "\nExternal Reference: " + tran.getAp21TransactionId());
            return true;
        }
        DlgMessage.showMessage(parent, "Undo-ing Qantas Transaction ");
        String payload = tran.getTransactionNumber() + "," + tran.getAp21TransactionId();
        Element response = null;
        try {
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Undo Transaction Request" + System.lineSeparator() + payload);
            response = SP.sParams.OnlineQueryProvider.getOnlineQuery("qantas_undo", payload).getXML();
            RollingLog.log(RollingLog.LogType.QANTAS, Level.INFO, "Qantas Undo Transaction Response" + System.lineSeparator() + response);
            if (response == null) {
                this.pollForUpdate(parent, tran);
                if (tran.getStatus() == QantasTransactionStatus.Undo) {
                    return true;
                }
                tran.addUndoRetryCount();
                if (tran.getUndoRetryCount() != 3) {
                    String errorMessage = "Transaction cannot be " + action + " at this time. Please try again.";
                    DlgMessage.showMessage(parent, errorMessage);
                    RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, errorMessage);
                    return false;
                }
                String errorMessage = "It looks like there is a connection problem. \nPlease contact head office if points got used.";
                DlgMessage.showMessage(parent, errorMessage);
                RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, errorMessage + "\nExternal Reference: " + tran.getAp21TransactionId());
                return true;
            }
            if (!response.getAttributeValue("status_code").contentEquals("200")) {
                throw new Exception(response.getAttributeValue("message"));
            }
        }
        catch (Exception e) {
            DlgMessage.showMessage(parent, "An error occured while processing data: \n" + e.getMessage());
            RollingLog.log(RollingLog.LogType.QANTAS, Level.SEVERE, "An error occured while processing data: \n" + e.getMessage());
            return true;
        }
        String status = response.getAttributeValue("status");
        if (status.length() > 0) {
            try {
                QantasTransactionStatus tranStatus = this.parseStatus(status);
                if (tranStatus != QantasTransactionStatus.OK) {
                    tran.setStatus(tranStatus);
                }
            }
            catch (IllegalArgumentException e) {
                DlgMessage.showMessage(parent, "Invalid input string for enum");
            }
        } else {
            DlgMessage.showMessage(parent, "Invalid transaction status data received. Unable to continue");
        }
        return true;
    }

    private QantasTransactionStatus parseStatus(String input) throws IllegalArgumentException {
        QantasTransactionStatus qantasStatus = QantasTransactionStatus.valueOf(input);
        return qantasStatus;
    }
}

