/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.sql.Connection;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StringUtils;

public class Country {
    private String name;
    private String code;

    public Country() {
        this("", "");
    }

    public Country(String name, String code) {
        this.name = StringUtils.nullToEmpty(name);
        this.code = StringUtils.nullToEmpty(code);
    }

    public Country(String codeOrName) {
        this(codeOrName, SP.sParams.conn);
    }

    public Country(String codeOrName, Connection con) {
        this();
        if (codeOrName != null && !codeOrName.isEmpty()) {
            String where = String.format("WHERE UPPER(%s) = %s", codeOrName.length() == 2 ? "CODE" : "NAME", PosUtils.StringToSqlString(codeOrName.toUpperCase()));
            try (SqlQuery sql = new SqlQuery(con, "SELECT TRIM(NAME), TRIM(CODE) FROM COUNTRY " + where);){
                if (sql.next()) {
                    this.name = StringUtils.nullToEmpty(sql.getString(1));
                    this.code = StringUtils.nullToEmpty(sql.getString(2));
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.nullToEmpty(name);
    }

    public void reset() {
        this.name = "";
        this.code = "";
    }

    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (o instanceof Country) {
            Country c = (Country)o;
            return this.code.toUpperCase().equals(c.code.toUpperCase()) || this.name.toUpperCase().equals(c.name.toUpperCase());
        }
        if (o instanceof String) {
            String value = ((String)o).toUpperCase();
            if (value.length() == 2) {
                return this.code.toUpperCase().equals(value);
            }
            return this.name.toUpperCase().equals(value);
        }
        return false;
    }

    public static Vector<Country> getCountryList() {
        Vector<Country> countries = new Vector<Country>();
        countries.addElement(new Country("", ""));
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT TRIM(NAME), TRIM(CODE) FROM COUNTRY ORDER BY TRIM(NAME)");){
            while (sql.next()) {
                Country country = new Country(sql.getString(1), sql.getString(2));
                if (Settings.getCountry().getName().length() > 0 && country.equals(Settings.getCountry())) {
                    countries.insertElementAt(country, 1);
                    continue;
                }
                countries.addElement(country);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return countries;
    }
}

